/*
 * Utility functions provided
 */

#ifndef UTILS_H
#define UTILS_H

#include <stdio.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#include "types.h"
#include "config.h"

#ifndef VERNAME
extern char *ver_name;
#define VERNAME ver_name
#define NEED_VERNAME
#endif

#ifdef DEBUG

extern void error_message (char *file, int line, char *func,
	char *type, int ecode, char *fmt, ...);
# define fatal(fmt, x...) error_message (__FILE__, __LINE__, __PRETTY_FUNCTION__,\
	"Fatal error", 1, fmt, ## x)

# define error(fmt, x...) error_message (__FILE__, __LINE__, __PRETTY_FUNCTION__,\
	"Error", 0, fmt, ## x)

# define warning(fmt, x...) error_message (__FILE__, __LINE__, __PRETTY_FUNCTION__,\
	"Warning", 0, fmt, ## x)

#else

extern void error_message (char *type, int ecode, char *fmt, ...);
# define fatal(fmt, x...) error_message ("Fatal error", 1, fmt, ## x)

# define error(fmt, x...) error_message ("Error", 0, fmt, ## x)

# define warning(fmt, x...) error_message ("Warning", 0, fmt, ## x)

#endif

#ifndef DEBUG
#define dprintf(fmt, x...)
#else
extern FILE *debug;
#define dprintf(fmt, x...) fprintf (debug, fmt, ## x)
#endif

#ifdef DEBUG
#define Assert(x) if (!(x)) fatal ("Assertion %s failed", #x)
#else
#define Assert(x)
#endif

#ifdef __cplusplus
extern void ReadFile (char *fname, void *ptr, size_t sz, int do_rpt = 0);
#else
extern void ReadFile (char *fname, void *ptr, size_t sz, int do_rpt);
#endif

extern int trace;

// Timing functions
extern volatile int timer_alrm;
extern void init_timing (void);
extern void start_timer (int usec);
extern void stop_timer (void);

// General event function
extern void doevents (void);

// Debugging stuff
extern void DebugInit (void);

// From Main.cc
extern int kbmap[0x10][0x8];
extern int mousebtns[3], mousemotx, mousemoty;
extern void ExecThread (void);	// Called every 100ms
typedef void (*KeyEventHandler) (int, int, void *);
extern KeyEventHandler KeyboardEvent;
extern void *KeyEventData;

extern void SetKeyEvent (KeyEventHandler handler, void *data);

#ifdef __cplusplus
}
#endif

#endif /* UTILS_H */

/* End of file. */
