/*
 * Copyright (c) James Fidell 1994, 1995, 1996.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the copyright holder
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission. The
 * copyright holder makes no representations about the suitability of
 * this software for any purpose. It is provided "as is" without express
 * or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */


#include	<stdio.h>
#include	<unistd.h>

#include "Config.h"
#include "ADC.h"

static unsigned char		Channel;
static unsigned char		FlagInput;
static unsigned char		TenBitConversion;


void
ResetADConverter ( void )
{
    /*
	 * FIX ME
	 *
	 * I have no idea what happens when the ADC is powered up/reset
	 */

	return;
}


byteval
ReadADConverter ( int addr )
{
	/*
	 * FIX ME
	 *
	 * This is a complete dummy -- no part of the ADC conversion
	 * works at the moment.
	 */

	/*
	 * Some dummy stuff just keep things working...
	 *
	 * Channel is whatever was set in the last write.
	 * 8/10 bit mode is whatever was set in the last write.
	 * Conversion value = 0
	 * ADC is not busy
	 * conversion is complete
	 */

	byteval			ret = 0;

	/*
	 * Handle address wrap-around
	 */

	switch ( addr & 0x3 )
	{
		case 0x0 :
			ret = Channel | TenBitConversion | 0x40;
			break;

		case 0x1 :
			ret = 0;
			break;

		case 0x2 :
			ret = 0;
			break;

		case 0x3 :
			/*
			 * FIX ME
			 *
			 * This location isn't used in the ADC chip.  The value
			 * returned is what my Beeb gives on reading the location.
			 */

			ret = 0x40;
			break;
	}

	return ( ret );
}


void
WriteADConverter ( int addr, byteval val )
{
	/*
	 * Handle address wraparound...
	 *
	 * Only register 0 at address &FEC0 is writeable, so we can ignore
	 * the rest.  Can't we ?
	 */

	if (( addr & 0x3 ) == 0 )
	{
		/*
		 * FIX ME
		 *
		 * This should initiate a conversion which, if interrupts are
		 * enabled, will cause an IRQ when complete.  This interrupt
		 * is generated by taking the CB1 line of the system VIA high.
		 *
		 */

		Channel = val & 0x3;
		FlagInput = val & 0x4;
		TenBitConversion = val & 0x8;
#ifdef	INFO
		printf ( "ADC started on channel %d, %d-bit conversion\n",
			Channel, TenBitConversion ? 10 : 8 );
#endif

		/*
		 * The rest of the bits are unused
		 */
	}
	return;
}


int
SaveADC ( int fd )
{
	byteval		adc [ 8 ];

	adc [ 0 ] = Channel | FlagInput | TenBitConversion;

	/*
	 * FIX ME
	 *
	 * Ought to have the value of the last conversion in here ?
	 */

	if ( write ( fd, adc, 8 ) != 8 )
		return -1;

	return 0;
}


int
RestoreADC ( int fd, unsigned int ver )
{
	byteval		adc [ 8 ];

	if ( ver > 1 )
		return -1;

	if ( read ( fd, adc, 8 ) != 8 )
		return -1;

	Channel = adc [ 0 ] & 0x3;
	FlagInput = adc [ 0 ] & 0x4;
	TenBitConversion = adc [ 0 ] & 0x8;

	/*
	 * FIX ME
	 *
	 * Ought to have the value of the last conversion in here ?
	 */

	return 0;
}
