#ifndef UEF_H
#define UEF_H

#include <zlib.h>

/*
	change this bit to be correct for your compiler - MSVC owners need not
	bother at all, and it is all correct for 32bit GCC
*/

#ifndef __int8
#define __int8 char
#endif
#ifndef __int16
#define __int16 short
#endif
#ifndef __int32
#define __int32 int
#endif

#ifndef broken_quad
union broken_quad
{
	unsigned __int32 a;

	struct
	{
		unsigned __int8 b0, b1, b2, b3;
	}b;
};
#endif

#ifndef broken_word
union broken_word
{
	unsigned __int16 a;

	struct
	{
		unsigned __int8 l, h;
	}b;
};
#endif

class C_UEF
{
	public :
		C_UEF(void);
		~C_UEF(void);

		bool Open(char *name, char *mode, unsigned __int8 minor, unsigned __int8 major);
		bool Restart(void);
		bool Close(void);

		bool FindNext(void);
		bool FindIdMajor(unsigned __int8 id);
		bool FindId(unsigned __int16 id);

		unsigned __int32 GetLength(void);
		unsigned __int16 GetId(void);

		unsigned __int32 ReadSome(unsigned __int8 *ptr, unsigned __int32 length);
		unsigned __int32 ReadAll(unsigned __int8 *ptr);
		bool WriteChunk(unsigned __int16 id, unsigned __int32 len, unsigned __int8 *ptr);

		bool HasFile(void);

		bool EOC(void);
		bool OverRan(void);

	private :
		gzFile file;

		broken_quad chunk_len;
		unsigned __int32 len_remaining;
		broken_word chunk_id;
		bool overeof, input;
};

#endif