#ifndef WD1770_H
#define WD1770_H

#include "uef.h"

enum wd1770_instruction{
	NONE,
	READ_SECTOR, READ_SECTOR_TRACK, WRITE_SECTOR,
	READ_TRACK, WRITE_TRACK,
};

class C_WD1770
{
	public :
		C_WD1770(void);
		~C_WD1770(void);

		bool Open(char *name);
		void Close(void);
		void Keepalive(void);
		void Reset(void);

		void WriteToRegister(int offset, unsigned __int8 value);
		unsigned __int8 ReadFromRegister(int offset);

	private :
		C_UEF disk;
		unsigned __int8 regs[5], disk_id;
		unsigned __int8 *cside, *side1, *side2;
		int datalen, len1, len2;
		int sector_position, nmi_id;

		bool present;

		wd1770_instruction instr;
		int sector, sector_size, tracks, track, sectors_in_track;
};

#define STATUS	0
#define INSTR	0
#define TRACK	1
#define SECTOR	2
#define DATA	3
#define CONTROL	4

#define WD_M_FLAG	0x80
#define WD_W_FLAG	0x40
#define WD_S_FLAG	0x20
#define WD_R_FLAG	0x10
#define WD_C_FLAG	0x08
#define WD_Z_FLAG	0x04
#define WD_D_FLAG	0x02
#define WD_B_FLAG	0x01
#endif