/*

  ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

  This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "6502.h"
#include <malloc.h>


#include "tape.h"
extern C_Tape tape;

#include "elecscreen.h"
extern C_screen elec_screen;


C_6502ULA::~C_6502ULA(void)
{
	int c;
	fclose(out);

	c = COUNT;
	while(c--)
	{
		free(types[c]);
	}
	free(types);

	free(o_r_mem);
	free(o_w_mem);
	free(nz_table);
	free(o_mem);
	free(o_junk);
	free(o_rom_ptrs);
	free(style_flags);
}

#define setup_table(x) ptr = (memory_access *)malloc(sizeof(memory_access)*(x+1))
#define insert_access(direction, location, bflag)	{ptr->type = direction; ptr->place = location; ptr->comp = bflag; ptr++;}
#define end_table()	ptr->place = FINISH

#define R_NO 0

C_6502ULA::C_6502ULA(C_sound_api &snd)
{
	memory_access *ptr;
	int c, tc;

	int_control = 0;
	int_status = 2;

	nmi = irq = irqm = false;

	soundptr = &snd;
	tape.motor_on = false;

	out = fopen("6502.log", "wt");

	types = (memory_access **)malloc(sizeof(memory_access *)*COUNT);

	types[BRK] = setup_table(7);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		RAM,		true);
		insert_access(write_op,		RAM,		true);
		insert_access(write_op,		RAM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	types[RTI] = setup_table(6);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
	end_table();

	types[RTS] = setup_table(6);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	types[PHx] = setup_table(3);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		RAM,		true);
	end_table();

	types[PLx] = setup_table(4);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
	end_table();

	types[JSR] = setup_table(6);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(write_op,		RAM,		true);
		insert_access(write_op,		RAM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	types[IMPLIED] = setup_table(2);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	types[IMMEDIATE] = setup_table(2);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	types[ABS_JMP] = setup_table(3);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	types[ABS_READ] = setup_table(4);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	types[ABS_MODIFY] = setup_table(6);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
	end_table();

	types[ABS_WRITE] = setup_table(4);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
	end_table();

	types[ZERO_READ] = setup_table(3);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
	end_table();

	types[ZERO_MODIFY] = setup_table(5);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(write_op,		RAM,		true);
		insert_access(write_op,		RAM,		true);
	end_table();

	types[ZERO_WRITE] = setup_table(3);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		RAM,		true);
	end_table();

	types[ZIND_READ] = setup_table(4);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);

	end_table();

	types[ZIND_MODIFY] = setup_table(6);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(write_op,		RAM,		true);
		insert_access(write_op,		RAM,		true);
	end_table();

	types[ZIND_WRITE] = setup_table(4);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(write_op,		RAM,		true);
	end_table();

	types[AIND_READ_NCROSS] = setup_table(4);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	types[AIND_READ_CROSS] = setup_table(5);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		false);
	end_table();

	types[AIND_MODIFY] = setup_table(7);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
	end_table();

	types[AIND_WRITE] = setup_table(5);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
	end_table();

	types[REL] = setup_table(5);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		false);
	end_table();

	types[INDI_READ] = setup_table(6);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	types[INDI_MODIFY] = setup_table(8);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
	end_table();

	types[INDI_WRITE] = setup_table(6);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(write_op,		ROM,		true);
	end_table();

	types[IIND_READ_NCROSS] = setup_table(6);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		false);
	end_table();

	types[IIND_READ_CROSS] = setup_table(5);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		false);
	end_table();

	types[IIND_MODIFY] = setup_table(8);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
	end_table();

	types[IIND_WRITE] = setup_table(6);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		RAM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(write_op,		ROM,		true);
	end_table();

	types[ABSOLUTE_IND] = setup_table(5);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
		insert_access(read_op,		ROM,		true);
	end_table();

	ram_available = no_line;

	c = 148;
	while(c--)
	{
		no_line[c] = true;
		wide_line[c] = false;
		thin_line[c] = (c&1) ? false : true;
	}

	c = 48;
	while(c--)
	{
		wide_line[c] = thin_line[c] = true;
	}

	style_flags = (access_type_minor *)malloc(sizeof(access_type_minor)*256);

	c = 128;
	while(c--)
	{
		style_flags[c] = RAM;
		style_flags[128+c] = ROM;
	}
	style_flags[0xfc] =
	style_flags[0xfd] =
	style_flags[0xfe] = ULA;

	c = 256;
	while(c--)
		mapped_flags[c] = false;

	mapped_flags[0xfc] =
	mapped_flags[0xfd] =
	mapped_flags[0xfe] = true;

	nz_table = (unsigned __int8 *)malloc(sizeof(unsigned __int8)*256);
	c = 256;

	while(c--)
	{
		nz_table[c] = c&128;
	}
	nz_table[0] |= Z_FLAG;

	o_r_mem = (unsigned __int8 **)malloc(sizeof(unsigned __int8 *)*256);
	o_w_mem = (unsigned __int8 **)malloc(sizeof(unsigned __int8 *)*256);

	o_mem = (unsigned __int8 *)malloc(sizeof(unsigned __int8)*(48 + 13*16)*1024); //32kb RAM, 16kb OS, 16kb BASIC, 12 other 16kb ROMS
	o_junk = (unsigned __int8 *)malloc(sizeof(unsigned __int8)*256);

	rom_present[0] = rom_present[1] = rom_present[2] = rom_present[3] =
	rom_present[4] = rom_present[5] = rom_present[6] = rom_present[7] = false;
	rom_present[8] = rom_present[9] = rom_present[10] = rom_present[11] = true;
	rom_present[12] = rom_present[13] = rom_present[14] = rom_present[15] = false;

	o_rom_ptrs = (unsigned __int8 **)malloc(sizeof(unsigned __int8 *)*16);

	o_rom_ptrs[0] = &o_mem[(48*1024) + (0 << 14)];
	o_rom_ptrs[1] = &o_mem[(48*1024) + (1 << 14)];
	o_rom_ptrs[2] = &o_mem[(48*1024) + (2 << 14)];
	o_rom_ptrs[3] = &o_mem[(48*1024) + (3 << 14)];
	o_rom_ptrs[4] = &o_mem[(48*1024) + (4 << 14)];
	o_rom_ptrs[5] = &o_mem[(48*1024) + (5 << 14)];
	o_rom_ptrs[6] = &o_mem[(48*1024) + (6 << 14)];
	o_rom_ptrs[7] = &o_mem[(48*1024) + (7 << 14)];
	o_rom_ptrs[8] = 
	o_rom_ptrs[9] = (unsigned __int8 *)NULL; //keyboard
	o_rom_ptrs[10] = 
	o_rom_ptrs[11] = &o_mem[(48*1024) + (8 << 14)]; //BASIC
	o_rom_ptrs[12] = &o_mem[(48*1024) + (9 << 14)];
	o_rom_ptrs[13] = &o_mem[(48*1024) + (10 << 14)];
	o_rom_ptrs[14] = &o_mem[(48*1024) + (11 << 14)];
	o_rom_ptrs[15] = &o_mem[(48*1024) + (12 << 14)];

	//page in OS, RAM and BASIC
	c = 64;
	tc = 16384;
	while(c--)
	{
		tc -= 256;

		o_r_mem[c]	=
		o_w_mem[c]	= &o_mem[tc];

		o_r_mem[64+c]	=
		o_w_mem[64+c]	= &o_mem[tc + 16384];

		o_r_mem[128+c]	= &o_rom_ptrs[10][tc];

		o_r_mem[192+c]	= &o_mem[tc + 32768];

		o_w_mem[128+c]	=
		o_w_mem[192+c]	= o_junk;
	}

	/* TAPE HACK :

00-02	JMP language entry
03-05	JMP service entry
06	ROM type
07	Copyright offset pointer (=nn)
08	Binary version number
09..	Title string, printed on selection as a language.
vv..	Optional version string, preceded by &00.
nn-nn+3	&00, &28 '(', &43 'C', &29 ')'
 	nn+4..	Copyright message
xx	Copyright message terminator (&00)
xx+1-xx+5	If applicable, second processor relocation address.
*/
/*	rom_present[R_NO] = true;

	o_rom_ptrs[R_NO][0] = 0x60;	// language entry - not important
	o_rom_ptrs[R_NO][1] = 0x0;
	o_rom_ptrs[R_NO][2] = 0x0;

	o_rom_ptrs[R_NO][3] = 0x4c; // service entry
	o_rom_ptrs[R_NO][4] = 29;
	o_rom_ptrs[R_NO][5] = 0x80;

	o_rom_ptrs[R_NO][6] = 0x82; // ROM type - 10000010

	o_rom_ptrs[R_NO][7] = 22; // COPYRIGHT offset pointer

	o_rom_ptrs[R_NO][8] = 0x01; // binary version number

	o_rom_ptrs[R_NO][9] = 'F'; // TITLE String
	o_rom_ptrs[R_NO][10] = 'A';
	o_rom_ptrs[R_NO][11] = 'S';
	o_rom_ptrs[R_NO][12] = 'T';
	o_rom_ptrs[R_NO][13] = 'L';
	o_rom_ptrs[R_NO][14] = 'o';
	o_rom_ptrs[R_NO][15] = 'a';
	o_rom_ptrs[R_NO][16] = 'd';
	o_rom_ptrs[R_NO][17] = ' ';
	o_rom_ptrs[R_NO][18] = 'v';
	o_rom_ptrs[R_NO][19] = '0';
	o_rom_ptrs[R_NO][20] = '.';
	o_rom_ptrs[R_NO][21] = '1';
	o_rom_ptrs[R_NO][22] = 0;

	o_rom_ptrs[R_NO][23] = '('; // (C) - as required
	o_rom_ptrs[R_NO][24] = 'C';
	o_rom_ptrs[R_NO][25] = ')';

	o_rom_ptrs[R_NO][26] = 'm'; // copyright message
	o_rom_ptrs[R_NO][27] = 'e';
	o_rom_ptrs[R_NO][28] = 0;

	o_rom_ptrs[R_NO][29] = TAPE_SERVICE;
	o_rom_ptrs[R_NO][30] = 0x60; //RTS */
}

void C_6502ULA::external_keepalive(void)
{
	elec_screen.Keepalive();
}

