#ifndef INPUT_H
#define INPUT_H

#ifdef TARGET_WIN32
#include <dinput.h>
#endif

#ifdef TARGET_SVGALIB
#include <vgakeyboard.h>
#endif

#include "gfx.h"

class C_input_api
{
	public :
		int Setup(void);
		int UpdateKeyStates(void);

		bool NewKey(void);
		unsigned char GetPressedASCII(void);
		void ClearBuffer(void);

		void SetCaps(bool on);

		~C_input_api(void);
		C_input_api(void);

		#ifdef TARGET_WIN32
		unsigned char array[256];
		#endif

		#ifdef TARGET_SVGALIB
		char *array;
		#endif

		#ifdef TARGET_ALLEGRO
		volatile char *array;
		#endif

	#ifdef TARGET_WIN32
	private :
		LPDIRECTINPUT lpdi;
		LPDIRECTINPUTDEVICE lpdiKeyb;
	#endif
};

#ifdef TARGET_ALLEGRO
#define EKEY_ESC		KEY_ESC

#define EKEY_1			KEY_1
#define EKEY_2			KEY_2
#define EKEY_3			KEY_3
#define EKEY_4			KEY_4
#define EKEY_5			KEY_5
#define EKEY_6			KEY_6
#define EKEY_7			KEY_7
#define EKEY_8			KEY_8
#define EKEY_9			KEY_9
#define EKEY_0			KEY_0

#define EKEY_Q			KEY_Q
#define EKEY_W			KEY_W
#define EKEY_E			KEY_E
#define EKEY_R			KEY_R
#define EKEY_T			KEY_T
#define EKEY_Y			KEY_Y
#define EKEY_U			KEY_U
#define EKEY_I			KEY_I
#define EKEY_O			KEY_O
#define EKEY_P			KEY_P
#define EKEY_A			KEY_A
#define EKEY_S			KEY_S
#define EKEY_D			KEY_D
#define EKEY_F			KEY_F
#define EKEY_G			KEY_G
#define EKEY_H			KEY_H
#define EKEY_J			KEY_J
#define EKEY_K			KEY_K
#define EKEY_L			KEY_L
#define EKEY_Z			KEY_Z
#define EKEY_X			KEY_X
#define EKEY_C			KEY_C
#define EKEY_V			KEY_V
#define EKEY_B			KEY_B
#define EKEY_N			KEY_N
#define EKEY_M			KEY_M

#define EKEY_1P			KEY_1_PAD
#define EKEY_2P			KEY_2_PAD
#define EKEY_3P			KEY_3_PAD
#define EKEY_4P			KEY_4_PAD
#define EKEY_5P			KEY_5_PAD
#define EKEY_6P			KEY_6_PAD
#define EKEY_7P			KEY_7_PAD
#define EKEY_8P			KEY_8_PAD
#define EKEY_9P			KEY_9_PAD
#define EKEY_0P			KEY_0_PAD

#define EKEY_F1			KEY_F1
#define EKEY_F2			KEY_F2
#define EKEY_F3			KEY_F3
#define EKEY_F4			KEY_F4
#define EKEY_F5			KEY_F5
#define EKEY_F6			KEY_F6
#define EKEY_F7			KEY_F7
#define EKEY_F8			KEY_F8
#define EKEY_F9			KEY_F9
#define EKEY_F10		KEY_F10
#define EKEY_F11		KEY_F11
#define EKEY_F12		KEY_F12

#define EKEY_MINUS		KEY_MINUS
#define EKEY_EQUALS		KEY_EQUALS
#define EKEY_BACKSPACE	KEY_BACKSPACE
#define EKEY_TAB		KEY_TAB

#define EKEY_OPENBRACE	KEY_OPENBRACE
#define EKEY_CLOSEBRACE	KEY_CLOSEBRACE
#define EKEY_ENTER		KEY_ENTER
#define EKEY_COLON		KEY_COLON
#define EKEY_QUOTE		KEY_QUOTE
#define EKEY_GRAVE		KEY_BACKSLASH

#define EKEY_LCTRL		KEY_LCONTROL
#define EKEY_RCTRL		KEY_RCONTROL
#define EKEY_LSHIFT		KEY_LSHIFT
#define EKEY_RSHIFT		KEY_RSHIFT
#define EKEY_ALT		KEY_ALT
#define EKEY_ALTGR		KEY_ALTGR

#define EKEY_BACKSLASH	KEY_BACKSLASH2
#define EKEY_COMMA		KEY_COMMA
#define EKEY_STOP		KEY_STOP
#define EKEY_SLASH		KEY_SLASH

#define EKEY_ASTERISK	KEY_ASTERISK
#define EKEY_SPACE		KEY_SPACE
#define EKEY_CAPSLCK	KEY_CAPSLOCK

#define EKEY_NUMLCK		KEY_NUMLOCK
#define EKEY_SCRLCK		KEY_SCROLL
#define EKEY_MINUSP		KEY_MINUS_PAD
#define EKEY_PLUSP		KEY_PLUS_PAD

#define EKEY_DELP		KEY_DEL_PAD

#define EKEY_ENTERP		KEY_ENTER_PAD

#define EKEY_SLASHP		KEY_SLASH_PAD
#define EKEY_PRTSCR		KEY_PRTSCR
#define EKEY_HOME		KEY_HOME
#define EKEY_UP			KEY_UP
#define EKEY_PGUP		KEY_PGUP
#define EKEY_LEFT		KEY_LEFT
#define EKEY_RIGHT		KEY_RIGHT
#define EKEY_END		KEY_END
#define EKEY_DOWN		KEY_DOWN
#define EKEY_PGDN		KEY_PGDN
#define EKEY_INSERT		KEY_INSERT
#define EKEY_DEL		KEY_DEL

#define MAX_KEY			KEY_MAX
#endif

/*
both SVGALib & DirectX do no remapping of keys from the hardware defaults,
so this next table holds for both
*/
#ifdef TARGET_WIN32
#define EKEY_ESC		DIK_ESCAPE

#define EKEY_1			DIK_1
#define EKEY_2			DIK_2
#define EKEY_3			DIK_3
#define EKEY_4			DIK_4
#define EKEY_5			DIK_5
#define EKEY_6			DIK_6
#define EKEY_7			DIK_7
#define EKEY_8			DIK_8
#define EKEY_9			DIK_9
#define EKEY_0			DIK_0

#define EKEY_Q			DIK_Q
#define EKEY_W			DIK_W
#define EKEY_E			DIK_E
#define EKEY_R			DIK_R
#define EKEY_T			DIK_T
#define EKEY_Y			DIK_Y
#define EKEY_U			DIK_U
#define EKEY_I			DIK_I
#define EKEY_O			DIK_O
#define EKEY_P			DIK_P
#define EKEY_A			DIK_A
#define EKEY_S			DIK_S
#define EKEY_D			DIK_D
#define EKEY_F			DIK_F
#define EKEY_G			DIK_G
#define EKEY_H			DIK_H
#define EKEY_J			DIK_J
#define EKEY_K			DIK_K
#define EKEY_L			DIK_L
#define EKEY_Z			DIK_Z
#define EKEY_X			DIK_X
#define EKEY_C			DIK_C
#define EKEY_V			DIK_V
#define EKEY_B			DIK_B
#define EKEY_N			DIK_N
#define EKEY_M			DIK_M

#define EKEY_1P			DIK_NUMPAD1
#define EKEY_2P			DIK_NUMPAD2
#define EKEY_3P			DIK_NUMPAD3
#define EKEY_4P			DIK_NUMPAD4
#define EKEY_5P			DIK_NUMPAD5
#define EKEY_6P			DIK_NUMPAD6
#define EKEY_7P			DIK_NUMPAD7
#define EKEY_8P			DIK_NUMPAD8
#define EKEY_9P			DIK_NUMPAD9
#define EKEY_0P			DIK_NUMPAD0

#define EKEY_F1			DIK_F1
#define EKEY_F2			DIK_F2
#define EKEY_F3			DIK_F3
#define EKEY_F4			DIK_F4
#define EKEY_F5			DIK_F5
#define EKEY_F6			DIK_F6
#define EKEY_F7			DIK_F7
#define EKEY_F8			DIK_F8
#define EKEY_F9			DIK_F9
#define EKEY_F10		DIK_F10
#define EKEY_F11		DIK_F11
#define EKEY_F12		DIK_F12

#define EKEY_MINUS		DIK_MINUS
#define EKEY_EQUALS		DIK_EQUALS
#define EKEY_BACKSPACE	DIK_BACK
#define EKEY_TAB		DIK_TAB

#define EKEY_OPENBRACE	DIK_LBRACKET
#define EKEY_CLOSEBRACE	DIK_RBRACKET
#define EKEY_ENTER		DIK_RETURN
#define EKEY_COLON		DIK_SEMICOLON
#define EKEY_QUOTE		DIK_APOSTROPHE
#define EKEY_GRAVE		DIK_GRAVE

#define EKEY_LCTRL		DIK_LCONTROL
#define EKEY_RCTRL		DIK_RCONTROL
#define EKEY_LSHIFT		DIK_LSHIFT
#define EKEY_RSHIFT		DIK_RSHIFT
#define EKEY_ALT		DIK_LMENU
#define EKEY_ALTGR		DIK_RMENU

#define EKEY_BACKSLASH	DIK_BACKSLASH
#define EKEY_COMMA		DIK_COMMA
#define EKEY_STOP		DIK_PERIOD
#define EKEY_SLASH		DIK_SLASH

#define EKEY_ASTERISK	DIK_MULTIPLY
#define EKEY_SPACE		DIK_SPACE
#define EKEY_CAPSLCK	DIK_CAPITAL

#define EKEY_NUMLCK		DIK_NUMLOCK
#define EKEY_SCRLCK		DIK_SCROLL
#define EKEY_MINUSP		DIK_SUBTRACT
#define EKEY_PLUSP		DIK_ADD

#define EKEY_DELP		DIK_DECIMAL

#define EKEY_ENTERP		DIK_NUMPADENTER

#define EKEY_SLASHP		DIK_DIVIDE
#define EKEY_PRTSCR		DIK_SYSRQ
#define EKEY_HOME		DIK_HOME
#define EKEY_UP			DIK_UP
#define EKEY_PGUP		DIK_PRIOR
#define EKEY_LEFT		DIK_LEFT
#define EKEY_RIGHT		DIK_RIGHT
#define EKEY_END		DIK_END
#define EKEY_DOWN		DIK_DOWN
#define EKEY_PGDN		DIK_NEXT
#define EKEY_INSERT		DIK_INSERT
#define EKEY_DEL		DIK_DELETE

#define MAX_KEY			256
#endif

#if TARGET_SVGALIB
#define EKEY_ESC                SCANCODE_ESCAPE

#define EKEY_1			SCANCODE_1
#define EKEY_2			SCANCODE_2
#define EKEY_3			SCANCODE_3
#define EKEY_4			SCANCODE_4
#define EKEY_5			SCANCODE_5
#define EKEY_6			SCANCODE_6
#define EKEY_7			SCANCODE_7
#define EKEY_8			SCANCODE_8
#define EKEY_9			SCANCODE_9
#define EKEY_0			SCANCODE_0

#define EKEY_Q			SCANCODE_Q
#define EKEY_W			SCANCODE_W
#define EKEY_E			SCANCODE_E
#define EKEY_R			SCANCODE_R
#define EKEY_T			SCANCODE_T
#define EKEY_Y			SCANCODE_Y
#define EKEY_U			SCANCODE_U
#define EKEY_I			SCANCODE_I
#define EKEY_O			SCANCODE_O
#define EKEY_P			SCANCODE_P
#define EKEY_A			SCANCODE_A
#define EKEY_S			SCANCODE_S
#define EKEY_D			SCANCODE_D
#define EKEY_F			SCANCODE_F
#define EKEY_G			SCANCODE_G
#define EKEY_H			SCANCODE_H
#define EKEY_J			SCANCODE_J
#define EKEY_K			SCANCODE_K
#define EKEY_L			SCANCODE_L
#define EKEY_Z			SCANCODE_Z
#define EKEY_X			SCANCODE_X
#define EKEY_C			SCANCODE_C
#define EKEY_V			SCANCODE_V
#define EKEY_B			SCANCODE_B
#define EKEY_N			SCANCODE_N
#define EKEY_M			SCANCODE_M

#define EKEY_1P			SCANCODE_KEYPAD1
#define EKEY_2P			SCANCODE_KEYPAD2
#define EKEY_3P			SCANCODE_KEYPAD3
#define EKEY_4P			SCANCODE_KEYPAD4
#define EKEY_5P			SCANCODE_KEYPAD5
#define EKEY_6P			SCANCODE_KEYPAD6
#define EKEY_7P			SCANCODE_KEYPAD7
#define EKEY_8P			SCANCODE_KEYPAD8
#define EKEY_9P			SCANCODE_KEYPAD9
#define EKEY_0P			SCANCODE_KEYPAD0

#define EKEY_F1			SCANCODE_F1
#define EKEY_F2			SCANCODE_F2
#define EKEY_F3			SCANCODE_F3
#define EKEY_F4			SCANCODE_F4
#define EKEY_F5			SCANCODE_F5
#define EKEY_F6			SCANCODE_F6
#define EKEY_F7			SCANCODE_F7
#define EKEY_F8			SCANCODE_F8
#define EKEY_F9			SCANCODE_F9
#define EKEY_F10		SCANCODE_F10
#define EKEY_F11		SCANCODE_F11
#define EKEY_F12		SCANCODE_F12

#define EKEY_MINUS		SCANCODE_MINUS
#define EKEY_EQUALS		SCANCODE_EQUAL
#define EKEY_BACKSPACE	SCANCODE_BACKSPACE
#define EKEY_TAB		SCANCODE_TAB

#define EKEY_OPENBRACE	SCANCODE_BRACKET_LEFT
#define EKEY_CLOSEBRACE	SCANCODE_BRACKET_RIGHT
#define EKEY_ENTER		SCANCODE_ENTER
#define EKEY_COLON		SCANCODE_SEMICOLON
#define EKEY_QUOTE		SCANCODE_APOSTROPHE
#define EKEY_GRAVE		SCANCODE_GRAVE

#define EKEY_LCTRL		SCANCODE_LEFTCONTROL
#define EKEY_RCTRL		SCANCODE_RIGHTCONTROL
#define EKEY_LSHIFT		SCANCODE_LEFTSHIFT
#define EKEY_RSHIFT		SCANCODE_RIGHTSHIFT
#define EKEY_ALT		SCANCODE_LEFTALT
#define EKEY_ALTGR		SCANCODE_RMENU

#define EKEY_BACKSLASH	SCANCODE_BACKSLASH
#define EKEY_COMMA		SCANCODE_COMMA
#define EKEY_STOP		SCANCODE_PERIOD
#define EKEY_SLASH		SCANCODE_SLASH

#define EKEY_ASTERISK	SCANCODE_KEYPADMULTIPLY
#define EKEY_SPACE		SCANCODE_SPACE
#define EKEY_CAPSLCK	SCANCODE_CAPSLOCK

#define EKEY_NUMLCK		SCANCODE_NUMLOCK
#define EKEY_SCRLCK		SCANCODE_SCROLLLOCK
#define EKEY_MINUSP		SCANCODE_KEYPADMINUS
#define EKEY_PLUSP		SCANCODE_KEYPADPLUS

#define EKEY_DELP		SCANCODE_KEYPADPERIOD

#define EKEY_ENTERP		SCANCODE_KEYPADENTER

#define EKEY_SLASHP		SCANCODE_KEYPADDIVIDE
#define EKEY_PRTSCR		SCANCODE_PRINTSCREEN
#define EKEY_HOME		SCANCODE_HOME
#define EKEY_UP			SCANCODE_CURSORBLOCKUP
#define EKEY_PGUP		SCANCODE_PAGEUP
#define EKEY_LEFT		SCANCODE_CURSORBLOCKLEFT
#define EKEY_RIGHT		SCANCODE_CURSORBLOCKRIGHT
#define EKEY_END		SCANCODE_END
#define EKEY_DOWN		SCANCODE_CURSORBLOCKDOWN
#define EKEY_PGDN		SCANCODE_PAGEDOWN
#define EKEY_INSERT		SCANCODE_INSERT
#define EKEY_DEL		SCANCODE_DELETE

#define MAX_KEY			112


#endif

#endif