/*

  ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

  This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "input.h"

#ifdef TARGET_SVGALIB
#include <sys/ioctl.h>
#include <linux/kd.h>
#include <unistd.h>
#include <term.h>
#endif

#if TARGET_SVGALIB || TARGET_WIN32
#include <string.h>

unsigned char ascii_table_shift[] ={
0,

0,

0x21, 0x22, 0x9c, 0x24, 0x25, 0x5e, 0x26, 0x2a, 0x28, 0x29,
0x5f, 0x2b, 0x08,

0x09,
0x51, 0x57, 0x45, 0x52, 0x54, 0x59, 0x55, 0x49, 0x4f, 0x50,
0x7b, 0x7d, 0x0a,

0,
0x41, 0x53, 0x44, 0x46, 0x47, 0x48, 0x4a, 0x4b, 0x4c,
0x3a, 0x40, 0x7e,

0, 0x5c,
0x5a, 0x58, 0x43, 0x56, 0x42, 0x4e, 0x4d,
0x3c, 0x3e, 0x3f, 0,

0x2a, 0, 0x20, 0,

0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

0, 0, 0x37, 0x38, 0x39,
0x2d, 0x34, 0x35, 0x36, 0x2b,
0x3a, 0x32, 0x33, 0x07,

0x07
};

unsigned char ascii_table[] ={
0,

0,

0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30,
0x2d, 0x3d, 0x08,

0x09,
0x71, 0x77, 0x65, 0x72, 0x74, 0x79, 0x75, 0x69, 0x6f, 0x70,
0x5b, 0x5d, 0x0a,


0,
0x61, 0x73, 0x64, 0x66, 0x67, 0x68, 0x6a, 0x6b, 0x6c,
0x3b, 0x27, 0x23,

0, 0x7c,
0x7a, 0x78, 0x63, 0x76, 0x62, 0x6e, 0x6d,
0x2c, 0x2e, 0x2f, 0,

0x2a, 0, 0x20, 0,

0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

0, 0, 0x37, 0x38, 0x39,
0x2d, 0x34, 0x35, 0x36, 0x2b,
0x3a, 0x32, 0x33, 0x07,

0x2e,
};

#define MAX_ASCII EKEY_DELP+1

char oldstates[MAX_ASCII];
#endif


C_input_api::C_input_api(void)
{
	#ifdef TARGET_WIN32
	lpdiKeyb = NULL;
	lpdi = NULL;
	#endif

	#ifndef TARGET_ALLEGRO
	memset(oldstates, 0, MAX_ASCII);
	#endif
}

C_input_api::~C_input_api(void)
{
	#ifdef TARGET_WIN32
	if(lpdiKeyb)
	{
		lpdiKeyb->Unacquire();
		lpdiKeyb->Release();
		lpdiKeyb = NULL;
	}

	if(lpdi)
	{
		lpdi->Release();
		lpdi = NULL;
	}
	#endif

	#ifdef TARGET_SVGALIB
	keyboard_close();
	#endif
}

int C_input_api::Setup(void)
{
	#ifdef TARGET_WIN32
	if(FAILED(DirectInputCreate(winfo.hInstance, DIRECTINPUT_VERSION, &lpdi, NULL)))
		return 1;

	if(FAILED(lpdi->CreateDevice(GUID_SysKeyboard, &lpdiKeyb, NULL)))
		return 1;

	if(FAILED(lpdiKeyb->SetCooperativeLevel(winfo.hWnd, DISCL_BACKGROUND | DISCL_NONEXCLUSIVE)))
		return 1;

	if(FAILED(lpdiKeyb->SetDataFormat(&c_dfDIKeyboard)))
		return 1;

	if(FAILED(lpdiKeyb->Acquire()))
		return 1;
	#endif

	#ifdef TARGET_ALLEGRO
	install_keyboard();
	array = key;
	#endif

	#ifdef TARGET_SVGALIB
	keyboard_init();
	#endif

	return 0;
}

int C_input_api::UpdateKeyStates(void)
{
	#ifdef TARGET_WIN32
	int c;
	unsigned int *iptr;

	if(lpdiKeyb)
	{
		while(lpdiKeyb->GetDeviceState(256, array) == DIERR_INPUTLOST)
		{
			if(FAILED(lpdiKeyb->Acquire()))
				return 1;
		}

		c = 64;
		iptr = (unsigned int *)array;
		while(c--)
		{
			iptr[c] &= 0x80808080;
		}
	}
	#endif

	#ifdef TARGET_SVGALIB
	keyboard_update();
	array = keyboard_getstate();
	#endif

	return 0;
}

void C_input_api::SetCaps(bool on)
{
	//note : Windows doesn't let you changes the keyboard LEDs

	#ifdef TARGET_ALLEGRO
//	set_leds(on ? 0 : KB_CAPSLOCK_FLAG);
	#endif

	#ifdef TARGET_SVGALIB
	/* must find tty, get fd, then do this : */

//	ioctl("/dev/tty1", KDSETLED, on ? LED_CAP : 0);
	#endif
}

void C_input_api::ClearBuffer(void)
{
	#ifdef TARGET_ALLEGRO
	clear_keybuf();
	#endif
}

bool C_input_api::NewKey(void)
{
	#ifdef TARGET_ALLEGRO
	return (keypressed() == TRUE) ? true : false;
	#else
	int c;
	bool ret = false;

	c = MAX_ASCII;
	while(c--)
	{
		if((array[c] ^oldstates[c])&array[c])
		{
			ret = true;
		}
		oldstates[c] = array[c];
	}

	return ret;
	#endif
}

unsigned char C_input_api::GetPressedASCII(void)
{
	#ifdef TARGET_ALLEGRO
	return readkey();
	#else
	unsigned char *stable;
	int c;

	stable = (array[EKEY_LSHIFT] || array[EKEY_RSHIFT]) ? ascii_table_shift : ascii_table;
	c = MAX_ASCII;
	while(c--)
	{
		if(array[c] && stable[c])
			return stable[c];
	}

	return 0;
	#endif
}
