/*

  ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

  This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "gui.h"
#include "gfx.h"
extern C_gfx_api gfxdrvr;

#include "input.h"
extern C_input_api inputdrvr;

#include <malloc.h>

gui_messages gui_textline(gui_messages message, int x, int y, gui_element *owner)
{
	int w;
	char key;
	char *tbuffer;

	switch(message)
	{
		case GUIMSG_DRAW :

			gfxdrvr.SetTextArea(owner->x1, owner->y1, owner->x2, owner->y2);
			w = gfxdrvr.StrLen((char *)owner->data) >> 1;
			gfxdrvr.WriteString((char *)owner->data, (owner->x1+owner->x2 >> 1)-w, owner->y1+2, 160);

		return GUIMSG_NONE;

		case GUIMSG_KEYPRESS :
			key = inputdrvr.GetPressedASCII();

			if(key == '\b')
			{
				w = strlen((char *)owner->data);
				if(w)
				{
					((char *)owner->data)[w-1] = '\0';
					return GUIMSG_REDRAW;
				}
			}
			else
			{
				tbuffer = (char *)malloc(owner->c+1);
				sprintf(tbuffer, "%s%c", (char *)owner->data, key);
				w = strlen(tbuffer);

				if(w < owner->c)
				{
					strcpy((char *)owner->data, tbuffer);
					free(tbuffer);
					return GUIMSG_REDRAW;
				}
				free(tbuffer);
			}
		return GUIMSG_NONE;
	}
	return GUIMSG_NONE;
}

gui_messages gui_radio_button(gui_messages message, int x, int y, gui_element *owner)
{
	switch(message)
	{
		case GUIMSG_DRAW :
			gfxdrvr.Rectangle(owner->x1, owner->y1, owner->x2, owner->y2, 131);
			gfxdrvr.Rectangle(owner->x1+2, owner->y1+2, owner->x2-2, owner->y2-2, (*((int *)owner->data2) == owner->c) ? 8 : 0);

			gfxdrvr.SetTextArea(owner->x2+5, owner->y1, owner->x2+5+gfxdrvr.StrLen((char *)owner->data), owner->y2);
			gfxdrvr.WriteString((char *)owner->data, owner->x2+6, owner->y1, 160);
		return GUIMSG_NONE;

		case GUIMSG_LCLICK :
			if(*((int *)owner->data2) != owner->c)
			{
				*((int *)owner->data2) = owner->c;
				return GUIMSG_REDRAW;
			}
		return GUIMSG_NONE;
	}
	return GUIMSG_NONE;
}

gui_messages gui_button(gui_messages message, int x, int y, gui_element *owner)
{
	int w;

	switch(message)
	{
		case GUIMSG_DRAW :
			gfxdrvr.Rectangle(owner->x1, owner->y1, owner->x2, owner->y2, 130);
			gfxdrvr.Rectangle(owner->x1+2, owner->y1+2, owner->x2-2, owner->y2-2, 0);

			gfxdrvr.SetTextArea(owner->x1, owner->y1, owner->x2, owner->y2);
			w = gfxdrvr.StrLen((char *)owner->data) >> 1;
			gfxdrvr.WriteString((char *)owner->data, (owner->x1+owner->x2 >> 1)-w, owner->y1+2, owner->c);
		return GUIMSG_NONE;

		case GUIMSG_LCLICK :
			callfunc sel;

			sel = (callfunc)owner->data2;
			sel();
		return GUIMSG_REDRAW;
	}
	return GUIMSG_NONE;
}

gui_messages gui_down_arrow(gui_messages message, int x, int y, gui_element *owner)
{
	unsigned int w, wadd, cy;

	switch(message)
	{
		case GUIMSG_DRAW :
			gfxdrvr.Rectangle(owner->x1, owner->y1, owner->x2, owner->y2, owner->c);

			w = 65536;
			wadd = ((owner->x2 - owner->x1- 2) << 16) / (owner->y2 - owner->y1 - 2);

			for(cy = owner->y2-1; cy > owner->y1+1; cy--)
			{
				gfxdrvr.HorizLine(((owner->x1 + owner->x2) >> 1) - (w >> 17), cy, ((owner->x1 + owner->x2) >> 1) + (w >> 17), 8);
				w += wadd;
			}
		return GUIMSG_NONE;

		case GUIMSG_LCLICK :
			(*(int *)owner->data)++;
		return GUIMSG_REDRAW;
	}

	return GUIMSG_NONE;
}

gui_messages gui_up_arrow(gui_messages message, int x, int y, gui_element *owner)
{
	unsigned int w, wadd, cy;
	switch(message)
	{
		case GUIMSG_DRAW :
			gfxdrvr.Rectangle(owner->x1, owner->y1, owner->x2, owner->y2, owner->c);

			w = 65536;
			wadd = ((owner->x2 - owner->x1- 2) << 16) / (owner->y2 - owner->y1 - 2);

			for(cy = owner->y1+1; cy < owner->y2-1; cy++)
			{
				gfxdrvr.HorizLine(((owner->x1 + owner->x2) >> 1) - (w >> 17), cy, ((owner->x1 + owner->x2) >> 1) + (w >> 17), 8);
				w += wadd;
			}
		return GUIMSG_NONE;

		case GUIMSG_LCLICK :
			(*(int *)owner->data)--;
		return GUIMSG_REDRAW;
	}

	return GUIMSG_NONE;
}

gui_messages gui_draw_rect(gui_messages message, int x, int y, gui_element *owner)
{
	if(message == GUIMSG_DRAW)
	{
		gfxdrvr.Rectangle(owner->x1, owner->y1, owner->x2, owner->y2, owner->c);
	}

	return GUIMSG_NONE;
}

gui_messages gui_centre_string(gui_messages message, int x, int y, gui_element *owner)
{
	int w;

	if(message == GUIMSG_DRAW)
	{
		gfxdrvr.SetTextArea(owner->x1, owner->y1, owner->x2, owner->y2);
		w = gfxdrvr.StrLen((char *)owner->data) >> 1;
		gfxdrvr.WriteString((char *)owner->data, (owner->x1+owner->x2 >> 1)-w, owner->y1, owner->c);
	}

	return GUIMSG_NONE;
}

gui_messages gui_left_string(gui_messages message, int x, int y, gui_element *owner)
{
	if(message == GUIMSG_DRAW)
	{
		gfxdrvr.SetTextArea(owner->x1, owner->y1, owner->x2, owner->y2);
		gfxdrvr.WriteString((char *)owner->data, owner->x1, owner->y1, owner->c);
	}

	return GUIMSG_NONE;
}

