/*

  ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

  This is open software, distributed under the GPL 2, see 'Copying' for details

*/
#include "gui.h"
#include "gfx.h"
#include "elecscreen.h"
#include "6502.h"
#include "config.h"

extern C_gfx_api gfxdrvr;
extern C_screen elec_screen;
extern C_6502ULA electron;
extern C_config settings;

void gfx_finish(void);
int scalewhen = 0, scaletype = 0, resolution = 0;
int tapespeed = 0;

gui_element gfxscreen[] =
{
	{0, FONT_H+3, 640, 511, 0, gui_draw_rect},

	{322, 511-FONT_H-6, 639, 511, 160, gui_button, "Okay", gfx_finish},
	{0, (int)(FONT_H*1.5), 639, (int)(FONT_H*2.5), 184, gui_centre_string, "Graphics & Load Setup"},

	{0, (int)(FONT_H*3), 320, (int)(FONT_H*4), 176, gui_left_string, "Base Resolution :"},
	{2, (FONT_H*5), 2+FONT_H, (FONT_H*6), 0, gui_radio_button, "Low Resolution", &resolution},
	{2, (int)(FONT_H*6.5), 2+FONT_H, (int)(FONT_H*7.5), 1, gui_radio_button, "High Resolution", &resolution},

	{320, (int)(FONT_H*3), 639, (int)(FONT_H*4), 176, gui_left_string, "Loading Speed :"},
	{322, (FONT_H*5), 322+FONT_H, (FONT_H*6), 0, gui_radio_button, "Normal", &tapespeed},
	{322, (int)(FONT_H*6.5), 322+FONT_H, (int)(FONT_H*7.5), 3, gui_radio_button, "High", &tapespeed},

	{0, (int)(FONT_H*9), 320, (int)(FONT_H*10), 176, gui_left_string, "Scale when :"},
	{2, (FONT_H*11), 2+FONT_H, (FONT_H*12), 0, gui_radio_button, "No scaling", &scalewhen},
	{2, (int)(FONT_H*12.5), 2+FONT_H, (int)(FONT_H*13.5), 1, gui_radio_button, "Worst case scaling", &scalewhen},
	{2, (FONT_H*14), 2+FONT_H, (FONT_H*15), 2, gui_radio_button, "Always scale", &scalewhen},

	{320, (int)(FONT_H*9), 639, (int)(FONT_H*10), 176, gui_left_string, "Scaling type :"},
	{322, (FONT_H*11), 322+FONT_H, (FONT_H*12), 0, gui_radio_button, "Half multiple", &scaletype},
	{322, (int)(FONT_H*12.5), 322+FONT_H, (int)(FONT_H*13.5), 1, gui_radio_button, "Any", &scaletype},

	{0, 0, 0, 0, 0, NULL}
};

void gfx_finish(void)
{
	config_setting s;

	/* not the best place to do this, but might as well for now */

	s.result_type = INTEGER_RESULT;
	s.result_int = tapespeed;
	settings.FindSetting("tapespeed");
	settings.WriteSetting(s);
	tapespeed ? electron.InstallTapeHack() : electron.RemoveTapeHack();

	s.result_int = resolution;
	settings.FindSetting("vidmode");
	settings.WriteSetting(s);

	s.result_int = scalewhen;
	settings.FindSetting("scalelevel");
	settings.WriteSetting(s);

	s.result_type = BOOLEAN_RESULT;
	s.result_bool = scaletype ? false : true;
	settings.FindSetting("cleanscale");
	settings.WriteSetting(s);

	elec_screen.SetSize(resolution ? true : false, scalewhen, scaletype ? false : true);

	set_default_behind();
}

void setup_gfx(void)
{
	kill_front();
	elements[0] = gfxscreen;

	resolution = elec_screen.GetSize() ? 1 : 0;
	scalewhen = gfxdrvr.GetStretchLevel();
	scaletype = gfxdrvr.GetCleanScale() ? 0 : 1;
	tapespeed = electron.TapeHackPresent() ? 3 : 0;
}

