/*

	ElectrEm (c) 2000 Thomas Harte - an Acorn Electron Emulator

	This is open software, distributed under the GPL 2, see 'Copying' for details

	escrsmall.cpp
	=============

	Draws Electron pixel scanlines, 1 pixel to 1 pixel at Electron 320x256

*/
#include "6502.h"
#include "elecscreen.h"
#include <string.h>
#include "tape.h"

extern C_Tape tape;
extern C_screen elec_screen;
extern C_6502ULA electron;

void C_screen_small::DrawBlankLine(void)
{
	unsigned __int32 *vptr;

	vptr = (unsigned __int32 *)img.GetLinePtr(elec_screen.line);
	memset(vptr, 7, 320);
	img.ReleaseLinePtr();
}

void C_screen_small::DrawPelLine(void)
{
	int p_ptr, x;
	unsigned __int32 *vptr;
	unsigned __int8 col;

	vptr = (unsigned __int32 *)img.GetLinePtr(elec_screen.line);
	p_ptr = l_ptr;

	if(c_table->wide)
	{
		electron.ram_available = electron.wide_line;
		x = 80;
		while(!(p_ptr&32768) && x--)
		{
			col = mptr[p_ptr];
			p_ptr += 8;

			*vptr++ = c_table->b_table_thin[col].l1.a;
		}

		if(p_ptr & 32768)
		{
			p_ptr -= c_table->pitch;
			while(x--)
			{
				col = mptr[p_ptr];
				p_ptr += 8;

				*vptr++ = c_table->b_table_thin[col].l1.a;
			}
		}
	}
	else
	{
		electron.ram_available = electron.thin_line;
		x = 40;
		while(!(p_ptr&32768) && x--)
		{
			col = mptr[p_ptr];
			p_ptr += 8;

			*vptr++ = c_table->b_table_thin[col].l1.a;
			*vptr++ = c_table->b_table_thin[col].h1.a;
		}

		if(p_ptr & 32768)
		{
			p_ptr -= c_table->pitch;
			while(x--)
			{
				col = mptr[p_ptr];
				p_ptr += 8;

				*vptr++ = c_table->b_table_thin[col].l1.a;
				*vptr++ = c_table->b_table_thin[col].h1.a;
			}
		}
	}

	img.ReleaseLinePtr();
	l_ptr ++;
	elec_screen.y++;
	if(!(elec_screen.y&7))
	{
		l_ptr = p_ptr-7;
		if(c_table->spaced)
			elec_screen.blank = elec_screen.line;
	}
}

void C_screen_small::InitDisplay(void)
{
	locked = false;

//	if(!(tape.motor_on && tape.pause_display))
		if(img.BeginDraw())
		{
			locked = true;
			l_ptr = elec_screen.vid_addr.a;
			mptr = electron.GetNormalPtr(0);
			elec_screen.y = 0;
			elec_screen.blank = -3;
		}
}

void C_screen_small::EndDisplay(void)
{
	if(locked)
	{
		img.EndOperation();
		img.Blit();
	}
}

void C_screen_small::Setup(void)
{
	img.Create(*elec_screen.gfxptr, 320, 256);
}

void C_screen_small::End(void)
{
	img.Destroy();
}
