#ifndef CONFIG_H
#define CONFIG_H

#include <stdio.h>

enum set_types
{
	BOOLEAN_RESULT, INTEGER_RESULT, STRING_RESULT
};

struct config_setting
{
	bool result_bool;
	int result_int;
	char *result_string;

	set_types result_type;
};

struct i_config_setting
{
	struct i_config_setting *next;
	char *title;
	config_setting value;
	bool written;
};

enum line_types
{
	OPTION, COMMENT
};

struct config_line
{
	char *linebuf;
	line_types type;
	i_config_setting option;
};

class C_config
{
	public :
		C_config(void);
		~C_config(void);

		bool Open(char *name);
		void Close(void);

		bool FindSetting(char *name);
		config_setting ReadSetting(void);
		void WriteSetting(struct config_setting setting);

	private :
		i_config_setting *changelist, *current;
		config_line *lastline;
		char *lastname, *filename;

		FILE *infile;
};

#endif
