/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>
#include <stdio.h>
#include "bbc.h"
#include "sysvia.h"
#include "matrix.h"
#include "key.h"

// [PA4-PA6] [PA0-PA3]
// [PA7] = keypress state
// CA2 - keypress pulse on here
// BREAK KEY WIRED DIRECTLY TO RESET LINE

// link options seem to be in reverse (from OS disassembly)...

volatile BYTE KeyBoardMatrix[8][10];

BYTE SHIFTLock,CAPSLock,MotorLED;

void ResetKeyboard()
{
  short CountX,CountY;

  // do not clear the links (row 0)
  
    for (CountX=1; CountX<8; CountX++)
        for (CountY=0; CountY<=10; CountY++)
          KeyBoardMatrix[CountX][CountY]=0;

}


void BBCKey(BYTE Flag,BYTE Key)
{
    if (Flag)
      KeyBoardMatrix[Key>>4][Key & 0xf]=1;
    else
      KeyBoardMatrix[Key>>4][Key & 0xf]=0;

    if ((Key>>4)>0)
      SetSysCA2(Flag);
}



BYTE ReadKeyboard(BYTE Key)
{
  Key&=0x7f;
    if ((Key & 0xf)>0xa) // illegal values dealt with.... not pressed
      return (Key);

    if (KeyBoardMatrix[Key>>4][Key & 0xf]>0)
      Key|=0x80;

    SetSysCA2((KeyBoardMatrix[1][Key & 0xf]) ||
              (KeyBoardMatrix[2][Key & 0xf]) ||
              (KeyBoardMatrix[3][Key & 0xf]) ||
              (KeyBoardMatrix[4][Key & 0xf]) ||
              (KeyBoardMatrix[5][Key & 0xf]) ||
              (KeyBoardMatrix[6][Key & 0xf]) ||
              (KeyBoardMatrix[7][Key & 0xf]) );

  return(Key);
}


void CAPSLockOn()
{
  CAPSLock=CAPS_ON;
}

void CAPSLockOff()
{
  CAPSLock=CAPS_OFF;
}

void SHIFTLockOn()
{
  SHIFTLock=SHIFT_ON;
}

void SHIFTLockOff()
{
  SHIFTLock=SHIFT_OFF;
}

/* Crap -- doesn't work...
void UpdateLEDs()
{
  static BYTE OldShift,OldCaps,OldMotor;
//  union REGS regs;
    if ( SHIFTLock!=OldShift ||
         CAPSLock!=OldCaps ||
         MotorLED!=OldMotor)
    {
      OldShift=SHIFTLock;
      OldCaps=CAPSLock;
      OldMotor=MotorLED;

      SetLEDS(OldShift+OldCaps+OldMotor);

//        if ((inp(0x64) & 2)==2)
//          return; // only write to 0x60 if status bit1==0

      outp(0x60,0xed);
      outp(0x60,OldShift+OldCaps+OldMotor);
    }
}
*/
