/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include "bbc.h"
#include "adc.h"
#include "6502.h"
#include "main.h"
#include "6845crtc.h"
#include "videoula.h"
#include "sysvia.h"
#include "uservia.h"
#include "matrix.h"
#include "mode7c.h"
#include "serial.h"
//#include "disass.h"  // debug only

extern unsigned long TotalClockCycles;
extern int    CyclesToGo,OriginalCyclesToGo;


///////////////////////////////////////////////
// The virtual BBC !!!!!, Excluding the 6502 //
///////////////////////////////////////////////

#define MAXROMS (16)

static BYTE SidewaysMemory[MAXROMS][0x4000];
static BYTE SidewaysROMFlag[MAXROMS]; // ROM/RAM flags for each bank
BYTE CurrentROMReadOnly=TRUE;
BYTE CurrentSidewaysRAMAltered=FALSE;

///////////////////////////
//  Not much is there ?  //
///////////////////////////

static BYTE CurrentPagedROM=MAXROMS; // no ROM paged in
static BYTE BasicROM=MAXROMS;
static BYTE ROMCount=MAXROMS; // only used for loading

#define ROMTYPEOFFSET (6)
#define ROMNAMEOFFSET (9)


void FatalError(const char * format, ... )
{
  char Error[256];
  va_list arglist;

  va_start( arglist, format );
  strcpy( Error, "Error: " );
  _vbprintf( &Error[7], 248, format, arglist );
  va_end( arglist );
  strcat(Error,"\n");

  TextMode();
  Dump6502(stdout);
  printf(Error);
  exit(1);
}


void InitialiseMachine()
{
  short Count;
    if (ROMCount==MAXROMS)
    {
        for (Count=0; Count<MAXROMS; Count++)
        {
          memset(SidewaysMemory[Count],0,0x4000);
          SidewaysROMFlag[Count]=TRUE; // ROM flag for each bank      
        }

      // The OS ROM must be the first one read
      ReadROM(TRUE,"OS.ROM");
      ReadROM(TRUE,"BASIC.ROM");
      ReadROM(TRUE,"DOS.ROM");
      ReadROM(TRUE,"EXMON.ROM");
      ReadROM(TRUE,"DOCTOR.ROM");
        if (BasicROM==MAXROMS)
          FatalError("OS and/or BASIC not found");
    }
}


static void ReadROM(bool ROMFlag,char * FName)
{
  FILE * FileHandle=fopen(FName,"rb");

    if (FileHandle==NULL)
    {
        if (ROMCount>MAXROMS-2)
          FatalError("ROM not found %s\n",FName);
      return;
    }

    if (ROMCount==0)
      FatalError("Too many ROMS");

    if (ROMCount==MAXROMS) // loading OS
    {
        if ( fread(&AddressSpace[0xc000],0x4000,1,FileHandle)!=1)
          FatalError("OS ROM reading error");
      printf("Reading OS     %s\n",FName);
      ROMCount--;
    }
    else
    {
      int RomSize;
      printf("Reading ROM %2d %s -> ",ROMCount,FName);

      RomSize=fread(SidewaysMemory[ROMCount],0x1000,4,FileHandle);
        if ( RomSize<1)
          FatalError("ROM reading error");
        else if (RomSize==1)
        {
          memcpy(&SidewaysMemory[ROMCount][0x1000],SidewaysMemory[ROMCount],0x1000);
          memcpy(&SidewaysMemory[ROMCount][0x2000],SidewaysMemory[ROMCount],0x1000);
          memcpy(&SidewaysMemory[ROMCount][0x3000],SidewaysMemory[ROMCount],0x1000);
        }
        else if (RomSize==2)
        {
          memcpy(&SidewaysMemory[ROMCount][0x2000],SidewaysMemory[ROMCount],0x2000);
        }

        if ((SidewaysMemory[ROMCount][ROMTYPEOFFSET] & 0x81)==0)
        {
          BasicROM=ROMCount; 
          ROMFlag=TRUE; // never load BASIC into RAM
        }
      printf("(%c%c) %s\n",
              (SidewaysMemory[ROMCount][ROMTYPEOFFSET] & 0x80) ? 'S' : '-',
              (SidewaysMemory[ROMCount][ROMTYPEOFFSET] & 0x40) ? 'L' : '-',
              &SidewaysMemory[ROMCount][ROMNAMEOFFSET]);
      SidewaysROMFlag[ROMCount]=ROMFlag;
      ROMCount--;
    }
  fclose(FileHandle);
}

extern void CopyROM(char * Dest,char * Source);
#pragma aux CopyROM = \
"MOV ECX,0x1000" \
"REP MOVSD" \
parm [edi] [esi] \
modify [ecx edi esi];


void PageInROM(BYTE ROMNumber)
{
    if (CurrentPagedROM==ROMNumber)  // currently paged in
      return;

    if (!CurrentROMReadOnly && CurrentSidewaysRAMAltered) // swapping out ram, so copy it to ROM slot
      CopyROM(SidewaysMemory[CurrentPagedROM],&AddressSpace[0x8000]);

  CopyROM(&AddressSpace[0x8000],SidewaysMemory[ROMNumber]);
  CurrentROMReadOnly=SidewaysROMFlag[ROMNumber];
  CurrentSidewaysRAMAltered=FALSE;
  CurrentPagedROM=ROMNumber;
}


void WriteShiela(register WORD Address,register BYTE Value)
{
#ifdef DEV
  printf("WRITE SHIELA %4x=%2x\n",Address,Value);
#endif
    switch (Address & 0xf8)
    {
      case 0x00 : WriteCRTC(Address, Value);
                  break;
//      case 0x08 : Write6850ACIA(Address, Value);
//                  break;
      case 0x10 :
      case 0x18 : WriteSerialULA(Value); // one register
                  break;
      case 0x20 :
      case 0x28 : WriteVideoULA(Address,Value);
                  break;
      case 0x30 :
      case 0x38 : PageInROM(Value & 15); // one 4 bit register write only
                  break;
      case 0x40 :
      case 0x48 :
      case 0x50 :
      case 0x58 :
                  WriteSystemVIA(Address,Value);
                  break;
      case 0x60 :
      case 0x68 :
      case 0x70 :
      case 0x78 :
                  WriteUserVIA(Address,Value);
                  break;

//      case 0x80 :
//      case 0x88 :
//      case 0x90 :
//      case 0x98 : Write8721(Address,Value);
//                  break;
//      case 0xa0 :
//      case 0xa8 :
//      case 0xb0 :
//      case 0xb8 : WriteEconet(Address,Value); // Will never do shit
//                  break;
      case 0xc0 :
      case 0xc8 :
      case 0xd0 :
      case 0xd8 : WriteADC(Address,Value);
                  break;
//      case 0xe0 :
//      case 0xe8 :
//      case 0xf0 :
//      case 0xf8 : WriteTUBE(Address,Value); // Will never do shit
//                  break;
    }
}

/*
void WriteFRED(WORD Address,BYTE Value)
{
  AddressSpace[Address]=Value; // nothing at all - same value can be re-read
}

void WriteJIM(WORD Address,BYTE Value)
{
  AddressSpace[Address]=Value; // nothing at all - same value can be re-read
}
*/

BYTE ReadShiela(register WORD Address)
{
#ifdef DEV
  printf("READ SHIELA %4x\n",Address);
#endif
    switch (Address & 0xf8)
    {
      case 0x00 : return (ReadCRTC(Address));
                  break;
//      case 0x08 : return (Read6850ACIA(Address));
//                  break;
      case 0x10 :
      case 0x18 : return (ReadSerialULA()); // one register
                  break;
      case 0x20 :
      case 0x28 : return(ReadVideoULA(Address));
                  break;
      case 0x30 :
      case 0x38 : return(CurrentPagedROM);
                  break;

      case 0x40 :
      case 0x48 :
      case 0x50 :
      case 0x58 : return (ReadSystemVIA(Address));
                  break;
      case 0x60 :
      case 0x68 :
      case 0x70 :
      case 0x78 : return (ReadUserVIA(Address));
                  break;
//      case 0x80 :
//      case 0x88 :
//      case 0x90 :
//      case 0x98 : return(Read8721(Address));
//                  break;
//      case 0xa0 :
//      case 0xa8 :
//      case 0xb0 :
//      case 0xb8 : return(ReadEconet(Address)); // Will never do shit
//                  break;
      case 0xc0 :
      case 0xc8 :
      case 0xd0 :
      case 0xd8 : return(ReadADC(Address));
                  break;
//      case 0xe0 :
//      case 0xe8 :
//      case 0xf0 :
//      case 0xf8 : 
//                  return(ReadTUBE(Address)); // Will never do shit
//                  break;
    }
  return (AddressSpace[Address]);
}

/*
BYTE ReadFRED(WORD Address)
{
  return(AddressSpace[Address]); // nothing at all - same value can be re-read
}

BYTE ReadJIM(WORD Address)
{
  return(AddressSpace[Address]); // nothing at all - same value can be re-read
}
*/
