//
// my_view.h
//

#ifndef _MY_VIEW_H_
#define _MY_VIEW_H_

#include <Bitmap.h>
#include <View.h>

class my_view : public BView
{
private:
	BBitmap *the_bitmap;
	int bytes_per_row;
	unsigned char *bitmap_data;

	int y_offset;

	virtual void KeyDown(const char *bytes, int32 numBytes);
	virtual void KeyUp(const char *bytes, int32 numBytes);
	virtual void MessageReceived(BMessage *message);
	char switch_key(const char *bytes, int &row, int &col);

public:
	my_view(BRect frame);
	virtual void Draw(BRect update);

	unsigned char *get_image_data(void) {
		return bitmap_data;
	}
	int get_bytes_per_row(void) {
		return bytes_per_row;
	}
	int get_y_offset(void) {
		return y_offset;
	}

};

#endif	// _MY_VIEW_H_
