//
// my_app.cc
//


//#include <Application.h>

#include <Alert.h>
#include <Path.h>
#include <unistd.h>
#include "beebwin.h"
#include "my_app.h"


// From main.cc
int real_main(int argc,char *argv[]);

extern int new_argc;
extern char **new_argv;

// From main.cc
extern BeebWin *mainWin;


my_app::my_app(void) : BApplication("application/x-vnd.BeebEm")
{
	//BRect frame_rect;
	//frame_rect.Set(0, 0, 640, 256);
	//BeebWin *win = new BeebWin();

	// Find my path...
	app_info info;
	BPath path;
	GetAppInfo(&info);
	BEntry entry(&info.ref);
	entry.GetPath(&path);
	path.GetParent(&path);
	chdir(path.Path());


	// Check for ROM images...
	FILE *fp;
	got_roms = true;
	if (NULL==(fp = fopen("beebfile/basic", "r"))) {
		got_roms = false;
	}
	if (NULL==(fp = fopen("beebfile/os12", "r"))) {
		got_roms = false;
	}
	if (NULL==(fp = fopen("beebfile/dnfs", "r"))) {
		got_roms = false;
	}

	if (!got_roms) {
		char msg[] ="Place the files\n\n"
					"    basic\n"
					"    os12\n"
					"    dnfs\n\n"
					"in directory 'beebfile'";
		BAlert *error = new BAlert("Error", msg, "Whoops!");
		error->Go();
		//PostMessage(B_QUIT_REQUESTED);
	}
}


// Spawn the emulation thread...
void my_app::ReadyToRun(void)
{
	puts("ReadyToRun");

	if (got_roms) {
		status_t ret = B_ERROR;
		is_quitting = false;
		mainWin = new BeebWin (&ret, true);
		// exit if constructing the WindowScreen failed. 
		if ((mainWin == NULL) || (ret < B_OK)) {
			PostMessage (B_QUIT_REQUESTED);
		}
	} else {
		PostMessage(B_QUIT_REQUESTED);
	}

//	the_thread = spawn_thread(thread_func, "BeebEm Thread", B_NORMAL_PRIORITY, this);
//	resume_thread(the_thread);
}


void my_app::RestartThread(void)
{
	// Tell emulator thread to quit itself...
	//QuitEmulator = 1;

	// ..wait for it to finish..
	status_t l;
	wait_for_thread(the_thread, &l);

	// ..then restart it
	//bitmap_view->ClearScreen();
	the_thread = spawn_thread(thread_func, "BeBeeb", B_DISPLAY_PRIORITY, this);
	resume_thread(the_thread);
}


bool my_app::QuitRequested(void)
{
	// Tell emulator thread to quit itself...
	//QuitEmulator = 1;

	puts("my_app::QuitRequested");

	is_quitting = true;

//	kill_thread(the_thread);
//	status_t l;
//	wait_for_thread(the_thread, &l);
	return true;
}


long my_app::thread_func(void *obj)
{
	real_main(new_argc, new_argv);
	return 0;
}
