#ifndef _TIMER_H
#define _TIMER_H

/* Maximum number of timers that can be remembered at any one time */
#define MAX_TIMERS 10

/* Attributes to be changed by change_timer() */
#define TIMER_HANDLER  (1<<0)
#define TIMER_INTERVAL (1<<1)
#define TIMER_VALUE    (1<<2)

/* external function prototypes */
extern int init_timer();
extern int add_timer(long interval, long value, void (*func)(int));
extern void remove_timer(int index);
extern void change_timer(int index, int change,
			 long interval, long value, void (*func)(int));
extern long query_timer_expire(int index);
extern long query_timer_interval(int index);
#endif
