#ifndef _ULA_H
#define _ULA_H

/*
 * ULA globals
 * -----------
 */
extern unsigned long colours[8];

/*
 * ULA functions
 * -------------
 */
extern void init_ula(Display *d, int screen);

/*
 * Defines for the ULA control register bits
 * -----------------------------------------
 */

/*
 * The bit offsets
 */
#define ULAB_CW 5
#define ULAB_SP 4
#define ULAB_CL 2
#define ULAB_TT 1
#define ULAB_FL 0

#define ULA_CW (7 << ULAB_CW)
#define ULA_SP (1 << ULAB_SP)
#define ULA_CL (3 << ULAB_CL)
#define ULA_TT (1 << ULAB_TT)
#define ULA_FL (1 << ULAB_FL)

/*
 * Get ULA control values. The numbers returned are not shifted down to
 * their representation bit values. They should be used as boolean, or
 * by explicitly comparing with the relevant values defined below.
 */
#define get_ULA_CURSOR_WIDTH(c)   ((c) & ULA_CW)
#define get_ULA_6845_SPEED(c)     ((c) & ULA_SP)
#define get_ULA_CHAR_PER_LINE(c)  ((c) & ULA_CL)
#define get_ULA_TELETEXT(c)       ((c) & ULA_FT)
#define get_ULA_FLASH(c)          ((c) & ULA_FL)

/*
 * Set the bits
 */
#define set_ULA_CURSOR_WIDTH(c,v)  (c = (c & ~ULA_CW) | (v))
#define set_ULA_6845_SPEED(c,v)    (c = (c & ~ULA_SP) | (v))
#define set_ULA_CHAR_PER_LINE(c,v) (c = (c & ~ULA_CL) | (v))
#define set_ULA_TELETEXT(c,v)      (c = (c & ~ULA_FT) | (v))
#define set_ULA_FLASH(c,v)         (c = (c & ~ULA_FL) | (v))

/*
 * The meanings of values
 */

/* no cursor */
#define ULA_CW_0 0

/* cursor width 1, modes 0, 3, 4, 6 */
#define ULA_CW_1 (4 << ULAB_CW)

/* cursor width 2, modes 1, 5 */
#define ULA_CW_2 (6 << ULAB_CW)

/* cursor width 4, modes 2 */
#define ULA_CW_4 (7 << ULAB_CW)
/* all others are cursor width 1 (not true, but I'm cheating) */ 

/* speed is either low (modes 4-7) or high (modes 0-3) */
#define ULA_SP_lo 0
#define ULA_SP_hi (1 << ULAB_SP)

/* chars per line are 10, 20, 40 or 80 */
#define ULA_CL_10 (0 << ULAB_CL)
#define ULA_CL_20 (1 << ULAB_CL)
#define ULA_CL_40 (2 << ULAB_CL)
#define ULA_CL_80 (3 << ULAB_CL)

/* Teletext, either selected or not */
#define ULA_TT_0 0
#define ULA_TT_1 (1 << ULAB_TT)

/* Flash colour, selected or not */
#define ULA_FL_0 0
#define ULA_FL_1 (1 << ULAB_FL)

/* functions */

#endif
