/* 7. 05. 2003 */

#include "globalstuff.h"


/* Initialize the gadgets for the Preferences window */
BOOL create_gadgets() {

    struct Gadget       *textGadget[10];
    struct Gadget       *hourSlider;
    struct Gadget       *minuteSlider;
    struct Gadget       *textColorGadget;
    struct Gadget       *memoColorGadget;
    struct Gadget       *toggleAlarm;
    struct Gadget       *okButton;
    struct Gadget       *showContentGadget;

    struct NewGadget     ng;

    struct RastPort     *rp = &screen->RastPort;

    UWORD               depth;

    textColor = 1;

    /* Try to approximinate the longest text line in pixels */
    textWidth = TextLength(rp, "Select Minute", 13);

    if ( TextLength(rp, "Alarm ON/OFF", 11) > textWidth)
        textWidth = TextLength(rp, "Alarm ON/OFF", 11);

    if ( TextLength(rp, "10th textline", 13) > textWidth)
        textWidth = TextLength(rp, "10th textline", 13);

    textWidth += 32;

    //printf("Text Width: %d\n", textWidth);

    ng.ng_GadgetID   = TEXT0;
    ng.ng_LeftEdge   = textWidth;
    ng.ng_TopEdge    = screen->WBorTop + screen->Font->ta_YSize + 1 + 16;
    ng.ng_Width      = 180;
    ng.ng_Height     = 16;
    ng.ng_GadgetText = "1st textline";
    ng.ng_TextAttr   = screen->Font;
    ng.ng_Flags      = 0;
    ng.ng_VisualInfo = visualInfo;

    /* create String type gadgets: */
    textGadget[0] = CreateGadget(STRING_KIND, CreateContext(&gadgetList), &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);

    ng.ng_GadgetID   = TEXT1;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "2nd textline";

    textGadget[1] = CreateGadget(STRING_KIND, textGadget[0], &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);

    ng.ng_GadgetID   = TEXT2;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "3rd textline";


    textGadget[2] = CreateGadget(STRING_KIND, textGadget[1], &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);

    ng.ng_GadgetID   = TEXT3;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "4th textline";


    textGadget[3] = CreateGadget(STRING_KIND, textGadget[2], &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);

    ng.ng_GadgetID   = TEXT4;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "5th textline";


    textGadget[4] = CreateGadget(STRING_KIND, textGadget[3], &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);

    ng.ng_GadgetID   = TEXT5;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "6th textline";


    textGadget[5] = CreateGadget(STRING_KIND, textGadget[4], &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);

    ng.ng_GadgetID   = TEXT6;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "7th textline";


    textGadget[6] = CreateGadget(STRING_KIND, textGadget[5], &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);

    ng.ng_GadgetID   = TEXT7;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "8th textline";


    textGadget[7] = CreateGadget(STRING_KIND, textGadget[6], &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);

    ng.ng_GadgetID   = TEXT8;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "9th textline";


    textGadget[8] = CreateGadget(STRING_KIND, textGadget[7], &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);


    ng.ng_GadgetID   = TEXT9;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "10th textline";


    textGadget[9] = CreateGadget(STRING_KIND, textGadget[8], &ng,
                     GTST_String, (ULONG)"",
                     GTST_MaxChars, 20,
                     TAG_DONE);


    /* Palette */
    ng.ng_GadgetID   = MEMOCOLOR;
    ng.ng_TopEdge    = ng.ng_TopEdge + 24;
    ng.ng_Height     = 44;
    ng.ng_Flags      = PLACETEXT_LEFT;
    ng.ng_GadgetText = "MemoColor";

    /* Allow maximum of 256 colors */
    depth = drawInfo->dri_Depth;
    if (depth > 8)
        depth = 8;

    memoColorGadget = CreateGadget(PALETTE_KIND, textGadget[9],
                     &ng, GTPA_Depth, depth,
                     GTPA_Color, memoColor,
                     GTPA_ColorOffset, 0,
                     GTPA_IndicatorHeight, 10,
                     GTPA_NumColors, 16,
                     TAG_DONE);

    ng.ng_GadgetID   = TEXTCOLOR;
    ng.ng_TopEdge    = ng.ng_TopEdge + 44;
    ng.ng_GadgetText = "TextColor";

    textColorGadget = CreateGadget(PALETTE_KIND, memoColorGadget,
                     &ng, GTPA_Depth, depth,
                     GTPA_Color, textColor,
                     GTPA_ColorOffset, 0,
                     GTPA_IndicatorHeight, 10,
                     GTPA_NumColors, 16,
                     TAG_DONE);


    /* Hour Slider */
    ng.ng_GadgetID   = HOURSLIDER;
    ng.ng_TopEdge    = ng.ng_TopEdge + 52;
    ng.ng_GadgetText = "Select Hour";
    ng.ng_Height     = 16;

    hourSlider = CreateGadget(SLIDER_KIND, textColorGadget,
                     &ng, GTSL_Min, 0, GTSL_Max, 23,
                     GTSL_Level, hours,
                     GTSL_MaxLevelLen, 2,
                     GTSL_LevelPlace, PLACETEXT_RIGHT,
                     GTSL_LevelFormat, (ULONG)"%2ld",
                     GA_Immediate, TRUE,
                     GA_RelVerify, TRUE,
                     TAG_DONE);


    /* Minute Slider */
    ng.ng_GadgetID   = MINUTESLIDER;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "Select Minute";

    minuteSlider = CreateGadget(SLIDER_KIND, hourSlider,
                     &ng, GTSL_Min, 0, GTSL_Max, 59,
                     GTSL_Level, minutes,
                     GTSL_MaxLevelLen, 2,
                     GTSL_LevelPlace, PLACETEXT_RIGHT,
                     GTSL_LevelFormat, (ULONG)"%2ld",
                     GA_Immediate, TRUE,
                     GA_RelVerify, TRUE,
                     TAG_DONE);

    /* Toggle Alarm */
    ng.ng_GadgetID   = TOGGLEALARM;
    ng.ng_TopEdge    = ng.ng_TopEdge + 24;
    ng.ng_GadgetText = "Alarm ON/OFF";

    toggleAlarm = CreateGadget(CHECKBOX_KIND, minuteSlider,
                     &ng, GTCB_Checked, FALSE, TAG_DONE);

    /* Show Content */
    ng.ng_GadgetID   = SHOWCONTENT;
    ng.ng_TopEdge    = ng.ng_TopEdge + 16;
    ng.ng_GadgetText = "Show Content";

    showContentGadget = CreateGadget(CHECKBOX_KIND, toggleAlarm,
                     &ng, GTCB_Checked, FALSE, TAG_DONE);


    /* OK */
    ng.ng_GadgetID   = OKBUTTON;
    ng.ng_TopEdge    = ng.ng_TopEdge - 16;
    ng.ng_Width      = TextLength(rp, "Launch Memo!", 12) + 8;
    ng.ng_LeftEdge   = textWidth + 180 - ng.ng_Width;
    ng.ng_Height     = 32;
    ng.ng_Flags      = 0;
    ng.ng_GadgetText = "Launch Memo!";

    okButton = CreateGadget(BUTTON_KIND, showContentGadget,
                     &ng, TAG_DONE);

    if( textGadget[0] && textGadget[1] && textGadget[2] &&
        textGadget[3] && textGadget[4] && textColorGadget &&
        hourSlider && minuteSlider && toggleAlarm && okButton &&
        memoColorGadget && textGadget[5] && textGadget[6] &&
        textGadget[7] && textGadget[8] && textGadget[9] && showContentGadget ) {

            textWidth += 180 + TextLength(rp, "59", 2) + 32;
            return ( TRUE );

        } else
            return FALSE;

} /* create_gadgets() */
