/* $VER: 19.05.03 */

#include "globalstuff.h"
#include "protos.h"

#include <string.h>

/* Load previously save memo preferences */
void load_memos(STRPTR fileName) {

    struct Memo memoBuffer;

    struct PenNode *penNode;
    struct Node nd = { NULL, NULL };
    nd.ln_Type = NT_UNKNOWN;
    nd.ln_Pri = 0;
    nd.ln_Name = "Pen";
    
    UBYTE prefsVersion[] = "0.00\0";

    BPTR file;
    LONG loaded = 0;
    BYTE i;

    doubleBorders = FALSE;

    if ( ! ( file = Open( fileName, MODE_OLDFILE ) ) ) {

        puts("No initial prefences file");

    } else {

        /* Check version */
        if ( ( loaded = FRead(file, &prefsVersion, sizeof( strlen(version) ), 1 ) ) == 1 )
        {

            /* Version match */
            if ( strcmp( version, prefsVersion ) == 0 )
            {

                /* Show content setting */
                FRead( file, &showContent, sizeof( BOOL ), 1 );

                while( (loaded = FRead( file, &memoBuffer, sizeof( struct Memo ), 1 ) ) == 1 ) {

                    zipped = memoBuffer.zipped;

                    tColor = memoBuffer.tColor;
                    mColor = memoBuffer.mColor;

                    /* Try to get proper pens :*/

                    textColor = (WORD)ObtainBestPen(cm, tColor.red, tColor.green, tColor.blue, TAG_DONE);
                    if ( textColor == -1 ) {
                        textColor = memoBuffer.textColor;
                    } else {
                        if ( ( penNode = (struct PenNode *)AllocVec( sizeof(struct PenNode), MEMF_PUBLIC ) ) ) {
                            penNode->node = nd;
                            penNode->pen = textColor;
                            AddTail(&penList, (struct Node *)penNode);
                        }
                    }
                     
                    memoColor = (WORD)ObtainBestPen(cm, mColor.red, mColor.green, mColor.blue, TAG_DONE);
                    if ( memoColor == -1 ) {
                        memoColor = memoBuffer.memoColor;
                    } else {
                        if ( ( penNode = (struct PenNode *)AllocVec( sizeof(struct PenNode), MEMF_PUBLIC ) ) ) {
                            penNode->node = nd;
                            penNode->pen = memoColor;
                            AddTail(&penList, (struct Node *)penNode);
                        }
                    }

                    for ( i = 0 ; i < 10 ; i++ ) {
                        strncpy( text[i], memoBuffer.text[i], 20 );
                    }

                    alarm = memoBuffer.alarm;
                    hours = memoBuffer.hours;
                    minutes = memoBuffer.minutes;

                    origWidth = memoBuffer.origWidth;
                    origHeight = memoBuffer.origHeight;

                    mx = memoBuffer.x;
                    my = memoBuffer.y;

                    open_newMemo();
                }

            }

        }

        Close( file );

    }

}


/* Save memo preferences to a file */
void save_memos(STRPTR fileName) {

    struct Node *node;

    BPTR file;
    LONG written;

    if ( ! ( file = Open( fileName, MODE_NEWFILE ) ) ) {

        puts("Can't create preferences file.\n");

    } else {

        /* Write version information */
        FWrite( file, version, sizeof( strlen(version) ), 1 );

        /* Show content setting */
        FWrite( file, &showContent, sizeof( BOOL ), 1 );

        node = memoList.lh_Head;

        while ( node->ln_Succ ) {

            /* Save the window location */
            ((struct Memo *)node)->x = ((struct Memo *)node)->window->LeftEdge;
            ((struct Memo *)node)->y = ((struct Memo *)node)->window->TopEdge;

            /* Get the RGB values for pens */
            GetRGB32( cm, (ULONG)((struct Memo *)node)->textColor, 1, (ULONG *)&( ((struct Memo*)node)->tColor ) );
            GetRGB32( cm, (ULONG)((struct Memo *)node)->memoColor, 1, (ULONG *)&( ((struct Memo*)node)->mColor ) );

            if ( ( written = FWrite( file, (struct Memo*) node, sizeof(struct Memo), 1 ) ) == 1 )
//                printf("Memo written to file\n");
                ;

            node = node->ln_Succ;
        }

        Close( file );
    }

}

