/*
	read.h
	Copyright (c) 2004 Kalle Risnen.


	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>

#define VERSTAG "read 0.3.6 (2004-04-30): Copyright (c) 2004 Kalle Risnen."

#define DEF_IFS " "
#define DEF_MAXREAD 768
#define MAXLEN DEF_MAXREAD


#ifdef AROS
#	include <exec/types.h>
#	include <proto/dos.h>
#	include <proto/intuition.h>
#else
#	define RETURN_FAIL 128
#	define RETURN_WARN   0 /* WARN is success */
#	define RETURN_OK     1
#endif


/* prototypes */
long get_secs(void);
int  get_str(FILE *in, char *buff, int max_len, int escape, int timeout, int s, char *delim);
void put_str(FILE *op, char *s, int escape);
int  get_word(char *str, char *out, int start, char *delim);
int  str_to_vars(char *str, char **vars, int num_vars, char *delim, int escape);
void *xmalloc(int size);
void error(char *fmt, ...);
void set_env(char *name, char *value);
char *get_env(char *name);
int  parse_escape(int c);
