/*--------------------------------------------------------------------------*/
/* Resident header written for ttengine.library */
/*--------------------------------------------------------------------------*/

#define __NOLIBBASE__

#define VERSION         7
#define REVISION        2

#define COMPDATE        "22.12.2005"
#define VERS            "7.2"

#include <proto/exec.h>
#include <exec/resident.h>
#include <exec/nodes.h>
#include <exec/libraries.h>
#include "lib.h"
#include "lib_req.h"
#include "lib_famlist.h"

const UBYTE lib_name[] = "ttengine.library";

const UBYTE lib_id[] = "$VER: ttengine.library " VERS " (" COMPDATE ") by Grzegorz "
  "\"Krashan\" Kraszewski (AROS)\n";

#define LIBBASETYPE 	struct TTEngineBase
#define LIBBASETYPEPTR  LIBBASETYPE *

extern const APTR FuncTable[];

AROS_UFP3 (LIBBASETYPEPTR, InitLib,
    AROS_UFPA(LIBBASETYPEPTR, ttb, D0),
    AROS_UFPA(BPTR, seglist, A0),
    AROS_UFPA(struct ExecBase *, sysbase, A6)
);

static struct LibInitStruct
{
    IPTR                   LibSize;
    const APTR             *FuncTable;
    const struct DataTable *DataTable;
    APTR                    InitFunc;
}
const LibInitStruct =
{
    sizeof(LIBBASETYPE),
    FuncTable,
    NULL,
    (APTR)InitLib
};

const struct Resident romtag =
{
  RTC_MATCHWORD,              /* match word */
  (APTR)&romtag,              /* back pointer */
  (APTR)(&romtag + 1),        /* skip pointer */
  RTF_AUTOINIT | RTF_EXTENDED,/* flags */
  VERSION,                    /* version */
  NT_LIBRARY,                 /* type of module */
  0,                          /* init priority */
  (STRPTR)lib_name,           /* module name */
  (STRPTR)lib_id + 6,
  (APTR)&LibInitStruct,
  REVISION, NULL
};

LONG dummy_f(VOID)
{
    return -1;
}

AROS_UFH3 (LIBBASETYPEPTR, InitLib,
    AROS_UFHA(LIBBASETYPEPTR, ttb, D0),
    AROS_UFHA(BPTR, seglist, A0),
    AROS_UFHA(struct ExecBase *, sysbase, A6)
)
{
    AROS_USERFUNC_INIT
    
    ttb->ttb_SegList = seglist;
    ttb->ttb_SysBase = sysbase;
    ttb->ttb_MemCacheLimit = 524288;
    ttb->ttb_DefGamma = 2500;
    NEWLIST(&ttb->ttb_MemoryCache);
    NEWLIST(&ttb->ttb_DataBase);
    NEWLIST(&ttb->ttb_EnvList);
    NEWLIST(&ttb->ttb_FontList);
    Ttb = ttb;
    return ttb;
    
    AROS_USERFUNC_EXIT
}

AROS_LH1(LIBBASETYPEPTR, LibOpen,
    AROS_LHA (ULONG, version, D0),
    LIBBASETYPEPTR, ttb, 1, ttengine
)
{
    AROS_LIBFUNC_INIT

    (void)version;
    
    return LibOpen(ttb);

    AROS_LIBFUNC_EXIT
    
}

AROS_LH0(BPTR, LibClose,
    LIBBASETYPEPTR, ttb, 2, ttengine
)
{
    AROS_LIBFUNC_INIT

    return (BPTR)LibClose(ttb);
	
    AROS_LIBFUNC_EXIT
}

AROS_LH1(BPTR, LibExpunge,
    AROS_LHA(LIBBASETYPEPTR, ttb, D0),
    struct ExecBase *, sysBase, 3, ttengine
)
{
    AROS_LIBFUNC_INIT

    (void)sysBase;
    
    return (BPTR)LibExpunge(ttb);
	
    AROS_LIBFUNC_EXIT
}

AROS_LH0(LIBBASETYPEPTR, LibReserved,
    LIBBASETYPEPTR, ttb, 4, ttengine
)
{
    AROS_LIBFUNC_INIT
    
    return (APTR)LibReserved();
    
    AROS_LIBFUNC_EXIT
}

AROS_LH1(APTR, TT_OpenFontA,
    AROS_LHA(struct TagItem *, taglist, A0),
    LIBBASETYPEPTR, ttb, 5, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_OpenFontA(ttb, taglist);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH2(BOOL, TT_SetFont,
    AROS_LHA(struct RastPort *, rp, A1),
    AROS_LHA(APTR, font, A0),
    LIBBASETYPEPTR, ttb, 6, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_SetFont(ttb, rp, font);
     
    AROS_LIBFUNC_EXIT
}

AROS_LH1(VOID, TT_CloseFont,
    AROS_LHA(APTR, font, A0),
    LIBBASETYPEPTR, ttb, 7, ttengine)
{
    AROS_LIBFUNC_INIT
    
    tt_CloseFont(ttb, font);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH3(VOID, TT_Text,
    AROS_LHA(struct RastPort *, rp, A1),
    AROS_LHA(APTR, string, A0),
    AROS_LHA(ULONG, count, D0),
    LIBBASETYPEPTR, ttb, 8, ttengine)
{
    AROS_LIBFUNC_INIT
    
    tt_Text(ttb, rp, string, count); 
    
    AROS_LIBFUNC_EXIT
}

AROS_LH2(ULONG, TT_SetAttrsA,
    AROS_LHA(struct RastPort *, rp, A1),
    AROS_LHA(struct TagItem *, taglist, A0),
    LIBBASETYPEPTR, ttb, 9, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_SetAttrsA(ttb, rp, taglist);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH2(ULONG, TT_GetAttrsA,
    AROS_LHA(struct RastPort *, rp, A1),
    AROS_LHA(struct TagItem *, taglist, A0),
    LIBBASETYPEPTR, ttb, 10, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_GetAttrsA(ttb, rp, taglist);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH3(ULONG, TT_TextLength,
    AROS_LHA(struct RastPort *, rp, A1),
    AROS_LHA(APTR, string, A0),
    AROS_LHA(ULONG, count, D0),
    LIBBASETYPEPTR, ttb, 11, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_TextLength(ttb, rp, string, count);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH4(VOID, TT_TextExtent,
    AROS_LHA(struct RastPort *, rp, A1),
    AROS_LHA(APTR, string, A0),
    AROS_LHA(WORD, count, D0),
    AROS_LHA(struct TextExtent *, te, A2),
    LIBBASETYPEPTR, ttb, 12, ttengine)
{
    AROS_LIBFUNC_INIT
    
    tt_TextExtent(ttb, rp, string, count, te);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH8(ULONG, TT_TextFit,
    AROS_LHA(struct RastPort *, rp, A1),
    AROS_LHA(APTR, string, A0),
    AROS_LHA(UWORD, count, D0),
    AROS_LHA(struct TextExtent *, te, A2),
    AROS_LHA(struct TextExtent *, tec, A3),
    AROS_LHA(WORD, dir, D1),
    AROS_LHA(UWORD, cwidth, D2),
    AROS_LHA(UWORD, cheight, D3),
    LIBBASETYPEPTR, ttb, 13, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_TextFit(ttb, rp, string, count, te, tec, dir, cwidth, cheight);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH4(struct TT_Pixmap *, TT_GetPixmapA,
    AROS_LHA(APTR, font, A1),
    AROS_LHA(APTR, string, A2),
    AROS_LHA(ULONG, count, D0),
    AROS_LHA(struct TagItem *, taglist, A0),
    LIBBASETYPEPTR, ttb, 14, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_GetPixmapA(ttb, font, string, count, taglist);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH1(void, TT_FreePixmap,
    AROS_LHA(struct TT_Pixmap *, pixmap, A0),
    LIBBASETYPEPTR, ttb, 15, ttengine)
{
    AROS_LIBFUNC_INIT
    
    tt_FreePixmap(ttb, pixmap); 
    
    AROS_LIBFUNC_EXIT
}

AROS_LH1(VOID, TT_DoneRastPort,
    AROS_LHA(struct RastPort *, rp, A1),
    LIBBASETYPEPTR, ttb, 16, ttengine)
{
    AROS_LIBFUNC_INIT
    
    tt_DoneRastPort(ttb, rp); 
    
    AROS_LIBFUNC_EXIT
}

AROS_LH0(APTR, TT_AllocRequest,
    LIBBASETYPEPTR, ttb, 17, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_AllocRequest(ttb);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH2(struct TagItem *, TT_RequestA,
    AROS_LHA(APTR, request, A0),
    AROS_LHA(struct TagItem *, taglist, A1),
    LIBBASETYPEPTR, ttb, 18, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_RequestA(ttb, request, taglist);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH1(VOID, TT_FreeRequest,
    AROS_LHA(APTR, request, A0),
    LIBBASETYPEPTR, ttb, 19, ttengine)
{
    AROS_LIBFUNC_INIT
    
    tt_FreeRequest(ttb, request);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH1(STRPTR *, TT_ObtainFamiliyListA,
    AROS_LHA(struct TagItem *, taglist, A0),
    LIBBASETYPEPTR, ttb, 20, ttengine)
{
    AROS_LIBFUNC_INIT
    
    return tt_ObtainFamilyListA(ttb, taglist);
    
    AROS_LIBFUNC_EXIT
}

AROS_LH1(VOID, TT_FreeFamilyList,
    AROS_LHA(STRPTR *, list, A0),
    LIBBASETYPEPTR, ttb, 21, ttengine)
{
    AROS_LIBFUNC_INIT
    
    tt_FreeFamilyList(ttb, list); 
    
    AROS_LIBFUNC_EXIT
}


const APTR FuncTable[] = 
{
    &AROS_SLIB_ENTRY(LibOpen,ttengine),
    &AROS_SLIB_ENTRY(LibClose,ttengine),
    &AROS_SLIB_ENTRY(LibExpunge,ttengine),
    &AROS_SLIB_ENTRY(LibReserved,ttengine),
    &AROS_SLIB_ENTRY(TT_OpenFontA,ttengine),
    &AROS_SLIB_ENTRY(TT_SetFont,ttengine),
    &AROS_SLIB_ENTRY(TT_CloseFont,ttengine),
    &AROS_SLIB_ENTRY(TT_Text,ttengine),
    &AROS_SLIB_ENTRY(TT_SetAttrsA,ttengine),
    &AROS_SLIB_ENTRY(TT_GetAttrsA,ttengine),
    &AROS_SLIB_ENTRY(TT_TextLength,ttengine),
    &AROS_SLIB_ENTRY(TT_TextExtent,ttengine),
    &AROS_SLIB_ENTRY(TT_TextFit,ttengine),
    &AROS_SLIB_ENTRY(TT_GetPixmapA,ttengine),
    &AROS_SLIB_ENTRY(TT_FreePixmap,ttengine),
    &AROS_SLIB_ENTRY(TT_DoneRastPort,ttengine),
    &AROS_SLIB_ENTRY(TT_AllocRequest,ttengine),
    &AROS_SLIB_ENTRY(TT_RequestA,ttengine),
    &AROS_SLIB_ENTRY(TT_FreeRequest,ttengine),
    &AROS_SLIB_ENTRY(TT_ObtainFamiliyListA,ttengine),
    &AROS_SLIB_ENTRY(TT_FreeFamilyList,ttengine),
    (void *)-1
};


