
#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/pngflux.h>
#include <proto/intuition.h>

struct Library *PngfluxBase;

int main (void)

{
struct RDArgs *rdargs = NULL;
struct {
	char *file;
	} args;

if (!(PngfluxBase = OpenLibrary (PNGFLUXNAME,PNGFLUXVERSION)))
	{
	Printf (PNGFLUXNAME " is missing.\n");
	return (RETURN_FAIL);
	}

if (rdargs = ReadArgs ("FILE/A",(APTR)&args,NULL))
	{
	struct PNGFObject *obj;

	if (obj = pngfLoad (args.file))
		{
		struct Window *win;
		UBYTE *array;

		array = pngfGetAttr (obj,PNGFA_ARGBDATA);

		Printf ("RGB array = 0x%lx\n",array);

		if (win = OpenWindowTags (NULL,
				WA_InnerWidth, obj->pfo_Width,
				WA_InnerHeight, obj->pfo_Height,
				WA_Flags, WFLG_CLOSEGADGET | WFLG_DRAGBAR | WFLG_DEPTHGADGET | WFLG_ACTIVATE | WFLG_NOCAREREFRESH,
				WA_IDCMP, IDCMP_VANILLAKEY | IDCMP_CLOSEWINDOW,
				TAG_END))
			{
			BOOL cont = TRUE;

			pngfDraw (obj,win->RPort,win->BorderLeft,win->BorderTop);

			do	{
				struct IntuiMessage *imsg;

				if (Wait ((1L << win->UserPort->mp_SigBit) | SIGBREAKF_CTRL_C) & SIGBREAKF_CTRL_C)
					cont = FALSE;

				while (imsg = (struct IntuiMessage *) GetMsg (win->UserPort))
					{
					switch (imsg->Class)
						{
					case IDCMP_VANILLAKEY:
						if (imsg->Code == 0x1b) /* Esc */
							cont = FALSE;
						break;
					case IDCMP_CLOSEWINDOW:
						cont = FALSE;
						break;
						}
					ReplyMsg ((struct Message *) imsg);
					}
				}
			while (cont);

			CloseWindow (win);
			}

		FreeVec (obj);
		}
	else
		PrintFault (IoErr(),args.file);

	FreeArgs (rdargs);
	}
else
	{
	PrintFault (IoErr(),NULL);
	return (RETURN_FAIL);
	}

CloseLibrary (PngfluxBase);
return (RETURN_OK);
}

