#ifndef _INLINE_PNGFLUX_H
#define _INLINE_PNGFLUX_H

#ifndef CLIB_PNGFLUX_PROTOS_H
#define CLIB_PNGFLUX_PROTOS_H
#endif

#ifndef __INLINE_MACROS_H
#include <inline/macros.h>
#endif

#ifndef  GRAPHICS_RASTPORT_H
#include <graphics/rastport.h>
#endif
#ifndef  LIBRARIES_PNGFLUX_H
#include <libraries/pngflux.h>
#endif

#ifndef PNGFLUX_BASE_NAME
#define PNGFLUX_BASE_NAME PngfluxBase
#endif

#define pngfLoad(filename) \
	LP1(0x1e, struct PNGFObject *, pngfLoad, CONST_STRPTR, filename, a0, \
	, PNGFLUX_BASE_NAME)

#define pngfGetAttr(object, AttrNr) \
	LP2(0x24, APTR, pngfGetAttr, struct PNGFObject *, object, a0, ULONG, AttrNr, d0, \
	, PNGFLUX_BASE_NAME)

#define pngfDraw(object, rp, x, y) \
	LP4NR(0x2a, pngfDraw, struct PNGFObject *, object, a0, struct RastPort *, rp, a1, ULONG, x, d0, ULONG, y, d1, \
	, PNGFLUX_BASE_NAME)

#define pngfDrawClip(pngfobject, rp, rpx, rpy, imagex, imagey, width, height) \
	LP8NR(0x30, pngfDrawClip, struct PNGFObject *, pngfobject, a0, struct RastPort *, rp, a1, WORD, rpx, d0, WORD, rpy, d1, UWORD, imagex, d2, UWORD, imagey, d3, UWORD, width, d4, UWORD, height, d5, \
	, PNGFLUX_BASE_NAME)

#define pngfDrawArray(pngfobject, array, arrayx, arrayy, imagex, imagey, width, height, arraywidth) \
	LP9NR(0x36, pngfDrawArray, struct PNGFObject *, pngfobject, a0, UBYTE *, array, a1, WORD, arrayx, d0, WORD, arrayy, d1, UWORD, imagex, d2, UWORD, imagey, d3, UWORD, width, d4, UWORD, height, d5, UWORD, arraywidth, d6, \
	, PNGFLUX_BASE_NAME)

#endif /*  _INLINE_PNGFLUX_H  */
