// ISO C9x  compliant stdint.h for Miscrosoft Visual Studio
// Based on ISO/IEC 9899:TC2 Committee draft (May 6, 2005) WG14/N1124 
// 
//  Copyright (c) 2006 Alexander Chemeris
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// 
//   1. Redistributions of source code must retain the above copyright notice,
//      this list of conditions and the following disclaimer.
// 
//   2. Redistributions in binary form must reproduce the above copyright
//      notice, this list of conditions and the following disclaimer in the
//      documentation and/or other materials provided with the distribution.
// 
//   3. The name of the author may be used to endorse or promote products
//      derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
// EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 
///////////////////////////////////////////////////////////////////////////////

// modified version of ../win/stdint.h for Amiga port, 23.12.2007 by akl

#ifndef _MSC_STDINT_H_ //
#define _MSC_STDINT_H_

#include <limits.h>

// 7.18.1 Integer types

#ifdef __SASC
struct __int64S
{
 long _LL[2];
};
struct __int64U
{
 unsigned long _LL[2];
};
typedef struct __int64S __int64TS;
typedef struct __int64U __int64TU;
#define __int8 char
#define __int16 short int
#define __int32 long
#else
#define __int8 char
#define __int16 short int
#define __int32 long
#define __int64 long long
#endif

// 7.18.1.1 Exact-width integer types
typedef __int8            int8_t;
typedef __int16           int16_t;
typedef __int32           int32_t;
typedef unsigned __int8   uint8_t;
typedef unsigned __int16  uint16_t;
typedef unsigned __int32  uint32_t;

#ifdef __SASC
typedef __int64TS          int64_t;
typedef __int64TU         uint64_t;
#else
typedef __int64           int64_t;
typedef unsigned __int64  uint64_t;
#endif

// 7.18.1.2 Minimum-width integer types
typedef int8_t    int_least8_t;
typedef int16_t   int_least16_t;
typedef int32_t   int_least32_t;
typedef int64_t   int_least64_t;
typedef uint8_t   uint_least8_t;
typedef uint16_t  uint_least16_t;
typedef uint32_t  uint_least32_t;
typedef uint64_t  uint_least64_t;

// 7.18.1.3 Fastest minimum-width integer types
typedef int8_t    int_fast8_t;
typedef int16_t   int_fast16_t;
typedef int32_t   int_fast32_t;
typedef int64_t   int_fast64_t;
typedef uint8_t   uint_fast8_t;
typedef uint16_t  uint_fast16_t;
typedef uint32_t  uint_fast32_t;
typedef uint64_t  uint_fast64_t;

// 7.18.1.4 Integer types capable of holding object pointers
typedef int               intptr_t;
typedef unsigned int      uintptr_t;

// 7.18.1.5 Greatest-width integer types
typedef int64_t   intmax_t;
typedef uint64_t  uintmax_t;


// 7.18.2 Limits of specified-width integer types

#if !defined(__cplusplus) || defined(__STDC_LIMIT_MACROS)

// 7.18.2.1 Limits of exact-width integer types
#ifdef __SASC
#define INT8_MIN    (-127-1)
#define INT8_MAX      127
#define INT16_MIN   (-32767-1)
#define INT16_MAX     32767
#define INT32_MIN   (-2147483647-1)
#define INT32_MAX    2147483647
#define INT64_MIN    ((((UINT32_MAX*UINT32_MAX+2)/2)+1)*-1)
#define INT64_MAX     (((UINT32_MAX*UINT32_MAX+2)/2)+1)
#define UINT8_MAX     255
#define UINT16_MAX    65535
#define UINT32_MAX    4294967295
#define UINT64_MAX    (UINT32_MAX*UINT32_MAX-1)
#else
#define INT8_MIN    (-127-1)
#define INT8_MAX      127
#define INT16_MIN   (-32767-1)
#define INT16_MAX     32767
#define INT32_MIN   (-2147483647-1)
#define INT32_MAX    2147483647
#define INT64_MIN    (((UINT32_MAX*UINT32_MAX+2)/2)+1)*-1)
#define INT64_MAX     ((UINT32_MAX*UINT32_MAX+2)/2)+1)
#define UINT8_MAX     255
#define UINT16_MAX    65535
#define UINT32_MAX    4294967295
#define UINT64_MAX    (UINT32_MAX*UINT32_MAX-1)
#endif

// 7.18.2.2 Limits of minimum-width integer types
#define INT_LEAST8_MIN    INT8_MIN
#define INT_LEAST8_MAX    INT8_MAX
#define INT_LEAST16_MIN   INT16_MIN
#define INT_LEAST16_MAX   INT16_MAX
#define INT_LEAST32_MIN   INT32_MIN
#define INT_LEAST32_MAX   INT32_MAX
#define INT_LEAST64_MIN   INT64_MIN
#define INT_LEAST64_MAX   INT64_MAX
#define UINT_LEAST8_MAX   UINT8_MAX
#define UINT_LEAST16_MAX  UINT16_MAX
#define UINT_LEAST32_MAX  UINT32_MAX
#define UINT_LEAST64_MAX  UINT64_MAX

// 7.18.2.3 Limits of fastest minimum-width integer types
#define INT_FAST8_MIN    INT8_MIN
#define INT_FAST8_MAX    INT8_MAX
#define INT_FAST16_MIN   INT16_MIN
#define INT_FAST16_MAX   INT16_MAX
#define INT_FAST32_MIN   INT32_MIN
#define INT_FAST32_MAX   INT32_MAX
#define INT_FAST64_MIN   INT64_MIN
#define INT_FAST64_MAX   INT64_MAX
#define UINT_FAST8_MAX   UINT8_MAX
#define UINT_FAST16_MAX  UINT16_MAX
#define UINT_FAST32_MAX  UINT32_MAX
#define UINT_FAST64_MAX  UINT64_MAX

// 7.18.2.4 Limits of integer types capable of holding object pointers
#define INTPTR_MIN   INT32_MIN
#define INTPTR_MAX   INT32_MAX
#define UINTPTR_MAX  UINT32_MAX

// 7.18.2.5 Limits of greatest-width integer types
#define INTMAX_MIN   INT64_MIN
#define INTMAX_MAX   INT64_MAX
#define UINTMAX_MAX  UINT64_MAX

// 7.18.3 Limits of other integer types

#define PTRDIFF_MIN  _I32_MIN
#define PTRDIFF_MAX  _I32_MAX

#define SIG_ATOMIC_MIN  INT_MIN
#define SIG_ATOMIC_MAX  INT_MAX

#ifndef SIZE_MAX
#define SIZE_MAX  _UI32_MAX
#endif

#define WINT_MIN  0
#define WINT_MAX  _UI16_MAX

#endif // __STDC_LIMIT_MACROS


// 7.18.4 Limits of other integer types

#if !defined(__cplusplus) || defined(__STDC_CONSTANT_MACROS) // [   See footnote 224 at page 260

// 7.18.4.1 Macros for minimum-width integer constants

#define INT8_C(val)  val
#define INT16_C(val) val
#define INT32_C(val) val##L
#define INT64_C(val) val##i64

#define UINT8_C(val)  val
#define UINT16_C(val) val
#define UINT32_C(val) val##UL
#define UINT64_C(val) val##Ui64

// 7.18.4.2 Macros for greatest-width integer constants
#define INTMAX_C   INT64_C
#define UINTMAX_C  UINT64_C

#endif // __STDC_CONSTANT_MACROS ]


#endif // _MSC_STDINT_H_