/*
**      $VER: iptcdata.h 1.0 (1.11.2007)
**
**      Core functions for iptcdata.library
**
**      (C) Copyright 2007 Andreas R. Kleinert
**      All Rights Reserved.
*/

#include <iptcdata/iptcdata.h>

struct IptcHandle
{
 ULONG           ih_Version;

 ULONG           ih_FreeFlag;

 struct Library *ih_MathDB;
 struct Library *ih_MathDT;

 APTR            ih_IptcData;

  LONG           ih_IptcOff;
  LONG           ih_IptcLen;

 UBYTE          *ih_Marker;
 ULONG           ih_MarkerLen;
};

#include <libiptcdata/iptc-data.h>
#include <libiptcdata/iptc-utils.h>
#include <libiptcdata/iptc-tag.h>
#include <libiptcdata/iptc-mem.h>
#include <libiptcdata/iptc-jpeg.h>

extern struct SignalSemaphore __aligned IptcSemaphore;

struct IptcHandle * __saveds __asm IPTC_Open( register __a0 UBYTE *filename, register __a1 ULONG *exerr);
void                __saveds __asm IPTC_Close(register __a0 struct IptcHandle *eh);
ULONG               __saveds __asm IPTC_FindTag(register __a0 struct IptcHandle *eh, register __d0 LONG record, register __d1 LONG tag, register __d2 ULONG index, register __a1 UBYTE *buffer, register __d3 ULONG buflen);
struct IptcHandle * __saveds __asm IPTC_OpenBuf( register __a0 UBYTE *buffer, register __d0 ULONG buflen, register __a1 ULONG *exerr);
