/*
**      $VER: iptcdata.c 37.5 (24.1.97)
**
**      Demo functions for iptcdata.library
**
**      (C) Copyright 1996-97 Andreas R. Kleinert
**      All Rights Reserved.
*/

#define __USE_SYSBASE

// #define IDEBUG 1

#include <exec/types.h>
#include <exec/memory.h>

#include <proto/exec.h>

#include "iptcdata.h"

extern void __saveds __stdargs TS_Msg(char *text);

struct IptcHandle * __saveds IPTC_XOpen(UBYTE *filename, ULONG *iperr);

struct IptcHandle * __saveds __asm IPTC_Open( register __a0 UBYTE *filename, register __a1 ULONG *iperr)
{
 struct IptcHandle *eh;

 ObtainSemaphore(&IptcSemaphore);

 eh = IPTC_XOpen(filename, iperr);

 ReleaseSemaphore(&IptcSemaphore);

 return(eh);
}

struct IptcHandle * __saveds IPTC_XOpen(UBYTE *filename, ULONG *iperr)
{
 struct IptcHandle *eh = N;

 *iperr = IPERR_NO_ERROR;

 eh = AllocVec(sizeof(struct IptcHandle), MEMF_CLEAR);
 if(eh)
  {
   eh->ih_IptcData = iptc_data_new_from_jpeg(filename);
   if(eh->ih_IptcData) eh->ih_FreeFlag = TRUE;
    else               *iperr = IPERR_NO_FILE;
   if(*iperr) {  IPTC_Close(eh); eh = N; }

  }else *iperr = IPERR_NO_MEMORY;

 return(eh);
}

void __saveds __asm IPTC_Close(register __a0 struct IptcHandle *eh)
{
 IptcData *ed;

 if(!eh) return;

 ed = (APTR) eh->ih_IptcData;
 if(ed)
  {
   if(eh->ih_FreeFlag) iptc_data_free(ed);
    else               iptc_data_unref(ed);
  }

 memset(eh, 0, sizeof(struct IptcHandle)); // destroy fully

 FreeVec(eh);
}

ULONG __saveds IPTC_XFindTag(struct IptcHandle *eh, LONG record, LONG tag, ULONG index, UBYTE *buffer, ULONG buflen);

ULONG __saveds __asm IPTC_FindTag(register __a0 struct IptcHandle *eh, register __d0 LONG record, register __d1 LONG tag, register __d2 ULONG index, register __a1 UBYTE *buffer, register __d3 ULONG buflen)
{
 ULONG ret = IPERR_NO_ERROR;

 ObtainSemaphore(&IptcSemaphore);

 ret = IPTC_XFindTag(eh, record, tag, index, buffer, buflen);

 ReleaseSemaphore(&IptcSemaphore);

 return(ret);
}

ULONG __saveds IPTC_XFindTag(struct IptcHandle *eh, LONG record, LONG tag, ULONG index, UBYTE *buffer, ULONG buflen)
{
 IptcData    *ed;
 IptcDataSet *es = NULL;
  LONG        i  = index;

 if(!eh)     return(IPERR_NO_POINTER);
 if(!buffer) return(IPERR_NO_POINTER);
 if(!buflen) return(IPERR_NO_SPACE);

#ifdef IDEBUG
  {
   char msg[256];

   sprintf(msg, "XFindTag(): eh: $%lx, record: %ld, tag: %ld, idx: %ld, buf: $%lx, len: %ld", eh, record, tag, index, buffer, buflen);

   TS_Msg(msg);
  }
#endif

 buffer[0] = (UBYTE) 0;

 ed = (APTR) eh->ih_IptcData;
 if(!ed) return(IPERR_NO_DATA);

 index++; // 0 is first

 for(i=0; i<index; i++)
  {
   es = iptc_data_get_next_dataset(ed, es, (IptcRecord) record, (IptcTag) tag); // only the first one
   if(!es) break;

   buffer[0] = (UBYTE) 0;
   if(!iptc_dataset_get_as_str(es, buffer, buflen))
    {
     iptc_dataset_unref(es);
     return(IPERR_NO_SPACE);
    }

   iptc_dataset_unref(es);
  }

#ifdef IDEBUG
  {
   char msg[256];
   extern int _snp_disable;
   extern int snprintf_noieee (char *s, size_t n, const char *format, ...);

   _snp_disable = FALSE;

   snprintf_noieee(msg, 128, "XFindTag(): buffer: %s (index %ld, i %ld)", buffer, index, i);

   TS_Msg(msg);
  }
#endif

 if(!es)        return(IPERR_NO_TAG);
 if(i != index) return(IPERR_NO_TAG); // must be 0 at the end

 if(!buffer[0]) return(IPERR_NO_CONTENT);

 return(IPERR_NO_ERROR);
}

struct IptcHandle * __saveds IPTC_XOpenBuf(UBYTE *buffer, ULONG buflen, ULONG *iperr);

struct IptcHandle * __saveds __asm IPTC_OpenBuf( register __a0 UBYTE *buffer, register __d0 ULONG buflen, register __a1 ULONG *iperr)
{
 struct IptcHandle *eh;

 ObtainSemaphore(&IptcSemaphore);

 eh = IPTC_XOpenBuf(buffer, buflen, iperr);

 ReleaseSemaphore(&IptcSemaphore);

 return(eh);
}

struct IptcHandle * __saveds IPTC_XOpenBuf(UBYTE *buffer, ULONG buflen, ULONG *iperr)
{
 struct IptcHandle *eh = N;

 *iperr = IPERR_NO_ERROR;

 eh = AllocVec(sizeof(struct IptcHandle), MEMF_CLEAR);
 if(eh)
  {
   eh->ih_IptcOff = iptc_jpeg_ps3_find_iptc(buffer, buflen, (unsigned int *) &eh->ih_IptcLen);
   if( (eh->ih_IptcOff >= 0) && (eh->ih_IptcLen > 0) )
    {
     eh->ih_IptcData = iptc_data_new_from_data(buffer + eh->ih_IptcOff, eh->ih_IptcLen);
     if(eh->ih_IptcData) eh->ih_FreeFlag = TRUE;
      else               *iperr = IPERR_NO_DATA;
    }else *iperr = IPERR_NO_DATA;

   if(*iperr) {  IPTC_Close(eh); eh = N; }

  }else *iperr = IPERR_NO_MEMORY;

 return(eh);
}
