/*
**      $VER: LibInit.c 1.0 (1.11.2007)
**
**      Library initializers and functions to be called by StartUp.c
**
**      (C) Copyright 2007 Andreas R. Kleinert
**      All Rights Reserved.
*/

#define __USE_SYSBASE

#ifndef N
#define N 0L
#endif

#include <exec/types.h>
#include <exec/memory.h>
#include <exec/libraries.h>
#include <exec/execbase.h>
#include <exec/resident.h>
#include <exec/initializers.h>

#include <proto/exec.h>

#include <iptcdata/iptcdatabase.h>

ULONG __saveds __stdargs L_OpenLibs(void);
void  __saveds __stdargs L_CloseLibs(void);

extern struct IptcDataBase *IptcDataBase;

struct ExecBase      *SysBase       = N;
struct DosLibrary    *DOSBase       = N;
struct Library       *UtilityBase   = N;

#define VERSION  1
#define REVISION 3

char __aligned ExLibName [] = "iptcdata.library";
char __aligned ExLibID   [] = "iptcdata 1.3 (16.3.2008)";

extern ULONG InitTab[];

extern APTR EndResident; /* below */

struct Resident __aligned ROMTag =     /* do not change */
{
 RTC_MATCHWORD,
 &ROMTag,
 &EndResident,
 RTF_AUTOINIT,
 VERSION,
 NT_LIBRARY,
 0,
 &ExLibName[0],
 &ExLibID[0],
 &InitTab[0]
};

APTR EndResident;

struct MyDataInit                      /* do not change */
{
 UWORD ln_Type_Init;      UWORD ln_Type_Offset;      UWORD ln_Type_Content;
 UBYTE ln_Name_Init;      UBYTE ln_Name_Offset;      ULONG ln_Name_Content;
 UWORD lib_Flags_Init;    UWORD lib_Flags_Offset;    UWORD lib_Flags_Content;
 UWORD lib_Version_Init;  UWORD lib_Version_Offset;  UWORD lib_Version_Content;
 UWORD lib_Revision_Init; UWORD lib_Revision_Offset; UWORD lib_Revision_Content;
 UBYTE lib_IdString_Init; UBYTE lib_IdString_Offset; ULONG lib_IdString_Content;
 ULONG ENDMARK;
} DataTab =
{
 INITBYTE(OFFSET(Node,         ln_Type),      NT_LIBRARY),
 0x80, (UBYTE) OFFSET(Node,    ln_Name),      (ULONG) &ExLibName[0],
 INITBYTE(OFFSET(Library,      lib_Flags),    LIBF_SUMUSED|LIBF_CHANGED),
 INITWORD(OFFSET(Library,      lib_Version),  VERSION),
 INITWORD(OFFSET(Library,      lib_Revision), REVISION),
 0x80, (UBYTE) OFFSET(Library, lib_IdString), (ULONG) &ExLibID[0],
 (ULONG) 0
};

struct SignalSemaphore __aligned IptcSemaphore;

extern int _snp_disable; // if set to TRUE, sprintf() is used in any case

APTR mem_pool = NULL;

ULONG __saveds __stdargs L_OpenLibs(void)
{
 SysBase = (*((struct ExecBase **) 4));

 DOSBase = (APTR) OpenLibrary("dos.library", 40);
 if(!DOSBase) return(FALSE);

 UtilityBase = (APTR) OpenLibrary("utility.library", 37);
 if(!UtilityBase) return(FALSE);

 InitSemaphore(&IptcSemaphore);

 IptcDataBase->ipb_SysBase     = SysBase;

 IptcDataBase->ipb_DOSBase     = DOSBase;
 IptcDataBase->ipb_UtilityBase = UtilityBase;

 _snp_disable = TRUE;

 mem_pool = CreatePool(MEMF_PUBLIC, 8192, 2048+8);
 if(!mem_pool) return(FALSE);

 return(TRUE);
}

void __saveds __stdargs L_CloseLibs(void)
{
 if(mem_pool)              DeletePool(mem_pool);

 if(UtilityBase)           CloseLibrary((APTR) UtilityBase);
 if(DOSBase)               CloseLibrary((APTR) DOSBase);
}

static APTR PAllocVec(ULONG size, ULONG flags);
static VOID PFreeVec(APTR ap);

APTR MyAllocVec(ULONG size)
{
 APTR x;

 ObtainSemaphore(&IptcSemaphore);
 x = PAllocVec(size, MEMF_CLEAR);
 ReleaseSemaphore(&IptcSemaphore);

 return(x);
}

VOID MyFreeVec(APTR ap)
{
 ObtainSemaphore(&IptcSemaphore);
 PFreeVec(ap);
 ReleaseSemaphore(&IptcSemaphore);
}

APTR MyReAllocVec(APTR old, ULONG size)
{
 APTR x;

 ObtainSemaphore(&IptcSemaphore);
 x = PAllocVec(size, MEMF_CLEAR);
 ReleaseSemaphore(&IptcSemaphore);

 if(old)
  {
   ULONG *p = old;
   ULONG sizeO;

   sizeO = *--p;

   CopyMem(old, x, sizeO < size ? sizeO : size);
  }

 return(x);
}

#include <string.h>
#include <stdlib.h>

static APTR PAllocVec(ULONG size, ULONG flags)
{
 extern APTR mem_pool;
 ULONG *p = AllocPooled(mem_pool, size += sizeof(ULONG));

 if(p)
  {
   if(flags & MEMF_CLEAR) memset(p, 0, size);
   *p++ = size;
  }

 return(p);
}

static VOID PFreeVec(APTR ap)
{
 extern APTR mem_pool;

 if(ap)
  {
   ULONG *p = ap;
   ULONG size;

   size = *--p;

   FreePooled(mem_pool, p, size);
  }
}

#include <intuition/intuitionbase.h>

void __saveds __stdargs TS_Msg(char *text)
{
 struct Window     *popup_win = N;
 ULONG              idcmp     = N;
 struct EasyStruct *estr;

 estr = (APTR) AllocVec(sizeof(struct EasyStruct), (MEMF_CLEAR|MEMF_PUBLIC));
 if(estr)
  {
   estr->es_StructSize   = sizeof(struct EasyStruct);
   estr->es_Flags        = N;
   estr->es_Title        = "IptcData Debug";
   estr->es_TextFormat   = text;
   estr->es_GadgetFormat = "Confirm";

   IntuitionBase = (struct IntuitionBase *) OpenLibrary("intuition.library", 37);
   if(IntuitionBase)
    {
     if(!popup_win) popup_win = IntuitionBase->FirstScreen->FirstWindow;

     EasyRequestArgs(popup_win, estr, &idcmp, N);

     CloseLibrary((APTR) IntuitionBase);
    }

   FreeVec(estr);
  }
}

