/*
**      $VER: exifdata.h 1.0 (1.11.2007)
**
**      Core functions for exifdata.library
**
**      (C) Copyright 2007 Andreas R. Kleinert
**      All Rights Reserved.
*/

#include <exifdata/exifdata.h>

struct ExifHandle
{
 ULONG           eh_Version;

 ULONG           eh_FreeFlag;

 struct Library *eh_MathDB;
 struct Library *eh_MathDT;

 APTR            eh_ExifData;

 UBYTE          *eh_Marker;
 ULONG           eh_MarkerLen;
};

#include <libexif/exif-data.h>
#include <libexif/exif-utils.h>

extern struct SignalSemaphore __aligned ExifSemaphore;

struct ExifHandle * __saveds __asm EXIF_Open( register __a0 UBYTE *filename, register __a1 ULONG *exerr);
void                __saveds __asm EXIF_Close(register __a0 struct ExifHandle *eh);
ULONG               __saveds __asm EXIF_FindTag(register __a0 struct ExifHandle *eh, register __d0 LONG tag, register __a1 UBYTE *buffer, register __d1 ULONG buflen);
struct ExifHandle * __saveds __asm EXIF_OpenBuf( register __a0 UBYTE *buffer, register __d0 ULONG buflen, register __a1 ULONG *exerr);

