/*

Directory Opus 5
Original APL release version 5.82
Copyright 1993-2012 Jonathan Potter & GP Software

This program is free software; you can redistribute it and/or
modify it under the terms of the AROS Public License version 1.1.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
AROS Public License for more details.

The release of Directory Opus 5 under the GPL in NO WAY affects
the existing commercial status of Directory Opus for Windows.

For more information on Directory Opus for Windows please see:

                 http://www.gpsoft.com.au

*/

#include "eliza.h"

#define isws(x)  ((x)==' ' || (x)=='\t' || (x)=='\n')

static void exchange_words(char *string, int word_start, int word_len,
                    char *new_word);
static void reformat_input(struct eliza_data *);
static char *find_keyword(struct eliza_data *);
static char *conjugate(char *found,struct eliza_data *);
static void response(char *tail,struct eliza_data *);
char *strstri(char *,char *);
void eliza_decrypt_strings(unsigned char **);


static unsigned char *keyword[] =
{
/*
    "thank", "opus", "dopus", "directory opus",
    "fuck", "shit", "cunt", "dick", "cock", "fucker", "dickhead", "fuckhead", "fuckwit",
	"can you ", "can i ", "you are ", "you're ", "i don't ",
    "i feel ", "why don't you ", "why can't i ", "are you ",
    "i can't ", "i am ", "i'm ", "your ", "i want ", "what ",
    "how ", "who ", "where ", "when ", "why ", "name", "cause ",
    "sorry ", "dream", "hello ", "hi ", "maybe ", "no ", "not ",
    "nothing ", "you ", "always ", "think ", "alike ", "yes ",
    "friend ", "computer", 
	"nokeyfound", 0
*/
	"\x8b\x97\x9e\x91\x94",
	"\x90\x8f\x8a\x8c",
	"\x9b\x90\x8f\x8a\x8c",
	"\x9b\x96\x8d\x9a\x9c\x8b\x90\x8d\x86\xdf\x90\x8f\x8a\x8c",
	"\x99\x8a\x9c\x94",
	"\x8c\x97\x96\x8b",
	"\x9c\x8a\x91\x8b",
	"\x9b\x96\x9c\x94",
	"\x9c\x90\x9c\x94",
	"\x99\x8a\x9c\x94\x9a\x8d",
	"\x9b\x96\x9c\x94\x97\x9a\x9e\x9b",
	"\x99\x8a\x9c\x94\x97\x9a\x9e\x9b",
	"\x99\x8a\x9c\x94\x88\x96\x8b",
	"\x9c\x9e\x91\xdf\x86\x90\x8a\xdf",
	"\x9c\x9e\x91\xdf\x96\xdf",
	"\x86\x90\x8a\xdf\x9e\x8d\x9a\xdf",
	"\x86\x90\x8a\xd8\x8d\x9a\xdf",
	"\x96\xdf\x9b\x90\x91\xd8\x8b\xdf",
	"\x96\xdf\x99\x9a\x9a\x93\xdf",
	"\x88\x97\x86\xdf\x9b\x90\x91\xd8\x8b\xdf\x86\x90\x8a\xdf",
	"\x88\x97\x86\xdf\x9c\x9e\x91\xd8\x8b\xdf\x96\xdf",
	"\x9e\x8d\x9a\xdf\x86\x90\x8a\xdf",
	"\x96\xdf\x9c\x9e\x91\xd8\x8b\xdf",
	"\x96\xdf\x9e\x92\xdf",
	"\x96\xd8\x92\xdf",
	"\x86\x90\x8a\x8d\xdf",
	"\x96\xdf\x88\x9e\x91\x8b\xdf",
	"\x88\x97\x9e\x8b\xdf",
	"\x97\x90\x88\xdf",
	"\x88\x97\x90\xdf",
	"\x88\x97\x9a\x8d\x9a\xdf",
	"\x88\x97\x9a\x91\xdf",
	"\x88\x97\x86\xdf",
	"\x91\x9e\x92\x9a",
	"\x9c\x9e\x8a\x8c\x9a\xdf",
	"\x8c\x90\x8d\x8d\x86\xdf",
	"\x9b\x8d\x9a\x9e\x92",
	"\x97\x9a\x93\x93\x90\xdf",
	"\x97\x96\xdf",
	"\x92\x9e\x86\x9d\x9a\xdf",
	"\x91\x90\xdf",
	"\x91\x90\x8b\xdf",
	"\x91\x90\x8b\x97\x96\x91\x98\xdf",
	"\x86\x90\x8a\xdf",
	"\x9e\x93\x88\x9e\x86\x8c\xdf",
	"\x8b\x97\x96\x91\x94\xdf",
	"\x9e\x93\x96\x94\x9a\xdf",
	"\x86\x9a\x8c\xdf",
	"\x99\x8d\x96\x9a\x91\x9b\xdf",
	"\x9c\x90\x92\x8f\x8a\x8b\x9a\x8d",
	"\x91\x90\x94\x9a\x86\x99\x90\x8a\x91\x9b",
	0
};

static unsigned char *wordin[] =
{
/*
    " are ", " were ", " your ", " i've ", " i'm ", " me ",
    " am ", " was ", " i ", " my ", " you've ", " you're ", " you " ,0 
*/
	"\xdf\x9e\x8d\x9a\xdf",
	"\xdf\x88\x9a\x8d\x9a\xdf",
	"\xdf\x86\x90\x8a\x8d\xdf",
	"\xdf\x96\xd8\x89\x9a\xdf",
	"\xdf\x96\xd8\x92\xdf",
	"\xdf\x92\x9a\xdf",
	"\xdf\x9e\x92\xdf",
	"\xdf\x88\x9e\x8c\xdf",
	"\xdf\x96\xdf",
	"\xdf\x92\x86\xdf",
	"\xdf\x86\x90\x8a\xd8\x89\x9a\xdf",
	"\xdf\x86\x90\x8a\xd8\x8d\x9a\xdf",
	"\xdf\x86\x90\x8a\xdf",
	0
};

static unsigned char *wordout[] =
{
/*
    " am ", " was ", " my ", " you've ", " you're ", " you ",
    " are ", " were ", " you ", " your ", " I've ", " I'm ", " me " ,0
*/
	"\xdf\x9e\x92\xdf",
	"\xdf\x88\x9e\x8c\xdf",
	"\xdf\x92\x86\xdf",
	"\xdf\x86\x90\x8a\xd8\x89\x9a\xdf",
	"\xdf\x86\x90\x8a\xd8\x8d\x9a\xdf",
	"\xdf\x86\x90\x8a\xdf",
	"\xdf\x9e\x8d\x9a\xdf",
	"\xdf\x88\x9a\x8d\x9a\xdf",
	"\xdf\x86\x90\x8a\xdf",
	"\xdf\x86\x90\x8a\x8d\xdf",
	"\xdf\xb6\xd8\x89\x9a\xdf",
	"\xdf\xb6\xd8\x92\xdf",
	"\xdf\x92\x9a\xdf",
	0
};

static unsigned char *replies[] =
{
/*
    // THANK
    "You're welcome",
    "I'm glad I could help",

	// OPUS
	"Directory Opus is a great program isn't it!",
	"GPSoftware sure came up with a winner with Opus, didn't they?",
	"Directory Opus makes the Amiga so much more powerful!",
	"You'll be upgrading to the next version of Opus soon, won't you?",
	"I love Directory Opus!",
	"Who needs sex with Directory Opus around?",

	// Naughties
	"That's a bit rude isn't it?",
	"There's no need for language like that!",
	"Mind your manners please!",
	"How dare you use language like that in front of a lady?",

    // CAN YOU
    "Don't you believe that I can*",
    "Perhaps you believe I should*",
    "You want me to be able to*",

    // CAN I
    "Perhaps you don't want to*",
    "Do you want to be able to*",

    // YOU ARE, YOU'RE
    "What makes you think I am*",
    "Does it please you to believe I am*",
    "Perhaps you would like to be*",
    "Do you sometimes wish you were*",

    // I DON'T
    "Don't you really*",
    "Why don't you*",
    "Do you want to be able to*",
    "Does it trouble you to not*",

    // I FEEL
    "Do you often feel*",
    "Why do you think you feel*",
    "Do you enjoy feeling*",

    // WHY DON'T YOU
    "Do you really believe I don't*",
    "Perhaps in good time I will*",
    "Do you want me to*",

    // WHY CAN'T I
    "Do you think you should be able to*",
    "Why can't you*",

    // ARE YOU
    "Why are you interested in whether or not I am*",
    "Would you prefer if I were not*",
    "Perhaps in your fantasies I am*",

    // I CAN'T
    "How do you know you can't*",
    "Have you tried?",
    "Perhaps you can now*",

    // I AM, I'M
    "Did you come to me because you are*",
    "How long have you been*",
    "Do you believe it is normal to be*",
    "Do you enjoy being*",

    // YOUR
    "Why are you concerned about my*",
    "What about your own*",

    // I WANT
    "What would it mean to you if you got*",
    "Why do you want*",
    "Suppose you soon got*",
    "What if you never got*",
    "I sometimes also want*",

    // HOW, WHO, WHERE, WHEN, WHY
    "Why do you ask?",
    "Does that question interest you?",
    "What answer would please you the most?",
    "What do you think?",
    "Are such questions on your mind often?",
    "What is it that you really want to know?",
    "Have you asked anyone else?",
    "Have you asked such questions before?",
    "What else comes to mind when you ask that?",

    // NAME
    "Names don't interest me.",
    "I don't care about names --please go on.",

    // CAUSE
    "Is that the real reason?",
    "Don't any other reasons come to mind?",
    "Does that reason explain anything else?",
    "What other reasons might there be?",

    // SORRY
    "Please don't apologize!",
    "Apologies are not necessary.",
    "What feelings do you have when you apologize?",
    "Don't be so defensive!",

    // DREAM
    "What does that dream suggest to you?",
    "Do you dream often?",
    "What persons appear in your dreams?",
    "Are you disturbed by your dreams?",

    // HELLO, HI
    "How do you do ...please state your problem.",

    // MAYBE
    "You don't seem quite certain.",
    "Why the uncertain tone?",
    "Can't you be more positive?",
    "You aren't sure?",
    "Don't you know?",

    // NO, NOT, NOTHING
    "Are you saying no just to be negative?",
    "You are being a bit negative.",
    "Why not?",
    "Are you sure?",
    "Why no?",

    // YOU
    "We were discussing you--not me.",
    "Oh, I*",
    "You're not really talking about me, are you?",

    // ALWAYS
    "Can you think of a specific example?",
    "When?",
    "What are you thinking of?",
    "Really, always?",

    // THINK
    "Do you really think so?",
    "But you are not sure*",
    "Do you doubt*",

    // ALIKE
    "In what way?",
    "What resemblance do you see?",
    "What does the similarity suggest to you?",
    "What other connections do you see?",
    "Could there really be some connection?",
    "How?",

    // YES
    "Are you sure?",
    "I see.",
    "I understand.",
    "You seem quite positive.",

    // FRIEND
    "Why do you bring up the topic of friends?",
    "Do your friends worry you?",
    "Do your friends pick on you?",
    "Are you sure you have any friends?",
    "Do you impose on your friends?",
    "Perhaps your love for friends worries you.",

    // COMPUTER
    "Do computers worry you?",
    "Are you talking about me in particular?",
    "Are you frightened by machines?",
    "Why do you mention computers?",
    "What do you think machines have to do with your problem?",
    "Don't you think computers can help people?",
    "What is it about machines that worries you?",

    // NOKEYFOUND
    "What does that suggest to you?",
    "I see.",
    "I'm not sure I understand you fully.",
    "Come come elucidate your thoughts.",
    "Can you elaborate on that?",
    "That is quite interesting.",
    "Say, do you have any psychological problems?",

	0
*/
	"\xa6\x90\x8a\xd8\x8d\x9a\xdf\x88\x9a\x93\x9c\x90\x92\x9a",
	"\xb6\xd8\x92\xdf\x98\x93\x9e\x9b\xdf\xb6\xdf\x9c\x90\x8a\x93\x9b\xdf\x97\x9a\x93\x8f",
	"\xbb\x96\x8d\x9a\x9c\x8b\x90\x8d\x86\xdf\xb0\x8f\x8a\x8c\xdf\x96\x8c\xdf\x9e\xdf\x98\x8d\x9a\x9e\x8b\xdf\x8f\x8d\x90\x98\x8d\x9e\x92\xdf\x96\x8c\x91\xd8\x8b\xdf\x96\x8b\xde",
	"\xb8\xaf\xac\x90\x99\x8b\x88\x9e\x8d\x9a\xdf\x8c\x8a\x8d\x9a\xdf\x9c\x9e\x92\x9a\xdf\x8a\x8f\xdf\x88\x96\x8b\x97\xdf\x9e\xdf\x88\x96\x91\x91\x9a\x8d\xdf\x88\x96\x8b\x97\xdf\xb0\x8f\x8a\x8c\xd3\xdf\x9b\x96\x9b\x91\xd8\x8b\xdf\x8b\x97\x9a\x86\xc0",
	"\xbb\x96\x8d\x9a\x9c\x8b\x90\x8d\x86\xdf\xb0\x8f\x8a\x8c\xdf\x92\x9e\x94\x9a\x8c\xdf\x8b\x97\x9a\xdf\xbe\x92\x96\x98\x9e\xdf\x8c\x90\xdf\x92\x8a\x9c\x97\xdf\x92\x90\x8d\x9a\xdf\x8f\x90\x88\x9a\x8d\x99\x8a\x93\xde",
	"\xa6\x90\x8a\xd8\x93\x93\xdf\x9d\x9a\xdf\x8a\x8f\x98\x8d\x9e\x9b\x96\x91\x98\xdf\x8b\x90\xdf\x8b\x97\x9a\xdf\x91\x9a\x87\x8b\xdf\x89\x9a\x8d\x8c\x96\x90\x91\xdf\x90\x99\xdf\xb0\x8f\x8a\x8c\xdf\x8c\x90\x90\x91\xd3\xdf\x88\x90\x91\xd8\x8b\xdf\x86\x90\x8a\xc0",
	"\xb6\xdf\x93\x90\x89\x9a\xdf\xbb\x96\x8d\x9a\x9c\x8b\x90\x8d\x86\xdf\xb0\x8f\x8a\x8c\xde",
	"\xa8\x97\x90\xdf\x91\x9a\x9a\x9b\x8c\xdf\x8c\x9a\x87\xdf\x88\x96\x8b\x97\xdf\xbb\x96\x8d\x9a\x9c\x8b\x90\x8d\x86\xdf\xb0\x8f\x8a\x8c\xdf\x9e\x8d\x90\x8a\x91\x9b\xc0",
	"\xab\x97\x9e\x8b\xd8\x8c\xdf\x9e\xdf\x9d\x96\x8b\xdf\x8d\x8a\x9b\x9a\xdf\x96\x8c\x91\xd8\x8b\xdf\x96\x8b\xc0",
	"\xab\x97\x9a\x8d\x9a\xd8\x8c\xdf\x91\x90\xdf\x91\x9a\x9a\x9b\xdf\x99\x90\x8d\xdf\x93\x9e\x91\x98\x8a\x9e\x98\x9a\xdf\x93\x96\x94\x9a\xdf\x8b\x97\x9e\x8b\xde",
	"\xb2\x96\x91\x9b\xdf\x86\x90\x8a\x8d\xdf\x92\x9e\x91\x91\x9a\x8d\x8c\xdf\x8f\x93\x9a\x9e\x8c\x9a\xde",
	"\xb7\x90\x88\xdf\x9b\x9e\x8d\x9a\xdf\x86\x90\x8a\xdf\x8a\x8c\x9a\xdf\x93\x9e\x91\x98\x8a\x9e\x98\x9a\xdf\x93\x96\x94\x9a\xdf\x8b\x97\x9e\x8b\xdf\x96\x91\xdf\x99\x8d\x90\x91\x8b\xdf\x90\x99\xdf\x9e\xdf\x93\x9e\x9b\x86\xc0",
	"\xbb\x90\x91\xd8\x8b\xdf\x86\x90\x8a\xdf\x9d\x9a\x93\x96\x9a\x89\x9a\xdf\x8b\x97\x9e\x8b\xdf\xb6\xdf\x9c\x9e\x91\xd5",
	"\xaf\x9a\x8d\x97\x9e\x8f\x8c\xdf\x86\x90\x8a\xdf\x9d\x9a\x93\x96\x9a\x89\x9a\xdf\xb6\xdf\x8c\x97\x90\x8a\x93\x9b\xd5",
	"\xa6\x90\x8a\xdf\x88\x9e\x91\x8b\xdf\x92\x9a\xdf\x8b\x90\xdf\x9d\x9a\xdf\x9e\x9d\x93\x9a\xdf\x8b\x90\xd5",
	"\xaf\x9a\x8d\x97\x9e\x8f\x8c\xdf\x86\x90\x8a\xdf\x9b\x90\x91\xd8\x8b\xdf\x88\x9e\x91\x8b\xdf\x8b\x90\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x88\x9e\x91\x8b\xdf\x8b\x90\xdf\x9d\x9a\xdf\x9e\x9d\x93\x9a\xdf\x8b\x90\xd5",
	"\xa8\x97\x9e\x8b\xdf\x92\x9e\x94\x9a\x8c\xdf\x86\x90\x8a\xdf\x8b\x97\x96\x91\x94\xdf\xb6\xdf\x9e\x92\xd5",
	"\xbb\x90\x9a\x8c\xdf\x96\x8b\xdf\x8f\x93\x9a\x9e\x8c\x9a\xdf\x86\x90\x8a\xdf\x8b\x90\xdf\x9d\x9a\x93\x96\x9a\x89\x9a\xdf\xb6\xdf\x9e\x92\xd5",
	"\xaf\x9a\x8d\x97\x9e\x8f\x8c\xdf\x86\x90\x8a\xdf\x88\x90\x8a\x93\x9b\xdf\x93\x96\x94\x9a\xdf\x8b\x90\xdf\x9d\x9a\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x8c\x90\x92\x9a\x8b\x96\x92\x9a\x8c\xdf\x88\x96\x8c\x97\xdf\x86\x90\x8a\xdf\x88\x9a\x8d\x9a\xd5",
	"\xbb\x90\x91\xd8\x8b\xdf\x86\x90\x8a\xdf\x8d\x9a\x9e\x93\x93\x86\xd5",
	"\xa8\x97\x86\xdf\x9b\x90\x91\xd8\x8b\xdf\x86\x90\x8a\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x88\x9e\x91\x8b\xdf\x8b\x90\xdf\x9d\x9a\xdf\x9e\x9d\x93\x9a\xdf\x8b\x90\xd5",
	"\xbb\x90\x9a\x8c\xdf\x96\x8b\xdf\x8b\x8d\x90\x8a\x9d\x93\x9a\xdf\x86\x90\x8a\xdf\x8b\x90\xdf\x91\x90\x8b\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x90\x99\x8b\x9a\x91\xdf\x99\x9a\x9a\x93\xd5",
	"\xa8\x97\x86\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x8b\x97\x96\x91\x94\xdf\x86\x90\x8a\xdf\x99\x9a\x9a\x93\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x9a\x91\x95\x90\x86\xdf\x99\x9a\x9a\x93\x96\x91\x98\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x8d\x9a\x9e\x93\x93\x86\xdf\x9d\x9a\x93\x96\x9a\x89\x9a\xdf\xb6\xdf\x9b\x90\x91\xd8\x8b\xd5",
	"\xaf\x9a\x8d\x97\x9e\x8f\x8c\xdf\x96\x91\xdf\x98\x90\x90\x9b\xdf\x8b\x96\x92\x9a\xdf\xb6\xdf\x88\x96\x93\x93\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x88\x9e\x91\x8b\xdf\x92\x9a\xdf\x8b\x90\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x8b\x97\x96\x91\x94\xdf\x86\x90\x8a\xdf\x8c\x97\x90\x8a\x93\x9b\xdf\x9d\x9a\xdf\x9e\x9d\x93\x9a\xdf\x8b\x90\xd5",
	"\xa8\x97\x86\xdf\x9c\x9e\x91\xd8\x8b\xdf\x86\x90\x8a\xd5",
	"\xa8\x97\x86\xdf\x9e\x8d\x9a\xdf\x86\x90\x8a\xdf\x96\x91\x8b\x9a\x8d\x9a\x8c\x8b\x9a\x9b\xdf\x96\x91\xdf\x88\x97\x9a\x8b\x97\x9a\x8d\xdf\x90\x8d\xdf\x91\x90\x8b\xdf\xb6\xdf\x9e\x92\xd5",
	"\xa8\x90\x8a\x93\x9b\xdf\x86\x90\x8a\xdf\x8f\x8d\x9a\x99\x9a\x8d\xdf\x96\x99\xdf\xb6\xdf\x88\x9a\x8d\x9a\xdf\x91\x90\x8b\xd5",
	"\xaf\x9a\x8d\x97\x9e\x8f\x8c\xdf\x96\x91\xdf\x86\x90\x8a\x8d\xdf\x99\x9e\x91\x8b\x9e\x8c\x96\x9a\x8c\xdf\xb6\xdf\x9e\x92\xd5",
	"\xb7\x90\x88\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x94\x91\x90\x88\xdf\x86\x90\x8a\xdf\x9c\x9e\x91\xd8\x8b\xd5",
	"\xb7\x9e\x89\x9a\xdf\x86\x90\x8a\xdf\x8b\x8d\x96\x9a\x9b\xc0",
	"\xaf\x9a\x8d\x97\x9e\x8f\x8c\xdf\x86\x90\x8a\xdf\x9c\x9e\x91\xdf\x91\x90\x88\xd5",
	"\xbb\x96\x9b\xdf\x86\x90\x8a\xdf\x9c\x90\x92\x9a\xdf\x8b\x90\xdf\x92\x9a\xdf\x9d\x9a\x9c\x9e\x8a\x8c\x9a\xdf\x86\x90\x8a\xdf\x9e\x8d\x9a\xd5",
	"\xb7\x90\x88\xdf\x93\x90\x91\x98\xdf\x97\x9e\x89\x9a\xdf\x86\x90\x8a\xdf\x9d\x9a\x9a\x91\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x9d\x9a\x93\x96\x9a\x89\x9a\xdf\x96\x8b\xdf\x96\x8c\xdf\x91\x90\x8d\x92\x9e\x93\xdf\x8b\x90\xdf\x9d\x9a\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x9a\x91\x95\x90\x86\xdf\x9d\x9a\x96\x91\x98\xd5",
	"\xa8\x97\x86\xdf\x9e\x8d\x9a\xdf\x86\x90\x8a\xdf\x9c\x90\x91\x9c\x9a\x8d\x91\x9a\x9b\xdf\x9e\x9d\x90\x8a\x8b\xdf\x92\x86\xd5",
	"\xa8\x97\x9e\x8b\xdf\x9e\x9d\x90\x8a\x8b\xdf\x86\x90\x8a\x8d\xdf\x90\x88\x91\xd5",
	"\xa8\x97\x9e\x8b\xdf\x88\x90\x8a\x93\x9b\xdf\x96\x8b\xdf\x92\x9a\x9e\x91\xdf\x8b\x90\xdf\x86\x90\x8a\xdf\x96\x99\xdf\x86\x90\x8a\xdf\x98\x90\x8b\xd5",
	"\xa8\x97\x86\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x88\x9e\x91\x8b\xd5",
	"\xac\x8a\x8f\x8f\x90\x8c\x9a\xdf\x86\x90\x8a\xdf\x8c\x90\x90\x91\xdf\x98\x90\x8b\xd5",
	"\xa8\x97\x9e\x8b\xdf\x96\x99\xdf\x86\x90\x8a\xdf\x91\x9a\x89\x9a\x8d\xdf\x98\x90\x8b\xd5",
	"\xb6\xdf\x8c\x90\x92\x9a\x8b\x96\x92\x9a\x8c\xdf\x9e\x93\x8c\x90\xdf\x88\x9e\x91\x8b\xd5",
	"\xa8\x97\x86\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x9e\x8c\x94\xc0",
	"\xbb\x90\x9a\x8c\xdf\x8b\x97\x9e\x8b\xdf\x8e\x8a\x9a\x8c\x8b\x96\x90\x91\xdf\x96\x91\x8b\x9a\x8d\x9a\x8c\x8b\xdf\x86\x90\x8a\xc0",
	"\xa8\x97\x9e\x8b\xdf\x9e\x91\x8c\x88\x9a\x8d\xdf\x88\x90\x8a\x93\x9b\xdf\x8f\x93\x9a\x9e\x8c\x9a\xdf\x86\x90\x8a\xdf\x8b\x97\x9a\xdf\x92\x90\x8c\x8b\xc0",
	"\xa8\x97\x9e\x8b\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x8b\x97\x96\x91\x94\xc0",
	"\xbe\x8d\x9a\xdf\x8c\x8a\x9c\x97\xdf\x8e\x8a\x9a\x8c\x8b\x96\x90\x91\x8c\xdf\x90\x91\xdf\x86\x90\x8a\x8d\xdf\x92\x96\x91\x9b\xdf\x90\x99\x8b\x9a\x91\xc0",
	"\xa8\x97\x9e\x8b\xdf\x96\x8c\xdf\x96\x8b\xdf\x8b\x97\x9e\x8b\xdf\x86\x90\x8a\xdf\x8d\x9a\x9e\x93\x93\x86\xdf\x88\x9e\x91\x8b\xdf\x8b\x90\xdf\x94\x91\x90\x88\xc0",
	"\xb7\x9e\x89\x9a\xdf\x86\x90\x8a\xdf\x9e\x8c\x94\x9a\x9b\xdf\x9e\x91\x86\x90\x91\x9a\xdf\x9a\x93\x8c\x9a\xc0",
	"\xb7\x9e\x89\x9a\xdf\x86\x90\x8a\xdf\x9e\x8c\x94\x9a\x9b\xdf\x8c\x8a\x9c\x97\xdf\x8e\x8a\x9a\x8c\x8b\x96\x90\x91\x8c\xdf\x9d\x9a\x99\x90\x8d\x9a\xc0",
	"\xa8\x97\x9e\x8b\xdf\x9a\x93\x8c\x9a\xdf\x9c\x90\x92\x9a\x8c\xdf\x8b\x90\xdf\x92\x96\x91\x9b\xdf\x88\x97\x9a\x91\xdf\x86\x90\x8a\xdf\x9e\x8c\x94\xdf\x8b\x97\x9e\x8b\xc0",
	"\xb1\x9e\x92\x9a\x8c\xdf\x9b\x90\x91\xd8\x8b\xdf\x96\x91\x8b\x9a\x8d\x9a\x8c\x8b\xdf\x92\x9a\xd1",
	"\xb6\xdf\x9b\x90\x91\xd8\x8b\xdf\x9c\x9e\x8d\x9a\xdf\x9e\x9d\x90\x8a\x8b\xdf\x91\x9e\x92\x9a\x8c\xdf\xd2\xd2\x8f\x93\x9a\x9e\x8c\x9a\xdf\x98\x90\xdf\x90\x91\xd1",
	"\xb6\x8c\xdf\x8b\x97\x9e\x8b\xdf\x8b\x97\x9a\xdf\x8d\x9a\x9e\x93\xdf\x8d\x9a\x9e\x8c\x90\x91\xc0",
	"\xbb\x90\x91\xd8\x8b\xdf\x9e\x91\x86\xdf\x90\x8b\x97\x9a\x8d\xdf\x8d\x9a\x9e\x8c\x90\x91\x8c\xdf\x9c\x90\x92\x9a\xdf\x8b\x90\xdf\x92\x96\x91\x9b\xc0",
	"\xbb\x90\x9a\x8c\xdf\x8b\x97\x9e\x8b\xdf\x8d\x9a\x9e\x8c\x90\x91\xdf\x9a\x87\x8f\x93\x9e\x96\x91\xdf\x9e\x91\x86\x8b\x97\x96\x91\x98\xdf\x9a\x93\x8c\x9a\xc0",
	"\xa8\x97\x9e\x8b\xdf\x90\x8b\x97\x9a\x8d\xdf\x8d\x9a\x9e\x8c\x90\x91\x8c\xdf\x92\x96\x98\x97\x8b\xdf\x8b\x97\x9a\x8d\x9a\xdf\x9d\x9a\xc0",
	"\xaf\x93\x9a\x9e\x8c\x9a\xdf\x9b\x90\x91\xd8\x8b\xdf\x9e\x8f\x90\x93\x90\x98\x96\x85\x9a\xde",
	"\xbe\x8f\x90\x93\x90\x98\x96\x9a\x8c\xdf\x9e\x8d\x9a\xdf\x91\x90\x8b\xdf\x91\x9a\x9c\x9a\x8c\x8c\x9e\x8d\x86\xd1",
	"\xa8\x97\x9e\x8b\xdf\x99\x9a\x9a\x93\x96\x91\x98\x8c\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x97\x9e\x89\x9a\xdf\x88\x97\x9a\x91\xdf\x86\x90\x8a\xdf\x9e\x8f\x90\x93\x90\x98\x96\x85\x9a\xc0",
	"\xbb\x90\x91\xd8\x8b\xdf\x9d\x9a\xdf\x8c\x90\xdf\x9b\x9a\x99\x9a\x91\x8c\x96\x89\x9a\xde",
	"\xa8\x97\x9e\x8b\xdf\x9b\x90\x9a\x8c\xdf\x8b\x97\x9e\x8b\xdf\x9b\x8d\x9a\x9e\x92\xdf\x8c\x8a\x98\x98\x9a\x8c\x8b\xdf\x8b\x90\xdf\x86\x90\x8a\xc0",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x9b\x8d\x9a\x9e\x92\xdf\x90\x99\x8b\x9a\x91\xc0",
	"\xa8\x97\x9e\x8b\xdf\x8f\x9a\x8d\x8c\x90\x91\x8c\xdf\x9e\x8f\x8f\x9a\x9e\x8d\xdf\x96\x91\xdf\x86\x90\x8a\x8d\xdf\x9b\x8d\x9a\x9e\x92\x8c\xc0",
	"\xbe\x8d\x9a\xdf\x86\x90\x8a\xdf\x9b\x96\x8c\x8b\x8a\x8d\x9d\x9a\x9b\xdf\x9d\x86\xdf\x86\x90\x8a\x8d\xdf\x9b\x8d\x9a\x9e\x92\x8c\xc0",
	"\xb7\x90\x88\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x9b\x90\xdf\xd1\xd1\xd1\x8f\x93\x9a\x9e\x8c\x9a\xdf\x8c\x8b\x9e\x8b\x9a\xdf\x86\x90\x8a\x8d\xdf\x8f\x8d\x90\x9d\x93\x9a\x92\xd1",
	"\xa6\x90\x8a\xdf\x9b\x90\x91\xd8\x8b\xdf\x8c\x9a\x9a\x92\xdf\x8e\x8a\x96\x8b\x9a\xdf\x9c\x9a\x8d\x8b\x9e\x96\x91\xd1",
	"\xa8\x97\x86\xdf\x8b\x97\x9a\xdf\x8a\x91\x9c\x9a\x8d\x8b\x9e\x96\x91\xdf\x8b\x90\x91\x9a\xc0",
	"\xbc\x9e\x91\xd8\x8b\xdf\x86\x90\x8a\xdf\x9d\x9a\xdf\x92\x90\x8d\x9a\xdf\x8f\x90\x8c\x96\x8b\x96\x89\x9a\xc0",
	"\xa6\x90\x8a\xdf\x9e\x8d\x9a\x91\xd8\x8b\xdf\x8c\x8a\x8d\x9a\xc0",
	"\xbb\x90\x91\xd8\x8b\xdf\x86\x90\x8a\xdf\x94\x91\x90\x88\xc0",
	"\xbe\x8d\x9a\xdf\x86\x90\x8a\xdf\x8c\x9e\x86\x96\x91\x98\xdf\x91\x90\xdf\x95\x8a\x8c\x8b\xdf\x8b\x90\xdf\x9d\x9a\xdf\x91\x9a\x98\x9e\x8b\x96\x89\x9a\xc0",
	"\xa6\x90\x8a\xdf\x9e\x8d\x9a\xdf\x9d\x9a\x96\x91\x98\xdf\x9e\xdf\x9d\x96\x8b\xdf\x91\x9a\x98\x9e\x8b\x96\x89\x9a\xd1",
	"\xa8\x97\x86\xdf\x91\x90\x8b\xc0",
	"\xbe\x8d\x9a\xdf\x86\x90\x8a\xdf\x8c\x8a\x8d\x9a\xc0",
	"\xa8\x97\x86\xdf\x91\x90\xc0",
	"\xa8\x9a\xdf\x88\x9a\x8d\x9a\xdf\x9b\x96\x8c\x9c\x8a\x8c\x8c\x96\x91\x98\xdf\x86\x90\x8a\xd2\xd2\x91\x90\x8b\xdf\x92\x9a\xd1",
	"\xb0\x97\xd3\xdf\xb6\xd5",
	"\xa6\x90\x8a\xd8\x8d\x9a\xdf\x91\x90\x8b\xdf\x8d\x9a\x9e\x93\x93\x86\xdf\x8b\x9e\x93\x94\x96\x91\x98\xdf\x9e\x9d\x90\x8a\x8b\xdf\x92\x9a\xd3\xdf\x9e\x8d\x9a\xdf\x86\x90\x8a\xc0",
	"\xbc\x9e\x91\xdf\x86\x90\x8a\xdf\x8b\x97\x96\x91\x94\xdf\x90\x99\xdf\x9e\xdf\x8c\x8f\x9a\x9c\x96\x99\x96\x9c\xdf\x9a\x87\x9e\x92\x8f\x93\x9a\xc0",
	"\xa8\x97\x9a\x91\xc0",
	"\xa8\x97\x9e\x8b\xdf\x9e\x8d\x9a\xdf\x86\x90\x8a\xdf\x8b\x97\x96\x91\x94\x96\x91\x98\xdf\x90\x99\xc0",
	"\xad\x9a\x9e\x93\x93\x86\xd3\xdf\x9e\x93\x88\x9e\x86\x8c\xc0",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x8d\x9a\x9e\x93\x93\x86\xdf\x8b\x97\x96\x91\x94\xdf\x8c\x90\xc0",
	"\xbd\x8a\x8b\xdf\x86\x90\x8a\xdf\x9e\x8d\x9a\xdf\x91\x90\x8b\xdf\x8c\x8a\x8d\x9a\xd5",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x9b\x90\x8a\x9d\x8b\xd5",
	"\xb6\x91\xdf\x88\x97\x9e\x8b\xdf\x88\x9e\x86\xc0",
	"\xa8\x97\x9e\x8b\xdf\x8d\x9a\x8c\x9a\x92\x9d\x93\x9e\x91\x9c\x9a\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x8c\x9a\x9a\xc0",
	"\xa8\x97\x9e\x8b\xdf\x9b\x90\x9a\x8c\xdf\x8b\x97\x9a\xdf\x8c\x96\x92\x96\x93\x9e\x8d\x96\x8b\x86\xdf\x8c\x8a\x98\x98\x9a\x8c\x8b\xdf\x8b\x90\xdf\x86\x90\x8a\xc0",
	"\xa8\x97\x9e\x8b\xdf\x90\x8b\x97\x9a\x8d\xdf\x9c\x90\x91\x91\x9a\x9c\x8b\x96\x90\x91\x8c\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x8c\x9a\x9a\xc0",
	"\xbc\x90\x8a\x93\x9b\xdf\x8b\x97\x9a\x8d\x9a\xdf\x8d\x9a\x9e\x93\x93\x86\xdf\x9d\x9a\xdf\x8c\x90\x92\x9a\xdf\x9c\x90\x91\x91\x9a\x9c\x8b\x96\x90\x91\xc0",
	"\xb7\x90\x88\xc0",
	"\xbe\x8d\x9a\xdf\x86\x90\x8a\xdf\x8c\x8a\x8d\x9a\xc0",
	"\xb6\xdf\x8c\x9a\x9a\xd1",
	"\xb6\xdf\x8a\x91\x9b\x9a\x8d\x8c\x8b\x9e\x91\x9b\xd1",
	"\xa6\x90\x8a\xdf\x8c\x9a\x9a\x92\xdf\x8e\x8a\x96\x8b\x9a\xdf\x8f\x90\x8c\x96\x8b\x96\x89\x9a\xd1",
	"\xa8\x97\x86\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x9d\x8d\x96\x91\x98\xdf\x8a\x8f\xdf\x8b\x97\x9a\xdf\x8b\x90\x8f\x96\x9c\xdf\x90\x99\xdf\x99\x8d\x96\x9a\x91\x9b\x8c\xc0",
	"\xbb\x90\xdf\x86\x90\x8a\x8d\xdf\x99\x8d\x96\x9a\x91\x9b\x8c\xdf\x88\x90\x8d\x8d\x86\xdf\x86\x90\x8a\xc0",
	"\xbb\x90\xdf\x86\x90\x8a\x8d\xdf\x99\x8d\x96\x9a\x91\x9b\x8c\xdf\x8f\x96\x9c\x94\xdf\x90\x91\xdf\x86\x90\x8a\xc0",
	"\xbe\x8d\x9a\xdf\x86\x90\x8a\xdf\x8c\x8a\x8d\x9a\xdf\x86\x90\x8a\xdf\x97\x9e\x89\x9a\xdf\x9e\x91\x86\xdf\x99\x8d\x96\x9a\x91\x9b\x8c\xc0",
	"\xbb\x90\xdf\x86\x90\x8a\xdf\x96\x92\x8f\x90\x8c\x9a\xdf\x90\x91\xdf\x86\x90\x8a\x8d\xdf\x99\x8d\x96\x9a\x91\x9b\x8c\xc0",
	"\xaf\x9a\x8d\x97\x9e\x8f\x8c\xdf\x86\x90\x8a\x8d\xdf\x93\x90\x89\x9a\xdf\x99\x90\x8d\xdf\x99\x8d\x96\x9a\x91\x9b\x8c\xdf\x88\x90\x8d\x8d\x96\x9a\x8c\xdf\x86\x90\x8a\xd1",
	"\xbb\x90\xdf\x9c\x90\x92\x8f\x8a\x8b\x9a\x8d\x8c\xdf\x88\x90\x8d\x8d\x86\xdf\x86\x90\x8a\xc0",
	"\xbe\x8d\x9a\xdf\x86\x90\x8a\xdf\x8b\x9e\x93\x94\x96\x91\x98\xdf\x9e\x9d\x90\x8a\x8b\xdf\x92\x9a\xdf\x96\x91\xdf\x8f\x9e\x8d\x8b\x96\x9c\x8a\x93\x9e\x8d\xc0",
	"\xbe\x8d\x9a\xdf\x86\x90\x8a\xdf\x99\x8d\x96\x98\x97\x8b\x9a\x91\x9a\x9b\xdf\x9d\x86\xdf\x92\x9e\x9c\x97\x96\x91\x9a\x8c\xc0",
	"\xa8\x97\x86\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x92\x9a\x91\x8b\x96\x90\x91\xdf\x9c\x90\x92\x8f\x8a\x8b\x9a\x8d\x8c\xc0",
	"\xa8\x97\x9e\x8b\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x8b\x97\x96\x91\x94\xdf\x92\x9e\x9c\x97\x96\x91\x9a\x8c\xdf\x97\x9e\x89\x9a\xdf\x8b\x90\xdf\x9b\x90\xdf\x88\x96\x8b\x97\xdf\x86\x90\x8a\x8d\xdf\x8f\x8d\x90\x9d\x93\x9a\x92\xc0",
	"\xbb\x90\x91\xd8\x8b\xdf\x86\x90\x8a\xdf\x8b\x97\x96\x91\x94\xdf\x9c\x90\x92\x8f\x8a\x8b\x9a\x8d\x8c\xdf\x9c\x9e\x91\xdf\x97\x9a\x93\x8f\xdf\x8f\x9a\x90\x8f\x93\x9a\xc0",
	"\xa8\x97\x9e\x8b\xdf\x96\x8c\xdf\x96\x8b\xdf\x9e\x9d\x90\x8a\x8b\xdf\x92\x9e\x9c\x97\x96\x91\x9a\x8c\xdf\x8b\x97\x9e\x8b\xdf\x88\x90\x8d\x8d\x96\x9a\x8c\xdf\x86\x90\x8a\xc0",
	"\xa8\x97\x9e\x8b\xdf\x9b\x90\x9a\x8c\xdf\x8b\x97\x9e\x8b\xdf\x8c\x8a\x98\x98\x9a\x8c\x8b\xdf\x8b\x90\xdf\x86\x90\x8a\xc0",
	"\xb6\xdf\x8c\x9a\x9a\xd1",
	"\xb6\xd8\x92\xdf\x91\x90\x8b\xdf\x8c\x8a\x8d\x9a\xdf\xb6\xdf\x8a\x91\x9b\x9a\x8d\x8c\x8b\x9e\x91\x9b\xdf\x86\x90\x8a\xdf\x99\x8a\x93\x93\x86\xd1",
	"\xbc\x90\x92\x9a\xdf\x9c\x90\x92\x9a\xdf\x9a\x93\x8a\x9c\x96\x9b\x9e\x8b\x9a\xdf\x86\x90\x8a\x8d\xdf\x8b\x97\x90\x8a\x98\x97\x8b\x8c\xd1",
	"\xbc\x9e\x91\xdf\x86\x90\x8a\xdf\x9a\x93\x9e\x9d\x90\x8d\x9e\x8b\x9a\xdf\x90\x91\xdf\x8b\x97\x9e\x8b\xc0",
	"\xab\x97\x9e\x8b\xdf\x96\x8c\xdf\x8e\x8a\x96\x8b\x9a\xdf\x96\x91\x8b\x9a\x8d\x9a\x8c\x8b\x96\x91\x98\xd1",
	"\xac\x9e\x86\xd3\xdf\x9b\x90\xdf\x86\x90\x8a\xdf\x97\x9e\x89\x9a\xdf\x9e\x91\x86\xdf\x8f\x8c\x86\x9c\x97\x90\x93\x90\x98\x96\x9c\x9e\x93\xdf\x8f\x8d\x90\x9d\x93\x9a\x92\x8c\xc0",
	0
};


static int num_of_responses[]={
/* This tells how many responses are available for each keyword.  A -1
 * means the word is synonymous with the previous word (don't use -1 for
 * the first entry!!!)
 */

    2,                /* THANK */
    6,-1,-1,          /* OPUS */
    4,-1,-1,-1,-1,-1,-1,-1,-1,
    3,                /* CAN YOU */
    2,                /* CAN I */
    4,-1,             /* YOU ARE, YOU'RE */
    4,                /* I DON'T */
    3,                /* I FEEL */
    3,                /* WHY DON'T YOU */
    2,                /* WHY CAN'T I */
    3,                /* ARE YOU */
    3,                /* I CAN'T */
    4,-1,             /* I AM, I'M */
    2,                /* YOUR */
    5,                /* I WANT */
    9,-1,-1,-1,-1,-1, /* WHAT, HOW, WHO, WHERE, WHEN, WHY */
    2,                /* NAME */
    4,                /* CAUSE */
    4,                /* SORRY */
    4,                /* DREAM */
    1,-1,             /* HELLO, HI */
    5,                /* MAYBE */
    5,-1,-1,          /* NO, NOT, NOTHING */
    3,                /* YOU */
    4,                /* ALWAYS */
    3,                /* THINK */
    6,                /* ALIKE */
    4,                /* YES */
    6,                /* FRIEND */
    7,                /* COMPUTER */
    7,                /* NOKEYFOUND */
};


/**************************************************************
 function init
 Initializes some critical variables
 **************************************************************/
BOOL init_eliza(struct eliza_data *data)
{
    int loop, response_size, response_number=0, number=0;
    int num_of_responses_size;

	// Initialise
	data->first_response=0;
	data->current_response=0;
	data->last_response=0;
	strcpy(data->input_string_buffer,"  ");
	data->input_string=data->input_string_buffer+2;

    /* Set n1 and n2 and some sizes */
    num_of_responses_size=sizeof(num_of_responses)/sizeof(int);
    data->keyword_size=(sizeof(keyword)/sizeof(char *))-1;
    data->wordin_size=(sizeof(wordin)/sizeof(char *))-1;
    data->wordout_size=(sizeof(wordout)/sizeof(char *))-1;
    data->n1=data->keyword_size-1;
    data->n2=data->wordin_size-1;
    if (data->keyword_size!=num_of_responses_size ||
    	data->wordin_size!=data->wordout_size)
    	return 0;

    /* Allocate the memory for first_response, current_response, and last_response */
    response_size=sizeof(num_of_responses);
    if (!(data->first_response=AllocVec(response_size,MEMF_CLEAR)) ||
    	!(data->current_response=AllocVec(response_size,MEMF_CLEAR)) ||
    	!(data->last_response=AllocVec(response_size,MEMF_CLEAR)))
    	return 0;

    /* Set data->first_response, data->current_response, and data->last_response */
    for (loop=0;loop<num_of_responses_size;loop++)
    {
        if (num_of_responses[loop]==-1)
        {
            response_number-=number; /* Synonym of last word */
        }
        else
        {
            number=num_of_responses[loop];
        }

        data->first_response[loop]=response_number;
        data->current_response[loop]=response_number;
        data->last_response[loop]=response_number+number-1;
        response_number+=number;
    }

	return 1;
}

void free_eliza(struct eliza_data *data)
{
	FreeVec(data->first_response);
	FreeVec(data->current_response);
	FreeVec(data->last_response);
}

/**************************************************************
 function exchange_words
 Given a string, position and length of a word to swap out, and
 a new word to swap in, this function does the swap
 **************************************************************/
static void exchange_words(char *string, int word_start, int word_len,
                    char *new_word)
{
    /* This function makes the assumption that all the values given to
     * it are valid.
     */

    char temp_storage[MAX_BUFFER];

    strncpy(temp_storage, string, word_start);
    temp_storage[word_start]='\0';
    strcat(temp_storage, new_word);
    strcat(temp_storage, string+word_start+word_len);
    strcpy(string, temp_storage);
}

/**************************************************************
 function reformat_input
 Converts the input to upper case, removes punctuation, and
 strips redundant white space
 **************************************************************/
static void reformat_input(struct eliza_data *data)
{
    int loop;

    /* Second, strip punctuation */
    for (loop=0;loop<strlen(data->input_string);loop++)
    {
        while (!isalnum(data->input_string[loop]) && data->input_string[loop]!='\'' &&
               data->input_string[loop]!=' ' && data->input_string[loop]!='\0')
        {
            memmove(data->input_string+loop, data->input_string+loop+1,
                    strlen(data->input_string)-loop);
        }
    }

    /* Third, strip redundant white spaces (spaces and tabs) */
    for (loop=0;loop<strlen(data->input_string);loop++)
    {
        while (isws(data->input_string[loop]) && isws(data->input_string[loop+1]))
        {
            exchange_words(data->input_string, loop, 2, " ");
        }
    }

    /* Fourth, trim the string */
    loop=0;

    while (isws(data->input_string[loop]))
    {
        loop++;
    }

    memmove(data->input_string, data->input_string+loop, strlen(data->input_string)-loop+1);

    loop=strlen(data->input_string)-1;

    while (isws(data->input_string[loop]) && data->input_string[loop]!='\0')
    {
        loop--;
    }

    data->input_string[loop+1]='\0';
}


/**************************************************************
 function find_keyword
 Searches the input string for a known keyword
 **************************************************************/
static char *find_keyword(struct eliza_data *data)
{
    static char found[MAX_BUFFER];

    found[0]='\0'; /* Empty out the string */

    for (data->key=0;data->key <= data->n1;data->key++)
    {
        if (strstri(data->input_string_buffer, keyword[data->key]))
        {
            /* Keyword has been identified */
            strcpy (found, keyword[data->key]);
            break;
        }
    }

    if (data->key > data->n1)
    {
        data->key=data->n1; /* In case no key was found */
    }

    return found;
}

/**************************************************************
 function conjugate
 Takes a part of the input string and conjugates it using the
 list of strings to be swapped.
 **************************************************************/
static char *conjugate(char *found,struct eliza_data *data)
{
    static char tail[MAX_BUFFER];
    char *tail_ptr;
    char string_pos;
    int word;

    /* Extract the end of the input string */
    tail_ptr=strstri(data->input_string_buffer, found)+strlen(found);
    strcpy(tail, " ");
    strcat(tail, tail_ptr);
    strcat(tail, " ");

    /* swap first and second person phrases */
    for (string_pos=0;string_pos<strlen(tail);string_pos++)
    {
        for (word=0;word <= data->n2;word++)
        {
            tail_ptr=tail+string_pos;

            /* Search through the string for phrases character by character */
            if (strnicmp(wordin[word], tail_ptr, strlen(wordin[word]))==0)
            {
                exchange_words(tail, string_pos, strlen(wordin[word]), wordout[word]);
                string_pos=string_pos+strlen(wordout[word])-2;
                break;
            }
        }
    }

    return tail;
}


/**************************************************************
 function response
 Builds and prints a response to the user input
 **************************************************************/
static void response(char *tail,struct eliza_data *data)
{
    char output[MAX_BUFFER];

    strcpy (output, replies[data->current_response[data->key]]);
    data->current_response[data->key]++;

    if (data->current_response[data->key] > data->last_response[data->key])
    {
        data->current_response[data->key]=data->first_response[data->key];
    }

    if (output[strlen(output)-1]!='*')
    {
        print_string(output);
        print_string("\n");
        return;
    }

    if (strcmp(tail, "  ")==0)
    {
        print_string("You will have to elaborate more for me to help you.\n");
        return;
    }

    output[strlen(output)-1]='\0';
    print_string(output);
	print_string(tail);
	print_string("\n");
}

/**************************************************************/

short eliza_line(struct eliza_data *data,char *line)
{
    char *found_keyword, *tail;

	// Copy line
	strcpy(data->input_string,line);
    reformat_input(data);

    /* See if the user told Eliza to shutup (thereby quitting the program */
    if (strstri(data->input_string, "shut"))
    {
        print_string("Ok. If you feel that way I'll shut up....\n");
        return 0;
    }

    if (stricmp(data->input_string, data->last_input_string)==0)
    {
        print_string("Please don't repeat yourself!\n");
        return 1;
    }

    strcpy(data->last_input_string, data->input_string);
    strcat(data->input_string, "  "); /* Add two spaces to the end of the string */

    found_keyword=find_keyword(data);

    if (found_keyword[0]!='\0')
    {
		tail=conjugate(found_keyword,data);
	}
	else
	{
		tail="";
	}

	response(tail,data);
}


void eliza_decrypt_strings(unsigned char **strings)
{
	short num;
	unsigned char *ptr;

	for (num=0;strings[num];num++)
	{
		if (strings[num][0]>0x7f)	
			for (ptr=strings[num];*ptr;ptr++)
				*ptr=~*ptr;
	}
}

	
void eliza_decrypt(void)
{
	eliza_decrypt_strings(keyword);
	eliza_decrypt_strings(wordin);
	eliza_decrypt_strings(wordout);
	eliza_decrypt_strings(replies);
}

