#include <stdio.h>
#include <exec/types.h>
#include <exec/memory.h>
#include <exec/libraries.h>
#include <graphics/gfx.h>
#include <libraries/dos.h>
#include <intuition/intuition.h>
#include "jiff.h"
#include "ntp.h"


#include <exec/types.h>
#include <graphics/gfxbase.h>
#include <graphics/gfx.h>
#include <graphics/copper.h>
#include <graphics/gfxmacros.h>
#include <graphics/view.h>
#include <graphics/rastport.h>
#include <graphics/text.h>
#include <exec/memory.h>

// #define DEBUG
// #define CORRECT30

static char xxx=2,*amem;
static Width,Height,Depth,Flags,Poly;

UWORD *colormap;

extern struct ExecBase *SysBase;
extern struct GfxBase *GfxBase;
struct View *oldview,view;
struct ViewPort vport;
static struct RastPort rastport,*rp;
struct RasInfo rasinfo;
struct BitMap bitmap,*bm30;
struct ColorMap *cm,*GetColorMap();
PLANEPTR AllocRaster();

void closegraph();

Prototype Kick(int v)
{
   if(((struct Library *)SysBase)->lib_Version>=v) return(1);
   else return(0);
}

Prototype int initgraph(w,h,d,f,p)
short w,h,d,f,p;
{
   PLANEPTR *pl;
   int i;
   Poly=p;
   oldview=GfxBase->ActiView;
   InitView(&view);
   InitVPort(&vport);
   InitRastPort(&rastport);
#ifdef CORRECT30
   if(Kick(39))
      bm30=(void *)AllocBitMap(Width,Height,Depth,BMF_CLEAR|BMF_DISPLAYABLE,NULL);
   else
#endif
      InitBitMap(bm30=(&bitmap),Depth,Width,Height);
   if ((cm=GetColorMap(256))==NULL) return(0);
   colormap=(UWORD *)cm->ColorTable;
#ifdef CORRECT30
   if(!Kick(39))
#endif
   {
      for (i=0 ;i<Depth ;i++ ) bitmap.Planes[i]=NULL;
      for (i=0 ;i<Depth;i++)
      {
         if((bitmap.Planes[i]=AllocRaster(Width,Height))==NULL)
         {
            xxx=1;
            return(0);
         }
         BltClear(bitmap.Planes[i],RASSIZE(Width,Height),1L);
      }
   }
   view.ViewPort=&vport;
   view.Modes=Flags;
   vport.Modes=Flags;
   vport.ColorMap=cm;
   vport.RasInfo=&rasinfo;
   vport.DWidth = Width;  //   VpWidth=Width !!;
   vport.DHeight= Height; //   VpHeight=Height !!;
   vport.DxOffset=-5;    /*-15  !!!!!!!!!!!!! */
   rasinfo.BitMap=bm30;
   rasinfo.Next=NULL;
   rasinfo.RxOffset=0;
   rasinfo.RyOffset=0;
   rp=&rastport;
   rp->BitMap=bm30;
   MakeVPort(&view,&vport);
   MrgCop(&view);
   LoadView(&view);
   SetRast(rp,0);
   if(xxx==6) FreeRaster(pl,Width,Height);
   if(xxx>4)
   {
      Poly=0;
      closegraph();
      xxx=5;
      return(0);
   }
   xxx=0;
   return(1);
}

Prototype void closegraph()
{
   int i;
   LoadView(oldview);
   FreeVPortCopLists(&vport);
   FreeCprList(view.LOFCprList);
   if (cm) FreeColorMap(cm);
#ifdef CORRECT30
   if(Kick(39))
      FreeBitMap(bm30);
   else
#endif
   {
      for (i=0;i<Depth;i++)
         if(bitmap.Planes[i]) FreeRaster(bitmap.Planes[i],Width,Height);
   }
}



Local struct ILBM_info *read_ilbm(), *read_body();
Local struct ILBM_info root_info;

Prototype struct ILBM_info *read_iff(char *name,short just_colors)
{
   struct ILBM_info *info = &root_info;
   FILE *file;
   struct form_chunk chunk;

   if ((file = fopen(name, "r") ) == 0) return(NULL);
   if(fread(&chunk,sizeof(struct form_chunk),1,file)!= 1)
        {
           fclose(file);
           return(NULL);
        }

   if (chunk.fc_type.b4_type != FORM)
        {
           fclose(file);
           return(NULL);
        }

   if (chunk.fc_subtype.b4_type != ILBM)
        {
           fclose(file);
           return(NULL);
        }

   info = read_ilbm(file, info, chunk.fc_length - sizeof(chunk), just_colors);
   fclose(file);
   return(info);
}

static struct ILBM_info *read_ilbm(file, info, length, just_colors)
FILE *file;
struct ILBM_info *info;
long length;
short just_colors;
{
   struct iff_chunk chunk;
   int i;
   long read_in = 0;
   int got_header = FALSE;  /*to make sure gots the header first*/
   int got_cmap = FALSE;  /*make sure get cmap before "BODY" */
   int got_camg = FALSE;

   for (i=0; i<8; i++)
           info->bitmap.Planes[i] = NULL;

   while (read_in < length)
        {
           if (fread(&chunk, sizeof(chunk), 1, file) != 1)
                   return(NULL);
           switch (chunk.iff_type.b4_type)
                {
                case BMHD:
                        if (fread(&info->header, sizeof(info->header), 1, file) != 1)
                                {
                                   return(NULL);
                                }
                        if(info->header.nPlanes>8) return(0);
                        got_header = TRUE;
                        Width=info->header.w;
                        Height=info->header.h;
                        Depth=info->header.nPlanes;
                        if(!got_camg)
                        {
                           Flags=0;
                           if(Width>362) Flags|=HIRES;
                           if(Height>283) Flags|=LACE;
                           if(Depth==6) Flags|=HAM;
                        }
                        if(info->header.masking==1) return(0);
                        break;
                case CMAP:
                        #ifdef DEBUG
                          puts("CMAP");
                        #endif
                        if (!got_header)
                                {
                                return(NULL);
                                }
                        if (chunk.iff_length <= 3*MAXCOL )
                                {
                                if (fread(info->cmap, (int)chunk.iff_length, 1, file) != 1)
                                        {
                                        return(NULL);
                                        }
                                }
                        else
                                {
                                if (fread(info->cmap, 3*MAXCOL, 1, file) != 1)
                                        {
                                        return(NULL);
                                        }
                                bit_bucket(file, chunk.iff_length - sizeof(3*MAXCOL));
                                }
                        got_cmap = TRUE;
                        if (just_colors)
                                return(info);
                        break;
                case BODY:
                        #ifdef DEBUG
                           puts("BODY");
                        #endif
                            if (!got_cmap)
                                {
                                return(NULL);
                                }
         if(initgraph(0,0,0,0,0))
         {
            if(Depth==6 && (Flags&(HAM|EXTRA_HALFBRITE)))
               put_ea_cmap(&((long)info->cmap),32);
            else put_ea_cmap(&((long)info->cmap),(1<<Depth));
            return( read_body(file, info, chunk.iff_length) );
         } else
         {
            closegraph();
            return(NULL);
         }

      case CAMG:
         #ifdef DEBUG
            puts("CAMG");
         #endif
         fread(&Flags, sizeof(int), 1, file);
         Flags&=~(VP_HIDE|SPRITES|EXTENDED_MODE);
         #ifdef DEBUG
            printf(" ...%x\n",Flags);
         #endif
         got_camg=TRUE;
         break;
                default:        /*squawk about unknown types if PARANOID */
                case GRAB:  /*ignore documented but unwanted types*/
                case DEST:
                case SPRT:
                case CRNG:
                case CCRT:
                        bit_bucket(file, chunk.iff_length);
                        break;
                }
        read_in += chunk.iff_length + sizeof(chunk);
        }
return(NULL);
}



static
struct ILBM_info *read_body(FILE *file, info, length)
register struct ILBM_info *info;
long length;
{
   struct ILBM_header *header;
   struct BitMap *bm;
   int i, j;
   int rlength;
   int plane_offset;

   if (info->header.compression != 0 && info->header.compression != 1)
           return(NULL);

   info->bitmap.BytesPerRow = line_bytes(info->header.w);
   info->bitmap.Rows = info->header.h;
   info->bitmap.Depth = info->header.nPlanes;
   info->bitmap.Flags = info->bitmap.pad = 0;

   rlength = info->bitmap.Rows * info->bitmap.BytesPerRow;

   plane_offset = 0;
   for (i=0; i<info->bitmap.Rows; i++)
        {
           if (info->header.compression == 0)
                {
                   for (j = 0; j < info->bitmap.Depth; j++)
                        {
                           if ( fread(bm30->Planes[j] + plane_offset,
                                   info->bitmap.BytesPerRow, 1, file) != 1)
                                {
                                   closegraph();
                                   return(NULL);
                                }
                        }
                }
           else
                {
                   register char *dest, value;
                   register int so_far, count;  /*how much have unpacked so far*/

                   for (j = 0; j < info->bitmap.Depth; j++)
                        {
                           so_far = info->bitmap.BytesPerRow;
                           dest = (char *)bm30->Planes[j] + plane_offset;
                           while (so_far > 0)
                                {
                                   if ( (value = getc(file)) == 128)
                                        {
                                        }
                                   else if (value > 0)
                                        {
                                           count = (int)value + 1;
                                           so_far -= count;
                                           if ( fread(dest, count, 1, file) != 1)
                                                {
                                                   closegraph();
                                                   return(NULL);
                                                }
                                           dest += count;
                                        }
                                   else
                                        {
                                           count = (int)-value + 1;
                                           so_far -= count;
                                           value = getc(file);
                                           while (--count >= 0)  /*this is fastest loop in C */
                                                   *dest++ = value;
                                        }
                                }
                           if (so_far != 0)
                                {
                                   closegraph();
                                   return(NULL);
                                }
                        }
                }
           plane_offset += info->bitmap.BytesPerRow;
        }
   return(info);
}
