#include <ntp.h>
#include <exec/types.h>
#include    <exec/nodes.h>
#include <exec/libraries.h>
#include <graphics/gfx.h>
#include <graphics/rastport.h>
#include <graphics/text.h>
#include <intuition/intuition.h>
#include <intuition/sghooks.h>
#include    <stdio.h>
#include <libraries/dosextens.h>
#include <libraries/filehandler.h>
#include <exec/memory.h>
#include <hardware/custom.h>
#include <graphics/gfxmacros.h>

#define custom (*((struct Custom *)0xdff000))


extern struct ExecBase *SysBase;
extern struct StringExtend Gadget3SExtend;
extern struct IntuiMessage *GetMsg();
extern struct StringInfo Gadget3SInfo;
extern struct NewWindow NW3;
extern struct Gadget Gadget32,Gadget31;
extern Show(char *sou);
extern ExecFile(char *name);
extern SendFile(char *sou);
extern struct Gadget NWGadget10,NWGadget6,NWGadget14;
extern struct Process *FindTask();
extern struct FileLock *Lock();
extern struct DosLibrary *DOSBase;
extern struct Window *OpenWindow();
extern struct NewScreen NewScreenStructure;
extern struct NewWindow NWNewWindowStructure1;
extern struct Menu NWMenu1;
extern ED(char *Name,int sea);
extern ED1(char *Name,int sea);
extern PlaySample1(char *Name);
extern Dump1(char *Name);
extern struct GfxBase *GfxBase;
extern struct IntuitionBase *IntuitionBase;


__regargs extern int START(char *Name);
extern THEEND();

__regargs extern int SHOWICON(char *Name,struct Screen *Screen);

Prototype void RMBTrap()
{
   NTPBase->w->Flags&=~RMBTRAP;
}

Prototype void FlushIDCMP()
{
   int msg;
   while(msg=GetMsg(NTPBase->w->UserPort))
      ReplyMsg(msg);
}

/*--------------------------------------------------*/

#include "qiff.h"

BOOL UserBreak=FALSE;

#define RAW_ESC   0x45
#define RAW_F10   0x59

Prototype BOOL TestMessage(struct IntuiMessage *IM)
{
   BOOL ret=TRUE;

   switch(IM->Class)
   {
      case MOUSEBUTTONS:
         switch(IM->Code)
         {
            case SELECTDOWN: ret=FALSE; break;
         }
         break;
      case RAWKEY:
         switch(IM->Code)
         {
            case RAW_ESC: UserBreak=TRUE;
            case RAW_F10: ret=FALSE; break;
         }
         break;
   }

   return(ret);
}

Prototype Show(char *sou)
{
   ULONG IFFErr;
#ifdef GERMAN
   ErrorLine("Lesen Bilder oder Animation");
#else
   ErrorLine("Viewing picture or animation");
#endif

   UserBreak=FALSE;
   IFFErr=ShowIFF(sou,MOUSEBUTTONS | RAWKEY,CLEAR_POINTER,0);

   if(IFFErr)
   {
      SE=1;
      ErrorLine(IFFMsg[IFFErr]);
   }
   else SE=0;

   return(IFFErr?0:(UserBreak?0:1));
}

/*--------------------------------------------------*/

Prototype void LeftLines()
{
   SetAPen(rp,LIGHT);
   Move(rp,lstart+2+((NLEN-1)<<3),2);
   Draw(rp,lstart+2+((NLEN-1)<<3),BotBor-12);
   Move(rp,lstart+5+((NLEN+7)<<3),2);
   Draw(rp,lstart+5+((NLEN+7)<<3),BotBor-12);
   Move(rp,2,BotBor-11);
   Draw(rp,rstart-9,BotBor-11);
}

Prototype void InitLeft()
{
   SetAPen(rp,DARK);
   RectFill(rp,2,2,rstart-9,BotBor-2);
   if(wp[LEFT].Type!=QVIEW && wp[LEFT].Type!=INFO) LeftLines();
}

Prototype void RightLines()
{
   SetAPen(rp,LIGHT);
   Move(rp,rstart+2+((NLEN-1)<<3),2);
   Draw(rp,rstart+2+((NLEN-1)<<3),BotBor-12);
   Move(rp,rstart+5+((NLEN+7)<<3),2);
   Draw(rp,rstart+5+((NLEN+7)<<3),BotBor-12);
   Move(rp,rstart-3,BotBor-11);
   Draw(rp,636,BotBor-11);

}

Prototype InitRight()
{
   SetAPen(rp,DARK);
   RectFill(rp,rstart-3,2,636,BotBor-2);

   if(wp[RIGHT].Type!=QVIEW && wp[RIGHT].Type!=INFO) RightLines();
}

Prototype void ClearWindow()
{
   SetDrMd(rp,1);
   if(Act==LEFT) InitLeft();
   else InitRight();

/*   if(Act==LEFT) RectFill(rp,lstart,5,lstart+width,4+(NTPBase->Lines+1<<3));
   else RectFill(rp,rstart,5,rstart+width,4+(NTPBase->Lines+1<<3));
   SetAPen(rp,1);*/
}

Prototype void PrintMNode(Dir *l)
{
   int x;
   SetDrMd(rp,1);
   SetBPen(rp,DARK);
   SetAPen(rp,l->Set ? YELLOW : LIGHT);
   x=strlen(l->Name);
   if(x>=NLEN) x=NLEN-1;
   Text(rp,l->Name,x);
   if(x<NLEN-1) Text(rp,spaces,NLEN-x-1);
   Move(rp,rp->cp_x+4,rp->cp_y);
 //  if(wp[Act].Type==DIR)
 //     if(!isdigit(l->Size[7])) SetAPen(rp,2);
   Text(rp,l->Size,8);
 //  Text(rp," ",1);
   Move(rp,rp->cp_x+4,rp->cp_y);
   Text(rp,l->Protect,8);
}

Prototype void PrintNode(l,line)
Dir *l;
char line;
{
   Move(rp ,(Act==LEFT ? lstart : rstart) , 11+(line<<3));
   PrintMNode(l);
}

Prototype void DelGadgets()
{
   NWNewWindowStructure1.FirstGadget=0;
}

Prototype void QView()
{
   int a;
   a=((1-Act)==LEFT) ? lstart : rstart;
   SetDrMd(rp,1);
   SetAPen(rp,LIGHT);
   SetBPen(rp,DARK);
   Move(rp,a,(NTPBase->Lines<<2)+16);
   Text(rp,spaces,37);
   Move(rp,a,(NTPBase->Lines<<2)+8);
   Text(rp,spaces,37);
   Move(rp,a,NTPBase->Lines<<2);
   if(wp[Act].Type!=DIR)
   {
      Text(rp,spaces,19);
      return;
   }
   if(isdigit(pw[Act].l[pw[Act].First+pw[Act].CurAct]->Size[7]))
   {
      struct FileHandle *f,*Open();
      short pos=pw[Act].First+pw[Act].CurAct,x;
      x=strlen(wp[Act].Path);
      strcat(wp[Act].Path,pw[Act].l[pos]->Name);
      if(f=Open(wp[Act].Path,MODE_OLDFILE))
      {
         unsigned long b=0;
         Read(f,&b,4);
         printf("%x\n",b);
         switch(b>>16)
         {
            case 0xe310: a=1; Text(rp,G("Icon Datei         ") E("Icon file          "),19); break;
            case 0x0f00: a=1; Text(rp,G("Font Datei         ") E("Font file          "),19); break;
         }
         if(a==rp->cp_x) switch(b)
         {
#ifdef GERMAN
            case 0x3f3 : Text(rp,"Lauffhiges Datei  ",19);break;
#else
            case 0x3f3 : Text(rp,"Executable file    ",19);break;
#endif
#ifdef GERMAN
            case 0x464f524d: Text(rp,"IFF-format Datei   ",19);break;
#else
            case 0x464f524d: Text(rp,"IFF-format file    ",19);break;
#endif
#ifdef GERMAN
            case 0x3e7 : Text(rp,"Objekt Datei       ",19);break;
#else
            case 0x3e7 : Text(rp,"Object file        ",19);break;
#endif
#ifdef GERMAN
            default    : Text(rp,"Unbekannt Format   ",19);break;
#else
            default    : Text(rp,"Unknown-format file",19);break;
#endif
         }
         
         Close(f);
         ExtCopyPath();
         InfoCfg(a,(NTPBase->Lines<<2)+8,pw[Act].l[pos]->Name,wp[Act].Path,pw[Act].l[pos]->Protect);
         ReRead=0;
#ifdef GERMAN
      } else Text(rp,"ffnen nicht mglich",22);
#else
      } else Text(rp,"Can't open       ",19);
#endif
      wp[Act].Path[x]=0;
   }
#ifdef GERMAN
   else Text(rp,"Verzeichnis        ",19);
#else
   else Text(rp,"Directory          ",19);
#endif
}

Prototype void PCurs()
{
   short a=(Act==LEFT ? lstart : rstart);
 //  SetAPen(rp,KMZ);
   SetDrMd(rp,2);
   if(pw[Act].cnt)
   {
      RectFill(rp,a, 5+(pw[Act].CurAct<<3) ,a+width,12+(pw[Act].CurAct<<3));
      if(wp[1-Act].Type==QVIEW) QView();
   }

}

Prototype void InitInLine(int i)
{
   char n[3];
   int a,b;
   LIn=i;
   switch(i)
   {
      case 1:  a=10;b=19;break;
      case 0:  a=0;b=9;break;
#ifdef GERMAN
      case 2:  CopyMem("Sich. ",inl[21],6);
#else
      case 2:  CopyMem("Save  ",inl[21],6);
#endif
               a=20;b=29;break;
      case 3:  CopyMem(spaces,inl[21],6);
               a=20;b=29;break;
   }
   SetDrMd(rp,1);
   Move(rp,0,NWNewWindowStructure1.Height-4);
   for(i=a;i<=b;i++)
   {
      sprintf(n,"%d",i-a+1);
      SetAPen(rp,GRAY);
      SetBPen(rp,BLACK);
      Text(rp,n,strlen(n));
      SetAPen(rp,BLACK);
      SetBPen(rp,KMZ);
      Text(rp,inl[i],6);
      if(i<b)
      {
         SetBPen(rp,BLACK);
         Text(rp,spaces,1);
      }
   }
}

Prototype PushInLine(int mx,int mc)
{
   static mxs=-2;
   char n[3];
   int a,b,x=0,p,i;
   mx>>=3;
   if(mc==104) mxs=mx;
      else mx=mxs;
   if(mx==-2) return(-2);
   switch(LIn)
   {
      case 1:  a=10;b=19;break;
      case 0:  a=0;b=9;break;
      case 2:  a=20;b=29;break;
      case 3:  a=20;b=29;break;
   }
   SetDrMd(rp,1);
   Move(rp,0,NWNewWindowStructure1.Height-4);
   for(i=a;i<=b;i++)
   {
      sprintf(n,"%d",i-a+1);
      if(i==b) p=2;
         else p=1;
      if(mx<x+p+7)
      {
         Move(rp,x<<3,NWNewWindowStructure1.Height-4);
         SetAPen(rp,GRAY);
         SetBPen(rp,BLACK);
         Text(rp,n,strlen(n));
         if(mc!=104)
         {
            SetAPen(rp,BLACK);
            SetBPen(rp,KMZ);
            Text(rp,inl[i],6);
         } else
         {
            SetAPen(rp,YELLOW);
            SetBPen(rp,DARK);
            Text(rp,inl[i],6);
            i=-1;
         }
         return(i);
      }
      x+=p+7;
   }
}

Prototype void InitRP()
{
   rp=NTPBase->w->RPort;
//   SetRast(rp,DARK);
   SetBPen(rp,DARK);
   BotBor=NWNewWindowStructure1.Height;
   if(!NWNewWindowStructure1.FirstGadget) BotBor-=19;
      else BotBor-=56;
   Rect(NTPBase->w,0,0,rstart-7,BotBor);
   Rect(NTPBase->w,rstart-5,0,638,BotBor);
   InitLeft();
   InitRight();
   if(!(NTPPREFS.Flags&INGADGETS))
   {
      SetAPen(rp,GRAY);
      RectFill(rp,0,BotBor+1,639,BotBor+37);
      RefreshGList(NTPBase->w->FirstGadget,NTPBase->w,0,-1);
   }
/*   SetRGB4(ViewPortAddress(NTPBase->w),0,10,10,10);
   SetRGB4(ViewPortAddress(NTPBase->w),1,0,0,0);
   SetRGB4(ViewPortAddress(NTPBase->w),3,6,8,11);
   SetRGB4(ViewPortAddress(NTPBase->w),2,15,15,15); */
   Palette();
   InitInLine(0);
}

Prototype char Side(short x)
{
   if(x <= lstart+width) return(LEFT);
   if(x >= rstart) return(RIGHT);
   return(Act);
}

Prototype void MCurs(char a,char li)
{
   void ActLine();
   char b=0;
   if(a!=Act)
      if((wp[a].Type == DIR ||
         wp[a].Type == TREE ||
         wp[a].Type > INFO) && pw[a].cnt)
      {
         PCurs();
         Act=a;
         ActLine();
         pw[a].CurAct=pw[a].cnt-1<li?pw[a].cnt-1:li;
         PCurs();
      } else;    // b=1;
   else b=1;
   if(b)
   {
      if(pw[Act].CurAct==pw[Act].cnt-1 &&
         li>pw[Act].CurAct);
      else
      {
         if(pw[a].cnt)
         {
            PCurs();
            pw[Act].CurAct=pw[Act].cnt-1<li?pw[Act].cnt-1:li;
            PCurs();
         }
      }
   }
}

Prototype void GoUp(char a)
{
   if(a!=Act) MCurs(a,0);
   if(pw[Act].First > 0)
   {
      short b=(Act==LEFT ? lstart : rstart);
      pw[Act].First--;
      PCurs();
      SetBPen(rp,DARK);
      ScrollRaster(rp, 0,-8, b,5, b+width,4+(NTPBase->Lines<<3));
      PrintNode(pw[Act].l[pw[Act].First], 0);
      if(Act==LEFT) LeftLines();
      else RightLines();
      PCurs();
   }
}

Prototype void GoDown(char a)
{
   if(a!=Act) MCurs(a,NTPBase->Lines-1);
   if(pw[Act].First+NTPBase->Lines < pw[Act].cnt)
   {
      short b=(Act==LEFT ? lstart : rstart);
      pw[Act].First++;
      PCurs();
      SetBPen(rp,DARK);
      ScrollRaster(rp, 0,8, b,5, b+width,4+(NTPBase->Lines<<3));
      PrintNode(pw[Act].l[pw[Act].First+NTPBase->Lines-1], NTPBase->Lines-1);
      if(Act==LEFT) LeftLines();
      else RightLines();
      PCurs();
   }
}

Prototype void FillFlags()
{
   if(NWNewWindowStructure1.FirstGadget)
      NTPPREFS.Flags&=~INGADGETS;
    else
      NTPPREFS.Flags|=INGADGETS;
}

Prototype RefCW(struct Window *w,int max,int cur)
{
   struct IntuiMessage *msg;
   int class,code;
   if(!w) return(0);
   if(max) RectFill(w->RPort,5+CWBORDER,45,5+CWBORDER+cur*(195-2*CWBORDER)/max,52);
   if(msg=GetMsg(w->UserPort))
   {
      class=msg->Class; code=msg->Code;
      ReplyMsg(msg);
      if((class==RAWKEY) && (code==0x45))
      {
         ErrorLine(breakstr); return(1);
      }
   }
   if(msg=GetMsg(NTPBase->w->UserPort))
   {
      class=msg->Class; code=msg->Code;
      ReplyMsg(msg);
      if((class==RAWKEY) && (code==0x45))
      {
         ErrorLine(breakstr); return(1);
      }
   }
   return(0);
}

Prototype void Set(a,li)
char a,li;
{
   if(wp[a].Type==DIR && li<pw[a].cnt)
   {
      char sAct=Act;
      short pos=pw[a].First+li;
      if(pos>=pw[a].s)
      {
         Act=a;
         pw[a].l[pos]->Set = 1-pw[a].l[pos]->Set;
         if(pw[a].l[pos]->Set)
         {
            pw[a].Sel++;
            pw[a].SetSize+=SizeVal(pw[a].l[pos]->Size);
         }
         else
         {
            pw[a].Sel--;
            pw[a].SetSize-=SizeVal(pw[a].l[pos]->Size);
         }
         if(sAct==Act && pw[Act].CurAct==li)
         {
            PCurs();
            PrintNode(pw[a].l[pw[a].First+li],li);
//            PCurs();
         }
         else PrintNode(pw[a].l[pw[a].First+li],li);
         RefreshSet(a);
         Act=sAct;
         if(a==Act && li==pw[a].CurAct) PCurs(a,li);
      }
   }
}

Prototype GetSort(char a)
{
   char sAct=Act,ret;
   Act=a;
   ret=GetDir(wp[a].Path,pw[a].l,&pw[a].cnt,fre+a);
   if(wp[a].Sort!=UNSORTED && pw[a].cnt>pw[a].s+1)
      quicksort(pw[a].s,pw[a].cnt-1);
     Act=sAct;
   if(ret && Act==a)
      ActLine();
   return(ret);
}

Prototype void RCurs(char a)
{
   if(Act==a&&(wp[a].Type==DIR||wp[a].Type==TREE||wp[a].Type>INFO))
      if(pw[a].cnt)
         if(nc) nc=0;
         else PCurs();
      else nc=1;
}

Prototype void HCurs()
{
   if(!pw[Act].cnt) nc=1;
   else PCurs();
}

Prototype void SetCursor()
{
   if((wp[0].Type==DIR || wp[0].Type==TREE || wp[0].Type>INFO) && pw[0].cnt)
   {
      Act=0;
      PCurs();
   }
   else
      if((wp[1].Type==DIR || wp[1].Type==TREE || wp[1].Type>INFO) && pw[1].cnt)
      {
         Act=1;
         PCurs();
      }
      else
      {
         nc=1;
         if(wp[0].Type==DIR || wp[0].Type==TREE || wp[0].Type>INFO)
            Act=0;
         else Act=1;
         RCurs(Act);
      }
}

Prototype void SetTest()
{
   register i;
   register struct Dir **l=pw[Act].l;
   if(pw[Act].First+pw[Act].CurAct>=pw[Act].s)
      if(wp[Act].Type==DIR)
      {
         for(i=pw[Act].cnt;i>0;i--,l++) if(l[0]->Set) break;
         if(!i)
         {
            pw[Act].l[pw[Act].CurAct+pw[Act].First]->Set=1;
            STest=1;
         } else STest=0;
      }
}

Prototype MkDir1(char *name,char mode)
{
   int i;
   struct FileLock *lock,*l1,*nd,*CreateDir(),*CurrentDir();
   l1=(struct FileLock *)Lock(wp[Act].Path,ACCESS_READ);
   lock=CurrentDir(l1);
   if(nd=Lock(name,ACCESS_READ))
   {
      UnLock(nd);
      CurrentDir(lock);
      UnLock(l1);
      return(0);
   }
   if(!(nd=CreateDir(name)))
   {
#ifdef GERMAN
      ErrorLine("Verchzeichnis nicht mglich");
#else
      ErrorLine("Can't create dir");
#endif
      CurrentDir(lock);
      UnLock(l1);
      return(0);
   }
   Examine(nd,lfib);
   i=pw[Act].cnt;
   if(mode)
      if(MakeNode(pw[Act].l,i,lfib->fib_FileName,0,lfib->fib_Protection,1,1,
      &lfib->fib_Date))
      {
         pw[Act].cnt++;
         if(wp[Act].Sort!=UNSORTED && i>pw[Act].s) quicksort(pw[Act].s,i);
      }
   FirstOcc(lfib->fib_FileName);
   UnLock(nd);
   CurrentDir(lock);
//   UnLock(lock);
   UnLock(l1);
   RFree(Act);
}

Prototype void MkDir()
{
   ac=0;
   *buf=0;
#ifdef GERMAN
   if(StringReq(buf,"Neue Nameverz.:"))
#else
   if(StringReq(buf,"New dir's name:"))
#endif
      MkDir1(buf,1);
}

Prototype Parent()
{
   struct FileLock *lock,*oldlock,*rol,*ParentDir(),*CurrentDir();
   if((pw[Act].s==2 && (pw[Act].First+pw[Act].CurAct==0)) || pw[Act].s==1 || wp[Act].Type==TREE)
   {
      if(NTPPREFS.Flags&STRICTNC && wp[Act].Type!=TREE && pw[Act].s!=1)
      {
         if(oldlock=(struct FileLock *)Lock(wp[Act].Path,ACCESS_READ))
         {
            char *ptr;
            rol=CurrentDir(oldlock);
            FullPath(wp[Act].Path);
            for(ptr=wp[Act].Path;*ptr!=':';ptr++);
            ptr[1]=0;
            CurrentDir(rol);
            GetSort(Act);
            PrintDir();
            PCurs();
            SetCount();
            UnLock(oldlock);
            return(1);
         } else DosError(IoErr());
         return(0);
      } else
      {
         wp[Act].Type=DEVS;
         RefType(Act);
         pw[Act].s=0;
         DosList(1<<DLT_DEVICE,1);
         if(!pw[Act].cnt) DosList(1<<DLT_DEVICE,0);
         if(wp[Act].Sort!=UNSORTED && 1<pw[Act].cnt)
            quicksort(pw[Act].s,pw[Act].cnt-1);
         PrintDir(Act);
         PCurs();
         return(1);
      }
   }
   if(oldlock=(struct FileLock *)Lock(wp[Act].Path,ACCESS_READ))
   {
      if(lock=ParentDir(oldlock))
      {
         char pom[256],*ptr;
         rol=CurrentDir(lock);
         ptr=wp[Act].Path+strlen(wp[Act].Path)-1;
         if(*ptr==':')
         {
            *ptr=0;
            ptr=wp[Act].Path;
         }
         else
         {
            *ptr=0;
            ptr--;
            for(;ptr>=wp[Act].Path;ptr--)
               if(*ptr==':' || *ptr=='/') break;
         }
         strcpy(pom,ptr+1);
         wp[Act].Path[0]=0;
         FullPath(wp[Act].Path);
         CurrentDir(rol);
         UnLock(lock);
         GetSort(Act);
         ClearWindow(Act);
         SetCount();
         FirstOcc(pom);
      }
      UnLock(oldlock);
   } else DosError(IoErr());
}

Prototype void Ref()
{
   if(STest)
   {
      pw[Act].l[pw[Act].First+pw[Act].CurAct]->Set=0;
      STest=0;
   }
   PCurs();
   RefreshDir(Act);
   PCurs();
}

Prototype PlayMED(char *sou)
{
   int a=0;
   struct Window *w;
   struct Module *m;
   if(GetPlayer(0))
   {
#ifdef GERMAN
      ErrorLine("Spielen nicht mglich");
#else
      ErrorLine("Can't init player");
#endif
      return(0);
   }
   if(m=(struct Module *)LoadModule(spath))
   {
      PlayModule(m);
/*      NW3.Height=32;
      NW3.FirstGadget=&Gadget32;
      NW3.Screen=NTPBase->Screen;
      CenterWindow(&NW3);
      if(w=OpenWindow(&NW3))
      {
         SetRast(w->RPort,GRAY);
         RefreshGList(w->FirstGadget,w,0,-1);
         WRectangle(w);
         WTitle(w,spath);
         Wait(1<<w->UserPort->mp_SigBit);
         {
            struct IntuiMessage *msg;
            msg=GetMsg(w->UserPort);
            a= ((struct Gadget *)msg->IAddress)->GadgetID;
            ReplyMsg(msg);
         }
         CloseWindow(w);
      } else a=2; */
      a=strlen(spath);
      if(a>24) a=NewReq(spath+a-24, E(" Play next"), E("   Cancel"));
      else a=NewReq(spath, E(" Play next"), E("   Cancel"));
      StopPlayer();
      UnLoadModule(m);
   }
   else
   {
#ifdef GERMAN
      sprintf(buf,"Lese %s nicht mglich oder es ist nicht MED Module",spath);
#else
      sprintf(buf,"Can't load %s or not a MED module",spath);
#endif
      ErrorLine(buf);
      a=2;
   }
   FreePlayer();
   return(a);
}

Prototype PlayOcta(char *sou)
{
   int a=0;
   struct Window *w;
   struct Module *m;
   if(GetPlayer8(0))
   {
#ifdef GERMAN
      ErrorLine("Spielen nicht mglich");
#else
      ErrorLine("Can't init player");
#endif
      return(0);
   }
   if(m=(struct Module *)LoadModule8(spath))
   {
      PlayModule8(m);
/*      NW3.Height=32;
      NW3.FirstGadget=&Gadget32;
      NW3.Screen=NTPBase->Screen;
      CenterWindow(&NW3);
      if(w=OpenWindow(&NW3))
      {
         SetRast(w->RPort,GRAY);
         RefreshGList(w->FirstGadget,w,0,-1);
         WRectangle(w);
         WTitle(w,spath);
         Wait(1<<w->UserPort->mp_SigBit);
         {
            struct IntuiMessage *msg,*GetMsg();
            msg=GetMsg(w->UserPort);
            a= ((struct Gadget *)msg->IAddress)->GadgetID;
            ReplyMsg(msg);
         }
         CloseWindow(w);
      } else a=2;*/
      a=strlen(spath);
      if(a>24) a=NewReq(spath+a-24, E(" Play next"), E("   Cancel"));
      else a=NewReq(spath, E(" Play next"), E("   Cancel"));
      StopPlayer8();
      UnLoadModule8(m);
   }
   else
   {
#ifdef GERMAN
      sprintf(buf,"Lesen %s nicht mglich oder es ist nicht MED Module",spath);
#else
      sprintf(buf,"Can't load %s or not a MED module",spath);
#endif
      ErrorLine(buf);
      a=2;
   }
   FreePlayer8();
   return(a);
}

Prototype void Menu3(char mi)
{
   switch(mi)
   {
      case 0:if(LoadPrefs())
             {
                Process(LEFT);
                Process(RIGHT);
                SetCursor();
             }
             break;
      case 1:DefaultPrefs();
             Process(LEFT);
             Process(RIGHT);
             SetCursor();
             break;
      case 2:SavePrefs("NT:NTPPrefs");break;
      case 3:
         {
            char i=NTPPREFS.TabLen;
            sprintf(buf,"%d",i);
#ifdef GERMAN
            if(StringReq(buf,"Ein neue Tab.lnge"))
#else
            if(StringReq(buf,"Enter new tab. size"))
#endif
            {
               NTPPREFS.TabLen=atoi(buf);
               if(NTPPREFS.TabLen>0 && NTPPREFS.TabLen<30);
               else NTPPREFS.TabLen=i;
            }
         }
         break;
   }
}

Prototype Insert(char *s,int l)
{
   int i;
   char *ptr1=line+cx;
   char *ptr2=line+cx+l;
   for(i=strlen(ptr1)+1;i>=0;i--)
      ptr2[i]=ptr1[i];
   for(i=0;i<l;i++) line[cx+i]=s[i];
}

Prototype void Home()
{
   if(pw[Act].First==0)
      if(wp[Act].Type==DIR && pw[Act].s==2) pw[Act].CurAct=1;
      else pw[Act].CurAct=0;
   else
   {
      pw[Act].First=0;
      if(wp[Act].Type==DIR && pw[Act].s==2) pw[Act].CurAct=1;
      else pw[Act].CurAct=0;
      RefreshDir(Act);
   }
}

Prototype void End()
{
   int c=pw[Act].cnt-1;
   if(pw[Act].First+NTPBase->Lines > c)
      pw[Act].CurAct=c-pw[Act].First;
   else
   {
      pw[Act].First=c-NTPBase->Lines+1;
      pw[Act].CurAct=NTPBase->Lines-1;
      RefreshDir(Act);
   }
}

Prototype void PgUp()
{
   if(pw[Act].First>=NTPBase->Lines)
   {
      pw[Act].First-=NTPBase->Lines;
      RefreshDir(Act);
   }
   else if(pw[Act].First)
   {
      pw[Act].First=0;
      pw[Act].CurAct=0;
      RefreshDir(Act);
   }
   else pw[Act].CurAct=0;
}

Prototype void PgDn()
{
   int c=pw[Act].cnt,l=NTPBase->Lines;
   pw[Act].First+=l;
   if(pw[Act].First+l>c)
   {
      pw[Act].First=c-l;
      pw[Act].CurAct=c-pw[Act].First-1;
   }
   if(pw[Act].First<0)
   {
      pw[Act].First=0;
      pw[Act].CurAct=c-1;
   }
   RefreshDir(Act);
}

Prototype void CtrlL()
{
   static char las=INFO,pom[256]="";
   if(wp[Act].Type==INFO)
   {
      wp[Act].Type=las;
      strcpy(wp[Act].Path,pom);
   }
   else
   {
      las=wp[Act].Type;
      wp[Act].Type=INFO;
      strcpy(pom,wp[Act].Path);
   }
   RefType(Act);
   if(wp[Act].Type==INFO)
   {
      struct FileLock *lock,*Lock();
      struct InfoData inf;
      if(lock=Lock(wp[1-Act].Path,ACCESS_READ))
      {
         Info(lock,&inf);
         NTPInfo(&inf,Act);
      }
   }
   else
   Process(Act);
}

Prototype void Menu0(a,mi,sn)
char a,mi,sn;
{
   char b=0;
   char sAct=Act;
   Act=a;
   switch(mi)
   {
      case 0 : {
                  char st=wp[a].Type;
                  wp[a].Type=sn+1;
                  if(wp[a].Type == INFO)
                  {
                     a=1-a;
                     if(wp[a].Type==DIR || wp[a].Type==TREE)
                     {
                        struct FileLock *lock,*Lock();
                        struct InfoData inf;
                        if(lock=Lock(wp[a].Path,ACCESS_READ))
                        {
                           Info(lock,&inf);
                           NTPInfo(&inf,1-a);
                        }
                        if(sAct==Act && nc==0)
                        {
                           sAct=Act=1-Act;
                           HCurs();
                        }
                     } else wp[1-a].Type=st;
                     a=1-a;
                  }
                  else if(wp[a].Type == QVIEW)
                     if(wp[1-a].Type != DIR) wp[a].Type=st;
                     else
                     {
                        ClearWindow();
                  //      if(pw[Act].cnt) QView();
                        if(sAct == a)
                        {
                           sAct=Act=1-Act;
                           HCurs();
                        }
                        else
                           sAct=Act=1-Act;
                        if(pw[Act].cnt) QView();
                     }
                  else
                  {
                     Act=sAct;
                     Process(a);
                     Act=a;
                     RCurs(sAct);
                  }
               }
               RefType(a);
               break;
      case 1 : {
                  char ss=wp[a].Sort;
                  if(!sn) wp[a].Sort=UNSORTED;
                  else
                  {
                     wp[a].Sort = sn-1;
                     if((wp[a].Type == DIR || wp[a].Type > INFO) &&
                         pw[a].cnt>1 && ss != wp[a].Sort)
                     {
                        quicksort(pw[a].s,pw[a].cnt-1);
                        b=1;
                     }
                  }
                  RefSort(a);
               }
               break;
      case 2 : {
                  char pom[16];
                  CopyMem(wp[a].Enable,pom,16);
#ifdef GERMAN
                  if(!StringReqLen(wp[a].Enable,"Ein Muster",16))
#else
                  if(!StringReqLen(wp[a].Enable,"Enable filter",16))
#endif
                     CopyMem(pom,wp[a].Enable,16);
                  else
                  {
                     ToUpper(wp[a].Enable);
                     b=1;
                  }
                  CopyMem(wp[a].Disable,pom,16);
#ifdef GERMAN
                  if(!StringReqLen(wp[a].Disable,"Aus Muster",16))
#else
                  if(!StringReqLen(wp[a].Disable,"Disable filter",16))
#endif
                     CopyMem(pom,wp[a].Disable,16);
                  else
                  {
                     ToUpper(wp[a].Disable);
                     b=1;
                  }
                  if(wp[a].Type == DIR && b)
                     GetSort(a);
                  else b=0;
                  break;
               }
      case 3 : // if(wp[a].Type == DIR || wp[a].Type == TREE)
               {
                  char pom[256],len;
                  if(NTPPREFS.Flags&STRICTNC)
                     if(!SelectPath(wp[a].Path)) break; else;
                  else
                  {
                     CopyMem(wp[a].Path,pom,256);
#ifdef GERMAN
                     if(!StringReqLen(wp[a].Path,"Aktuelle Weg:",256) ||
#else
                     if(!StringReqLen(wp[a].Path,"Current path:",256) ||
#endif
                        (strlen(wp[a].Path)==0))
                     {
                        CopyMem(pom,wp[a].Path,256);
                        break;
                     }
                  }

                  if(wp[a].Type != TREE)
                  {
                     wp[a].Type=DIR;
                     Act=sAct;
                     len=strlen(wp[a].Path)-1;
                     if(wp[a].Path[len]!=':'&&wp[a].Path[len]!='/'&&(len>0))
                     {
                        wp[a].Path[len+1]='/';
                        wp[a].Path[len+2]=0;
                     }
                     if(!(GetSort(a)))
                     {
                        CopyMem(pom,wp[a].Path,256);
                        b=0;
                     }
                     else b=1;
                     Act=a;
                  }
                  else if(wp[a].Type == TREE)
                  {
                     GetTree(a);
                     b=1;
                  }
               }
               break;
      case 4 : wp[a].Case = 1-wp[a].Case;
               if((wp[a].Type == DIR || wp[a].Type > INFO) && pw[a].cnt>1)
               {
                  quicksort(pw[a].s,pw[a].cnt-1);
                  b=1;
               }
               RefCase(a);
               break;
      case 5 : wp[a].List=sn+1;
               RefList(a);
               if(wp[a].Type==LIST)
               {
                  Process(a);
                  RCurs(sAct);
               }
               break;
   }
   if(b)
   {
      PrintDir();
      if(sAct==Act)  // predtym RCurs(Act)
         PCurs();  // predtym
   }
   Act=sAct;
}

extern struct DosLibrary *DOSBase;

Prototype void *DOSAlloc(long size)
{
   long *ptr=(long *)AllocMem(size+4,MEMF_CLEAR|MEMF_PUBLIC);
   if(ptr)
   {
      *ptr=size+4;
      return ptr+1;
   }
   return(0);
}

Prototype void DOSFree(void *mem)
{
   long *ptr=(long *)mem;
   FreeMem(ptr-1,*(ptr-1));
}

Prototype Assign(char *lname,char *name)
{
   int n;
   char *ptr,*nam,*rname;
   struct DosInfo *i;
   struct DeviceNode *d;
   struct FileLock *lock,*Lock();
   if(!(lock=Lock(lname,ACCESS_READ)))
   {
#ifdef GERMAN
      ErrorLine("Lock nicht existiert");
#else
      ErrorLine("Unexist. lock");
#endif
      return(0);
   }
   if(Kick(36))
   {
      AssignLock(name,lock);
      return(1);
   }
   n=strlen(name);
   if(!(rname=nam=(char *)AllocMem(n+4,0)))
   {
      ErrorLine(memory);
      UnLock(lock);
      return(0);
   }
   nam=nam>>2;
   nam=nam<<2;
   CopyMem(name,nam+1,*nam=n);
   i=(struct DosInfo *)BADDR(((struct RootNode *)DOSBase->dl_Root)->rn_Info);
   Forbid();
   d=(struct DeviceNode *)BADDR(i->di_DevInfo);
   for(;d;d=(struct DeviceNode *)BADDR(d->dn_Next))
   {
      ptr=(char *)BADDR(d->dn_Name);
      if(!strnicmp(nam,ptr,*nam+1)) break;
   }
   if(d)
   {
      if(d->dn_Type==DLT_DIRECTORY)
      {
         if(d->dn_Lock)
         {
            Permit();
            UnLock(d->dn_Lock);
         }
         d->dn_Task=((struct FileLock *)BADDR(lock))->fl_Task;
         d->dn_Lock=(BPTR)lock;
      } else UnLock(lock);
      FreeMem(rname,n+4);
   }
   else
   {
      struct DeviceList *d1;
      if(d1=(struct DeviceNode *)DOSAlloc(sizeof(struct DeviceList)))
      {
         d1->dl_Type=DLT_DIRECTORY;
         d1->dl_Task=((struct FileLock *)BADDR(lock))->fl_Task;
         d1->dl_Lock=(BPTR)lock;
         d1->dl_Name=nam>>2;
         Forbid();
         d1->dl_Next=i->di_DevInfo;
         i->di_DevInfo=d1>>2;
         Permit();
         return(1);
      }
      else
      {
         ErrorLine(memory);
         UnLock(lock);
         FreeMem(rname,n+4);
      }
   }
   Permit();
}

Prototype void CloseWind()
{
   struct Process *proc=FindTask(0);
   proc->pr_WindowPtr=sw;
   ClearMenuStrip(NTPBase->w);
   CloseWindow(NTPBase->w);
}

Prototype struct Window *Iconify()
{
   struct NewWindow NW =
   {
      228,10,
      200,8,
      0,1,
      CLOSEWINDOW|MOUSEBUTTONS,
      WINDOWCLOSE|WINDOWDRAG|RMBTRAP,
      NULL,
      NULL,
#ifdef GERMAN
      "NTP Einschlafe",
#else
      "NTP's dream",
#endif
      NULL,
      NULL,
      -1,-1,
      -1,-1,
      WBENCHSCREEN
   };
   struct Window *w;
   if(Kick(36)) NW.Height+=1;
   if(!(w=OpenWindow(&NW))) return(0);
   SizeWindow(w,0,w->BorderTop-8);
   CloseWind();
   CloseScreen(NTPBase->Screen);
   return(w);
}


Prototype Open1()
{
   struct Process *proc;
   NWNewWindowStructure1.Screen=NTPBase->Screen;
   if(NTPBase->w=(void *)Open2(&NWNewWindowStructure1))
   {
      if(!SetMenuStrip(NTPBase->w,&NWMenu1))
      {
         CloseWindow(NTPBase->w);
         return(0);
      }
      proc=FindTask(0);
      sw=proc->pr_WindowPtr;
      proc->pr_WindowPtr=(APTR)NTPBase->w;
      if(!(NTPPREFS.Flags&REQON)) MsgOFF();
      InitRP();
      return(1);
   }
   return(0);
}

Prototype OpenWind()
{
   char sAct=Act;
   if(Open1())
   {
      for(Act=0;Act<2;Act++)
      {
         if(wp[Act].Type==QVIEW)
            if(pw[1-Act].cnt)
            {
               QView();
               if(Act==sAct) HCurs();
            } else;
         else if(wp[Act].Type==INFO)
         {
            struct FileLock *lock;
            struct InfoData inf;
            if(lock=(struct FileLock *)Lock(wp[1-Act].Path,ACCESS_READ))
            {
               Info(lock,&inf);
               NTPInfo(&inf,Act);
            }
            if(sAct==Act) HCurs();
         }
         else
         {
            RefreshDir(Act);
         }
      }
      Act=sAct;
      PCurs();
      ActLine();
      PrintLine();
      TCurs();
      return(1);
   }
   return(0);
}

Prototype UnIconify(struct Window *w)
{
   struct Screen *OpenScreen();
   if(OpenScr())
   {
      if(!OpenWind())
      {
         CloseScreen(NTPBase->Screen);
         return(0);
      }
   } else return(0);
   if(w) CloseWindow(w);
   return(1);
}

Prototype do_Iconify()
{
   struct IntuiMessage *msg;
   struct Window *w;
   if(w=Iconify())
   {
      int go=2,cl,code;
      while(go==2)
      {
         Wait(1<<w->UserPort->mp_SigBit);
         msg=GetMsg(w->UserPort);
         cl=msg->Class;
         code=msg->Code;
         ReplyMsg(msg);
         switch(cl)
         {
           case MOUSEBUTTONS: if(code==105)
                                 if(UnIconify(w)) go=1;
                              break;
           case CLOSEWINDOW : CloseWindow(w);
                              NTPBase->Screen=NULL;
                              go=0;
                              break;
         }
      }
      return(go);
   } else
   {
      ErrorLine(memory);
      return(1);
   }
}

Prototype int Menu2(char mi)
{
   switch(mi)
   {
      case 0:
         Help(0);
         break;
      case 1:
         Menu(wp[Act].Path);
         break;
      case 2:
         MkDir();
         break;
      case 3:
         return(do_Iconify());
      case 4:
         ReadCfg("NT:NTP.Cfg");
         break;
      case 5:
         Calc();
         break;
      case 6:
         {
            int drv=0;
#ifdef GERMAN
            if(TDiskReq1(&drv,"Instalieren:"))
#else
            if(TDiskReq1(&drv,"Select drive to Install"))
#endif
               Install(drv);
            break;
         }
      case 7:
         {
            int drv=0;
#ifdef GERMAN
            if(TDiskReq1(&drv,"Schnellformatieren:"))
#else
            if(TDiskReq1(&drv,"Select drive to QFormat"))
#endif
               FastFormat(drv);
            break;
         }
      case 8:
         {
            int drv=0;
#ifdef GERMAN
            if(TDiskReq1(&drv,"Formatieren:"))
#else
            if(TDiskReq1(&drv,"Select drive to Format"))
#endif
               Format(drv);
            break;
         }
      case 9:
         {
            int d1=0,d2=0;
#ifdef GERMAN
            if(TDiskReq2(&d1,&d2,"Whlen des Gertes:"))
#else
            if(TDiskReq2(&d1,&d2,"Disk copy-Select Drives:"))
#endif
               DiskCopy(d1,d2);
            break;
         }
      case 10:
         buf[0]=0;
#ifdef GERMAN
         if(StringReqLen(buf,"Assign Verz. als:",31))
#else
         if(StringReqLen(buf,"Assign directory as:",31))
#endif
         {
            char i=strlen(buf);
            if(buf[i-1]==':') buf[i-1]=0;
            Assign(wp[Act].Path,buf);
            if(wp[1-Act].Type==ASSIGN)
               Process(1-Act);
         }
         break;
      case 11:
         SetTest();
         Find();
         break;
      case 12:
         if(wp[Act].Type==DIR)
         {
            struct FileHandle *f;
            struct FileLock *ol,*lock,*lock2;
            lock2=Lock(wp[Act].Path,ACCESS_READ);
            if(lock2)
            {
               char Name[61]="";
#ifdef GERMAN
               if(StringReqLen(Name,"Datei Name",NLEN))
#else
               if(StringReqLen(Name,"File name to Edit",NLEN))
#endif
                  if(strlen(Name)<NLEN && *Name)
                  {
                     {
                        int i;
                        for(i=strlen(Name);i>=0;i--)
                           if(Name[i]==':' || Name[i]=='/') break;
                        if(i>-1)
                        {
                           UnLock(lock2);
#ifdef GERMAN
                           ErrorLine("Nur Name!");
#else
                           ErrorLine("I wonted only name!");
#endif
                           break;
                        }
                     }
                     ol=CurrentDir(lock2);
                     if(f=Open(Name,MODE_OLDFILE))
                     {
                        Close(f);
                        ar=0;
                        men=1;
                        ED1(Name,0);
                     }
                     else
                     {
                        men=1;
                        ED(Name,0);
                        if(lock=Lock(Name,ACCESS_READ))
                        {
                           Examine(lock,lfib);
                           if(MakeNode(pw[Act].l,
                                       pw[Act].cnt,
                                       lfib->fib_FileName,
                                       lfib->fib_Size,
                                       lfib->fib_Protection,
                                       (lfib->fib_DirEntryType >= 0 ? 1 : 0),
                                       1),&lfib->fib_Date  )
                              pw[Act].cnt++;
                           UnLock(lock);
                        } else DosError(IoErr());
                        if(wp[Act].Sort!=UNSORTED && pw[Act].s+1<pw[Act].cnt)
                           quicksort(pw[Act].s,pw[Act].cnt-1);
                     }
                     CurrentDir(ol);
                     RFree(Act);
                     PCurs();
                     RefreshDir(Act);
                     PCurs();
#ifdef GERMAN
                  } else ErrorLine("Ungltiges Dateiname");
#else
                  } else ErrorLine("Bad file name");
#endif
               UnLock(lock2);
            }
         }
         break;
      case 13:
         {
            int drv;
            *buf=0;
#ifdef GERMAN
            if(drv=DDiskReq1("Gert auswahl"))
#else
            if(drv=DDiskReq1("View Block-Select drive"))
#endif
#ifdef GERMAN
               if(StringReq(buf,"Block Nummer:"))
#else
               if(StringReq(buf,"Block number:"))
#endif
                  DumpTrack(drv,atoi(buf));
            break;
         }
      case 14:
         {
            int err;
            *buf=0;
#ifdef GERMAN
            if(StringReq(buf,"Fehler Nummer:"))
#else
            if(StringReq(buf,"Error number:"))
#endif
            {
               err=atoi(buf);
               DosError(err);
            }
            break;
         }
      case 15:
//         ErrorLine("NTP Author Patrick Sucansky, Slovakia, Tel: -427/729296");
         break;
      case 16:
         {
            int pom=1;
            if(NWGadget6.GadgetText->FrontPen==WARN)
#ifdef GERMAN
               if(Req(sure)) pom=0; else;
#else
               if(Req("Are you sure to Exit?")) pom=0; else;
#endif
            else pom=0;
            if(pom==0)
            {
#ifdef PATRIK
               SavePrefs("Env:NTPPrefs");
#endif
               return(0);
            }               
         }
   }
   return(1);
}

Prototype View()
{
   int i=1,x,j;
   char *p,*q;
   for(p=q=spath; *p; p++) if(*p=='/' || *p==':') q=p+1;
#ifdef GERMAN
   ErrorLine("Spiele module ...");
#else
   ErrorLine("Playing module ...");
#endif
   if((j=PlayST1(q))==2)
   {
      ErrorLine("");

/* -------------------------------------------------*/

      if (!(stricmp(".info",spath+strlen(spath)-5)))
      {
         p=spath+strlen(spath)-5;
         *p=0;
         if(Kick(39))
         {
            char *pom=p, t;
            struct FileLock *lock;
            while(*pom!=':' && *pom!='/' && pom>spath) pom--;
            t=*pom;
            if(pom>spath)
               *pom=0;
            if(!WorkbenchBase)
               WorkbenchBase=(void *)OpenLibrary("workbench.library",0);
            if(WorkbenchBase)
               x=WBInfo(lock=Lock(spath, ACCESS_READ), pom+1, NTPBase->Screen);
            else x=0;
            *pom=t;
            UnLock(lock);
         } else x=SHOWICON(spath,NTPBase->Screen);
         FlushIDCMP();
         *p='.';
         if(x==1) return(1);
         if(x==2) return(0);
      }

/* -------------------------------------------------*/

      x=Show(spath);
      ErrorLine(wp[Act].Path);
      FlushIDCMP();
      if(x==1) return(1);
      if(x==2 || x==0 && SE)
      {
         men=0;
         i=ED(spath,0);
         RFree(Act);
      }
      else i=0;
      ErrorLine(wp[Act].Path);
      return(i);
   }
   ErrorLine(wp[Act].Path);
   return(j);
}

Prototype ProcFile()
{
   char name[256],sp=0,pname[256];
   if(strchr(spath,' '))
   {
      sp=1;
      sprintf(pname,"\"%s\"",spath);
   }
   else sprintf(pname,"%s",spath);
   sprintf(name,"%s",spath);
   if(!UseCfg(l[cl]->Name,pname,l[cl]->Protect))
   {
      struct FileHandle *f;
      if(f=(struct FileHandle *)Open(name,MODE_OLDFILE))
      {
         long lx;
         struct FileLock *l,*ol;
         l=Lock(spath,ACCESS_READ);
         ol=CurrentDir(ParentDir(l));
         if(Read(f,&lx,4))
         {
            int i=1;
            Close(f);
            if(lx==0x3f3)
               if(NWGadget14.GadgetText->FrontPen==WARN)
                  ExecFile(pname);
               else Exec(pname);
            else
               View();
         } else Close(f);
         UnLock(l);
         UnLock(CurrentDir(ol));
      }
   }
   return(1);
}

Prototype void Enter()
{
   short pos;
   pos=pw[Act].First + pw[Act].CurAct;
   if(pos<pw[Act].s) Parent();
   else if(wp[Act].Type == DIR || wp[Act].Type==DEVS || wp[Act].Type==ASSIGN)
   {
      if(!isdigit(pw[Act].l[pos]->Size[7])&&wp[Act].Type==DIR )
      {
         char t[256];
         struct FileLock *l1,*l2,*ol;
         if(l1=Lock(wp[Act].Path,ACCESS_READ))
         {
            ol=CurrentDir(l1);
            strcpy(t,pw[Act].l[pos]->Name);
            strcpy(wp[Act].Path,t);
            if(GetSort(Act))
            {
               l2=Lock(t,ACCESS_READ);
               CurrentDir(l2);
               FullPath(wp[Act].Path);
               UnLock(l1);
            } else FullPath(wp[Act].Path);
            UnLock(CurrentDir(ol));
            PrintDir();
            PCurs();
            ErrorLine(wp[Act].Path);
            MCurs(Act,pw[Act].CurAct);
         } else DosError(205);
      } else if(wp[Act].Type!=DIR)
      {
         char t[256];
         strcpy(t,wp[Act].Path);
         sprintf(wp[Act].Path,"%s:",pw[Act].l[pos]->Name);
         if(GetSort(Act))
         {
            wp[Act].Type=DIR;
            RefType(Act);
            PrintDir();
            PCurs();
            MCurs(Act,pw[Act].CurAct);
         } else strcpy(wp[Act].Path,t);
      } else if(wp[Act].Type==DIR)
         ProcFile();
   }
   else if(wp[Act].Type==TREE)
   {
      if(!strcmp(pw[Act].l[pos]->Name,"|-.")) Parent();
      else if(pw[Act].l[pos]->Comment)
      {
         Act=1-Act;
         wp[Act].Type=DIR;
         strcpy(wp[Act].Path,pw[1-Act].l[pos]->Comment);
         Process(Act);
         Act=1-Act;
      }
   }
}

Prototype void CountLines()
{
   if(NWNewWindowStructure1.FirstGadget)
      NTPBase->Lines=(NewScreenStructure.Height-81)>>3;
   else NTPBase->Lines=(NewScreenStructure.Height-47)>>3;
}

Prototype StringReq(UBYTE *gb,char *t)
{
   int a,k34=0;
   char temp[256];
   struct Window *w;
   strcpy(temp,gb);
   NW3.Height=41;
   NW3.FirstGadget=&Gadget31;
   NW3.Screen=NTPBase->Screen;
   CenterWindow(&NW3);
   Gadget3SInfo.Buffer=temp;
   Gadget3SInfo.DispPos=0;
   Gadget3SInfo.BufferPos=0;
   if(w=OpenWindow(&NW3))
   {
      int i,wid=NW3.Width;
      struct ViewPort *vp;
      struct UCopList *ucop,*sucop;
      struct CopList *dspins,*sprins,*clrins;
      if(!Kick(36))
      {
         if(NTPPREFS.Flags&COLOR)
         {
            k34=1;
            SetRGB4(ViewPortAddress(NTPBase->w),0,5,5,5);
         }
      }
      else
      {
         Gadget3SExtend.Font=NTPBase->w->RPort->Font;
         Gadget3SExtend.Pens[0]=BLACK;
         Gadget3SExtend.Pens[1]=GRAY;
         Gadget3SExtend.ActivePens[0]=WHITE;
         Gadget3SExtend.ActivePens[1]=GRAY;
      }
      SetRast(w->RPort,GRAY);
      RefreshGList(w->FirstGadget,w,0,-1);
      WRectangle(w);
      WTitle(w,t);
      ActivateGadget(&Gadget31,w,0);
      Wait(1<<w->UserPort->mp_SigBit);
      {
         struct IntuiMessage *msg,*GetMsg();
         msg=GetMsg(w->UserPort);
         a = ((struct Gadget *)msg->IAddress)->GadgetID;
         ReplyMsg(msg);
      }
      if(k34)
         SetRGB4(ViewPortAddress(NTPBase->w),0,0,0,0);
      CloseWindow(w);
      strcpy(gb,temp);
      FlushIDCMP();
   } else return(0);
   return(a);
}

Prototype StringReqLen(UBYTE *gb,char *t,int len)
{
   int ret;
   Gadget3SInfo.MaxChars=len;
   ret=StringReq(gb,t);
   Gadget3SInfo.MaxChars=60;
   return(ret);
}

Prototype Req(char *t)
{
   int a=2;
   struct Window *w;
   NW3.Height=32;
   NW3.FirstGadget=&Gadget32;   
   NW3.Screen=NTPBase->Screen;
   NW3.IDCMPFlags|=RAWKEY;
   CenterWindow(&NW3);
   if(w=OpenWindow(&NW3))
   {
      SetRast(w->RPort,GRAY);
      RefreshGList(w->FirstGadget,w,0,-1);
      WRectangle(w);
      WTitle(w,t);
      {
         struct IntuiMessage *msg,*GetMsg();
         while(a==2)
         {
            Wait(1<<w->UserPort->mp_SigBit);
            while(msg=GetMsg(w->UserPort))
            {
               if(msg->Class==GADGETUP)
                  a=((struct Gadget *)msg->IAddress)->GadgetID;
               else
                  switch(msg->Code)
                  {
                     case 0x44:
                     case 0x18:
                     case 0x43:
                     case 0x27:a=1;break;
                     case 0x45:
                     case 0x33:a=0;
                  }
               ReplyMsg(msg);
            }
         }
      }
      CloseWindow(w);
      NW3.IDCMPFlags&=~RAWKEY;
      FlushIDCMP();
   } else return(0);
   return(a);
}

Prototype OpenCopyW(char *t)
{
#define TS 3
   char temp[26],dp[256];
   int i;
   struct Window *w;
   NW3.Height=60;
   NW3.FirstGadget=NULL;
   NW3.Screen=NTPBase->Screen;
   CenterWindow(&NW3);
   NW3.Flags&=~ACTIVATE;
   NW3.IDCMPFlags|=RAWKEY;
   if(w=OpenWindow(&NW3))
   {
      SetRast(w->RPort,GRAY);
      if(pbx>1) SetFont(w->RPort,pbx);
      WRectangle(w);
      if(*dpath==' ') strcpy(dp, dpath+1);
      else
      {
         strcpy(dp,dpath);
         for(i=strlen(dp);dp[i]!=':' && dp[i]!='/' && i>0;i--);
         if(i>=0) dp[i+1]=0;
      }
      SetAPen(w->RPort,BLACK);
      SetBPen(w->RPort,GRAY);
      Move(w->RPort,TS,11);
      switch(work)
      {
#ifdef GERMAN
         case COPY:Text(w->RPort,"      Kopiere Datei",19);break;
#else
         case COPY:Text(w->RPort,"       Copying file",19);break;
#endif
#ifdef GERMAN
         case MOVE:Text(w->RPort,"     Schieben Datei",19);break;
#else
         case MOVE:Text(w->RPort,"        Moving file",19);break;
#endif
#ifdef GERMAN
         case ENCRYPT:Text(w->RPort,"     Kodieren Datei",19);break;
#else
         case ENCRYPT:Text(w->RPort,"    Encrypting file",19);break;
#endif
         case FORMAT: Text(w->RPort,E("    Formatting disk"),19); break;
      }
      if(strlen(t)>=24)
      {
         CopyMem(t,temp,24);
         temp[24]=0;
      }
      else
      {
         CopyMem(spaces,temp,i=(25-strlen(t))/2);
         temp[i]=0;
         strcat(temp,t);
      }
      Move(w->RPort,TS,w->RPort->cp_y+10);
      Text(w->RPort,temp,strlen(temp));
      Move(w->RPort,TS,w->RPort->cp_y+10);
#ifdef GERMAN
      Text(w->RPort,"           zu",13);
#else
      Text(w->RPort,"           to",13);
#endif
      Move(w->RPort,TS+4,w->RPort->cp_y+9);
      if(strlen(dp)>=23)
      {
         CopyMem(dp,temp,23);
         temp[23]=0;
      }
      else
      {
         CopyMem(spaces,temp,i=(24-strlen(dp))/2);
         temp[i]=0;
         strcat(temp,dp);
      }
      Text(w->RPort,temp,strlen(temp));
      SetAPen(w->RPort,WHITE);
      RectFill(w->RPort,2+CWBORDER,43,202-CWBORDER,54);
      SetAPen(w->RPort,DARK);
      RectFill(w->RPort,3+CWBORDER,44,201-CWBORDER,53);
      SetAPen(w->RPort,LIGHT);
   }
   return(w);
#undef TS
}

Prototype void CloseCopyW(struct Window *w)
{
   if(w) CloseWindow(w);
   NW3.Flags|=ACTIVATE;
   NW3.IDCMPFlags&=~RAWKEY;
}

Prototype int PlayST1(char *sou)
{
   int ret=0;
   if((!stricmp(".mod",sou+strlen(sou)-4)) || (!strnicmp("mod.",sou,4)))
   {
      ret=START(sou);
      switch(ret)
      {
#ifdef GERMAN
         case 0: ErrorLine("Spielen diese Module ist nicht mglich"); break;
#else
         case 0: ErrorLine("Can't play this module"); break;
#endif
         case 1:
            ret=Req(sou);
            THEEND();
            break;
#ifdef GERMAN
         case 2: ErrorLine("Diese Datei ist nicht Module"); break;
#else
         case 2: ErrorLine("This is not a module"); break;
#endif
      }
   }
   else
   {
#ifdef GERMAN
      ErrorLine("Datei entspricht nicht Muster  MOD.* oder *.MOD");
#else
      ErrorLine("File doesn't match pattern MOD.* or *.MOD");
#endif
      return(2);
   }
   return(ret);
}

Prototype void Menu1(char mi)
{
   if(wp[Act].Type==DIR && pw[Act].cnt)
   {
      if(mi!=14 && mi<18) SetTest();
      switch(mi)
      {
         case 0:
            ResDir(OTHER,ExecFile);break;
         case 1:
            men=0;
            ResDir(OTHER,View);break;
         case 2:
            ResDir(OTHER,Dump1);
            break;
         case 3:
            men=1;
            ResDir(OTHER,ED1);
            RFree(Act);
            break;
         case 4:
            ac=0;
            Copy();
            break;
         case 5:
            ac=0;
            FMove();
            break;
         case 6:
            ac=0;
            if(NWGadget10.GadgetText->FrontPen==WARN)
#ifdef GERMAN
               if(Req(sure)) FDel(); else;
#else
               if(Req("Are you sure to delete?")) FDel(); else;
#endif
            else FDel();
            break;
         case 7:
            ac=0;
            FRename();
            break;
         case 8:
            ac=0;
            Print();
            break;
         case 9:
            ResDir(OTHER,Show);
            break;
         case 10:
            ResDir(OTHER,PlaySample1);
            break;
         case 11:
            {

               if(!MEDPlayerBase)
               {
                  struct FileLock *lock;
                  char *ptr;
                  if(!(lock=Lock(wp[Act].Path,ACCESS_READ))) break;
                  ptr=(char *)BADDR(\
                       ((struct DeviceList *)BADDR(\
                       ((struct FileLock *)BADDR(\
                       lock))->fl_Volume))\
                        ->dl_Name);
                  CopyMem(ptr+1,buf,*ptr);
                  buf[*ptr]=':';
                  buf[*ptr+1]=0;
                  UnLock(lock);
                  if(!(MEDPlayerBase=(struct MEDPlayerBase *)
                        OpenLibrary("medplayer.library",0)))
                  {
#ifdef GERMAN
                     ErrorLine("Medplayer.library ist bentigt!");
#else
                     ErrorLine("Medplayer.library required!");
#endif
                     break;
                  }
                  else
                  {
                     if(!(lock=Lock(buf,ACCESS_READ))) break;
                     UnLock(lock);
                  }
               }
               ResDir(OTHER,PlayMED);
            }
            break;
         case 12:
            {
               if(!OctaPlayerBase)
               {
                  struct FileLock *lock;
                  char *ptr;
                  if(!(lock=Lock(wp[Act].Path,ACCESS_READ))) break;
                  ptr=(char *)BADDR(\
                       ((struct DeviceList *)BADDR(\
                       ((struct FileLock *)BADDR(\
                       lock))->fl_Volume))\
                        ->dl_Name);
                  CopyMem(ptr+1,buf,*ptr);
                  buf[*ptr]=':';
                  buf[*ptr+1]=0;
                  UnLock(lock);
                  if(!(OctaPlayerBase=(struct OctaPlayerBase *)
                        OpenLibrary("octaplayer.library",0)))
                  {
#ifdef GERMAN
                     ErrorLine("Octaplayer.library ist bentigt!");
#else
                     ErrorLine("Octaplayer.library required!");
#endif
                     break;
                  }
                  else
                  {
                     if(!(lock=Lock(buf,ACCESS_READ))) break;
                     UnLock(lock);

                  }
               }
               ResDir(OTHER,PlayOcta);
            }
            break;
         case 13:
            ResDir(OTHER,PlayST1);
            break;
         case 14:
            FSearch();
            break;
         case 15:
            Encrypt();
            break;
         case 16:
            ac=0;
            Protect();
            break;
         case 17:
            CountSumm();
            break;
         case 18:
            SelectGroup();
            break;
         case 19:
            UnSelectGroup();
            break;
      }
      Ref();
   }
}
