/* double syntax-analyzed */

#include <ntp.h>
#include <math.h>

#define PUn    13
#define Blen   10
// #define DEBUG

extern MathIeeeDoubBasBase,MathIeeeDoubTransBase;

typedef struct
{
   char *Name,Size,Bukva;
} UnOp;

typedef struct
{
   int i;

   char c;
} Buffer;

typedef struct TERM
{
   double i;
   char c;
   struct TERM *l,*r;
} Term;

typedef struct
{
   double (*f)(double,double);
   double *c;
} Znam;

static Znam *z[128];

UnOp Un[PUn] =

{
   {"abs",3,'A'}, {"acos",4,'B'}, {"asin",4,'D'}, {"atg",3,'E'},
   {"cos",3,'C'}, {"cosh",4,'F'}, {"ln",2,'I'},   {"log",3,'J'},
   {"sin",3,'S' },{"sinh",4,'G'}, {"sqr",3,'O'},  {"tg",2,'T'},
   {"tgh",3,'H'}
};

static int ak;

static Term *Alloc(double i, char c,Term *l, Term *r)

{
   Term *x,*malloc();
   if(!(x=malloc(sizeof(Term))))

   {
#ifdef GERMAN
      ErrorLine("Nicht genug Speicher");
#else
      ErrorLine("not enough memory");
#endif
      return(0);
   }
   x->i=i;x->c=c;
   x->l=l;x->r=r;
   return(x);
}

static void Delete(char *a,int num)
{
   *a=a[num];
   do
   {
      a++;
      *a=a[num];
   } while(a+num < (char *)ak);
   ak-=num;
}

static void Insert(char *a,int num)
{
   register char *b=a;
   b=(char *)ak;
   for(;b>a;b--) b[num]=*b;
   ak+=num;
}

static OptOperands(char *a)
{
   register char *b=a;
   register i;

   int p;
   while(*b)
   {
      if(isalpha(*b)) if(isalpha(b[1])) b+=Un[FindUnary(b)].Size;
                          else
                          {
                             if(!(p=(int)Alloc((double)0,(char)*b,(Term *)0,(Term *)0)))
                                 return(0);
                             Insert(b,4);*b='$';b++;
                             CopyMem(&p,b,4);b+=4;
                          }
      if(isdigit(*b)||(*b=='-' && isdigit(b[1])) && *(b-5)!='$')
      {
         int z=1,sign=1;
         int bodka=0;
         a=b;
         if(*b=='-')
         {
            b++;
            sign=-1;
         }
         i=*b-'0';
         b++;
         while(isdigit(*b) || *b=='.')
         {
            if(*b=='.') bodka=1;
            else
            {
               i=i*10+*b-'0';
               if(bodka) z=z*10;
            }
            b++;
         }
         p=b-a;b=a;
         if(p<5) Insert(b,5-p);
            else if(p>5) Delete(b,p-5);
         *b='$';b++;
         if(!(p=(int)Alloc((double)sign*i/z,0,0,0))) return(0);
         CopyMem(&p,b,4);
         b+=4;
      }
      b++;
   }
   return(1);
}

static void Optimize(char *a)
{
   register char *b=a,c=*a;
   register i;
   *a='a';
   while(*b) b++;
   *b=')';
   b[1]=0;
   b--;
   for(;b>=a;b--)
   {
      i=0;
      if(isupper(*b)) *b=(char)tolower(*b);
      else
      while(*b==' ')
      {
         b--;
         i++;
      }
      if(i) Delete(b+1,i);
   }
   *a=c;
   if(*a==' ') Delete(a,1);
}

static int FindUnary(char *a)
{
   int i=0,j=PUn,k;
   int b;
   do
   {
      k=(i+j)/2; // >>1;
      if((b=strncmp(a,Un[k].Name,Un[k].Size))==1) i=k+1; else j=k-1;
   } while(b && i<=j);
   if(b!=0) return(-1);
   return(k);
}

static char *Operator(char *a,char *o)
{
   if(*a==')' || a>=(char *)ak) { *o='+';
#ifdef DEBUG
                                  puts("znam=)");
#endif
                                  return(a);
                                }
   *o=*a;
#ifdef DEBUG
   printf("znam=%c\n",*o);
#endif
   return(a+1);
}


static char *Operand(char *a,int *c)
{
   int k;
#ifdef DEBUG
   printf("Operand:");
#endif
   if(*a=='(')
   {
      Delete(a,1);
#ifdef DEBUG
      printf("( ");
      Printt(a);
#endif
      if(!(Create(a))) return(0);
   }
      else if((*a) != '$') {
         if((k=FindUnary(a))!=-1) {if(!(UnOpFn(a,k))) return(0);}
              else {ErrorLine("Error");return(0);}
         }
   a++;
   CopyMem(a,c,4);
#ifdef DEBUG
   puts("");
#endif
   return(a+4);
}

static UnOpFn(char *a,int k)
{
   int l;
#ifdef DEBUG
   printf("Unary\n");
#endif
   Delete(a,Un[k].Size+1);
   if(!(Create(a))) return(0);
   CopyMem(a+1,&l,4);
   if(!(l=(int)Alloc((double)0,Un[k].Bukva,(Term *)l,0))) return(0);
   CopyMem(&l,a+1,4);
#ifdef DEBUG
   printf("adrUn=%x\n",l);
#endif
   return(1);
}

static Create(char *a)
{
  Buffer b[Blen];
  int i=0,j;
   char *a0=a;
#ifdef DEBUG
   printf("Call\n");
#endif
   if(*a=='(')
   {
      Delete(a,1);
      if(!(Create(a))) return(0);
   }
   if(!(a=Operand(a,&b[0].i))) return(0);
#ifdef DEBUG
   puts("while ...");
#endif
   while(a!=Operator(a,&b[i].c))
   {
      a++;i++;
      if(!(a=Operand(a,&b[i].i))) return(0);
   }
   i++;
#ifdef DEBUG
   for(j=0;j<i;j++) printf("%d : %x,%c\n",j,b[j].i,b[j].c);puts("");
#endif
   j=a-a0+1;
   if(j>5) Delete(a0,j-5);
    else if(j<5) Insert(a0,5-j);
   *a0='$';
   while(i>1)
   {
      int jj;
      for(j=1;j<i;j++)
         if(z[b[j-1].c]->c >= z[b[j].c]->c)
         {
            int x;
            if(!(b[j-1].i=(int)Alloc((double)0,b[j-1].c,(Term *)b[j-1].i,
            (Term *)b[j].i))) return(0);
            b[j-1].c=b[j].c;
            for(x=j;x<i;x++) b[x]=b[x+1];
            i--;
         }
#ifdef DEBUG
      for(jj=0;jj<i;jj++) printf("%d : %x,%c\n",jj,b[jj].i,b[jj].c);
      printf("\n");
#endif
   }
   CopyMem(&b[0].i,a0+1,4);
#ifdef DEBUG
   printf("EndCreat\n");
   Printt(a0);
#endif
   return(1);
}


#ifdef DEBUG
Printt(char *a)
{
   int i;
   while(a<(char *)ak)
   {
      printf("%c",*a);
      if(*a=='$')
      {
         for(i=1;i<5;i++) printf("%02x,",a[i]&255);
         a+=4;
      }
      a++;
   }
   printf("\n");return(0);
}
#endif


static char *MulMis(char *a)
{
   Insert(a-1,1);
   *a='*';
   ErrorLine("Warning : missing *");
   return(a+1);
}

static SyntaxAnalyze(char *a)
{
   int l=0,zz=0;
   if(!(*a)) return(0);
   while(a[1])
   {
      if(*a == '(')
      {
         zz++;
         if(l==3 || l==8 || l==7) a=MulMis(a);
         l=2;
      }
      else if(*a == ')')
      {
#ifdef GERMAN
         zz--;if(zz<0) {ErrorLine("Error : es fehlt (");return(0);}
#else
         zz--;if(zz<0) {ErrorLine("Error : missing (");return(0);}
#endif
         if(l==5) {ErrorLine("Error : operand)");return(0);}
         if(l==2)
         {
            ErrorLine("Error : ()");return(0);
         }
         l=3;
      }
      else if(isdigit(*a))
      {
         while(isdigit(*a)) a++;
         if(l==3 || l==7) a=MulMis(a);
         l=8;a--;
      }
      else if(*a=='.')
      {
         if(l!=8) return(0);
      }
      else if(isalpha(*a))
      {
         int k;
         if((k=FindUnary(a)) != -1)
         {
#ifdef GERMAN
            if(a[Un[k].Size] != '(') {ErrorLine("Error : fn( (<- es fehlt");return(0);}
#else
            if(a[Un[k].Size] != '(') {ErrorLine("Error : fn( (<- missing");return(0);}
#endif
            if(l==8 || l==7 || l==3) a=MulMis(a);
            a+=Un[k].Size-1;
            l=6;
         }
         else
         {
#ifdef GERMAN
            if(z[*a]==0) {ErrorLine("Error : es existiert nur die Mglichteit x eingeben");return(0);}
#else
            if(z[*a]==0) {ErrorLine("Error : Variables not implemented");return(0);}
#endif
            if(l==8 || l==7 || l==3) a=MulMis(a);
            l=7;
         }
      }
      else if(*a=='-' && (l==2 || l==0))
      {
         if(l==5) {ErrorLine("Error : OperndOperand");return(0);}
         if(isalpha(a[1]))
         {
            Insert(a,1);
            a[1]='1';
         }
         l=5;
      }
      else
      {
#ifdef GERMAN
         if(z[*a]==0) {ErrorLine("Error : Operator ungltig");return(0);}
#else
         if(z[*a]==0) {ErrorLine("Error : unknown operator");return(0);}
#endif
         if(l==5 || l==2) {if(l==2) ErrorLine("Error : (Operator");
                           else ErrorLine("Error : OperatorOperator");

                           return(0);
                          }
         l=5;
      }
      a++;
   }
#ifdef GERMAN
   if(zz!=0) {ErrorLine("Error : Mehr ( als )");return(0);}
#else
   if(zz!=0) {ErrorLine("Error : More ( than )");return(0);}
#endif
   return(1);
}

static Term *hlav(char *a)
{
   int i;
   ak=(int)a+strlen(a);
   Optimize(a);ak++;
#ifdef DEBUG
   Printt(a);puts("OperOpt:");
#endif
   if(!(SyntaxAnalyze(a))) return(0);
#ifdef DEBUG
   Printt(a);
#endif
   if(!(OptOperands(a))) return(0);
#ifdef DEBUG
   Printt(a);
#endif
   if(!(Create(a))) return(0);
#ifdef DEBUG
   Printt(a);
#endif
   CopyMem(a+1,&i,4);
   return((Term *)i);
}


static double Add(double a,double b)
{  return((double)(a+b)); }
static double Sub(double a,double b)
{  return((double)(a-b)); }
static double Mul(double a,double b)
{  return((double)(a*b)); }
static double Div(double a,double b)
{
  if(b) return((double)(a/b));
  return((double)(a/0.00000001));
}
static double Cmp(double a,double b)
{
   if(a>b) return((double)1);
   if(a<b) return((double)-1);
   return(0);
}
static double Abs(double a)
{
   if(a<0) return((double)(-a));
   return(a);
}
static double Pow(double a,double b)
{
/*   register x=0;
   double c=1;
   for(x=0;x<b;x++) c*=a; */
   return(exp(log(a)*b));
}



static double Tree(Term *i)
{
   if(i->l) if(i->r)
#ifdef DEBUG
               {
                  double a,b;
                  printf("(%f%c%f)\n",a=Tree(i->l),i->c,b=Tree(i->r));
                  return((double)z[i->c]->f(a,b));
               }
#else
                  return(z[i->c]->f(Tree(i->l),Tree(i->r)));
#endif
               else
#ifdef DEBUG
               {
                  double a;
                  printf("%c(%f)\n",i->c,a=Tree(i->l));
                  return((double)z[i->c]->f(a,0));
               }
#else
                  return(z[i->c]->f(Tree(i->l),0));
#endif
   else if(i->c == 0) {
#ifdef DEBUG
                        printf("%f\n",i->i);
#endif
                        return(i->i);
                      }
         else {
#ifdef DEBUG
                  printf("%f\n",*z[i->c]->c);
#endif
                  return(*(z[i->c]->c));
              }
}

static Make(a,f,c)
char a;
double (*f)(double,double);
double *c;
{
   if(!(z[a]=(Znam *)malloc(sizeof(Znam))))

   {
      ErrorLine(memory);
      return(0);
   }
   z[a]->f=f;
   z[a]->c=c;
}

Prototype void InitLineAnalyse()
{
   Make('A',fabs,(double *)0);
   Make('C',cos,(double *)0);
   Make('S',sin,(double *)0);
   Make('T',tan,(double *)0);
   Make('O',sqrt,(double *)0);
   Make('B',acos,(double *)0);
   Make('D',asin,(double *)0);
   Make('E',atan,(double *)0);
//   Make('F',SPCosh,(double *)0);
//   Make('G',SPSinh,(double *)0);
//   Make('H',SPTanh,(double *)0);
   Make('I',log,0);
   Make('J',log10,0);
   Make('+',Add,(double *)10);
   Make('-',Sub,(double *)10);
   Make('*',Mul,(double *)20);
   Make('/',Div,(double *)20);
   Make('=',Cmp,(double *)5);
   Make('^',pow,(double *)30);

   Make('x',0,&x);
}

Prototype void Free(Term *i)
{
   if(i)
   {
      Free(i->l);
      Free(i->r);
      free(i);
   }
}

Prototype void Calc()
{
   if(CalcEn)
   {
      *buf=0;
#ifdef GERMAN
      if(StringReq(buf,"Ausdruck:"))
#else
      if(StringReq(buf,"Expression:"))
#endif
      {
         Term *i=0;
         if(MathIeeeDoubBasBase==0)
            if(!(MathIeeeDoubBasBase=OpenLibrary("mathieeedoubbas.library",0)))
               return;
         if(MathIeeeDoubTransBase==0)
            if(!(MathIeeeDoubTransBase=OpenLibrary("mathieeedoubtrans.library",0)))
               return;
         if(strchr(buf,'=')==0)
         {
            i=hlav(buf);
            if(i)
            {
               x=Tree(i);
               sprintf(buf,"x=%f",x);
               ErrorLine(buf);
            }
#ifdef GERMAN
         } else ErrorLine("Ungltig Ausdruck");
#else
         } else ErrorLine("Not valid expression");
#endif
      }
   }
   else ErrorLine(memory);
}
