#include <NTP.h>
#include <exec/types.h>
#include <stdio.h>
#include "exec/ports.h"
#include "exec/io.h"
#include "exec/memory.h"
#include "libraries/dos.h"
#include "libraries/dosextens.h"
#include "dos/dostags.h"

#include "workbench/startup.h"

#define PRIORITY 0
#define STACKSIZE 8192
#define FBL 100

extern struct ExecBase *SysBase;
extern struct Message *GetMsg();
extern int LoadSeg();
extern struct MsgPort *CreatePort(),*CreateProc();
extern struct FileHandle *Open();
extern char *strchr();

struct MsgPort *port;
struct WBStartup *msg;

Prototype OpenIO()
{
   struct Process *FindTask();
   if(FindTask(0)->pr_CLI)
   {
      io=0;
   }
   else
   {
         if(Kick(36))
            if(!(io=Open("CON:0/10/640/100/NTPShell/CLOSE",MODE_OLDFILE)))
               return(0);
            else ;
         else if(!(io=Open("CON:0/10/640/100/NTPShell",MODE_OLDFILE)))
            return(0);
         Write(io,"\0",1);
   }
/*
   if(Kick(37))
   {
      msg=(struct WBStartup *)AllocMem(sizeof(struct WBStartup), MEMF_CLEAR);
      port=CreatePort(0,0);
   }*/
}

Prototype void CloseIO()
{
/*   if(Kick(37))
   {
      if(msg) FreeMem(msg,sizeof(struct WBStartup));
      DeletePort(port);
   }*/
   if(io)
   {
      Close(io);
      io=0;
   }
}
/*
Prototype void Exec37(char *Name, struct FileHandle *io)
{
   struct Message *reply;
   struct Process *myprocess;
   int littleSeg;
   char *startname, *pom, temp, *args;
   struct MsgPort *littleProc;
   
   pom=Name;
   puts("Enter");
   while(TRUE)
   {
      if(*pom==' ' || *pom=='\t' || *pom==0)
         break;
      if(*pom=='\"')
         for(pom++; *pom!='\"'; pom++);
      pom++;
   }
   temp=*pom;
   if(*pom)
   {
      args=pom+1;
      *pom=0;
      printf("Args found : Name: %s   Args: %s", Name, args);
   } else
   {
      printf("Args not found, Name: %s\n", Name);
      args=NULL;
   }
      
   startname="StarterMessage";
   if(littleSeg=LoadSeg(Name))
   {
      puts("Seg. loaded");
      littleProc=(void *)CreateNewProcTags(NP_Seglist, littleSeg, NP_Input, io, NP_Output, io, NP_CloseInput, FALSE, NP_CloseOutput, FALSE, NP_StackSize, STACKSIZE, NP_Priority, PRIORITY, NP_Arguments, args, NP_Name, "Ahoj", TAG_END, NULL);
//      littleProc=CreateProc("Name",0,littleSeg,8192);
      if(littleProc==NULL)
      {
         UnLoadSeg(littleSeg);
         ErrorLine("Can't create process");
         *pom=temp;
         return(0);
      }
      puts("PROC CREATED");
      myprocess = (struct Process *)FindTask(0);
      if(msg)
      {
         msg->sm_Message.mn_ReplyPort=port;
         msg->sm_Message.mn_Length=sizeof(struct WBStartup);
         msg->sm_Message.mn_Node.ln_Name=startname;
         msg->sm_ArgList=NULL;
         msg->sm_ToolWindow=NULL;
         puts("sending");
         PutMsg(littleProc,msg);
         puts("sent");
         WaitPort(port);
         puts("waited");
      }
      else ErrorLine(memory);
   }
   *pom=temp;
}
*/

Prototype Exec(char *Name)
{
   struct Process *proc=(struct Process *)FindTask(0);
   RMBTrap();
   ScreenToBack(NTPBase->Screen);
   OpenIO();
   proc->pr_WindowPtr=sw;
//   if(Kick(36))
//   {
//      struct FileHandle *nio;
//      if(nio=Open("CON:0/10/640/100/NTPShell/CLOSE",MODE_READWRITE))
//      {
//         SystemTags(Name, SYS_Input, nio, SYS_Output, io, TAG_END);
//         Close(nio);
//      }
//   } else 
   Execute(Name,0,io);
   proc->pr_WindowPtr=(APTR)NTPBase->w;
   if(io)
   {
      char a[2];
      if(!wait) Read(io,a,1);
      else wait=0;
   }
   ScreenToFront(NTPBase->Screen);
   CloseIO();
   FlushIDCMP();
}

Prototype ExecFile(char *Name)
{
   char pom1[60];
   strcpy(pom1,Name);
#ifdef GERMAN
   if(StringReq(pom1,"Argumenten:", SR_OTHER))
#else
   if(StringReq(pom1,"Arguments:", SR_OTHER))
#endif
      Exec(pom1);
}

struct CfgNode
{
   struct CfgNode *Next;
   char  patt[20];
   char  file[40];
};

struct CfgNode *b;

Prototype FreeCfg()
{
   struct CfgNode *p;
   while(b)
   {
      p=b->Next;
      FreeMem(b,sizeof(struct CfgNode));
      b=p;
   }
}

Prototype ReadCfg(char *Name)
{
   FILE *f;
   char patt[20],file[40];
   FreeCfg();
   if(f=fopen(Name,"r"))
   {
      int e=1;
      while(e==1)
      {
         if(fgets(patt,20,f))
            if(fgets(file,40,f))
            {
               int l;
               l=strlen(patt);
               if(l==20) e=0;
                  else if(patt[l-1]=='\n') patt[l-1]=0;
               for(l-=2;l>=0;l--) patt[l]=tolower(patt[l]);
               l=strlen(file);
               if(l==40) e=0;
                  else if(file[l-1]=='\n') file[l-1]=0;
            }
            else e=2;
         else e=2;
         if(e==1)
         {
            struct CfgNode *p=b;
            if(!(b=(struct CfgNode *)AllocMem(sizeof(struct CfgNode),0)))
            {
               e=0;
               b=p;
               break;
            }
            b->Next=p;
            strcpy(b->patt,patt);
            strcpy(b->file,file);
         }
      }
      fclose(f);
   } else return(0);
   return(1);
}

Prototype char *SkipWhite(char *a)
{
   while(*a==' ' || *a=='\t') a++;
   return(a);
}

Prototype char *MyStrCpy(char *d,char *s)
{
   strcpy(d,s);
   return(d+strlen(d));
}

Prototype char *Evaluate(char *s,char *d)
{
                             /* \a -> a
                                %o -> original source path
                                %s -> source path
                                %d -> destination path
                                %e -> extended destination path
                                %f -> file name
                                %w -> file name without suffix
                                %i(a,b) -> input string a, prompt b
                                %a -> ReRead Active window
                                %n -> ReRead NonActive Window
                                %b -> backspace
                                %p -> %s-%o */
   char stop=0, *od;
   if(*s=='(')
   {
      stop=',';
      s++;
   }
   if(*s==',')
   {
      stop=')';
      s++;
   }
   while(*s && *s!=stop)
   {
      switch(*s)
      {
         case '%':s++;
                  switch(*s)
                  {
                     case 'b':d--;break;
                     case 'a':ReRead|=1<<Act;break;
                     case 'n':ReRead|=1<<(1-Act);break;
                     case 's':
                     case 'p':od=d;
                              if(*s=='s') d=MyStrCpy(d,spath);
                              else d=MyStrCpy(d, spath+strlen(wp[Act].Path));
                              if(isdigit(l[cl]->Size[SLEN-1]))
                              {
                                 while(*d!=':' && *d!='/' && d>=od) d--;
                                 d++;
                              }
                              break;
                     case 'd':d=MyStrCpy(d,wp[1-Act].Path);
                              break;
                     case 'o':d=MyStrCpy(d,wp[Act].Path);
                              break;
                     case 'e':d=MyStrCpy(d,dpath);
                              if(isdigit(l[cl]->Size[SLEN-1]))
                              {
                                 while(*d!=':' && *d!='/') d--;
                                 d++;
                              }
                              break;
                     case 'f':d=MyStrCpy(d,l[cl]->Name);
                              break;
                     case 'v':wait=1;break;
                     case 'w':{
                                 char t[40],*ptr;
                                 strcpy(t,l[cl]->Name);
                                 if(ptr=strchr(t,'.'))
                                    *ptr=0;
                                 d=MyStrCpy(d,t);
                              }
                              break;
                     case 'i':s++;
                              while(*s!='(') s++;
                              {
                                 char print[60],prompt[60];
                                 if(!(s=Evaluate(s,print))) return(0);
                                 if(!(s=Evaluate(s,prompt))) return(0);
                                 if(!(StringReq(prompt,print, SR_OTHER))) return(0);
                                 d=MyStrCpy(d,prompt);
                              }
                              break;
                     default: return 0;
                  }
                  break;
         case '\\':  s++;
                     if(*s==0 || *s==stop) break;
         default: *d=*s;
                  d++;
      }
      s++;
   }
   *d=0;
   return(s);
}

Prototype HexVal(char x)
{
   if(isdigit(x)) return(x-'0');
   if(x>='a' && x<='f') return(x-'a'+10);
   if(x>='A' && x<='F') return(x-'A'+10);
   return(-1);
}

Prototype int htoc(char *s,char *b)
{
   int len=0,stat=0,i;
   while((i=HexVal(*s))!=-1)
   {
      if(stat) b[len++]|=i;
      else b[len]=i << 4;
      stat=1-stat;
      s++;
   }
   return(len);
}


Prototype char *UseCfg1(char *name,char *npp,char *prot)
{
   static char a[300];
   char bb[50],*s,z,fb[FBL];
   struct FileHandle *f=0;
   struct CfgNode *p;
   int t,r,fl=0;
   for(p=b;p;p=p->Next)
   {
      s=SkipWhite(p->patt);
      {
         char *y,*x;
         if(!(x=strchr(s,'='))) continue;
         if(y=strchr(s,'!')) t=(y<x?1:0);
            else t=0;
      }
      z=*s;
      if(!(s=strchr(s,'='))) continue;
      s++;
      switch(z)
      {
         case 'n':
                  ToUpper(s);
                  strcpy(bb,s);
                  r=Match(name,bb);
                  break;
         case 's':
                  ToUpper(s);
                  sprintf(bb,"*%s",s);
                  r=Match(name,bb);
                  break;
         case 'p':
                  r=1;
                  for(;*s&&r;s++)
                  {
                     int i;
                     r=0;
                     for(i=0;i<8;i++)
                        if(*s==prot[i])
                        {
                           r=1;
                           break;
                        }
                  }
                  break;
         case 'o':
               {
                  char *n;
                  int x,len;
                     do
                     {
                        if(*s==',') s++;
                        if(!(n=strchr(s,','))) continue;
                        *n=0;
                        sscanf(s,"%x",&x);
                        *n=',';
                        s=n+1;
                        len=htoc(s,bb);
/*                        {
                           int i=0,j=len-1;
                           char pom;
                           while(i<j)
                           {
                              pom=bb[i];
                              bb[i]=bb[j];
                              bb[j]=pom;
                              i++;j--;
                           }
                        }*/
                        if(!f)
                           if(f=Open(npp,MODE_OLDFILE))
                           fl=Read(f,fb,FBL);
                        if(x+len>fl) continue;
                        r=!memcmp(fb+x,bb,len);
                     } while(s=strchr(s,','));
               }
      }
      if(t&&r) continue;
      if(t||r)
      {
         if(f) Close(f);
         if(Evaluate(p->file,a)) return(a);
         else return(0);
      }
   }
   if(f) Close(f);
   return(0);
}

Prototype UseCfg(char *name,char *npp,char *prot)
{
   char *xxx;
   xxx=UseCfg1(name,npp,prot);
   if(xxx)
   {
      Exec(xxx);
      return(1);
   }
   return(0);
}

Prototype void InfoC(int x,int y,char *npp)
{
   int stl=strlen(npp);
   SetAPen(rp,LIGHT);
   Move(rp,x,y);
#ifdef GERMAN
   Text(rp,"Wenn Sie Enter drcken, startet:",34);
#else
   Text(rp,"If you press enter,I will execute:",34);
#endif
   Move(rp,x,y+8);
   Text(rp,npp,stl>37?37:stl);
   if(37-stl>0) Text(rp,spaces,37-stl);
}

Prototype InfoCfg(int x,int y,char *name,char *npp,char *prot)
{
   char *xxx=UseCfg1(name,npp,prot);
   if(xxx)
   {
      InfoC(x,y,xxx);
      return(1);
   }
   return(0);
}
