#include <ntp.h>
#include <intuition/intuition.h>
#include <intuition/sghooks.h>
#include <libraries/dosextens.h>
#include <libraries/filehandler.h>
#include <stdio.h>

// #include <clib/dos_protos.h>

#ifndef White
#define White 2
#define Black 3
#define Pen 1
#define Back 0
#endif

extern struct FileHandle *Open();
extern struct FileLock *Lock();
extern struct IntuiText IText1;

#define FMAX 4096

UBYTE Pens1[4]={LIGHT,GRAY,WHITE,KMZ};

extern struct StringExtend Gadget3SExtend;

typedef struct FrontNode
{
   char buf[FMAX+1];
   struct FrontNode *next;
} front;

struct Front
{
   int p,r;
   struct FrontNode *FNode,*LNode;
};

static pi;
static front *zac=0,*last;

Prototype struct Front *OpenFront()
{
   struct Front *f;
   f=(struct Front *)AllocMem(sizeof(struct Front),0);
   if(f)
   {
      f->p=f->r=0;
      if(zac)
      {
         f->FNode=zac;
         f->LNode=last;
         f->p=pi;
      }
      else
         if(zac=f->LNode=f->FNode=(front *)AllocMem(sizeof(front),0))
         {
            last=zac;
            zac->next=0;
            pi=0;
         }
         else
         {
            FreeMem(f,sizeof(struct Front));
            return(0);
         }
   }
   return(f);
}

Prototype void CloseFront(struct Front *f)
{
   FreeMem(f,sizeof(struct Front));
}

Prototype void FreeFront()
{
   front *pom=zac;
   while(pom)
   {
      zac=pom->next;
      FreeMem(pom,sizeof(front));
      pom=zac;
   }
}

Prototype put(struct Front *f,char c)
{
   void ErrorLine();
   if(f->p == FMAX)
   {
      front *pom;
      if(!(pom=(front *)AllocMem(sizeof(front),0)))
     {
#ifdef GERMAN
         ErrorLine(memory);
#else
         ErrorLine("Out of memory");
#endif
         return(0);
      }
     f->p=0;
     f->LNode->next=pom;
      last=f->LNode=pom;
      pom->next=0;
     *pom->buf=c;
   }
   else
   {
      f->p++;
      *(f->LNode->buf+f->p)=c;
   }
   pi=f->p;
   return(1);
}

Prototype get(struct Front *f)
{
   if(f->FNode == f->LNode && f->r >= f->p) return(EOF);
   if(f->r == FMAX)
   {
      if(f->FNode)
      {
         f->FNode=f->FNode->next;
      f->r=0;
     }
      if(!f->FNode) return(EOF);
   }
   else f->r++;
   return((char)*(f->FNode->buf+f->r));
}

struct PrintInfo
{
   int lpp;
   char i1,i2,i3,i4;
};

static struct PrintInfo p=
{
   0,0,1,1,0
};

static UBYTE Gadget5SIBuff[4] =
   "72";

Prototype void DefaultPrintInfo()
{
   p.i1=p.i2=p.i3=p.i4=0;
   p.lpp=0;
   strcpy(Gadget5SIBuff,"72");
}

Prototype void ReadPrintInfo(struct FileHandle *f)
{
   Read(f,&p,8);
   Read(f,Gadget5SIBuff,4);
}

Prototype void WritePrintInfo(struct FileHandle *f)
{
   Write(f,(APTR)&p,8);
   Write(f,(APTR)Gadget5SIBuff,4);
}

#ifdef TEST
void CenterWindow(struct NewWindow *a)
{
   a->LeftEdge = 680 - a->Width >> 1;
   a->TopEdge  = 265 - a->Height >> 1;
}

void ErrorLine(char *Str)
{
   puts(Str);
}

void WRectangle(struct Window *w)
{
   SetAPen(w->RPort,White);
   Move(w->RPort,0,w->Height-1);
   Draw(w->RPort,0,0);
   Draw(w->RPort,w->Width-1,0);
   Move(w->RPort,1,w->Height-2);
   Draw(w->RPort,1,1);
   Draw(w->RPort,w->Width-2,1);
   SetAPen(w->RPort,Black);
   Move(w->RPort,1,w->Height-1);
   Draw(w->RPort,w->Width-1,w->Height-1);
   Draw(w->RPort,w->Width-1,1);
   Move(w->RPort,2,w->Height-2);
   Draw(w->RPort,w->Width-2,w->Height-2);
   Draw(w->RPort,w->Width-2,2);
}

void WTitle(struct Window *w,char *str)
{
   SetAPen(w->RPort,White);
   Move(w->RPort,2,12);
   Draw(w->RPort,2,2);
   Draw(w->RPort,w->Width-3,2);
   SetAPen(w->RPort,Black);
   Move(w->RPort,3,12);
   Draw(w->RPort,w->Width-3,12);
   Draw(w->RPort,w->Width-3,2);
   SetAPen(w->RPort,Pen);
   Move(w->RPort,5,10);
   Text(w->RPort,str,strlen(str));
}
#endif

static SHORT BorderVectors1[] = {
   130,0,
   130,14,
   0,14,
   0,0,
   130,0
};

static struct Border Border0 =
{
   -1,-1,
   WHITE,0,JAM1,
   3,
   BorderVectors1+4,
   NULL
};

static struct Border Border1 = {
   -1,-1,
   DGRAY,0,JAM1,
   3,
   BorderVectors1,
   &Border0
};

static struct Border Border4 =
{
   -1,-1,
   DGRAY,0,JAM1,
   3,
   BorderVectors1+4,
   NULL
};

static struct Border Border2= {
   -1,-1,
   WHITE,0,JAM1,
   3,
   BorderVectors1,
   &Border4
};

static struct IntuiText IText1x = {
   DARK,GRAY,JAM2,
   40,3,
   NULL,
#ifdef GERMAN
   "Abbruch",
#else
   "Cancel",
#endif
   NULL
};

static struct Gadget Gadget7 = {
   NULL,
   135,59,
   129,13,
   GADGHIMAGE,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border1,
   (APTR)&Border2,
   &IText1x,
   NULL,
   NULL,
   7,
   NULL
};

static struct IntuiText IText2 = {
   YELLOW,GRAY,JAM2,
   42,3,
   NULL,
#ifdef GERMAN
   "Druck ",
#else
   "Print ",
#endif
   NULL
};

static struct Gadget Gadget6 = {
   &Gadget7,
   3,59,
   129,13,
   GADGHIMAGE,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border1,
   (APTR)&Border2,
   &IText2,
   NULL,
   NULL,
   4,
   NULL
};


static struct StringInfo Gadget5SInfo = {
   Gadget5SIBuff,
   NULL,
   0,
   4,
   0,
   0,0,0,0,0,
   &Gadget3SExtend,
   0,
   NULL
};

static SHORT BorderVectors3[] = {
   0,0,
   130,0,
   130,9,
   0,9,
   0,0
};
static struct Border Border3 = {
   -1,-1,
   3,GRAY,JAM1,
   5,
   BorderVectors3,
   NULL
};

static struct IntuiText IText3 = {
   KMZ,GRAY,JAM2,
#ifdef GERMAN
   9,-12,
#else
   17,-12,
#endif
   NULL,
#ifdef GERMAN
   "Zeil. pro Seite",
#else
   "Lines per page",
#endif
   NULL
};

static struct Gadget Gadget5 = {
   &Gadget6,
   135,44,
   129,8,
   NULL,
   RELVERIFY+LONGINT,
   STRGADGET,
   (APTR)&Border3,
   NULL,
   &IText3,
   NULL,
   (APTR)&Gadget5SInfo,
   6,
   NULL
};
/*
__chip static USHORT ImageData1[] = {
   0x1F00,0x6080,0x83E0,0x81C0,0x8080,0x8000,0x6080,0x1F00
};

static struct Image Image1 = {
   2,3,
   11,8,
   1,
   ImageData1,
   0x0002,0x0001,
   NULL
};
*/
__chip static USHORT ImageData1[] = {
   0x80E0,0x3E60,0x3E60,0x3800,0x3C20,0x3E60,0x3FE0,0x3E60,
   0x80E0,0x80E0,0x3E60,0x3E60,0x3800,0x3C20,0x3E60,0x3FE0,
   0x3E60,0x80E0
};

static struct Image Image1 = {
   2,3,
   11,9,
   3,
   ImageData1,
   0x0005,0x0002,
   NULL
};



static struct IntuiText IText4 = {
   BLACK,GRAY,JAM2,
   20,3,
   NULL,
#ifdef GERMAN
   "Keine Kopfz.",
#else
   "No header",
#endif
   NULL
};

static struct Gadget Gadget4 = {
   &Gadget5,
   135,14, //52,21
   129,13,
   GADGHIMAGE,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border1,
   (APTR)&Border2,
   &IText4,
   NULL,
   NULL,
   5,
   NULL
};

static struct IntuiText IText5 = {
   BLACK,GRAY,JAM2,
   20,3,
   NULL,
#ifdef GERMAN
   "Pagin. ON ",
#else
   "Paging ON ",
#endif
   NULL
};

static struct Gadget Gadget3 = {
   &Gadget4,
   3,44,
   129,13,
   GADGHIMAGE,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border1,
   (APTR)&Border2,
   &IText5,
   NULL,
   NULL,
   3,
   NULL
};

static struct IntuiText IText6 = {
   BLACK,GRAY,JAM2,
   19,3,
   NULL,
#ifdef GERMAN
   "Send zu PAR:",
#else
   "Send to PAR:",
#endif
   NULL
};

static struct Gadget Gadget2 = {
   &Gadget3,
   3,29,
   129,13,
   GADGHIMAGE,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border1,
   (APTR)&Border2,
   &IText6,
   NULL,
   NULL,
   2,
   NULL
};

static struct IntuiText IText7 = {
   BLACK,GRAY,JAM2,
   20,3,
   NULL,
#ifdef GERMAN
   "Normal Druck",
#else
   "Normal print",
#endif
   NULL
};

static struct Gadget Gadget1 = {
   &Gadget2,
   3,14,
   129,13,
   GADGHIMAGE,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border1,
   (APTR)&Border2,
   &IText7,
   NULL,
   NULL,
   1,
   NULL
};

Prototype void OnOffChk(struct Window *w,struct RastPort *rp,int i3)
{
   if(!i3)
   {
      OffGadget(&Gadget4,w,0);
      OffGadget(&Gadget5,w,0);
   }
   else
   {
      int le=Gadget4.LeftEdge,te=Gadget4.TopEdge;
      OnGadget(&Gadget4,w,0);
      OnGadget(&Gadget5,w,0);
      SetAPen(rp,GRAY);
      RectFill(rp,le,te,le+Gadget4.Width-1,te+Gadget4.Height-1);
      DrawImage(rp,&Image1,le,te);
      PrintIText(rp,&IText4,le,te);
      le=Gadget5.LeftEdge,te=Gadget5.TopEdge;
      RectFill(rp,le,te,le+Gadget5.Width-1,te+Gadget5.Height-1);
      RefreshGList(&Gadget5,w,0,1);
   }
}

Prototype char PrintMenu()
{
   char g1[5][14] =
   {
#ifdef GERMAN
      "Normal Druck ",
#else
      "Normal print ",
#endif
#ifdef GERMAN
      "Effective Dr.",
#else
      "Effective pr.",
#endif
#ifdef GERMAN
      "Spezial Druck",
#else
      "Special print",
#endif
#ifdef GERMAN
      "HexDump Druck",
#else
      "HexDump print",
#endif
      "Hex-Effective"
   },
   g2[3][13] =
   {
#ifdef GERMAN
      "Send zu PAR:",
#else
      "Send to PAR:",
#endif
#ifdef GERMAN
      "Send zu SER:",
#else
      "Send to SER:",
#endif
#ifdef GERMAN
      "Send zu PRT:"
#else
      "Send to PRT:"
#endif
   },
   g3[3][13] =
   {
#ifdef GERMAN
      "Pagin. OFF  ",
#else
      "Paging OFF  ",
#endif
#ifdef GERMAN
      "Pagin. ON   ",
#else
      "Paging ON   ",
#endif
#ifdef GERMAN
      "Spez. Pagin."
#else
      "Spec. Paging"
#endif
   },
   g4[4][13] =
   {
#ifdef GERMAN
      "Keine Kopfz.",
#else
      "No header   ",
#endif
#ifdef GERMAN
      "Name des Dat",
#else
      "Name of file",
#endif
#ifdef GERMAN
      "Seite Numm. ",
#else
      "Page numbers",
#endif
#ifdef GERMAN
      "Name + Seite"
#else
      "Name + Page "
#endif
   };
   struct NewWindow NewWindowStructure1 =
   {
      188,56,
      267,74,
      0,1,
      GADGETUP,
      BORDERLESS+ACTIVATE+NOCAREREFRESH+RMBTRAP,
      &Gadget1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,5,
      -1,-1,
      CUSTOMSCREEN
   };
   struct Window *w,*OpenWindow();
   struct IntuiMessage *msg,*GetMsg();
   struct RastPort *rp;
   char go=1,i1,i2,i3,i4;
   int k34=0;
   NewWindowStructure1.Screen=NTPBase->Screen;

   if((!Kick(36)))
   {
      if(NTPPREFS.Flags&COLOR)
      {
         k34=1;
         SetRGB4(ViewPortAddress(NTPBase->w),0,5,5,5);
      }
   }
   else
   {
      Gadget3SExtend.Font=NTPBase->w->RPort->Font;
      Gadget3SExtend.Pens[0]=BLACK;
      Gadget3SExtend.Pens[1]=GRAY;
      Gadget3SExtend.ActivePens[0]=BLACK;
      Gadget3SExtend.ActivePens[1]=GRAY;
      Gadget5.Flags|=GFLG_STRINGEXTEND;
   }

   if(p.i1<5) i1=p.i1;
   if(p.i2<3) i2=p.i2;
   if(p.i3<3) i3=p.i3;
   if(p.i4<4) i4=p.i4;
   IText5.IText=g3[i3];
   IText7.IText=g1[i1];
   IText6.IText=g2[i2];
   IText4.IText=g4[i4];
   CenterWindow(&NewWindowStructure1);
   if(!(w=OpenWindow(&NewWindowStructure1)))
   {
      if(k34)
         SetRGB4(ViewPortAddress(NTPBase->w),0,0,0,0);
      return(0);
   }
   SetRast(rp=w->RPort,GRAY);
   RefreshGList(w->FirstGadget,w,0,-1);
   WRectangle(w);
#ifdef GERMAN
   WTitle(w,"Druck Menu");
#else
   WTitle(w,"Print menu");
#endif
   DrawImage(rp,&Image1,Gadget1.LeftEdge,Gadget1.TopEdge);
   DrawImage(rp,&Image1,Gadget2.LeftEdge,Gadget2.TopEdge);
   DrawImage(rp,&Image1,Gadget3.LeftEdge,Gadget3.TopEdge);
   DrawImage(rp,&Image1,Gadget4.LeftEdge,Gadget4.TopEdge);
   if(i3) OnOffChk(w,rp,i3);
   while(go==1)
   {
      Wait(1<<w->UserPort->mp_SigBit);
      while(msg=GetMsg(w->UserPort))
      {
         switch(((struct Gadget *)msg->IAddress)->GadgetID)
         {
            case 1 : if(i1==4) i1=0;
                     else i1++;
                     IText7.IText=g1[i1];
                     PrintIText(rp,&IText7,Gadget1.LeftEdge,Gadget1.TopEdge);
                     break;
            case 2 : if(i2==2) i2=0;
                     else i2++;
                     IText6.IText=g2[i2];
                     PrintIText(rp,&IText6,Gadget2.LeftEdge,Gadget2.TopEdge);
                     break;
            case 3 : if(i3==2) i3=0;
                     else i3++;
                     IText5.IText=g3[i3];
                     PrintIText(rp,&IText5,Gadget3.LeftEdge,Gadget3.TopEdge);
                     OnOffChk(w,rp,i3);
                     break;
            case 5 : if(i4==3) i4=0;
                     else i4++;
                     IText4.IText=g4[i4];
                     PrintIText(rp,&IText4,Gadget4.LeftEdge,Gadget4.TopEdge);
                     break;
            case 7 : go=0;break;
            case 4 : go=2;break;
         }
         ReplyMsg(msg);
      }
   }
   CloseWindow(w);
   if(go)
   {
      p.lpp=atoi(Gadget5SIBuff);
      p.i1=i1;
      p.i2=i2;
      p.i3=i3;
      p.i4=i4;
   }
   if(k34)
      SetRGB4(ViewPortAddress(NTPBase->w),0,0,0,0);
   return(go);
}

#define esc 27
#define pr 4

#ifdef TEST
   #define NLEN 20
   #define BLEN 4095
   char buf[BLEN];
   char spaces[]="                                                            \
                                                                              \
                                                                              \
                                                                              \
                                                                              \
                                                                              \
                                                                             ";
#endif


Local struct Filehandle *OpenPrinterDev1()
{
   struct FileHandle *f;
   switch(p.i2)
   {
      case 0 : f=Open("par:",MODE_NEWFILE);break;
      case 1 : f=Open("ser:",MODE_NEWFILE);break;
      case 2 : f=Open("prt:",MODE_NEWFILE);break;
   }
#ifdef GERMAN
   if(!f) ErrorLine("ffnen des Druckertreibers ist nicht mglich");
#else
   if(!f) ErrorLine("Can't open printer device");
#endif
   return(f);
}

Local struct FileHandle *OpenPrinterDev()
{
   struct FileHandle *f;
   struct FileLock *lock;
   char *ptr;
   if(!(lock=Lock(wp[Act].Path,ACCESS_READ))) return(0);
   ptr=(char *)BADDR(((struct DeviceList *)BADDR(((struct FileLock *)BADDR(\
                     lock))->fl_Volume))->dl_Name);
   CopyMem(ptr+1,buf,*ptr);
   buf[*ptr]=':';
   buf[*ptr+1]=0;
   UnLock(lock);
   if(f=OpenPrinterDev1())
   {
      if(!(lock=Lock(buf,ACCESS_READ))) return(0);
      UnLock(lock);
   }
   return(f);
}

Local void NewPage(struct FileHandle *out,char *sou,int page)
{
   char buff[10];
   int i;
   switch(p.i4)
   {
#ifdef GERMAN
      case 1 : Write(out,(APTR)" Datei:",7);
#else
      case 1 : Write(out,(APTR)"  File:",7);
#endif
               Write(out,(APTR)sou,strlen(sou));
               Write(out,(APTR)"\n\n",2);
               break;
      case 2 : {
                  short a=(p.i1==1||p.i1==4 ? 150 : 70);
                  sprintf(buff,"( %d )",page);
                  for(i=0;i<a;i++) Write(out,(APTR)" ",1);
                  Write(out,(APTR)buff,strlen(buff));
                  Write(out,(APTR)"\n\n",2);
                  break;
               }
      case 3 : {
                  short a;
                  a=strlen(sou);
#ifdef GERMAN
                  Write(out,(APTR)" Datei:",7);
#else
                  Write(out,(APTR)"  File:",7);
#endif
                  Write(out,(APTR)sou,a);
                  a=(p.i1==1||p.i1==4 ? 150 : 70)-7-a;
                  for(i=0;i<a;i++) Write(out,(APTR)" ",1);
                  sprintf(buff,"( %d )",page);
                  Write(out,(APTR)buff,strlen(buff));
               }
      case 0 : Write(out,(APTR)"\n\n",2);
               break;
   }
}

Local void EndPage(struct *out)
{
   strcpy(IText1.IText," O.K. ");
   Req("Insert new page");
#ifdef GERMAN
   strcpy(IText1.IText,"Abbruch");
#else
   strcpy(IText1.IText,"Cancel");
#endif
}

Local void FillToPage(struct FileHandle *out,int e)
{
   int por=p.lpp-6;
   if(p.i3==2)
   {
   //   char pom=12;
        EndPage(out);
   //   Write(out,&pom,1);
   }
   else if(e>0 && e<por)
   {
      while(e!=por)
      {
         Write(out,(APTR)"\n",1);
         e++;
      }
      Write(out,(APTR)"\n\n\n\n",4);
   }
}

Local PPrint(char *sou)
{
   struct FileHandle *in, *out;
   int on,m=BLEN,i,n=BLEN,pa=p.i3,e=0,k=1,page=1,por; // por=66;
   unsigned int a,b;
   on=p.i1;
   por=p.lpp-6;
   if(!(out=OpenPrinterDev())) return(0);
   in=Open(sou,MODE_OLDFILE);
   if(pa)
#ifdef TEST
      NewPage(out,sou,page);
#else
      NewPage(out,spath,page);
#endif
   Read(in,buf,pr);
   while(k)
   {
      m=Read(in,buf+pr,BLEN-pr);
      if(m != BLEN-pr) k=0;
      n=m=m+pr;
      for(i=0;(i < n-pr*k) && (on);i++)
      switch(buf[i])
      {
         case '\\':  if(buf[i+1] == '\\')
                     {
                     for(a=i;a < n-1;a++) buf[a]=buf[a+1];
                     n-=1;
                     break;
                     }
                    buf[i]=esc;
                     break;
         case '|':   a=atoi(buf+i+1);
                    if(a<256) buf[i]=(char)a;
                    b=1;if(a>9) b++;
                    if(a>99) b++;
                    if(buf[i+1] == '|') {b=1;}
                    if((a==0) && (buf[i+1]>'9' || buf[i+1]<'0')) i--;
                    for(a=i+1;a<n-b+1;a++) buf[a]=buf[a+b];
                    n-=b;
      }
      if(pa)
      {
         a=0;
         b=n-pr*k;
         for(i=0;i<b;i++)
            if(buf[i] == '\n')
            {
               e++;
            if(e==por)
               {
                  e=0;
                  page++;
              Write(out,(APTR)(buf+a),i-a+1);
              if(p.i3==1) Write(out,(APTR)"\n\n\n\n",4);
                  else
                  {
                     EndPage(out);
                  }
#ifdef TEST
                  NewPage(out,sou,page);
#else
                  NewPage(out,spath,page);
#endif
              a=i+1;
               }
         }
         Write(out,(APTR)(buf+a),i-a);
      }
      else Write(out,(APTR)buf,n-pr*k);
      for(i=0;i < pr;i++) buf[i]=buf[i+n-pr];
   }
   if(pa) FillToPage(out,e);
   Close(in);
   Close(out);
   return(1);
}

#define cpl 79

Local tabul(char *inn,int tab)
{
   char c;
   FILE *in;
   struct Front *out;
   int k=0,i,cnt=0,nl=0;
   if(in=fopen(inn,"r"))
   {
      if(out=OpenFront())
      {
         while((c=fgetc(in)) != -1)
         {
            if(cnt > cpl)
            {
               put(out,'\n');
               k=0;
               cnt=1;nl++;
            }
            if(c == '\t')
            {
               for(i=tab-k-1;i>0;i--)
               {
                  if(cnt>cpl)
                  {
                     put(out,'\n');
                     cnt=1;nl++;
                  }
                  put(out,' ');cnt++;
               }
               k=-1;c=' ';
            }
            else if(c == '\n')
            {
               k=-1;
               cnt=0;
               nl++;
            }
           k=(k+1)%(tab+1);cnt++;
           put(out,c);
         }
         CloseFront(out);
#ifdef GERMAN
     } else ErrorLine(memory);
#else
     } else ErrorLine("Not enough memory");
#endif
     fclose(in);
   } else
   {
#ifdef GERMAN
      sprintf(buf,"Datei %s nicht gefunden",inn);
#else
      sprintf(buf,"File %s not found",inn);
#endif
      ErrorLine(buf);
   }
   return(nl);
}

Local Phase2(char *inn,int cnt)
{
   struct FileHandle *o;
   struct Front *i1,*i2;
   int lin=0,pp=0,page=1,por=p.lpp-6;
   char c1,c;
   if(cnt==0) return(0);
   cnt=(cnt+1)/2;
   if(!(i2=OpenFront())) return(0);
   while(lin < cnt)
   {
      if(get(i2) == '\n') lin++;
   }
   if(!(i1=OpenFront()))
   {
      CloseFront(i2);
      return(0);
   }
   if(o=OpenPrinterDev())
   {
      if(p.i3)
#ifdef TEST
         NewPage(o,inn,page);
#else
         NewPage(o,spath,page);
#endif
      lin=0;
      while(lin < cnt)
      {
         if((c1=get(i1)) == '\n')
         {
            int i;
            for(i=pp;i<cpl;i++) Write(o,(APTR)" ",1);
            pp=0;
            lin++;
            Write(o,(APTR)"|",1);
            while((c=get(i2)) != EOF &&  c !='\n') Write(o,(APTR)(&c),1);
            Write(o,(APTR)"\n",1);
            if(p.i3)
               if((lin % por) == 0)
               {
                  page++;
                  if(p.i3==1) Write(o,(APTR)"\n\n\n\n",4);
                  else
                  {
                     EndPage(o);
                  }
#ifdef TEST
                  NewPage(o,inn,page);
#else
                  NewPage(o,spath,page);
#endif
               }
         }
         else
         {
            Write(o,(APTR)(&c1),1);pp++;
         }
      }
      if(p.i3==1)
      {
         while(lin % por) {Write(o,(APTR)"\n",1);lin++;}
         Write(o,(APTR)"\n\n\n\n",4);
      }
      else if(p.i3==2)
      {
         EndPage(o);
      }
      CloseFront(i1);
      CloseFront(i2);
      Close(o);
   } else return(0);
   return(1);
}

Local PatTab(char *sou)
{
   int ret;
   ret=Phase2(sou,tabul(sou,NTPPREFS.TabLen));
   FreeFront();
   return(ret);
}

Local void DumpLine(sadr,adr,len)
long len,sadr;
unsigned char *adr;
{
   char pom[4];
   int a;
   sprintf(buf,"%06lx: ",sadr);
   for(a=0;a<pi;a++)
   if(a < len)
   {
      sprintf(pom," %02x",*(adr+a));
      strcat(buf,pom);
   }
   else strcat(buf,"   ");
   strcat(buf,"     ");
   for(a=0;a<pi;a++)
   if(a<len)
      if((*(adr+a) & 0x7f) < 32)
         strcat(buf,".");
      else
      {
         sprintf(pom,"%c",*(adr+a));
         strcat(buf,pom);
      }
   else strcat(buf," ");
   strcat(buf,"\n");
}

Local HexPrint(char *sou)
{
   struct FileHandle *i, *out;
   int page=1,por=p.lpp-6,n,sadr=0,e=0,ret=1;
   char pom[32];
#ifdef GERMAN
   ErrorLine("Drucken");
#else
   ErrorLine("printing");
#endif
   if(i=Open(sou,MODE_OLDFILE))
   {
      if(out=OpenPrinterDev())
      {
         if(p.i3) NewPage(out,spath,page);
         do
         {
            n=Read(i,pom,pi);
            if(n)
            {
               e++;
               DumpLine(sadr,pom,n);
               sadr+=n;
               Write(out,(APTR)buf,strlen(buf));
               if(e==por)
                  if(p.i3)
                  {
                     e=0;page++;
                     if(p.i3==1) Write(out,(APTR)"\n\n\n\n",4);
                        else EndPage(out);
                     NewPage(out,spath,page);
                  }
            }
         } while(n==pi);
         if(p.i3) FillToPage(out,e);
         Close(out);
      } else ret=0;
      Close(i);
   }
   else
   {
      DosError(IoErr());
      ret=2;
   }
   return(ret);
}

Prototype void Print()
{
   if(PrintMenu())
   if(p.i1==1) ResDir(OTHER,PatTab);
   else if(p.i1==3)
   {
      pi=16;
      ResDir(OTHER,HexPrint);
   }
   else if(p.i1==4)
   {
      pi=32;
      ResDir(OTHER,HexPrint);
   }
   else ResDir(OTHER,PPrint);
}

#ifdef TEST
main(int ac,char **av)
{
   if(ac>1)
   {
      int i=1;
      if(PrintMenu())
         for(;i<ac;i++) Print(av[i]);
   }
   else
   {
      sprintf(buf,"%s (C) By Patrick Sucansky 1992",av[0]);
      puts(buf);
      sprintf(buf,"Usage : %s file1 ... fileN   (ADos wildcards are aslo supported)",av[0]);
      puts(buf);
   }
}
#endif
