/*
**  $filename :   Gad3 $
**  $Release 1        $
**
**
**
**  (C) Copyright 1992 Patrick Sucansky
** All Rights Reserved
**
*/

#include <ntp.h>
#include <intuition/intuition.h>
#include <intuition/sghooks.h>
#include <libraries/dosextens.h>
#include <libraries/filehandler.h>
#include <exec/memory.h>

extern View();
extern DumpEd(char *Name);
extern struct ExecBase *SysBase;
extern struct FileLock *CurrentDir(), *ParentDir();
extern ProcFile();
extern PlayOcta(),PlayMED();
extern Show(char *sou);
extern ExecFile(char *name);
extern SendFile(char *sou);
extern struct Gadget NWGadget10,NWGadget6,NWGadget14,NWGadget1,NWGadget7,NWGadget13;
extern struct Process *FindTask();
extern struct FileLock *Lock();
extern struct DosLibrary *DOSBase;
extern struct Window *OpenWindow();
extern struct NewScreen NewScreenStructure;
extern struct NewWindow NWNewWindowStructure1;
extern struct Menu NWMenu1;
extern ED(char *Name);
extern ED1(char *Name);
extern PlaySample1(char *Name);
extern Dump1(char *Name);

UBYTE Pens[4]={LIGHT,GRAY,WHITE,KMZ};

struct StringExtend Gadget3SExtend = {
   NULL,
   Pens,
   Pens+2,
   SGM_EXITHELP,NULL,NULL,NULL
};

struct StringInfo Gadget3SInfo = {
   NULL,
   NULL,
   0,
   60,
   0,
   0,0,0,0,0,
   &Gadget3SExtend,
   0,
   NULL
};

SHORT BorderVectors2[] = {
   0,16,
   0,0,
   99,0,
   99,16,
   0,16,
};

struct Border Border3 = {
   -1,-1,
   DGRAY,0,JAM1,
   3,
   BorderVectors2+4,
   NULL
};


struct Border Border2 = {
   -1,-1,
   WHITE,0,JAM1,
   3,
   BorderVectors2,
   &Border3
};

struct Border Border5 = {
   -1,-1,
   WHITE,0,JAM1,
   3,
   BorderVectors2+4,
   NULL
};


struct Border Border4 = {
   -1,-1,
   DGRAY,0,JAM1,
   3,
   BorderVectors2,
   &Border5
};

extern struct TextAttr TOPAZ60;

struct IntuiText IText1 = {
   BLACK,GRAY,JAM2,
   3,4,
   &TOPAZ60,
#ifdef GERMAN
   "  Abbruch",
#else
   "  Cancel",
#endif
   NULL
};

struct Gadget Gadget33 = {
   NULL,
   -100,-17,
   98,15,
   GADGHIMAGE|GRELRIGHT|GRELBOTTOM,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border2,
   (APTR)&Border4,
   &IText1,
   NULL,
   NULL,
   0,
   NULL
};

struct IntuiText IText2 = {
   DARK,GRAY,JAM2,
   6,3,
   &TOPAZ60,
   "   O.K.",
   NULL
};

struct Gadget Gadget32 = {
   &Gadget33,
   -200,-17,
   98,15,
   GADGHIMAGE|GRELRIGHT|GRELBOTTOM,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border2,
   (APTR)&Border4,
   &IText2,
   NULL,
   NULL,
   1,
   NULL
};

struct IntuiText OverIText = {
   YELLOW,GRAY,JAM2,
   30,3,
   &TOPAZ60,
   E("All") G("Alle"),
   NULL
};


struct Gadget OverGadget = {
	&Gadget32,
	3,-17,
	98,15,
	GADGHIMAGE|GRELBOTTOM,
	RELVERIFY,
	BOOLGADGET,
	(APTR)&Border2,
	(APTR)&Border4,
	&OverIText,
	NULL,
	NULL,
	2,
	NULL
};


struct Gadget Gadget31 = {
   &Gadget32,
   6,13,
   198,9,
   SELECTED,
   RELVERIFY+STRINGCENTER,
   STRGADGET,
   NULL,
   NULL,
   NULL,
   NULL,
   (APTR)&Gadget3SInfo,
   1,
   NULL
};

struct IntuiText IText2xu = {
   BLACK,GRAY,JAM1,
   -72,3,
   &TOPAZ60,
#ifdef GERMAN
   "_",
#else
   "_",
#endif
   NULL
};



struct IntuiText IText2x = {
   BLACK,GRAY,JAM2,
   -72,3,
   &TOPAZ60,
#ifdef GERMAN
   "Aus:",
#else
   "From:",
#endif
   &IText2xu
};

struct IntuiText IText1x = {
   BLACK,GRAY,JAM2,
   19,4,
   &TOPAZ60,
   NULL,
   &IText2x
};

struct Gadget Gadget2x = {
   &Gadget32,
   -100,14,
   98,15,
   GADGHIMAGE|GRELRIGHT,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border2,
   (APTR)&Border4,
   &IText1x,
   NULL,
   NULL,
   2,
   NULL
};


struct IntuiText IText4xu = {
   YELLOW,GRAY,JAM1,
   -71,4,
   &TOPAZ60,
   "_",
   NULL
};


struct IntuiText IText4x = {
   YELLOW,GRAY,JAM2,
   -71,4,
   &TOPAZ60,
#ifdef GERMAN
   "Zum:",
#else
   "To:",
#endif
   &IText4xu
};

struct IntuiText IText3x = {
   YELLOW,GRAY,JAM2,
   19,4,
   &TOPAZ60,
   "",
   &IText4x
};

struct Gadget Gadget1x = {
   &Gadget2x,
   -100,-34,
   98,15,
   GADGHIMAGE+GRELBOTTOM+GRELRIGHT,
   RELVERIFY,
   BOOLGADGET,
   (APTR)&Border2,
   (APTR)&Border4,
   &IText3x,
   NULL,
   NULL,
   3,
   NULL
};

struct NewWindow NW3 = {
   228,84,
   204,0,
   0,1,
   GADGETUP,
   ACTIVATE+RMBTRAP+BORDERLESS,
   NULL,
   NULL,
   NULL,
   NULL,
   NULL,
   5,5,
   -1,-1,
   CUSTOMSCREEN
};


Prototype NewReq(char *msg, char *yes, char *no)
{
   char *oldyes, *oldno;
   int x;
   oldyes=IText2.IText; IText2.IText=yes;
   oldno=IText1.IText; IText1.IText=no;
   x=Req(msg);
   IText2.IText=oldyes;
   IText1.IText=oldno;
   return(x);
}

Prototype OverReq1(char *t, char *adv)
{
   int a;
   struct Window *w;
   struct RastPort *rp;
   NW3.Screen=NTPBase->Screen;
   NW3.IDCMPFlags|=RAWKEY;
   CenterWindow(&NW3);
   if(w=OpenWindow(&NW3))
   {
      SetRast(rp=w->RPort,GRAY);
      SetBPen(rp,GRAY);
      SetAPen(rp,BLACK);
      a=strlen(adv);
      Move(rp,152-a*4,24);
      Text(rp, adv, a);
      RefreshGList(w->FirstGadget,w,0,-1);
      WRectangle(w);
      WTitle(w,t);
      {
         struct IntuiMessage *msg,*GetMsg();
         a=-1;
         while(a==-1)
         {
            Wait(1<<w->UserPort->mp_SigBit);
            while(msg=GetMsg(w->UserPort))
            {
               if(msg->Class==GADGETUP)
                  a=((struct Gadget *)msg->IAddress)->GadgetID;
               else
                  switch(msg->Code)
                  {
                     case 0x20:a=2; break;
                     case 0x44:
                     case 0x13:
                     case 0x43:
                     case 0x27:a=1;break;
                     case 0x45:
                     case 0x21:a=0;
                  }
               ReplyMsg(msg);
            }
         }
      }
      CloseWindow(w);
      NW3.IDCMPFlags&=~RAWKEY;
      FlushIDCMP();
   } else return(0);
   return(a);
}

Prototype MyCompareDates(struct DateStamp *date1, struct DateStamp *date2)
{
   if(date1->ds_Days==date2->ds_Days)
      if(date1->ds_Minute==date2->ds_Minute)
         return(date1->ds_Tick - date2->ds_Tick);
      else return(date1->ds_Minute - date2->ds_Minute);
   else return(date1->ds_Days - date2->ds_Days);
}

Prototype OverReq(char *file, int ns, struct DateStamp *nd, int os, struct DateStamp *od)
{
   char *oldyes, *oldno;
   int x;
   char *help=buf+512;

   oldyes=IText2.IText; IText2.IText=E("  Replace");
   oldno=IText1.IText; IText1.IText= E("  Skip it");
   NW3.Width=304; // 312, 57
   NW3.Height=50;
   NW3.FirstGadget=&OverGadget;
   if(ns==os)
   {
      x=MyCompareDates(od, nd);
      if(x==0) strcpy(help, E("Both files seems to be the same."));
      else if(x<0) strcpy(help, E("I should replace it, it's newer."));
      else strcpy(help, E("I shouldn't replace it, it's older."));
   }
   else if(ns>os) strcpy(help, E("I should replace it, it's bigger."));
   else strcpy(help, E("I shouldn't replace it, it's smaller."));

   sprintf(buf,E("File %s exists.") G(hhhhh), file);
   x=OverReq1(buf, help);
   NW3.Width=204;
   IText2.IText=oldyes;
   IText1.IText=oldno;
   return(x);
}   

Prototype TDiskReq1(int *n,char *t)
{
   int a=0;
   char go=1,*t2x,*t3x,d[]="Disk",st[]="  Start";
   struct Window *w;
   NW3.IDCMPFlags|=RAWKEY;
   NW3.Height=49;
   NW3.FirstGadget=&Gadget2x;
   NW3.Screen=NTPBase->Screen;
   CenterWindow(&NW3);
   IText1x.IText=drives[*n];
   t2x=IText2x.IText;
   IText2x.IText=d;
   t3x=Gadget32.GadgetText->IText;
   Gadget32.GadgetText->IText=st;
   if(w=OpenWindow(&NW3))
   {
      SetRast(w->RPort,GRAY);
      RefreshGList(w->FirstGadget,w,0,-1);
      WRectangle(w);
      WTitle(w,t);
      while(go)
      {
         struct IntuiMessage *msg,*GetMsg();
         Wait(1<<w->UserPort->mp_SigBit);
         while(msg=GetMsg(w->UserPort))
         {
            if(msg->Class==GADGETUP)
            {   
               a = ((struct Gadget *)msg->IAddress)->GadgetID;
               switch(a)
               {
                  case 0:
                  case 1:go=0;break;
                  case 2:
__drive:             if(*n==3) *n=0;
                     else (*n)++;
                     IText1x.IText=drives[*n];
                     RefreshGList(&Gadget2x,w,0,1);
                     break;
               }
               ReplyMsg(msg);
            }
            else switch(msg->Code)
            {
               case 0x33:
               case 0x45: a=0; go=0; break;
               case 0x21:
               case 0x43:
               case 0x44: a=1; go=0; break;
               case 0x22: goto __drive;
            }
         }
      }
      CloseWindow(w);
      Gadget32.GadgetText->IText=t3x;
      IText2x.IText=t2x;
   } else a=0;
   NW3.IDCMPFlags&=~RAWKEY;
   return(a);
}

Prototype char *BtoCStr(char *x)
{
   static char a[32];
   x=BADDR(x);
   CopyMem(x+1,a,*x);
   a[*x]=0;
   return(a);
}

extern struct DeviceNode *NextDevice();

Prototype struct DeviceNode *DDiskReq1(char *t)
{
   static last;
   int a;char *str;
   char go=1,*t2x,*t3x,d[]="Disk",st[]="  Start";
   struct DeviceNode *nod, *tnod;
   struct Window *w;
   
   D(printf("%d\n",last));
   nod=tnod=NextDevice(0);
   if(last)
   {
      a=last;
      while(a--) nod=NextDevice(nod);
   }
   a=0;
   
   str=BtoCStr((char *)nod->dn_Name);
   NW3.Height=49;
   NW3.FirstGadget=&Gadget2x;
   NW3.Screen=NTPBase->Screen;
   NW3.IDCMPFlags|=RAWKEY;
   CenterWindow(&NW3);
   IText1x.IText=str;
   t2x=IText2x.IText;
   IText2x.IText=d;
   t3x=Gadget32.GadgetText->IText;
   Gadget32.GadgetText->IText=st;
   if(w=OpenWindow(&NW3))
   {
      SetRast(w->RPort,GRAY);
      RefreshGList(w->FirstGadget,w,0,-1);
      WRectangle(w);
      WTitle(w,t);
      while(go)
      {
         struct IntuiMessage *msg,*GetMsg();
         Wait(1<<w->UserPort->mp_SigBit);
         while(msg=GetMsg(w->UserPort))
         {
            if(msg->Class==GADGETUP)
            {
               a = ((struct Gadget *)msg->IAddress)->GadgetID;
               switch(a)
               {
                  case 0:
                  case 1:go=0;break;
                  case 2:
__ddrdisk:        {
                     char *xxx,str1[8]="       ";
                     if(tnod==(nod=NextDevice(nod))) last=0;
                     else last++;
                     xxx=BtoCStr((char *)nod->dn_Name);
                     IText1x.IText=str1;
                     RefreshGList(&Gadget2x,w,0,1);
                     IText1x.IText=(UBYTE *)xxx;
                     RefreshGList(w->FirstGadget,w,0,-1);
                     break;
                  }
               }
            } else if(msg->Class==RAWKEY)
               switch(msg->Code)
               {
                  case 0x45:
                  case 0x33:
                     a=go=0; break;
                  case 0x44:
                  case 0x43:
                  case 0x21:
                     a=1; go=0; break;
                  case 0x22:
                     goto __ddrdisk;
               }
            ReplyMsg(msg);
         }
      }
      CloseWindow(w);
      Gadget32.GadgetText->IText=t3x;
      IText2x.IText=t2x;
   } else a=0;
   NW3.IDCMPFlags&=~RAWKEY;
   if(a) return(nod);
   return 0;
}


Prototype TDiskReq2(int *n1,int *n2,char *t)
{
   int a=0;
   char go=1,*t3x,st[]="  Start";
   struct Window *w;
   NW3.Height=66;
   NW3.FirstGadget=&Gadget1x;
   NW3.IDCMPFlags|=RAWKEY;
   NW3.Screen=NTPBase->Screen;
   CenterWindow(&NW3);
   IText1x.IText=drives[*n1];
   IText3x.IText=drives[*n2];
   t3x=Gadget32.GadgetText->IText;
   Gadget32.GadgetText->IText=st;
   if(w=OpenWindow(&NW3))
   {
      SetRast(w->RPort,GRAY);
      RefreshGList(w->FirstGadget,w,0,-1);
      WRectangle(w);
      WTitle(w,t);
      while(go)
      {
         struct IntuiMessage *msg,*GetMsg();
         Wait(1<<w->UserPort->mp_SigBit);
         while(msg=GetMsg(w->UserPort))
         {
            if(msg->Class==GADGETUP)
            {
               a = ((struct Gadget *)msg->IAddress)->GadgetID;
               switch(a)
               {
                  case 0:
                  case 1:go=0;break;
                  case 2:
__td2from:           if(*n1==3) *n1=0;
                     else (*n1)++;
                     IText1x.IText=drives[*n1];
                     RefreshGList(&Gadget2x,w,0,1);
                     break;
                  case 3:
__td2to:             if(*n2==3) *n2=0;
                     else (*n2)++;
                     IText3x.IText=drives[*n2];
                     RefreshGList(&Gadget1x,w,0,1);
                     break;
               }
            } else if(msg->Class==RAWKEY)
               switch(msg->Code)
               {
                  case 0x45:
                  case 0x33:
                     a=0; go=0; break;
                  case 0x44:
                  case 0x43:
                  case 0x21:
                     a=1; go=0; break;
#ifdef GERMAN                  
                  case 0x20:
#else
                  case 0x23:
#endif            
                     goto __td2from;                 
#ifdef GERMAN
                  case 0x15:
#else
                  case 0x14:
#endif
                     goto __td2to;
               }
            ReplyMsg(msg);
         }
      }
      CloseWindow(w);
      Gadget32.GadgetText->IText=t3x;
   } else a=0;
   NW3.IDCMPFlags&=~RAWKEY;
   return(a);
}


Prototype void ActLine()
{
   void TCurs(),PrintLine();
   int i,d,x=0;
   for(i=0;line[i]!='>';i++);
   d=strlen(wp[Act].Path)-i;
   if(d+i>40)
   {
      d=-i;
      x=1;
   }
   if(d+strlen(line)<mal)
   {
      strcpy(buf,line+i);
      if(x) *line=0;
      else strcpy(line,wp[Act].Path);
      strcat(line,buf);
      cx+=d;
      if(!ty)
      {
         ty=NWNewWindowStructure1.Height-18;
         cx=strlen(line);
      }
      if(line[cx]=='>') cx++;
      PrintLine();
      TCurs();
      ErrorLine(wp[Act].Path);
   }
}


Prototype void TCurs()
{
   SetDrMd(rp,3);
   SetAPen(rp,LIGHT);
   RectFill(rp,xx+(cx<<3),ty,xx+7+(cx<<3),ty+7);
   SetDrMd(rp,1);
}

Prototype void PrintLine()
{
   short l=strlen(line);
   Move(rp,xx,ty+6);
   SetAPen(rp,GRAY);
   SetBPen(rp,BLACK);
   SetDrMd(rp,1);
   Text(rp,line,l);
   if(l<mal) Text(rp,spaces,mal-l);
   SetBPen(rp,DARK);
}


Prototype void AltTab()
{
   int ind=pw[Act].First+pw[Act].CurAct;
   if(wp[Act].Type==DIR && ind>=pw[Act].s && !isdigit(pw[Act].l[ind]->Size[SLEN-1]))
   {
      PCurs();
      Act=1-Act;
      wp[Act].Type=DIR;
      sprintf(wp[Act].Path,"%s%s/",wp[1-Act].Path,pw[1-Act].l[ind]->Name);
      Process(Act);
      PCurs();
   }
}

Prototype void KeyEnter()
{
   char *ptr, len;
   struct FileLock *ol,*l;
   char nline[81];

   if(l=Lock(wp[Act].Path,ACCESS_READ))
   {
      ol=CurrentDir(l);   
      
      strcpy(nline,line);
   
      for(ptr=line; *ptr!='>'; ptr++);
      ptr++;
      {
         int i;
         char *t=his[HISL-1];
         for(i=HISL-1;i>0;)
            his[i]=his[--i];
         his[0]=t;
         his[0][0]=0;
      }
      ah=0;
      strcpy(his[1],ptr);
      if(ht<HISL-1) ht++;
         *ptr=0;
      
      PrintLine();
      cx=ptr-line;
      TCurs();
       
      for(ptr=nline;*ptr!='>';ptr++);
      ptr++;
      len=strlen(ptr);
       
      if(!strnicmp("cd ",ptr,3) && len>3)
      {
         char pom[256];
         
         len-=3;
         strcpy(pom, wp[Act].Path);
         if(strcmp(ptr+3,".."))
         {
            CopyMem(ptr+3, wp[Act].Path, len+1);
            if(wp[Act].Path[len-1]!=':' && wp[Act].Path[len-1]!='/')
            {
               wp[Act].Path[len]='/';
               wp[Act].Path[len+1]=0;
            }
         }
         else
         {
            struct FileLock *ol, *pl;
            pl=ParentDir(l);
            if(pl==NULL) goto __exitKeyEnter;
            ol=CurrentDir(pl);
            FullPath(wp[Act].Path);
            UnLock(CurrentDir(ol));
         }
         if(!(GetSort(Act)))
            strcpy(wp[Act].Path, pom);
         else
         {
            struct FileLock *l, *ol;
            l=Lock(wp[Act].Path,ACCESS_READ);
            ol=CurrentDir(l);
            FullPath(wp[Act].Path);
            UnLock(CurrentDir(ol));
            PrintDir();
            PCurs();
         }
      } else if(len>0)
         Exec(ptr);
__exitKeyEnter:
      if(ol)
      {
         CurrentDir(ol);
         UnLock(l);
      }
   }
}

Prototype void ExtCopyPath()
{
   cl=pw[Act].First+pw[Act].CurAct;
   l[cl]=pw[Act].l[cl];
   sprintf(spath,"%s%s",wp[Act].Path,l[cl]->Name);
   sprintf(dpath,"%s%s",wp[1-Act].Path,l[cl]->Name);
}

Prototype struct IntuiMessage *GetMsgSafe(struct MsgPort *p)
{
   if(p) return((void *)GetMsg(p));
   return(0);
}


Prototype void RepairCursor()
{
   int ind=pw[Act].First+pw[Act].CurAct;
   if(ind<NTPBase->Lines)
   {
      pw[Act].First=0;
      pw[Act].CurAct=ind;
   }
   else
   {
      pw[Act].CurAct=NTPBase->Lines-1;
      pw[Act].First=ind-NTPBase->Lines+1;
   }
   pw[1-Act].CurAct=pw[1-Act].First=0;
}

Prototype InitIconBase()
{
   if(!IconBase)
      IconBase=(void *)OpenLibrary("icon.library",0);
}

Prototype IOBox()
{
   unsigned int sec=0;
   int xxxx=0;
   char li,a,go=1,ab[20],alt=0,sf=1,linl=0;
   static last=MOUSE;
   struct MsgPort *usp1=NTPBase->w->UserPort;
   struct IntuiMessage *msg,*GetMsg();
   ULONG Class,Seconds,Micros;
   UWORD Code,Qualifier;
   WORD MouseX,MouseY;
   APTR  IAddress;
#ifdef DEMO
   ModifyIDCMP(NTPBase->w,MOUSEBUTTONS+GADGETUP+RAWKEY+MENUPICK+MENUVERIFY+INTUITICKS);
   NWNewWindowStructure1.IDCMPFlags=MOUSEBUTTONS+GADGETUP+RAWKEY+MENUPICK+MENUVERIFY+INTUITICKS;
#endif
   if(((struct Library *)SysBase)->lib_Version>=36) Gadget31.Flags|=GFLG_STRINGEXTEND;
   ty=NWNewWindowStructure1.Height-18;
   for(a=0;a<HISL;a++)
   {
      if(!his[a])
      {
         his[a]=(char *)malloc(80);
         strcpy(his[a],"");
      }
   }
   ActLine();
   PrintLine();
   TCurs();
//   if(HelpPossible) Help(45214);
   while(go)
   {
      Wait(1<<usp1->mp_SigBit);
      while(msg=GetMsgSafe(usp1))
      {
    Class=msg->Class;Code=msg->Code;Seconds=msg->Seconds;
    Micros=msg->Micros;Qualifier=msg->Qualifier;
    MouseX=msg->MouseX;MouseY=msg->MouseY;
    IAddress=msg->IAddress;
    ReplyMsg(msg);
    switch(Class)
    {
#ifdef DEMO20
       case INTUITICKS : if(xxxx==DEMO20)
            {
#ifdef GERMAN
               ErrorLine("!! Danke, das ist eine Demodiskette !!");
#else
               ErrorLine("!! Thank you, this is only a DEMO. !!");
#endif
               Delay(500);
               go=0;
            }
            xxxx++;
            break;
#endif
       case MOUSEMOVE:
         if(NTPBase->w->MouseY>0)
               NTPBase->w->Flags|=RMBTRAP;
         else
               NTPBase->w->Flags&=~RMBTRAP;
         break;
       case MOUSEBUTTONS :
         {
            last=MOUSE;
            if( (Code == 104 && MouseY>NWNewWindowStructure1.Height-11) ||\
                (Code == 232 && linl==-1) )
            {
               switch(linl=PushInLine(MouseX,Code))
               {
                  case 0:Menu2(0); break;
                  case 1:Menu2(1); break;
                  case 2:Menu1(1); break;
                  case 3:Menu1(3); break;
                  case 4:Menu1(5); break;
                  case 5:Menu1(6); break;
                  case 6:Menu2(2); break;
                  case 7:Menu1(7); break;
                  case 8:Menu1(8); break;
                  case 9:goto __SQuit; break;
                  case 10:goto __LPath;
                  case 11:goto __RPath;
                  case 12:Menu1(2); break;
                  case 13:Menu1(4); break;
                  case 15:goto __Search;
                  case 16:goto __Find;
                  case 18:goto __Lace;
                  case 19:goto __SQuit;
               }
               break;
            }
            if( Code == 104 && MouseY > 5 &&
                (li=MouseY-5 >> 3) < NTPBase->Lines )
            {
               int go=1;
               a=Side(MouseX);
               if(li != pw[Act].CurAct || a!=Act)
               {
                  if(a!=Act && sec+1>=Seconds) AltTab();
                  else
                  {
                     if(nc)
                     {
                        PCurs();
                        nc=0;
                     }
                     MCurs(a,li);
                  }
               }
               else
                  if(sec+1>=Seconds)
                     if(wp[Act].Type==DIR && \
                     isdigit(pw[Act].l[pw[Act].First+pw[Act].CurAct]->Size[SLEN-1]))
                     {
                        ExtCopyPath();
                        ProcFile();
                        ReReadCheck();
                        Ref();
                     }
                     else Enter();
               if(!(*cia&0x40))

                  while(go)
                  {
                     msg=GetMsg(usp1);
                     if(msg && msg->Class==MOUSEBUTTONS && msg->Code==232) go=0;
                     if(msg) ReplyMsg(msg);
                     a=Side(NTPBase->w->MouseX);
                     li=NTPBase->w->MouseY - 5 >> 3;
                     if(li!=pw[Act].CurAct || a!=Act)
                     if(li >= NTPBase->Lines) GoDown(a);
                        else if(li<0) GoUp(a);
                     else MCurs(a,li);
                  }
               sec=Seconds;
            } else if(Code==105)
            {
               last=MOUSE;
               if(!(*rmb & 4) && (li=MouseY-5>>3) > -1
                  && li<NTPBase->Lines)
               {
                  char set;
                  a=Side(MouseX);
                  if(a!=Act) MCurs(1-Act,pw[1-Act].CurAct); // added
                  set=pw[a].l[li+pw[a].First]->Set;
                  Set(a,li);

                  {
                     char oli,oa,go=1;
                     oli=li;oa=a;
                     while(go)  //!(*rmb&4)
                     {
                        WaitPort(usp1);
                        msg=GetMsg(usp1);
                        if(msg && msg->Class==MOUSEBUTTONS && msg->Code==233) go=0;
                        if(msg) ReplyMsg(msg);
                        li=NTPBase->w->MouseY-5>>3;
                        if(li<NTPBase->Lines && li>=0)
                        {
                           a=Side(NTPBase->w->MouseX);
                           if(oli != li || oa != a)
                           {
                              if(pw[a].l[li+pw[a].First]->Set==set)
                              Set(a,li);
                              oli=li;
                              oa=a;
                           }
                        }
                     }
                  }
               }
            }
            break;
         }
       case GADGETUP   :
       case GADGETDOWN :
           {
         struct Gadget *g=((struct Gadget *)IAddress);
         int i=g->GadgetID;
         last=MOUSE;ErrorLine(0);
         if( (MouseX-g->LeftEdge < 6) &&
             (MouseY-(NTPBase->w->Height+g->TopEdge)<3))
         {
            if(g->GadgetID<17)
            {
               if(g->GadgetID != 15)
               {
             if(g->GadgetText->FrontPen==NOW)
                g->GadgetText->FrontPen=WARN;
             else g->GadgetText->FrontPen=NOW;
             RefreshGList(g,NTPBase->w,0,1);
               }
            }
            else
            {
               ((char *)g->UserData)++;
               if(g->UserData==(APTR)NUMD)
               {
                  g->UserData=0;
               }
               g->GadgetText->IText=drives[NUMD];
               RefreshGList(g,NTPBase->w,0,1);
               g->GadgetText->IText=drives[(int)g->UserData];
               RefreshGList(g,NTPBase->w,0,1);
            }
         }
         else
         {
            if(g->GadgetID!=5 && g->GadgetID!=6 && g->GadgetID!=4 && g->GadgetID!=11)
               if(g->GadgetText->FrontPen==WARN)
#ifdef GERMAN
             if(!Req("Sind Sie sicher?")) break;
#else
             if(!Req("Are you sure?")) break;
#endif
            switch(i)
            {
               case 2:  Menu(wp[Act].Path);break;
               case 3:  if(pw[Act].cnt)
                   {
                 SetTest();
                 ResDir(OTHER,Dump1);
                 Ref();
                   }
                   break;
               case 4:  if(pw[Act].cnt)
                   {
                 SetTest();
                 men=1;
                 ResDir(OTHER,ED1);
                 RFree(Act);
                 Ref();
                   }
                   break;
               case 5:  if(pw[Act].cnt)
                   {
                 SetTest();
                 ac=0;
                 Copy();
                 Ref();
                   }
                   break;
               case 6:  if(pw[Act].cnt)
                   {
                 SetTest();
                 ac=0;
                 FMove();
                 Ref();
                   }
                   break;
               case 7:  if(wp[Act].Type==DIR)
                   {
                 MkDir();
                 Ref();
                   }
                   break;
               case 8:  if(pw[Act].cnt)
                   {
                 SetTest();
                 ac=0;
                 FDel();
                 Ref();
                   }
                   break;
               case 9:  if(pw[Act].cnt)
                   {
                 SetTest();
                 ac=0;
                 FRename();
                 Ref();
                   }
                   break;
               case 10: go=0;
                   break;
               case 11: if(pw[Act].cnt)
                   {
                 SetTest();
                 ResDir(OTHER,ProcFile);
                 Ref();
                   }
                   break;
               case 12: if(pw[Act].cnt && wp[Act].Type==DIR)
                   {
                 SetTest();
                 ac=0;
                 Protect();
                 Ref();
                   }
                   break;
               case 13: if(pw[Act].cnt)
                   {
                 SetTest();
                 ResDir(OTHER,Show);
                 Ref();
                 ActivateWindow(NTPBase->w);
                 break;
                   }
               case 14: if(pw[Act].cnt)
                   {
                 SetTest();
                 ResDir(OTHER,PlaySample1);
                 Ref();
                   }
                   break;
               case 15: if(wp[Act].Type==DIR && pw[Act].cnt)
                 pw[Act].First=0;
                 pw[Act].CurAct=pw[Act].s-1;
                 Parent();
                   break;
               case 16: if(pw[Act].cnt)
                   {
                 SetTest();
                 ac=0;
                 Print();
                 Ref();
                   }
                   break;
               case 17:
               case 18:
               case 19:
                   {
                 strcpy(wp[Act].Path,drives[(int)g->UserData]);
                 wp[Act].Type=DIR;
                 GetSort(Act);
                 PrintDir();
                 PCurs(Act);
                   }
                   break;
             }
         }
           }
           break;
       case MENUPICK     :
               {
                  UWORD mn=MENUNUM(Code);
                  last=MOUSE;ErrorLine(0);
                  if(mn != NOMENU && ITEMNUM(Code) != NOITEM)
                  {
                     if(mn==0 || mn==4)
                     Menu0(mn>>2,ITEMNUM(Code),SUBNUM(Code));
                     else if(mn==1)
                     Menu1(ITEMNUM(Code));
                     else if(mn==2)
                     {
                        int mi=ITEMNUM(Code);
                        go=Menu2(mi);
                        if(go) usp1=NTPBase->w->UserPort;
                        else usp1=NULL;
                     }
                     else if(mn==3)
                     {
                        int of=NTPPREFS.Flags&INGADGETS;
                        Menu3(ITEMNUM(Code));
                        switch(ITEMNUM(Code))
                        {
                           case 0:
                           case 1:
                              if(of!=(NTPPREFS.Flags&INGADGETS))
                              {
                                 CloseWind();
                                 if(NTPPREFS.Flags&INGADGETS)
                                    NWNewWindowStructure1.FirstGadget=0;
                                 else
                                    NWNewWindowStructure1.FirstGadget=&NWGadget1;
                                 CountLines();
                                 RepairCursor();
                                 OpenWind();
                                 usp1=NTPBase->w->UserPort;
                              }
                              break;

                           case 4:goto CtrlP;break;
                           case 5:goto CtrlG;break;
                           case 6:goto CtrlS;break;
                           case 7:
                           {
                              NTPPREFS.Flags^=OVWMSG;
                              RefPrefs();
                           }
                           break;
                           case 8:
                           {
                              NTPPREFS.Flags^=MBLANK;
                              RefPrefs();
                              break;
                           }
                           case 9:
                           {
                              NTPPREFS.Flags^=COLOR;
                              RefPrefs();
                              Palette();
                              break;
                           }
                           case 10:
                           {
                              NTPPREFS.Flags^=STRICTNC;
                              RefStrictNC();
                              RefPrefs();
                              break;
                           }
                           case 11:
                           {
                              int i;
                              sprintf(buf,"%d",NTPPREFS.NChan);

                              if(EvalReq(buf, G("Music Kannele:") E("Music channels:"), &i))
                              {
                                 if(i>0 && i<5)
                                 NTPPREFS.NChan=i;
                              }
                              break;
                           }
                           case 12:  /* WB like */
                           {
                              ULONG mode;
                              NTPPREFS.Flags^=WBLIKE;
                              if(NTPPREFS.Flags&WBLIKE)
                                 mode=GetVPModeID(&((struct Screen *)FindWorkBench())->ViewPort);
                              else mode=mode_id;
                              CloseWind();
                              CloseScreen(NTPBase->Screen);

                              DetectDimension(&mode);
                              CountLines();
                              RepairCursor();
                              ty=NWNewWindowStructure1.Height-18;
                              UnIconify(0);
                              usp1=NTPBase->w->UserPort;
                              RefPrefs();
                              break;
                           }
                           case 13:
                           {
                              if(NTPPREFS.Flags^=NOTIFYWB)
                                 InitIconBase();
                              RefPrefs();
                              break;
                           }
                        }
                     }
                  }
               }
            break;
       case MENUVERIFY   :

            break;
       case DISKINSERTED :
       case DISKREMOVED  :
         {
            int i;
            for(i=0;i<2;i++)
               if(wp[i].Type==ASSIGN)
             Menu0(i,0,4);
         }
            break;
       case RAWKEY       :
         if(!(NTPPREFS.Flags&MBLANK)) FreeSprite(0);
         if(Code==0x44 || Code==0x43)
            if(Qualifier&IEQUALIFIER_CONTROL)
               goto CtrlJ;
            else if(last==MOUSE)
            {
               if(NTPPREFS.Flags&STRICTNC)
               {
                  char *ptr;
                  for(ptr=line;*ptr!='>';ptr++);
                  if(++ptr<line+cx)
                  {
                     KeyEnter();
                     break;
                  }
               }
__ment:        if(wp[Act].Type!=INFO && wp[Act].Type!=QVIEW)
                  if(wp[Act].Type==DIR && \
                  isdigit(pw[Act].l[pw[Act].First+pw[Act].CurAct]->Size[SLEN-1]))
                  {
                     ExtCopyPath();
                     ProcFile();
                     ReReadCheck();
                     Ref();
                  }
                  else Enter();
            }
            else
            {
               char *ptr;
               for(ptr=line;*ptr!='>';ptr++);
               if(strlen(ptr)<2) goto __ment;
               KeyEnter();
               last=MOUSE;
            }
         else if(!(Code&0x80))
         {
            last=MOUSE;ErrorLine(0);
            switch(Code)
            {
               case 0x5e:SelectGroup();
               PCurs();
               RefreshDir(Act);
               PCurs();
               break;
               case 0x4a:UnSelectGroup();
               PCurs();
               RefreshDir(Act);
               PCurs();
               break;
               case 0x42: if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
             AltTab();
             else MCurs(1-Act,pw[1-Act].CurAct);break;
               case 0x0f:
Ins:              if(wp[Act].Type==DIR)
               {
                  int i;
                  i=pw[Act].First+pw[Act].CurAct;
                  if(i>=pw[Act].s)
                  {
                     pw[Act].l[i]->Set=
                  1-pw[Act].l[i]->Set;
                     if(pw[Act].l[i]->Set)
                     {
                   pw[Act].Sel++;
                   pw[Act].SetSize+=\
                     SizeVal(pw[Act].l[i]->Size);
                     }
                     else
                     {
                   pw[Act].Sel--;
                   pw[Act].SetSize-=
                     SizeVal(pw[Act].l[i]->Size);
                     }
                     PCurs();
                     PrintNode(pw[Act].l[i],pw[Act].CurAct);
                     RefreshSet(Act);
                     PCurs();
                  }
               }
               case 0x4d:
               case 0x1e:if(Qualifier&(IEQUALIFIER_LALT|IEQUALIFIER_RALT))
               if(ah>0)
                 {
                    char *ptr;
                    for(ptr=line;*ptr!='>';ptr++);
                    ptr++;
                    if(ptr-line+strlen(his[ah-1])<mal)
                    {
                  strcpy(ptr,his[--ah]);
                  PrintLine();
                  cx=ptr-line;
                  TCurs();
                  last=KEY;
                    }
                 } else;
               else if(Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT))
               {
                 PCurs();PgDn();PCurs();break;
               }
               else
               {
                 li=pw[Act].CurAct+1;
                 if(li >= NTPBase->Lines) GoDown(Act);
                    else if(li<0) GoUp(Act);
                   else MCurs(Act,li);
               }
               break;
               case 0x4c:
               case 0x3e:if(Qualifier&(IEQUALIFIER_LALT|IEQUALIFIER_RALT))
                 if(ah<ht)
                 {
CtrlE:               char *ptr;
                     for(ptr=line;*ptr!='>';ptr++);
                     ptr++;
                     if(ptr-line+strlen(his[ah+1])<mal)
                     {
                        strcpy(ptr,his[++ah]);
                        PrintLine();
                        cx=ptr-line;
                        TCurs();
                        last=KEY;
                     }
                 } else;
               else if(Qualifier&(IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT))
               {
                 PCurs();PgUp();PCurs();break;
               }
               else
               {
                  li=pw[Act].CurAct-1;
                  if(li >= NTPBase->Lines) GoDown(Act);
                     else if(li<0) GoUp(Act);
                   else MCurs(Act,li);
               }
               break;
               case 0x59:
__SQuit:       {
                  int i=1;
                  if(NWGadget6.GadgetText->FrontPen==WARN)
#ifdef GERMAN
                     i=Req("Sind Sie sicher?");
#else
                     i=Req("Are you sure to Exit?");
#endif
                  if(i)
                     if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
                     {
                        Menu3(2);
                        go=0;
                     }
                     else
                     {
#ifdef ENVIROMENT
                         SavePrefsEnv();
#endif
                         go=0;
                     }
                  break;
               }
               case 0x3d:PCurs();Home();PCurs();break;
               case 0x1d:PCurs();End();PCurs();break;
               case 0x3f:PCurs();PgUp();PCurs();break;
               case 0x1f:PCurs();PgDn();PCurs();break;
               case 0x50:
__LPath:       if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
                  {
                     Menu0(0,3,0);
                     InitInLine(0);
                     break;
                  }
                  if(Qualifier&IEQUALIFIER_CONTROL)
                  {
                     if(sf) ScreenToBack(NTPBase->Screen);
                     else ScreenToFront(NTPBase->Screen);
                     sf=1-sf;
                     break;
                  }
               case 0x5f:Help(0);break;
__RPath:       case 0x51:if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
               {
                  Menu0(1,3,0);
                  InitInLine(0);
               }
               else Menu(wp[Act].Path);
               break;
               case 0x52:if(pw[Act].cnt && wp[Act].Type==DIR)
               {
                  men=0;
                  SetTest();
                  if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
                  {
#ifdef PATRIK
                     ResDir(OTHER,DumpEd);
#else
                     ResDir(OTHER,Dump1);
#endif
                     InitInLine(0);
                  }
                  else ResDir(OTHER,View);
                  Ref();
               }
               break;
               case 0x53:
               if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
                  Menu1(4);
               else if(Qualifier&(IEQUALIFIER_RSHIFT|IEQUALIFIER_LSHIFT))
                  Menu2(12);
               else
                  Menu1(3);
                  /*  if(pw[Act].cnt)
               {
                  SetTest();
                  men=1;
                  ResDir(OTHER,ED1);
                  RFree(Act);
                  Ref();
               } */
               break;
               case 0x54:if(pw[Act].cnt && wp[Act].Type==DIR)
               {
                  SetTest();
                  ac=0;
                  Copy();
                  Ref();
               }
               break;
               case 0x55:if(pw[Act].cnt && wp[Act].Type==DIR)
               {
__Search:         SetTest();
                  ac=0;
                  if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
                  {
                     FSearch();
                     InitInLine(0);
                  }
                  else FMove();
                  Ref();
               }
               break;
__Find:        case 0x56:if(wp[Act].Type==DIR)
               {
                 if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
                 {
                    SetTest();
                    Find();
                                             InitInLine(0);
                 }
                 else MkDir();
                  Ref();
               }
               break;
               case 0x57:if(pw[Act].cnt && wp[Act].Type==DIR)
               {
                  SetTest();
                  ac=0;
                  if(NWGadget10.GadgetText->FrontPen==WARN)
#ifdef GERMAN
                    if(Req("Sicher zum Lschen?")) FDel();
#else
                    if(Req("Are you sure to Delete?")) FDel();
#endif
                    else;
                  else FDel();
                  Ref();
               }
               break;
               case 0x58:if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
__Lace:        {
                  if(Kick(36))
                  {
                     if(!AskForMode()) break;

                     NTPPREFS.Flags&=~WBLIKE;
                     RefPrefs();
                     CloseWind();
                     CloseScreen(NTPBase->Screen);
                  }
                  else
                  {                     
                     CloseWind();
                     CloseScreen(NTPBase->Screen);
                     NTPPREFS.Flags^=INTERLACE;
                     NewScreenStructure.ViewModes^=LACE;
                  }
                  DetectDimension(&mode_id);
                  CountLines();
                  RepairCursor();
                  ty=NWNewWindowStructure1.Height-18;
                  UnIconify(0);
                  usp1=NTPBase->w->UserPort;
               }
               else if(pw[Act].cnt && wp[Act].Type==DIR)
               {
                  SetTest();
                  ac=0;
                  FRename();
                  Ref();
               }
               InitInLine(1);
               alt=1;
               break;
               case 0x45:
                   break;
               case 0x64:
               case 0x65:alt=0;
               InitInLine(1);
               break;
               default:
             if(Qualifier&IEQUALIFIER_CONTROL)
             switch(Code)
                {
                  case 0x12:
                     goto CtrlE;
                   case 0x17:
                 goto Ins;
                   case 0x1b:
                 Menu1(17);
                 break;
                   case 0x3a:
                 Menu1(18);
                 break;
                   case 0x20:
                 Menu0(Act,0,4);
                 break;
                   case 0x0d:
                     if(wp[Act].Type==DIR && pw[Act].cnt)
                     {
                        PCurs();
                        pw[Act].First=0;
                        pw[Act].CurAct=0;
                        Parent();
                     }
                     break;
                   case 0x21:
CtrlS:                 if(NTPPREFS.Flags&REQON)
                 {
                    MsgOFF();
#ifdef GERMAN
                    ErrorLine("System Requestern sind OFF");
#else
                    ErrorLine("System requests are OFF");
#endif
                    NTPPREFS.Flags&=~REQON;
                 }
                 else
                 {
                    MsgON();
#ifdef GERMAN
                    ErrorLine("System Requestern sind ON");
#else
                    ErrorLine("System requests are ON");
#endif
                    NTPPREFS.Flags|=REQON;
                 }
                 RefPrefs();
                 break;
                   case 0x24:
CtrlG:           CloseWind();
                 if(!(NTPPREFS.Flags&INGADGETS))
                 {
                    NTPPREFS.Flags|=INGADGETS;
                    NWNewWindowStructure1.FirstGadget=0;
                 }
                 else
                 {
                    NTPPREFS.Flags&=~INGADGETS;
                    NWNewWindowStructure1.FirstGadget=&NWGadget1;
                 }
                 CountLines();
                 RepairCursor();
                 OpenWind();
           //         Rect(NTPBase->w,0,0,639,ty-2);
                 usp1=NTPBase->w->UserPort;
                 RefPrefs();
                 break;
                   case 0x18:
                 if(sf) ScreenToBack(NTPBase->Screen);
                    else ScreenToFront(NTPBase->Screen);
                 sf=1-sf;
                 break;
                 case 0x19:
CtrlP:                   {
                 char sAct=Act;
                 NTPBase->Prot=(NTPBase->Prot+1)%3;
                 PCurs();
                 for(Act=0;Act<2;Act++)
                    if(wp[Act].Type==DIR)
                    {
                  int cnt=pw[Act].cnt;
                  GetSort(Act);
                  if(cnt==pw[Act].cnt)
                     RefreshDir(Act);
                  else PrintDir();
                    }
                 Act=sAct;
                 RefPrefs();
                 PCurs();
                 break;
                   }
                   case 0x28:if(wp[Act].Type==DIR)
                   {
                      Act=1-Act;
                      CtrlL();
                      Act=1-Act;
                   }
                   break;
                   case 0x13:Process(Act);
                   RCurs(Act);
                   break;
                   case 0x26:
CtrlJ:               last=KEY;
                     if(wp[Act].Type==DIR||wp[Act].Type>INFO)
                     {
                        int ind=pw[Act].First+pw[Act].CurAct;
                        int lp;
                        lp=strlen(pw[Act].l[ind]->Name);
                        if(lp+strlen(line)<mal)
                        {
                           Insert(pw[Act].l[ind]->Name,lp);
                           cx+=lp;
                           PrintLine();
                           TCurs();
                        }
                     }
                     break;
                   case 0x27:
                 {
                    int i,lp,ll=strlen(line),f=0;
                    last=KEY;
                    for(i=0;i<pw[Act].cnt;i++)
                  if(pw[Act].l[i]->Set)
                  {
                     lp=strlen(pw[Act].l[i]->Name);
                     ll+=lp;
                     if(ll<mal)
                     {
                        if(f)
                        {
                      ll++;
                      if(ll<mal)
                      {
                         Insert(" ",1);
                         cx++;
                      }
                      else break;
                        }
                        Insert(pw[Act].l[i]->Name,lp);
                        cx+=lp;
                        f=1;
                     }
                  }
                    PrintLine();
                    TCurs();
                 }
                 break;
                   case 0x01:
                   {
                 strcpy(wp[Act].Path,drives[(int)NWGadget13.UserData]);
                 wp[Act].Type=DIR;
                 GetSort(Act);
                 PrintDir();
                 PCurs(Act);
                   }
                   break;
                   case 0x02:
                   {
                 strcpy(wp[Act].Path,drives[(int)NWGadget7.UserData]);
                 wp[Act].Type=DIR;
                 GetSort(Act);
                 PrintDir();
                 PCurs(Act);
                   }
                   break;
                   case 0x03:
                   {
                 strcpy(wp[Act].Path,drives[(int)NWGadget1.UserData]);
                 wp[Act].Type=DIR;
                 GetSort(Act);
                 PrintDir();
                 PCurs(Act);
                   }
                   break;
                }
             else if(Qualifier&(IEQUALIFIER_RALT|IEQUALIFIER_LALT))
             {
                char str[20];
                if(!(wp[Act].Type==DIR||wp[Act].Type>INFO))
                   break;
                Qualifier=0;
                if(KeyConvert(Code,Qualifier,IAddress,str)==1)
                {
                   int i;
                   ab[alt]=str[0];
                   alt++;
                   for(i=pw[Act].CurAct+pw[Act].First;i<pw[Act].cnt;i++)
                      if(!strnicmp(pw[Act].l[i]->Name,ab,alt))
                         break;
                   if(i==pw[Act].cnt)
                     for(i=0 ;i<pw[Act].cnt;i++)
                        if(!strnicmp(pw[Act].l[i]->Name,ab,alt))
                           break;
                   if(i<pw[Act].cnt)
                   {
                     PCurs();
                     AltFirstOcc(pw[Act].l[i]->Name);
                   }
                }
             }
             else if(Qualifier&IEQUALIFIER_RCOMMAND)
             {
                switch(Code)
                {
                   case 0x19:Menu1(9);break;
                   case 0x17:Menu1(10);break;
                   case 0x21:Menu1(11);break;
                //   case 0x37:Menu1(11);break;
                   case 0x36:Menu1(12);break;
                //   case 0x18:Menu1(12);break;
                   case 0x33:Menu2(5);break;
                   case 0x10:Menu2(7);break;
                   case 0x23:Menu2(8);break;
                   case 0x22:Menu2(9);break;
                   case 0x20:Menu2(10);break;
                   case 0x35:Menu2(13);break;
                   case 0x12:Menu2(14);break;
                   case 0x28:Menu3(0);break;
                   case 0x14:Menu3(1);break;
                   case 0x11:Menu3(2);break;
                   case 0x13:Menu1(15); break;
                   case 0x3a:Menu1(16); break;
                }
             }
             else
             {
                char str[20],i;
                TCurs();
                switch(Code)
                {
                   case 0x4e:
                 if(cx<strlen(line)) cx++;break;
                   case 0x4f:
                 if(line[cx-1]!='>') cx--;
                  else
                  {
                     int i;
                     for(i=0;line[i]!='>';i++);
                     if(i<cx-1) cx--;
                  }
                  break;
                   case 0x41:
                  if(line[cx-1]!='>')
                  {
                     cx--;
                     CopyMem(line+cx+1,line+cx,
                     strlen(line+cx));
                     PrintLine();
                  } else
                  {
                     int i;
                     for(i=0;line[i]!='>';i++);
                     if(i<cx-1)
                     {
                        cx--;
                        CopyMem(line+cx+1,line+cx,
                        strlen(line+cx));
                        PrintLine();
                     }
                  }
                 break;
                   case 0x3c:
                   case 0x46:
                 if(cx<strlen(line))
                 {
                    CopyMem(line+cx+1,line+cx,
                  strlen(line+cx));
                    PrintLine();
                 }
                 break;
                   default:
                 if(i=KeyConvert(Code,Qualifier,IAddress,str))
                 {
                    str[i]=0;
                    if(cx+i<mal)
                    {
                  Insert(str,i);
                  cx+=i;
                  PrintLine();
                    }
                 }
                }
                TCurs();
                last=KEY;
             }
            }
         } else if(Code==0xe4 || Code==0xe5)
             InitInLine(0);
         break;
   }
   if(!(Qualifier&(IEQUALIFIER_LALT|IEQUALIFIER_RALT)))
      if(LIn==1) InitInLine(0);

/* #ifndef DEMO
    NTPBase->w->Flags&=~RMBTRAP;
#endif*/
      }
   }
   if(MEDPlayerBase)
      CloseLibrary(MEDPlayerBase);
   if(OctaPlayerBase)
      CloseLibrary(OctaPlayerBase);
   if(WorkbenchBase)
      CloseLibrary(WorkbenchBase);
   if(IconBase)
      CloseLibrary(IconBase);
}

#ifdef TEST
main()
{
   char ahoj[32];
   strcpy(ahoj,"df0:source/");
   printf("%d\n",StringReq(ahoj,"Move files to:"));
   printf("%s\n",ahoj);
   printf("%d\n",Req("Are you sure?"));
}
#endif
