/*********************\
* midtofront_locale.h *
**********************/

#ifndef MIDTOFRONT_LOCALE_H
#define MIDTOFRONT_LOCALE_H

/***********\
* constants *
************/

// constants related to locale
#define CATCOMP_ARRAY

#define CATALOG_NAME     "midtofront.catalog"
#define CATALOG_VERSION  1

#define MSG_WINDOW_TITLE 0
#define MSG_ACTIVATE 1
#define MSG_PUSHBACK 2
#define MSG_OK 3
#define MSG_DESCR 4

#define MSG_WINDOW_TITLE_STR "MidToFront Prefs"
#define MSG_ACTIVATE_STR "_Activate frontmost window"
#define MSG_PUSHBACK_STR "_Push frontmost back"
#define MSG_OK_STR "_Ok"
#define MSG_DESCR_STR "Middle mouse button clicks to front"

/*********************\
* Types and variables *
* ********************/

struct CatCompArrayType { ULONG id; STRPTR Str; };

static const struct CatCompArrayType CatCompArray[] = {
  { MSG_WINDOW_TITLE, (STRPTR )MSG_WINDOW_TITLE_STR },
  { MSG_ACTIVATE, (STRPTR )MSG_ACTIVATE_STR },
  { MSG_PUSHBACK, (STRPTR )MSG_PUSHBACK_STR },
  { MSG_OK, (STRPTR )MSG_OK_STR },
  { MSG_DESCR, (STRPTR )MSG_DESCR_STR },
  { 0, NULL }
};

/******************\
* Global variables *
* *****************/

// Locale data
struct Catalog *catalog;

/************\
* prototypes *
*************/

CONST_STRPTR CatalogString(ULONG id);

#endif
