/*********************\
* midtofront_locale.h *
*******************************************************\
* This is a barebones locale setup;                    *
* be advised that initialization and deinitialization  *
* takes place in the functions of midtofront_gui.c.    *
*                                                      *
* I understand why the AROS standard is to use _(...), *
* but I prefer the name CatalogString.                 *
* De gustibus non disputandum, si placet.              *
*******************************************************/

/********************\
* necessary includes *
*********************/

#include <exec/types.h>

#include <libraries/locale.h>

#include <locale.h>

#include <proto/locale.h>

#include "midtofront_globals.h"
#include "midtofront_locale.h"

/***************\
* CatalogString *
**************************************\
* extract the string for message `id` *
* from the language catalog           *
**************************************/
CONST_STRPTR CatalogString(ULONG id) {

  D(bug("catalog %d id %d str %s\n", catalog, id, CatCompArray[id].Str));

  if (LocaleBase != NULL && catalog != NULL)
    return GetCatalogStr(catalog, id, CatCompArray[id].Str);
  else return CatCompArray[id].Str;

}
