/******************\
* midtofront_gui.c *
***********************************************\
* Takes care of all issues related to the GUI, *
* including intialization and deinitialization *
* of the locale.                               *
***********************************************/

/********************\
* necessary includes *
*********************/

#include <clib/alib_protos.h>

#include <libraries/mui.h>

#include <proto/icon.h>
#include <proto/intuition.h>
#include <proto/locale.h>
#include <proto/muimaster.h>

#include "midtofront_globals.h"
#include "midtofront_gui.h"
#include "midtofront_locale.h"

/******************\
* Global variables *
* *****************/

// MUI data
Object *app, *win, *ck_act, *ck_pbk, *but, *lb_act, *lb_pbk;

TEXT version[] = "$VER: " APPNAME " " VERSION " (" ADATE ") " COPYRIGHT "";

/*****************\
* modify_pushback *
************************************************\
* Get the value of pushback from the checkmark. *
************************************************/
void modify_pushback() {

  get(ck_pbk, MUIA_Selected, &pushback);
  D(bug("[midtofront] [midtofront] pbk: %d\n", pushback));

}

/*******************\
* modify_activation *
************************************************\
* Get the value of activate from the checkmark. *
************************************************/
void modify_activation() {

  get(ck_act, MUIA_Selected, &activate);
  D(bug("[midtofront] [midtofront] act: %d\n", activate));

}

/*******************\
* Locale_Initialize *
********************************************************\
* initialize the locale to the user's preferred setting *
********************************************************/
VOID Locale_Initialize(VOID) {

  D(bug("[midtofront] [midtofront] locale base: %d %s %d\n", LocaleBase, CATALOG_NAME, CATALOG_VERSION));

  if (LocaleBase != NULL) catalog = OpenCatalog(NULL, CATALOG_NAME, OC_Version, CATALOG_VERSION, TAG_DONE);
  else catalog = NULL;

  D(bug("[midtofront] [midtofront] catalog: %d\n", catalog));

}

/*********************\
* Locale_Deinitialize *
************************\
* shut down the catalog *
************************/
VOID Locale_Deinitialize(VOID) {
    if(LocaleBase != NULL && catalog != NULL) CloseCatalog(catalog);
}

/*******************\
* show_popup_window *
*********************
* does what it says *
********************/
void show_popup_window() {

  D(bug("[midtofront] [midtofront] appear "));
  set(win, MUIA_Window_Open, TRUE);

  // get signals
  if (XGET(win, MUIA_Window_Open)) {

    DoMethod(app, MUIM_Window_ToFront); // in case of CXCMD_NOTIFY
    DoMethod(app, MUIM_Application_NewInput, (IPTR )(&mui_sigs));

  }

}

/*******************\
* hide_popup_window *
*********************
* does what it says *
********************/
void hide_popup_window() {

  D(bug("[midtofront] [midtofront] disappear "));
  set(win, MUIA_Window_Open, FALSE);
  mui_sigs = 0;

}

/***************\
* handle_popkey *
******************************************\
* pop up or close the preferences window, *
* depending on its current state          *
******************************************/
void handle_popkey() {

  BOOL window_open = FALSE;

  get(win, MUIA_Window_Open, &window_open);
  D(bug("[midtofront] [midtofront] %d %d\n", window_open, !window_open));
  window_open = !window_open;
  set(win, MUIA_Window_Open, window_open);

  // get signals
  if (XGET(win, MUIA_Window_Open))
    DoMethod(app, MUIM_Application_NewInput, (IPTR )(&mui_sigs));

}

/********************\
* handle_mui_signals *
******************************************************\
* takes care of the input from the preferences window *
******************************************************/
void handle_mui_signals() {

  LONG method_id;

  D(bug("[midtofront] [midtofront] Received mui signal\n"));

  method_id = (LONG )DoMethod(app, MUIM_Application_NewInput, (IPTR )(&mui_sigs));

  switch (method_id) {

    case MUIV_Application_ReturnID_Quit:

      set(win, MUIA_Window_Open, FALSE);
      mui_sigs = 0;
      break;

    case PREFS_ACT:

      D(bug("[midtofront] [midtofront] activation\n"));
      modify_activation();
      break;

    case PREFS_PBK:

      D(bug("[midtofront] [midtofront] pushback\n"));
      modify_pushback();
      break;

    default: break; // do nothing

  }

}

/**************\
* popup_window *
***************************\
* sets up the popup window *
***************************/
int setup_popup_window(BOOL cx_popup) {

  mui_sigs = 0;

  Locale_Initialize();

  app = ApplicationObject,

    MUIA_Application_UseCommodities, FALSE,
    // up on my soapbox: I should not have to request the above attribute
    // Zune apps should not automatically be commodities;
    // this violates the entire principle of a commodity

    // some standard information

    MUIA_Application_Title, (IPTR )APPNAME,
    MUIA_Application_Version, (IPTR )version,
    MUIA_Application_Copyright, (IPTR )COPYRIGHT,
    MUIA_Application_Author, (IPTR )AUTHOR,
    MUIA_Application_Base, (IPTR )"MIDTOFRONT",
    MUIA_Application_DiskObject, (IPTR )disko,

    // the window!

  	SubWindow, win = WindowObject,

      // some standard information

  	  MUIA_Window_Title, CatalogString(MSG_WINDOW_TITLE),
  	  MUIA_Window_ID, MAKE_ID('M','T','F','W'),

  	  WindowContents, VGroup,

  	    // first group: checkboxes w/labels

  	    Child, HGroup,

          // checkboxes

          Child, VGroup,
            Child, ck_act = MUI_MakeObject(MUIO_Checkmark, CatalogString(MSG_ACTIVATE)),
            Child, ck_pbk = MUI_MakeObject(MUIO_Checkmark, CatalogString(MSG_PUSHBACK)),
          End, // VGroup

          // labels

          Child, VGroup,
            Child, lb_act = LLabel1(CatalogString(MSG_ACTIVATE)),
            Child, lb_pbk = LLabel1(CatalogString(MSG_PUSHBACK)),
          End, // VGroup

        End, // HGroup

        // second group: button to dismiss window

        Child, HGroup,
          Child, HVSpace,
          Child, but = SimpleButton(CatalogString(MSG_OK)),
          Child, HVSpace,
        End, // HGroup

  	  End, // VGroup

  	End, // WindowObject

  End; // ApplicationObject

  if (app != NULL) {

    // close button should close window

    DoMethod(win, MUIM_Notify, MUIA_Window_CloseRequest, TRUE,
        (IPTR)app, 2,
        MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit);

    // dismissal button should close window

    DoMethod(but, MUIM_Notify, MUIA_Pressed, FALSE,
        (IPTR)app, 2,
        MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit);

    // set up a tab chain for the GUI

    set(ck_act, MUIA_CycleChain, 1);
    set(ck_pbk, MUIA_CycleChain, 1);
    set(but, MUIA_CycleChain, 1);

    // initialize the checkmarks to the values of the corresponding variables

    set(ck_act, MUIA_Selected, activate);
    set(ck_pbk, MUIA_Selected, pushback);

    // enable the checkmarks to signal us when they are checked or unchecked

    DoMethod(ck_act, MUIM_Notify, MUIA_Selected, TRUE,
        app, 2, MUIM_Application_ReturnID, PREFS_ACT);
    DoMethod(ck_act, MUIM_Notify, MUIA_Selected, FALSE,
        app, 2, MUIM_Application_ReturnID, PREFS_ACT);
    DoMethod(ck_pbk, MUIM_Notify, MUIA_Selected, TRUE,
        app, 2, MUIM_Application_ReturnID, PREFS_PBK);
    DoMethod(ck_pbk, MUIM_Notify, MUIA_Selected, FALSE,
        app, 2, MUIM_Application_ReturnID, PREFS_PBK);

    // open window and get its signals
    
    if (cx_popup) show_popup_window();

    return 1;

  } // if app

  return 0;

}

/***********************\
* shutdown_popup_window *
*************************
* does what it says...  *
************************/
void shutdown_popup_window() {

  if (app != NULL) MUI_DisposeObject(app);
  Locale_Deinitialize();

}
