/**************************\
* midtofront_commodities.h *
***************************/

#ifndef MIDTOFRONT_COMMODITIES_H
#define MIDTOFRONT_COMMODITIES_H

/********************\
* necessary includes *
*********************/

#include <dos/dos.h>
#include <dos/rdargs.h>

#include <exec/ports.h>

#include <libraries/commodities.h>

#include <proto/commodities.h>
#include <proto/dos.h>
#include <proto/exec.h>

/***********\
* constants *
************/

// for CxSender's
#define BUTTONPRESS 3
#define POPKEYPRESS 4

// command line arguments
#define ARG_TEMPLATE "CX_POPKEY/K,CX_POPUP/K,CX_PRIORITY=PRI/N/K,ACTIVATE/K,PUSHBACK/K"
#define DEF_POPKEY "ctrl alt m"
enum {
    ARG_HOT,
    ARG_POP,
    ARG_PRI,
    ARG_ACT,
    ARG_PBK,
    NUM_ARGS
};

/******************\
* Global variables *
* *****************/

// broker data must be global

struct MsgPort *mp;
CxObj *cb;

/************\
* prototypes *
*************/

void read_arguments(int argc, char **argv);
int initialize_commodities();
BOOL handle_commodity_signals(ULONG signals);
void shutdown_commodities();

#endif
