/**************************\
* midtofront_commodities.c *
***************************/

/********************\
* necessary includes *
*********************/

#include <libraries/commodities.h>

#include <proto/alib.h>
#include <proto/icon.h>

#include <workbench/startup.h>

#include "midtofront_globals.h"
#include "midtofront.h"
#include "midtofront_commodities.h"
#include "midtofront_gui.h"
#include "midtofront_locale.h"

/******************\
* Global variables *
* *****************/

struct NewBroker nb = {
  NB_VERSION,
  "MidToFront",
  "MidToFront",
  NULL,
  NBU_UNIQUE | NBU_NOTIFY,
  COF_SHOW_HIDE,
  0,
  NULL,
  0
};

/****************\
* read_arguments *
*********************************************\
* read the commodity arguments either in the *
* tooltypes or on the command line           *
*********************************************/
void read_arguments(int argc, char **argv) {

  activate = pushback = TRUE;
  cx_popkey = DEF_POPKEY;
  cx_popup = FALSE;
  cx_priority = 0;

  static IPTR args[NUM_ARGS];
  static struct RDArgs *myargs;
  static struct WBStartup *argmsg;
  static struct WBArg *wb_arg;
  static STRPTR cxname;
  UBYTE **arguments;
  STRPTR data;

  // get disk object name

  if (argc != 0) {

    argmsg = (struct WBStartup *)argv;
    wb_arg = argmsg->sm_ArgList;
    cxname = wb_arg->wa_Name;

  } else {

    if (!(myargs = ReadArgs(ARG_TEMPLATE, args, NULL))) return;
    if (args[ARG_PRI]) cx_priority = *(LONG*)args[ARG_PRI];
    if (args[ARG_POP]) cx_popkey = StrDup((char *)args[ARG_POP]);
    else cx_popkey = StrDup(DEF_POPKEY);
    FreeArgs(myargs);
    cxname = argv[0];

  }

  // get disk object

  disko = GetDiskObject(cxname);

  // get command line arguments or tooltypes

  arguments = ArgArrayInit(argc, (UBYTE **)argv);
  cx_popkey = StrDup((STRPTR )ArgString(arguments, "CX_POPKEY", DEF_POPKEY));
  cx_priority = ArgInt(arguments, "CX_PRIORITY", 0);
  data = (STRPTR )ArgString(arguments, "CX_POPUP", "N");
  if ((data[0] == 'y') || (data[0] == 'Y')) cx_popup = TRUE;
  data = (STRPTR )ArgString(arguments, "ACTIVATE", "Y");
  if ((data[0] == 'n') || (data[0] == 'N')) activate = FALSE;
  data = (STRPTR )ArgString(arguments, "PUSHBACK", "Y");
  if ((data[0] == 'n') || (data[0] == 'N')) pushback = FALSE;
  ArgArrayDone();
  cxname = argv[0];

  D(bug("[midtofront] pop %d pri %d act %d pbk %d key %d %s\n",
      cx_popup, cx_priority, activate, pushback, cx_popkey, cx_popkey));

  return;

}

/************************\
* initialize_commodities *
**********************************************\
* sets up the commodities:                    *
* initializes two brokers and senders         *
* (one for popkey, one for middle button)     *
* returns 0 iff failure to create and attach; *
* otherwise, returns 1                        *
**********************************************/
int initialize_commodities() {

  CxObj *cf = NULL;
  CxObj *cs = NULL;
  CxObj *hf = NULL;
  CxObj *hs = NULL;

  mp = CreateMsgPort();

  if (mp != NULL) {

    nb.nb_Port = mp;
    nb.nb_Descr = (STRPTR )CatalogString(MSG_DESCR);
    nb.nb_Pri = cx_priority;
    cb = CxBroker(&nb, NULL);

    if (cb != NULL) {

      cf = CxFilter("rawmouse upstroke mouse_middlepress");
      hf = CxFilter(cx_popkey);

      if ((cf != NULL) && (hf != NULL)) {

        AttachCxObj(cb, cf);
        AttachCxObj(cb, hf);
        cs = CxSender(mp, BUTTONPRESS);
        hs = CxSender(mp, POPKEYPRESS);

        if ((cs != NULL) && (hs != NULL)) {

          AttachCxObj(cf, cs);
          AttachCxObj(hf, hs);
          ActivateCxObj(cb, TRUE);
          
          return 1;

        }

        D(bug("[midtofront] No sender\n"));

      }

      D(bug("[midtofront] No filter(s)\n"));

    }

    D(bug("[midtofront] No broker\n"));

  }

  D(bug("[midtofront] No message port\n"));

  return 0;

}

/****************************\
* handle_commodities_signals *
***********************************************\
* take care of commodities messages:           *
* popkey press (dispatch to midtofront_gui)    *
* and middle button press (do the job!)        *
* returns TRUE iff message was not CXCMD_KILL  *
***********************************************/
BOOL handle_commodities_signals(ULONG signals) {

  CxMsg *cm;
  struct InputEvent *ie;
  BOOL return_value = TRUE;

  D(bug("[midtofront] have message "));

  // handle all the commodities messages we have at the moment

  while (cm = (CxMsg *)GetMsg(mp)) {

    D(bug("[midtofront] ID %d\n", CxMsgID(cm)));

    // get message type

    switch (CxMsgType(cm)) {

      case CXM_IEVENT:

        D(bug("[midtofront] have input event "));

        // we have an input event, get the message ID

        switch (CxMsgID(cm)) {

          case BUTTONPRESS: bring_window_to_front(); break;

          case POPKEYPRESS:

            handle_popkey();
            break;

          default: break;

        }

        break;

      case CXM_COMMAND:

        D(bug("[midtofront] have command "));

        // we have a commodities command, get the message ID

	      switch (CxMsgID(cm)) {

        	// the window should show when asked,
        	// and also when the user tries to start us
        	// when we're already up and running

        	case CXCMD_APPEAR:
        	case CXCMD_UNIQUE:

        	  show_popup_window();
        	  break;

        	// the window should go away when asked

        	case CXCMD_DISAPPEAR:

        	  hide_popup_window();
        	  break;

          // enable the commodity

        	case CXCMD_ENABLE:

            D(bug("[midtofront] enable "));
            ActivateCxObj(cb, TRUE);
            break;

          // disable the commodity

        	case CXCMD_DISABLE:

            D(bug("[midtofront] disable "));
            ActivateCxObj(cb, FALSE);
            break;

          // go away

  	      case CXCMD_KILL:

    	      D(bug("[midtofront] quit "));
      	    return_value = FALSE;
        	  break;

        	default: break;

        } // switch ...MsgID

        break;

      default: break;

    } // switch ...MsgType

  } // while ...GetMsg

  return return_value;

}

/**********************\
* shutdown_commodities *
*******************************************\
* shuts down the commodities:              *
* deletes the objects and the message port *
*******************************************/
void shutdown_commodities() {

  if (cb != NULL) DeleteCxObjAll(cb);
  if (nb.nb_Port != NULL) DeleteMsgPort(nb.nb_Port);
  FreeDiskObject(disko);
  FreeVec(cx_popkey);

}
