/**************\
* midtofront.c *
**************************************************************\
* MidToFront for AROS                                         *
* v1.2 Copyright (C) 2012 John Perry, PhD                     *
* This software is released into the public domain            *
*                                                             *
* This is a very basic commodity that brings to the front a   *
* window when the user clicks the middle mouse button.        *
*                                                             *
* Options for this commodity are through tool types and       *
* command line:                                               *
* - CX_POPKEY/K/S                                             *
*   The default is "ctrl alt m"                               *
*   (This option is currently disabled.)                      *
* - CX_POPUP/K/N                                              *
*   If set to "Y" or "y", brings up the settings window.      *
* - CX_PRIORITY/K/N                                           *
*   Has the usual meaning.                                    *
* - ACTIVATE/K                                                *
*   If set to "Y" or "y", activates the frontmost window      *
*   If PUSHBACK is also "Y" or "y" and you have just pushed   *
*   the frontmost window back, this will activate the window  *
*   that is now frontmost.                                    *
* - PUSHBACK/K                                                *
*   If set to "Y" or "y", this will push a window in front of *
*   the screen to the back.                                   *
*                                                             *
* The DONOTWAIT tooltype should be left alone.                *
*                                                             *
* Please direct questions, comments, and snide remarks to the *
* author at either devotus@yahoo.com or john.perry@usm.edu.   *
* The Yahoo! address is preferred, as long as the spam        *
* filters do not block you, and as long as both Yahoo! and I  *
* remain.                                                     *
**************************************************************/

/******\
* TODO *
*****************************************\
* 1. Figure out why Ctrl+C doesn't work. *
*****************************************/

/********************\
* necessary includes *
*********************/

#include <devices/inputevent.h>

#include <graphics/clip.h>
#include <graphics/layers.h>

#include <exec/ports.h>
#include <exec/types.h>

#include <intuition/intuition.h>
#include <intuition/intuitionbase.h>

#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/layers.h>

#include "midtofront_globals.h"
#include "midtofront_commodities.h"
#include "midtofront_gui.h"
#include "midtofront_locale.h"

/***********************\
* bring_window_to_front *
****************************************\
* brings to the fore the "first" window *
* on Intuition's "first" screen         *
****************************************/
void bring_window_to_front() {

  struct Window *win = NULL;
  struct Screen *scr;
  struct Layer *lay, *top_lay, *low_lay;
  ULONG ib_data;

  /* Lock IntuitionBase before reading its data */
  ib_data = LockIBase(0);
  scr = IntuitionBase->FirstScreen;
  UnlockIBase(ib_data);

  /* try to bring the window beneath the mouse to the front
     if there is no window under the mouse,
     try to bring up the screen's "first" window */

  if (scr != NULL) {

    LockLayerInfo(&(scr->LayerInfo));
    lay = WhichLayer(&(scr->LayerInfo), scr->MouseX, scr->MouseY);
    top_lay = (&(scr->LayerInfo))->top_layer;
    UnlockLayerInfo(&(scr->LayerInfo));

    if (lay != NULL) {

      win = (struct Window *)lay->Window;
      low_lay = lay->back;

    }

    if (win != NULL) {

      if (lay != top_lay) {

        WindowToFront(win);
        if (activate) ActivateWindow(win);

      } else if (pushback) {

        D(bug("[midtofront] pushing back\n"));
        WindowToBack(win);

        if (activate) {

          D(bug("[midtofront] and activating\n"));
          win = (struct Window *)(low_lay->Window);
          ActivateWindow(win);
          D(bug("[midtofront] %s\n",win->Title));

        }

      }

    }

  }

}

/******************\
* listen_and_react *
*********************************************\
* listens to the message ports and           *
* handles appropriate messages appropriately *
*********************************************/
void listen_and_react() {

  BOOL running = TRUE;
  LONG signals;
  
  while (running) {

    // Maybe I'm doing something wrong, but CTRL+C doesn't seem to work
    signals = Wait((1 << mp -> mp_SigBit) | mui_sigs | SIGBREAKF_CTRL_C);
    D(bug("[midtofront] signal!\n"));

    // handle MUI input first
    if (signals & mui_sigs) handle_mui_signals();

    // now handle commodities input
    if (signals & (1 << mp -> mp_SigBit)) running = handle_commodities_signals(signals);

    // finally, check for CTRL+C
    // (this doesn't usually work for some reason)
    if (signals & SIGBREAKF_CTRL_C) running = FALSE;

  } // while running

} // listen_and_react

/******\
* main *
*********************\
* bare-bones control *
*********************/
int main(int argc, char **argv) {

  D(bug("[midtofront] start (DEBUG)\n"));

  // setup, reading command line and starting popup window

  read_arguments(argc, argv);
  setup_popup_window(cx_popup);

  // listen_and_react acts as a dispatcher for messages

  if (initialize_commodities()) listen_and_react();

  // if we get here, either the startup was in error,
  // or the user requested shutdown

  shutdown_commodities();
  shutdown_popup_window();

  D(bug("[midtofront] stop (DEBUG)\n"));
  return 0;

}
