#include "rar.hpp"

#if defined(__AROS__)
   #include <exec/exec.h>
   #include <dos/dos.h>
   #include <proto/exec.h>
   #include <proto/dos.h>

   /*256 kBstack*/
   #define REQUIRED_STACK_SIZE 262144L
#endif

#if !defined(GUI) && !defined(RARDLL)
#if defined (__AROS__)

struct StartMessage
{
   struct Message msg;
   int argc;
   char **argv;
   int rc;
};

void proc_entry();
int unrar(int argc, char *argv[]);

int main(int argc, char *argv[])
{
   struct Process *myproc = (struct Process *)FindTask(NULL);
   IPTR stacksize = (IPTR)myproc->pr_Task.tc_SPUpper - (IPTR)myproc->pr_Task.tc_SPLower;
   int rc;

   if (stacksize >= REQUIRED_STACK_SIZE)
   {
      rc = unrar(argc, argv);
   }
   else
   {
      struct StartMessage msg;
      struct Process *child_proc;
      struct MsgPort *my_mp;
      struct MsgPort *child_mp;
      struct StartMessage *my_msg;

      child_proc = CreateNewProcTags(
         NP_Entry, proc_entry,
         NP_StackSize, REQUIRED_STACK_SIZE,
         TAG_END);
      if(!child_proc)
      {
         return RETURN_FAIL; 
      }

      my_mp=&myproc->pr_MsgPort; 
      child_mp=&child_proc->pr_MsgPort;

      msg.msg.mn_Node.ln_Type = NT_MESSAGE;
      msg.msg.mn_Length = sizeof(msg);
      msg.msg.mn_ReplyPort = my_mp;
      msg.argc = argc;
      msg.argv = argv;

      PutMsg(child_mp, &msg.msg); 
      while (!(my_msg = (struct StartMessage *)GetMsg(my_mp))) WaitPort(my_mp);
      rc = my_msg->rc; 
   } 
   return rc;
}

void proc_entry ()
{
   struct Process *myproc = (struct Process *)FindTask(NULL);
   IPTR stacksize = (IPTR)myproc->pr_Task.tc_SPUpper - (IPTR)myproc->pr_Task.tc_SPLower;
   struct MsgPort *my_mp = &myproc->pr_MsgPort;
   struct StartMessage *my_msg;

   while (!(my_msg = (struct StartMessage *)GetMsg(my_mp))) WaitPort(my_mp);

   my_msg->rc = unrar(my_msg->argc, my_msg->argv);

   Forbid();
   ReplyMsg(&my_msg->msg);
}

int unrar(int argc, char *argv [])
#else
int main(int argc, char *argv[])
#endif
{
#if defined(_UNIX) && !defined(__AROS__)
  setlocale(LC_ALL,"");
#endif

#if defined(_EMX) && !defined(_DJGPP)
  uni_init(0);
#endif

#if !defined(_SFX_RTL_) && !defined(_WIN_32) && !defined(__AROS__)
  setbuf(stdout,NULL);
#endif

#if !defined(SFX_MODULE) && defined(_EMX)
  EnumConfigPaths(argv[0],-1);
#endif

  ErrHandler.SetSignalHandlers(true);

  RARInitData();

#ifdef SFX_MODULE
  char ModuleName[NM];
#ifdef _WIN_32
  GetModuleFileName(NULL,ModuleName,sizeof(ModuleName));
#else
  strcpy(ModuleName,argv[0]);
#endif
#endif

#ifdef _WIN_32
  SetErrorMode(SEM_NOALIGNMENTFAULTEXCEPT|SEM_FAILCRITICALERRORS|SEM_NOOPENFILEERRORBOX);


#endif

#if defined(_WIN_32) && !defined(SFX_MODULE) && !defined(SHELL_EXT)
  bool ShutdownOnClose;
#endif

#ifdef ALLOW_EXCEPTIONS
  try 
#endif
  {
  
    CommandData Cmd;
#ifdef SFX_MODULE
    strcpy(Cmd.Command,"X");
    char *Switch=NULL;
#ifdef _SFX_RTL_
    char *CmdLine=GetCommandLine();
    if (CmdLine!=NULL && *CmdLine=='\"')
      CmdLine=strchr(CmdLine+1,'\"');
    if (CmdLine!=NULL && (CmdLine=strpbrk(CmdLine," /"))!=NULL)
    {
      while (IsSpace(*CmdLine))
        CmdLine++;
      Switch=CmdLine;
    }
#else
    Switch=argc>1 ? argv[1]:NULL;
#endif
    if (Switch!=NULL && Cmd.IsSwitch(Switch[0]))
    {
      int UpperCmd=etoupper(Switch[1]);
      switch(UpperCmd)
      {
        case 'T':
        case 'V':
          Cmd.Command[0]=UpperCmd;
          break;
        case '?':
          Cmd.OutHelp();
          break;
      }
    }
    Cmd.AddArcName(ModuleName,NULL);
#else
    if (Cmd.IsConfigEnabled(argc,argv))
    {
      Cmd.ReadConfig(argc,argv);
      Cmd.ParseEnvVar();
    }
    for (int I=1;I<argc;I++)
      Cmd.ParseArg(argv[I],NULL);
#endif
    Cmd.ParseDone();

#if defined(_WIN_32) && !defined(SFX_MODULE) && !defined(SHELL_EXT)
    ShutdownOnClose=Cmd.Shutdown;
#endif

    InitConsoleOptions(Cmd.MsgStream,Cmd.Sound);
    InitLogOptions(Cmd.LogName);
    ErrHandler.SetSilent(Cmd.AllYes || Cmd.MsgStream==MSG_NULL);
    ErrHandler.SetShutdown(Cmd.Shutdown);

    Cmd.OutTitle();
    Cmd.ProcessCommand();
  }
#ifdef ALLOW_EXCEPTIONS
  catch (int ErrCode)
  {
    ErrHandler.SetErrorCode(ErrCode);
  }
#ifdef ENABLE_BAD_ALLOC
  catch (bad_alloc)
  {
    ErrHandler.SetErrorCode(MEMORY_ERROR);
  }
#endif
  catch (...)
  {
    ErrHandler.SetErrorCode(FATAL_ERROR);
  }
#endif
  File::RemoveCreated();
#if defined(SFX_MODULE) && defined(_DJGPP)
  _chmod(ModuleName,1,0x20);
#endif

#if defined(_EMX) && !defined(_DJGPP)
  uni_done();
#endif
#if defined(_WIN_32) && !defined(SFX_MODULE) && !defined(SHELL_EXT)
  if (ShutdownOnClose)
    Shutdown();
#endif
  return(ErrHandler.GetErrorCode());
}
#endif


