/*
	strip_roff, strips nroff backspace sequences.
	            Takes input on stdin, outputs to stdout.
	Copyright (c) 2004 Kalle Risnen <kal@aros-stuff.tk>.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	
*/

#include <stdio.h>

int main()
{
	int c, prev = 0;

	while((c = getchar()) != EOF)
		{
		if(c == '\b') 
			{ if(prev != '_') c = getchar(); }
		else if(c == '_')
			{
			int d = getchar();
			if(d != '\b')
				{
				putchar(c);
				if(d != '_') putchar(d);
				else         ungetc(d,stdin);
				}
			}
		else 
			putchar(c);
		prev = c;
		}
}
