NROFF(1)                                                 NROFF(1)



NNAAMMEE
       nroff - text processor (Version 1.10)

SSYYNNOOPPSSIISS
       nroff [options] file [...]

DDEESSCCRRIIPPTTIIOONN
       Nroff  is  a  text  processor  and  formatter based on the
       design provided  in  "Software  Tools"  by  Kernighan  and
       Plauger.   It  has  been  modified to closely resemble the
       Unix(tm) nroff command.  The text and  commands  found  in
       the  file(s)  are  processed  to  generate formatted text.
       Note that one (and only one) of the files can be "-" which
       reads  input  from stdin at that point.  The output always
       goes to stdout which can be redirected by the shell.   The
       -o  option lets you redirect error output to the specified
       file rather than  stderr.   Debugging  information  always
       goes  to  the  file "nroff.dbg" and is generally used only
       for program development.

OOPPTTIIOONNSS
       The following command line options are available:

       -d     Set debug mode.

       -h     Hold before exit (Atari TOS only).

       -m<name>
              Process  macro  file  tmac.<name>.  Thus -man would
              cause  the  file  tmac.an  to be loaded.  Note that
              files processed in this  way  should  contain  only
              macro  definitions,  no  immediate output should be
              generated from this file (see ENVIRONMENT).

       -o<file>
              Set error log file (default is stderr).

       -raN   Preset number register 'a' (single character) to  N
              (decimal integer only).

       -po<n> Shift output right n spaces (like .po).

       -pn<n> Initial page number (like .pn).

       -v     Prints the version information to stdout.

       +<n>   Causes output to start with page n.

       -<n>   Causes output to stop after page n.

       -      Input from stdin.


EENNVVIIRROONNMMEENNTT
       Nroff  recognizes the following environment variables from
       the shell:

       TMACDIR
              An alternate directory to  find  the  files  tmac.*
              ("."  for  example).   The  default  is c:\lib\tmac
              under  TOS  and  /usr/lib/tmac   under   Minix   or
              Unix(tm).

       TMPDIR An  alternate  directory  to  place  any  temporary
              files.  The default is the current directory.  Note
              that  nroff  does  not  currently use any temporary
              files.

CCOOMMMMAANNDDSS
       Commands typically are distinguished by a period in column
       one  of the input followed by a two character abbreviation
       for the command funtion.  The  abbreviation  may  then  be
       followed  by  an  optional  numeric or character argument.
       The numeric argument may be an absolute value such as set-
       ting the right margin to a particular column, or the argu-
       ment may be preceded by a plus sign or  a  minus  sign  to
       indicate that the parameter should be modified relative to
       a previous setting.  The following commands are recognized
       (those  marked "extension" are requests added to the basic
       set provided by Unix(tm) nroff):

       .ad    Begin line adjustment.  If fill  mode  is  not  on,
              adjustment  is  defered  until it is back on.  If a
              type indicator is present, the adjustment  type  is
              changed as follows:

                   Indicator      Type
                      l           adjust left margin only
                      r           adjust right margin only
                      c           center
                   b or n         adjust both margins (default)
                   absent         unchanged

       .af    Assign  format  to  number register.  The available
              formats are:

                   Format    Numbering Sequence
                     1       0,1,2,3,4,...
                    001      000,001,002,...
                     i       0,i,ii,iii,iv,v,...
                     I       0,I,II,III,IV,V,...
                     a       0,a,b,...,z,aa,ab,...zz,aaa,...
                     A       0,A,B,...,Z,AA,AB,...ZZ,AAA,...

              The second format above indicates  that  the  field
              width,  i.e.  number of digits, is specified by the
              number of digits in the format type.

       .bd    Ignored by nroff.

       .bo    Causes the following lines of  text  to  appear  in
              boldface.  The optional argument specifies the num-
              ber of lines to be typed in boldface.  Boldface and
              underlining  are  mutually exclusive features.  The
              appearance of a boldface  command  will  cause  any
              underlining to cease.

       .bp    Causes  succeeding  text  to appear at the top of a
              new page.  The optional argument specifies the page
              number  for the new page.  The initial value is one
              and the default value is one more than the previous
              page number.

       .br    Causes  succeeding  text  to start on a new line at
              the current left margin.  There is no numeric argu-
              ment for this command.

       .bs    Enables or disables the appearance of backspaces in
              the output text.  Underlining and boldface  options
              are  implemented by inserting character - backspace
              - character combinations into  the  output  buffer.
              This  is  fine for devices which properly recognize
              the backspace character.  Some  printers,  however,
              do  not recognize backspaces, so the option is pro-
              vided to overprint one line  buffer  with  another.
              The  first  line  buffer  is terminated with just a
              carriage return rather than the carriage  return  -
              linefeed  combination.  A zero argument or no argu-
              ment to the backspace  command  removes  backspaces
              from  the  output.  A non-zero argument leaves them
              in  the  output.   The   default   is   to   remove
              backspaces.

       .cc    Changes  the nroff command character to that speci-
              fied by the character argument.  If no argument  is
              provided, the default is a period (.).

       .ce    Causes  the next line of text to appear centered on
              the output.  The  optional  argument  specifies  if
              more than one line is to be centered.

       .cs    Ignored by nroff.

       .cu    Causes  the next line(s) of text to be continuously
              underlined.  Unlike the underline command (see .ul)
              which  underlines  only  alphanumerics,  continuous
              underlining underlines  all  printable  characters.
              The optional argument specifies the number of lines
              of text to underlined.  Any normal  underlining  or
              boldface  commands currently in effect will be ter-
              minated.

       .c2    Changes the nroff no break character to that speci-
              fied  by the character argument.  If no argument is
              provided, the default is a single quote.

       .de    Causes all text and commands following to  be  used
              to define a macro.  The definition is terminated by
              a .en command or the default  ..  terminator.   The
              first  two characters of the argument following the
              .de command become the name of the new command.  It
              should be noted that upper and lower case arguments
              are considered different.  Thus, the  commands  .PP
              and  .pp  could  define two different macros.  Care
              should be exercised since existing commands may  be
              redefined.

              A  macro  may contain up to nine arguments.  In the
              macro definition, the  placement  of  arguments  is
              designated  by the two character sequences, $1, $2,
              ... $9.  When the macro is invoked,  each  argument
              of  the  macro  command line is substituted for its
              corresponding designator  in  the  expansion.   The
              first  argument of the macro command is substituted
              for the $1 in the expansion,  the  second  argument
              for  the $2, and so forth.  Arguments are typically
              strings which do not contain blanks or tabs.  If an
              argument  is  to  contain blanks, then it should be
              surrounded by either single or double quotes.

       .ds    Define a string.  To initiate  the  string  with  a
              blank  or  include  blanks  in the string, start it
              with a single or double quite.  The string can con-
              tain  other  defined strings or number registers as
              well as normal text.  Strings  are  stored  on  the
              macro name space.

       .ec    Changes  the  nroff escape character to that speci-
              fied by the character argument.  If no argument  is
              provided, the default is a backslash.

       .ef    Specifies  the text for the footer on even numbered
              pages.  The format is the same as  for  the  footer
              command (see .fo).

       .eh    Specifies  the text for the header on even numbered
              pages.  The format is the same as  for  the  footer
              command (see .fo).

       .en    Designates the end of a macro definition.

       .eo    Turn the escape mechanism off.

       .ex    Exit  nroff  at  this  point in the processing.  Ex
              forces all files closed and flushes the output.

       .fi    Causes the input text to be rearranged or filled to
              obtain  the maximum word count possible between the
              previously set left and right margins.  No argument
              is expected.

       .fl    Causes the output buffer to be flushed immediately.

       .fo    Specifies text to be used for a footer.  The footer
              text  contains  three strings seperated by a delim-
              iter character.  The first non-blank character fol-
              lowing  the command is designated as the delimiter.
              The first text string is left justified to the cur-
              rent  indentation  value  (specified  by .in).  The
              second  string  is  centered  between  the  current
              indentation  value  and  the  current  right margin
              value (specified by  .rm).   The  third  string  is
              right  justified to the current right margin value.
              The absence of  footer  text  will  result  in  the
              footer  being printed as one blank line.  The pres-
              ence of the page number character (set by  .pc)  in
              the  footer text results in the current page number
              being inserted at that position.   Multiple  occur-
              rances of the page number character are allowed.

       .ft    Changes the current font.  The choices are R (Times
              Roman), I (Times Italic), B (Times Bold),  S  (math
              special),  and P used to request the previous font.
              P resets the next previous font to be the one  just
              changed, amounting to a swap.

       .he    Specifies text to be used for a header.  The format
              is the same as for the footer (see .fo).

       .if    Execute a command if the condition is true.  Format
              is:

                   .if c command
                   .if !c command
                   .if N command
                   .if !N command
                   .if "str1"str2" command
                   .if !"str1"str2" command

              Here  c  is  a  single letter: n (true if nroff), t
              (true if troff), e (true if even page), or o  (true
              if  odd page).  N is a numerical experssion and can
              include operators +, -, *, /, % (mod),  >,  <,  >=,
              <=,  =  (or ==), & (and), or : (or).  If the result
              is greater than 0, the  condition  evaluates  true.
              Numbers  in  the expression can be either constants
              or  contents  of  number  registers.   Strings  are
              tested  using  delimeter  / or " only at this time.
              Note that "block" conditionals like:

                   .if c \{\
                   ...
                   ...
                   ... \}

              are not yet supported.   Also  the  .ie/.el  condi-
              tional is not yet supported.

       .in    Indents  the left margin to the column value speci-
              fied by the argument.  The default left  margin  is
              set to zero.

       .ju    Causes  blanks  to  be  inserted between words in a
              line of output in order to  align  or  justify  the
              right margin.  The default is to justify.

       .lg    Ignored by nroff.

       .ll    Sets  the  current  line  length.   The  default is
              eighty.

       .ls    Sets the line spacing to the value specified by the
              argument.  The default is for single spacing.

       .lt    Set  length  of three-part titles.  Line length and
              title length are independent.  Indents do not apply
              to titles but page offsets do.

       .m1    Specifies the number of lines in the header margin.
              This is the space from the physical top of page  to
              and  including  the  header  text.  A value of zero
              causes the header to not be printed.   A  value  of
              one causes the header to appear at the physical top
              of page.  Larger argument values cause  the  appro-
              priate  number  of blank lines to appear before the
              header is printed.

       .m2    Specifies the number of blank lines to  be  printed
              between  the  header line and the first line of the
              processed text.

       .m3    Specifies the number of blank lines to  be  printed
              between  the  last  line  of processed text and the
              footer line.

       .m4    Specifies the number of lines in the footer margin.
              This  command  affects  the footer the same way the
              .m1 command affects the header.

       .mc    Margin character. The first argument is the charac-
              ter to use, the second is the distance to the right
              of the right margin to place the margin  character.
              Useful  for  change  bars.   No arguments turns the
              capability off. Note that with this nroff, the mar-
              gin character is always a single character only and
              this distance is prefered to  be  in  inches  (e.g.
              0.2i).  The default space is 0.2i (2 spaces).

       .na    Noadjust.  Ajdustment is turned off; the right mar-
              gin is ragged.  The adjustment type for .ad is  not
              changed.   Output line filling still occurs if fill
              mode is on.

       .ne    Specifies a number of lines  which  should  not  be
              broken  across  a  page boundary.  If the number of
              lines remaining on a page is less  than  the  value
              needed, then a new output page is started.

       .nf    Specifies  that  succeeding  text should be printed
              without rearrangement, or with no fill.   No  argu-
              ment is expected.

       .nj    Specifies  that  no attempt should be made to align
              or  justify  the  right  margin.   No  argument  is
              expected.

       .nr    Causes  the value of a number register to be set or
              modified.  A total of twenty-six  number  registers
              are  available  designated  \na through \nz (either
              upper or lower case is allowed).  When the sequence
              \nc  is  imbedded in the text, the current value of
              number register c replaces the sequence, thus, such
              things  as  paragraph numbering can be accomplished
              with relative ease.

       .of    Specifies the text for the footer on  odd  numbered
              pages.   The  format is the same as the footer com-
              mand (see .fo).

       .oh    Specifies the text for the header on  odd  numbered
              pages.   The  format is the same as the footer com-
              mand (see .fo).

       .pc    Specifies the page number character to be  used  in
              headers  and footers.  The occurrance of this char-
              acter in the header or footer text results  in  the
              current page number being printed.  The default for
              this character is the percent sign (%).

       .pl    Specifies the page length or the  number  of  lines
              per output page.  The default is sixty-six.

       .pm    Print  macros.   The  names and sizes of the macros
              are printed to stdout.  This is useful when  build-
              ing  a  macro  package to see how much of the total
              namespace is consumed by the package.

       .pn    Changes the page number of the current page and all
              subsequent  pages  to its argument.  If no argument
              is given, the command is ignored.

       .po    Specifies a page offset  value.   This  allows  the
              formatted  text  to  be shifted to the right by the
              number of spaces specified.  This feature may  also
              be invoked by a switch on the command line.

       .ps    Ignored by nroff.

       .rr    Removes a number register.

       .so    Causes  input  to be retrieved from the file speci-
              fied by the command's  character  string  argument.
              The  contents of the new file are inserted into the
              output stream until an EOF is detected.  Processing
              of  the  original  file  is  then resumed.  Command
              nesting is allowed.

       .sp    Specifies a number of  blank  lines  to  be  output
              before printing the next line of text.

       .ss    Ignored by nroff.

       .ti    Temporarily  alters  the indentation or left margin
              value for a single succeeding input line.

       .tl    Specifies text to be used for a  page  title.   The
              format is the same as for the header (see .he).

       .ul    Causes  the  next line(s) of text to be underlined.
              Unlike the .cu command, this  command  causes  only
              alphanumerics  to  be underlined, skipping punctua-
              tion and white space.  Underline and  boldface  are
              mutually exclusive.

       The following nroff commands, normally available, are cur-
       rently not implemented in this  version:  .fp,  .mk,  .rt,
       .vs,  .sv,  .os,  .ns,  .rs, .am, .as, .rm, .rn, .di, .da,
       .wh, .ch, .dt, .it, .em, .ta, .tc,  .lc,  .fc,  .lg,  .uf,
       .tr,  .nh,  .hy,  .hc,  .hw, .nm, .nn, .ie, .el, .ev, .rd,
       .ex, .nx, .pi, .tm, and .ig.

EESSCCAAPPEE SSEEQQUUEENNCCEESS
       Escape sequences are used  to  access  special  characters
       (such  as  Greek  letters) which may be outside the normal
       printable ASCII character set.  The are also used to  tog-
       gle certain actions such as font selection.

       The escape sequences include:

       \\          backslash character
       \e          printable version of escape character
       \'          accute accent (equivalent to \\(aa)
       \`          grave accent (equivalent to \\(ga)
       \-          minus sign
       \.          period
       \<space>    a single, unpaddable space
       \0          digit-width space
       \|          1\6em space (zero space in nroff)
       \^          1\12em space (zero space in nroff)
       \&          non-printing zero-width character
       \"          beginning of comment
       \%          default hyphenation character
       \(xx        special character named xx
       \*x,\*(xx   interpolate string x or xx
       \fc         font change (c = R,I,B,S,P)
       \nx         interpolate number register x
       \t          horizontal tab

       The Atari ST (TOS) version of nroff includes the following
       special characters. NOTE: THESE ARE  NOT  AVAILABLE  UNDER
       Minix OR Unix(tm)!

       \(co        copyright
       \(rg        registered
       \(tm        trademark
       \(12        1/2
       \(14        1/4
       \(p2        exponent 2
       \(p3        exponent 3
       \(pn        exponent n
       \(aa        acute
       \(ga        grave
       \(de        degree
       \(dg        dagger
       \(ct        cent
       \(bu        bullet
       \(pp        paragraph
       \(^g        ring bell
       \(ua        up arrow
       \(da        dn arrow
       \(->        rt arrow
       \(<-        lf arrow
       \(di        divide
       \(sr        sq root
       \(==        ==
       \(>=        >=
       \(<=        <=
       \(+-        +-
       \(~=        ~=
       \(ap        approx
       \(no        not
       \(mo        memeber
       \(ca        intersect
       \(cu        union
       \(*a        alpha
       \(*b        beta
       \(*G        Gamma
       \(*d        delta
       \(*s        sigma
       \(*p        pi
       \(*m        mu

PPRREEDDEEFFIINNEEDD GGEENNEERRAALL NNUUMMBBEERR RREEGGIISSTTEERRSS
       The  following  number  registers  are  available for both
       reading and writing.  They are accessed with the \n(xx and
       \nx escape and can be set with .nr:

       %           current page number
       dw          current day of the week (1-7)
       dy          current day of the month (1-31)
       hh          current hours (0-23)
       ln          current line number
       mm          current minutes (0-59)
       mo          current month (1-12)
       ss          current seconds (0-59)
       yr          last 2 digits of current year

       The  following  number registers are available for reading
       only:

       .$          number of args available in current macro
       .A          always 1 in nroff
       .H          available horizontal resolution
       .T          always 0 in nroff
       .V          available vertical resolution
       .c          number of lines read from current file
       .f          current font (1-4)
       .i          current indent
       .l          current line length
       .o          current page offset
       .p          current page length
       .v          current vertical spacing


NNOOTTEESS
       There are several missing  features,  notably  diversions,
       traps,  conditionals,  all the hard stuff.  This means you
       can't use some existing  macro  packages  (yet,  I  hope).
       There  is  no  complete  -ms and -me packages as a result.
       The goal is to make this nroff work  with  all  the  SunOS
       macro packages sometime before Unix becomes obsolete!

       If  you  make  additions  to  this  code,  please mail the
       changes to me so I can make formal distributions.

BBUUGGSS
       Undoubtedly more than I know about.  Here are a few:

       The ability to perform numerical calculations on registers
       is not implemented.

       All dimensional units are in em's or inches only.

       Lines  with  multiple  string instances (i.e. \*(xx) don't
       seem to work.

       Lines with font changes (e.g. for italics) use vt52 escape
       sequences to go to highlight mode.  This should read term-
       cap/terminfo to do it right.

       Some interpolations don't work properly.

       The code uses  statically  allocated  arrays  for  macros,
       strings, and registers.  This should be changed to dynami-
       cally allocated buffers or write to intermediate files  on
       small memory systems (i.e. Minix).

FFIILLEESS
       \lib\tmac\tmac.*   predefined macros (see ENVIRONMENT)
       nroff.dbg          debugging output
       stderr             default error output stream
       stdout             output stream


AAUUTTHHOORR
       Adapted for Atari ST (TOS) and Minix by Bill Rosenkranz 11/89

       net:    rosenkra@convex.com
       CIS:    71460,17
       GENIE:  W.ROSENKRANZ

       Original author:

       Stephen L. Browning
       5723 North Parker Avenue
       Indianapolis, Indiana 46220


HHIISSTTOORRYY
       Originally written in BDS C (by Stephen L. Browning?)
       Adapted for standard C by W. N. Paul
       Heavily hacked up to conform to the "real" nroff with numerous
       additions by Bill Rosenkranz 11/89
       Bug fixes (termcap) and Minix 1.5.5 compatibility by
       Wim 'Blue Baron' van Dorst (wsincc@tuerc3.urc.tue.nl)



RREECCOOMMMMEENNDDAATTIIOONNSS
       I  envisioned  this  rather  limited  version  as a way of
       formatting man pages for my Atari  ST  system.   It  works
       just  fine  for  that.  The man macro package is certainly
       adequate for that purpose.  However, it would be  nice  to
       have  more.   I suggest you limit yourself to things which
       would port easily to  other  environments.   All  the  man
       macros available here should port without effort to a more
       complete Unix(tm) environment.

       Nroff as it stands can certainly be useful.   I  recommend
       you  don't use the commands marked "extension".  Study the
       source for  the  man  pages  here  (nroff(1),  ms(7),  and
       man(7)) as well as the macro packages (tmac.an and tmac.s)
       and the examples to find out the quirks.  Some things  may
       not  quite  work  like  they  do under Unix(tm), but it is
       fairly close for what is here.

RREEFFEERREENNCCEESS
       This document briefly describes the workings of nroff.  It
       is  certainly  not the definitive work on text processing.
       I suggest you go out and get a good book (there  are  sev-
       eral  on  the market) or refer to the Unix(tm) manuals for
       more help.  Nroff is just like a compiler and is much more
       complicated  than  (say)  the  C language which only has a
       handful of rules and is much more  thoroughly  documented.
       Good luck!

RREEQQUUEESSTT SSUUMMMMAARRYY
       The  following  table  summarizes  the nroff requests cur-
       rently available:

       Request Form    Initial  Default  Notes   Explanation
       --------------  -------  -------  ------- ----------------------
       Font and Character Size Control

       .ps +-N         10pt     prev     E       point size (ignored)
       .ss N           12/36em  ignored  E       space size (ignored)
       .cs F N M       off      -        P       constant space mode (ign)
       .bd F N         off      -        P       embolden font F (ignored)
       .bd S F N       off      -        P       embolden special font
       .ft F           Roman    prev     E       change to font F

       Page Control

       .pl +-N         11in     11in     v       page length
       .bp +-N         N=1      -        B,v     eject page
       .pn +-N         N=1      ignored  -       next page number N
       .po +-N         0        prev     v       page offset
       .ne N           -        N=1V     D,v     need N vertical space

       Text Filling, Adjusting, and Centering

       .br             -        -        B       break
       .fi             fill     -        B,E     fill mode
       .nf             fill     -        B,E     no fill or adjust
       .ad c           adj,both adjust   E       adjust output, mode c
       .na             adjust   -        E       no adjust
       .ce N           off      N=1      B,E     center N lines

       Vertical Spacing

       .ls N           N=1      prev     E       output N-1 Vs
       .sp N           -        N=1V     B,v     space vertical




       Line Length and Indenting

       .ll +-N         6.5i     prev     E,m     line length
       .in +-N         N=0      prev     B,E,m   indent
       .ti +-N         -        ignored  B,E,m   temporary indent

       Macros, Strings, Diversions, and Position Traps

       .de xx yy       -        .yy=..   -       define macro xx
       .ds xx str      -        ignored  -       define string xx

       Number Registers

       .nr R +-N M              -        u       define and set num reg
       .af R c         arabic   -        -       assign format to reg
       .rr R           -        -        -       remove register

       I/O Conventions and Character Translation

       .ec c                           -       set escape char
       .eo             on       -        -       turn off escape mech
       .lg N           -        -        -       ligature mode (ignored)
       .ul N           off      N=1      E       underline N lines
       .cu N           off      N=1      E       cont. underline
       .cc c           .        .        E       set control char
       .c2 c           '        '        E       set nobreak control char

       Three-part Titles

       .tl 'l'c'r'              -        -       three-part title
       .pc c           %        off      -       page number char
       .lt +-N         6.5in    prev     E,m     length of title

       Conditional Acceptence of Input

       .if c cmd                -        -       if c true, accept cmd
       .if !c cmd               -        -       if c false, accept cmd
       .if N cmd                -        -       if N > 0, accept cmd
       .if !N cmd               -        -       if N <= 0, accept cmd
       .if "s1"s2" cmd          -        -       if strings same, accept cmd
       .if !"s1"s2" cmd         -        -       if strings differ, accept cmd

       Input/Output File Switching

       .so filename             -        -       switch source file

       Miscellaneous

       .mc c N         -        off      E,m     margin char c, seperation N
       .pm t           -        all      -       print macro names
       .fl             -        -        B       flush output buffer

       Notes

       B       causes a break
       D       mode or parameters associated with current diversion level
       E       relevant parameters are a part of the current environment
       O       must stay in effect until logical output
       P       mode must be still or again in effect at time of physical output
       v,p,m,u default scale indicators



                                                         NROFF(1)
