#ifndef UADE_TNPLUG_H
#define UADE_TNPLUG_H

#include <exec/exec.h>
#include <dos/dos.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/utility.h>
#include <libraries/TNPlug.h>
#include <proto/TNPlug.h>
#include "debug.h"

#define PLUGINNAME "TN_UADE.tnplug"
#define PLAYERNAME "TN_UADE.player"
#define AUDIO_BUFFER_SIZE 4096

struct TNPlugBase {
	struct Library tnpb_LibNode;
	BPTR tnpb_SegList;
};

struct StartMessage {
	struct Message sm_Msg;
	struct TNDecHandle *sm_Handle;
};

struct AudioDataMessage {
	struct Message adm_Msg;
	uint32 adm_NumPCMFrames;
	uint32 adm_SongEndType;
};

struct TNDecHandle {
	struct MsgPort *main_port;
	struct StartMessage *start_msg;
	struct AudioDataMessage *adata_msg;
	struct DeathMessage *death_msg;

	STRPTR filename;
	BOOL tempfile;
	int16 *pcm;
	struct Process *player_proc;

	int32 frequency;
	int32 cur_subsong;
	int32 num_subsongs;
	int32 jump_subsong;

	uint32 data_sig;
	uint32 subsong_sig;
	uint32 end_sig;
};

enum {
	FORMAT_RAW,
	FORMAT_XPK,
	FORMAT_XFD,
	FORMAT_PT36
};

#ifdef __cplusplus
extern "C" {
#endif

/* announceplayer.c */
struct audio_player *TNPlug_AnnouncePlayer (struct TNPlugIFace *Self, uint32 version);

/* initplayer.c */
BOOL TNPlug_InitPlayer (struct TNPlugIFace *Self, struct TuneNet *inTuneNet, uint32 playmode);
void TNPlug_ExitPlayer (struct TNPlugIFace *Self, struct audio_player *aplayer);

/* openplayer.c */
int32 TNPlug_TestPlayer (struct TNPlugIFace *Self, uint8 *testme, uint8 *testbuffer,
	uint32 totalsize, uint32 testsize);
BOOL TNPlug_OpenPlayer (struct TNPlugIFace *Self, uint8 *openme, struct TuneNet *inTuneNet);
void TNPlug_ClosePlayer (struct TNPlugIFace *Self, struct TuneNet *inTuneNet);

/* decodeframeplayer.c */
int32 TNPlug_DecodeFramePlayer (struct TNPlugIFace *Self, struct TuneNet *inTuneNet,
	int16 *outbuffer);
int32 TNPlug_SeekPlayer (struct TNPlugIFace *Self, struct TuneNet *inTuneNet, uint32 seconds);

/* donotify.c */
uint32 TNPlug_DoNotify (struct TNPlugIFace *Self, struct TuneNet *inTuneNet, uint32 item,
	uint32 value);

/* compression.c */
BOOL IsXPK (uint8 *testbuffer, int32 testsize);
BOOL IsXFD (uint8 *testbuffer, int32 testsize);
int32 IsCompressed (CONST_STRPTR filename);
BOOL UnpackXPK (CONST_STRPTR infilename, CONST_STRPTR outfilename);
BOOL ReadFile (CONST_STRPTR filename, uint8 **buffer, int32 *size);
BOOL WriteFile (CONST_STRPTR filename, uint8 *buffer, int32 size);
BOOL UnpackXFD (CONST_STRPTR infilename, CONST_STRPTR outfilename);

/* pt36.c */
#ifdef NOPT36
#define IsPT36(testbuffer,testsize) (FALSE)
#define UnpackPT36(infilename,outfilename) (FALSE)
#else
BOOL IsPT36 (uint8 *testbuffer, int32 testsize);
BOOL UnpackPT36 (CONST_STRPTR infilename, CONST_STRPTR outfilename);
#endif

#ifdef __cplusplus
}
#endif

#endif
