	incdir	"Amiga:Includes/"
	include	"misc/DeliPlayer.i"
	
;
;
	SECTION Player,Code
;
;

	PLAYERHEADER PlayerTagArray

	dc.b '$VER: Art Of Noise 8 voices replayer 20060410',0
	even

PlayerTagArray
	dc.l	DTP_RequestDTVersion,16
	dc.l	DTP_PlayerVersion,1
	dc.l	DTP_PlayerName,PName
	dc.l	DTP_Creator,CName
	dc.l	DTP_ModuleName,MNamePTR
	dc.l	DTP_DeliBase,delibase
	dc.l	DTP_Interrupt,aon8_playcia
	dc.l	DTP_Check2,Chk
	;dc.l	DTP_StartInt,ALLOCCIAB
	;dc.l	DTP_StopInt,FREECIAB
	dc.l	DTP_InitPlayer,InitPlay
	dc.l	DTP_EndPlayer,EndPlay
	dc.l	DTP_InitSound,InitSnd
	dc.l	DTP_EndSound,EndSnd
	dc.l	DTP_Flags, PLYF_SONGEND
	dc.l	TAG_DONE

*-----------------------------------------------------------------------*
;
; Player/Creatorname und lokale Daten

MNamePTR:
	dc.l	MName

PName	dc.b 'ArtOfNoise (8ch)',0
CName	dc.b 'by Bastian Spiegel (Twice/Lego)',10
	dc.b 'adapted for UADE by mld',0
uadename	dc.b	'uade.library',0
MName:	ds.b 32
	dc.b 0
	even
delibase	dc.l 0


*-----------------------------------------------------------------------*
;
; Testet auf Modul

Chk						; AON8 ?
	move.l	a5,delibase
	move.l	dtg_ChkData(a5),a0
	moveq	#-1,d0				; no (default)
	cmp.l	#"AON8",(a0)
	bne.s	ChkEnd
	move.l	a0,mod				; save Pointer
	move.l	#"NAME",d0			
	move.l	#"INFO",d1
	bsr.b	cpyMName
	moveq	#0,d0
ChkEnd
	rts



cpyMName:
	move.l	a0,a1
.search	cmp.l	(a1),d0
	beq.b	.ok
	cmp.l	(a1),d1
	beq.b	.end
	addq.l	#2,a1
	bra.b	.search
.ok	addq.l	#8,a1

	move.w	-2(a1),d0				; quick and dirty
	subq.b	#1,d0	
	cmp.b	#32,d0
	ble.b	.cpy	
	moveq	#32,d0
.cpy	lea.l	MName,a0
.loop	move.b	(a1)+,(a0)+	
	dbra	d0,.loop	
.end	rts
	

*-----------------------------------------------------------------------*
;
; Init Player

InitPlay
	move.l	4.w,a6
	lea	uadename(pc),a1
	moveq	#0,d0
	jsr	-552(a6)			; open library
	tst.l	d0
	beq.b	nouadelib
    	move.l	d0,a6
	moveq	#-1,d0
	jsr	-6(a6)				; "all you cpu belong to us!"
nouadelib:
	move.l	dtg_AudioAlloc(a5),a0		; Function
	jsr	(a0)				; returncode is already set !
	rts

*-----------------------------------------------------------------------*
;
; End Player

EndPlay
	;jsr	AON_END
	move.b	#0,playbit
	move.l	dtg_AudioFree(a5),a0		; Function
	jsr	(a0)
	rts

*-----------------------------------------------------------------------*
;
; Init Module

InitSnd
	move.l	mod,a0
	lea	buffers,a1			
	moveq	#0,d0				;start Pos
	move	#250,d1				;Mixrate
	bsr.b	AON_init			;init Aon Player
	move.b	#1,playbit

	;move.l	aon_timerval,d0
	;divu	#125,d0
	;bsr	aon_setspeed

	rts
*-----------------------------------------------------------------------*
;
; SongEnd

AON_Songend
    movem.l d0-a6,-(a7)
    move.l delibase,a5
    move.l dtg_Songend(a5),a0
    jsr (a0)
    movem.l (a7)+,d0-a6
    rts


*-----------------------------------------------------------------------*
;
; Clean up Module

EndSnd
	bsr.w	aon_end
	rts

aon_setspeed:
	movem.l	d0-a6,-(sp)	    
	move.l	delibase(pc),a5
	move.w	d0,dtg_Timer(a5)
	move.l	dtg_SetTimer(a5),a1
	jsr	(a1)
	movem.l	(sp)+,d0-a6	    
	rts

;####################################################################
;			SECTION	replay,code
PLAYERSTART
; Jumptable
			bra.b	aon_init
			bra.w	aon_end
			bra.b	aon_init


mix_buflen		= 128
aon_timerval		= 1773447		PAL!!

; ## AON-INCLUDES ##

aon.songinfo_mfver	=0
aon.songinfo_maxpos	=1
aon.songinfo_respos	=2

aon.instrtypeSample8bit	=0
aon.instrtypeSynth1	=1

			rsreset
instr_control		rs.b	1	; Instr-Type (check out aon.instrtypexxxxx)
instr_volume		rs.b	1	; volume 0-64
instr_finetune		rs.b	1	; finetune -7 to 7  bits 4-7 are unused
instr_waveform		rs.b	1	; waveform 0-63

; Sample 8 bit
			rsset	4
sample8_dmaoffset	rs.l	1	; Sampleoffset/2 (words)
sample8_dmalen		rs.l	1	; Samplelen/2 (words)
sample8_dmarepoffset	rs.l	1	; Repeatstrt/2 (words)
sample8_dmareplen	rs.l	1	; Repeatlen/2 (words)

; Wavetable 8 bit
			rsset	4
synth8_partwaveDmaLen	rs.b	1	; in words (--> up to 512 bytes)

			rs.b	1	; Unused
			rs.b	1
			rs.b	1
			rs.b	1
			rs.b	1

synth8_VIBpara		rs.b	1	; the same param. like with effect '4'
synth8_vibdelay		rs.b	1	; framecnt
synth8_vibwave		rs.b	1	; sine,triangle,rectangle
synth8_WAVEspd		rs.b	1	; framecnt
synth8_WAVElen		rs.b	1
synth8_WAVErep		rs.b	1
synth8_WAVEreplen	rs.b	1
synth8_WAVErepCtrl	rs.b	1	; 0=Repeatnormal/1=Backwards/1=PingPong

			rsset	32-4
instr_Astart		rs.b	1	; Vol_startlevel
instr_Aadd		rs.b	1	; Zeit bis maximalLevel
instr_Aend		rs.b	1	; Vol_endlevel
instr_Asub		rs.b	1	; Zeit bis endlevel

playbit			dc.b	0
			even


;========================================================================
aon8_playcia:
			cmp.b	#0,playbit
			beq.b	aon8_playciaend
			movem.l	d1-a6,-(sp)
			
			bsr.w	aon8_play

			lea	mix_bypass(pc),a0
			moveq	#8-1,d7
			bsr.w	mix_startsamples

			movem.l	(sp)+,d1-a6
aon8_playciaend		moveq	#0,d0
			rts
;========================================================================
; IN:	d0=Startpos
;	d1=Mixperiod
;	a0=Moduleadr
;	a1=Bufferptr
; OUT:	d0= result (0=ok,-1=error occured)
AON_INIT
			movem.l	d1-d7/a0-a6,-(sp)

			lea	aon_channels,a4
			move	#aon_chdatasize*2-1,d7
.clrch			clr.l	(a4)+
			dbf	d7,.clrch


			cmp.l	#"AON8",(a0)
			bne.w	aon_notinitalized

			lea	aon_data(pc),a6
			move.b	#6,aon_speed(a6)
			move.b	d0,aon_pos(a6)

			move.l	a0,aon_modulestart(a6)

			lea	mix_buff1(pc),a2
			lea	mix_buff1hear(pc),a3
			move.l	a1,(a2)+		; workbuf
			lea	mix_buflen(a1),a1
			move.l	a1,(a3)+		; hearbuf
			lea	mix_buflen(a1),a1
			move.l	a1,(a2)+		; workbuf
			lea	mix_buflen(a1),a1
			move.l	a1,(a3)+		; hearbuf
			lea	mix_buflen(a1),a1
			move.l	a1,(a2)+		; workbuf
			lea	mix_buflen(a1),a1
			move.l	a1,(a3)+		; hearbuf
			lea	mix_buflen(a1),a1
			move.l	a1,(a2)+		; workbuf
			lea	mix_buflen(a1),a1
			move.l	a1,(a3)+		; hearbuf

			lea	mix_mixrate(pc),a1
			move	d1,(a1)

			move.l	#"INFO",d0
			bsr.w	aon_searchchunk
			move.l	a1,aon_statdata(a6)
			move.l	#"ARPG",d0
			bsr.w	aon_searchchunk
			move.l	a1,aon_arpdata(a6)
			move.l	#"PLST",d0
			bsr.w	aon_searchchunk
			move.l	a1,aon_posdata(a6)
			move.l	#"PATT",d0
			bsr.w	aon_searchchunk
			move.l	a1,aon_pattdata(a6)

			move.l	#"INST",d0
			bsr.w	aon_searchchunk

			lea	aon_instrstarts(a6),a2
			moveq	#61-1,d7
aon_initinstradrtab	move.l	a1,(a2)+
			lea	32(a1),a1
			dbf	d7,aon_initinstradrtab

			move.l	#"WLEN",d0
			bsr.b	aon_searchchunk
			move.l	a1,a3			; a3=ptr on wlen-tab
			move.l	#"WAVE",d0
			bsr.b	aon_searchchunk		; a1=ptr on wave-adr0
			lea	aon_wavestarts(a6),a2
			move.l	a1,d0
			moveq	#64-1,d7
aon_initwavetab		move.l	d0,(a2)+
			add.l	(a3)+,d0
			dbf	d7,aon_initwavetab

			lea	aon_channels+aon_trackvol(pc),a0
			moveq	#64,d0
			move	d0,aon_chdatasize*0(a0)
			move	d0,aon_chdatasize*1(a0)
			move	d0,aon_chdatasize*2(a0)
			move	d0,aon_chdatasize*3(a0)
			move	d0,aon_chdatasize*4(a0)
			move	d0,aon_chdatasize*5(a0)
			move	d0,aon_chdatasize*6(a0)
			move	d0,aon_chdatasize*7(a0)

;			bset	#1,$bfe001
			bclr	#1,$bfe001

;			bsr	allocCIAB
;			tst	d0
;			bmi	aon_notinitalized
			bsr.w	aon_resettimer

			bsr.w	mix_init

			move.l	$70,oldaudio(a6)
			lea	mix_play(pc),a1
			move.l	a1,$70
			move	#$c780,$dff09a

			movem.l	(sp)+,d1-d7/a0-a6
			moveq	#0,d0
			rts
aon_searchchunk		move.l	a0,a1
.search			cmp.l	(a1),d0
			beq.b	.ok
			addq.l	#2,a1
			bra.b	.search
.ok			addq.l	#8,a1
			rts


AON_NOTINITALIZED	movem.l	(sp)+,d1-d7/a0-a6
			moveq	#-1,d0		; yep,seems that an error
			rts			; has occured... bad luck..!

;========================================================================
AON_END
			lea	aon_data(pc),a6

			move	#$0780,$dff09a
			move.l	oldaudio(a6),$70

			;bsr	freeCIAB
			move	#$ff,$dff09e	; no modulation
			move	#$f,$dff096	; DMA off
			clr	$dff0a8
			clr	$dff0b8
			clr	$dff0c8
			clr	$dff0d8
			rts
;========================================================================
; a6=data
; get new step ...!
AON_GETDACHANNEL
			move.b	2(a0),aon_fxCOM(a4)	; needed l8r on
			and.b	#$3f,aon_fxcom(a4)
			move	2(a0),d0
			and	#$3fff,d0
			move.b	d0,d1
			move.b	d0,aon_fxDAT(a4)
			cmp.b	#$d,aon_fxcom(a4)
			bne.b	.nobreak
			cmp.b	#$100-4,aon_patcnt+1(a6)
			bne.b	.nobreak
			move.b	#$100-8,aon_patcnt+1(a6)
.nobreak

			and.b	#$f0,d0
			and.b	#$0f,d1

			clr.b	aon_stepfxcnt(a4)

			cmp.b	#16,aon_fxcom(a4)	; 'g' volset
			bne.b	.novoldel
			move.b	aon_fxdat(a4),d2
			and.b	#$f,d2
			move.b	d2,aon_stepfxcnt(a4)
			bra.b	aon_gdc_nomoreFX
.novoldel
			cmp	#$0ec0,d0
			bne.s	aon_gdc_nonotecut	; note cut ?
			move.b	d1,aon_stepfxcnt(a4)
			bra.b	aon_gdc_nomoreFX
aon_gdc_nonotecut
			cmp	#$0ee0,d0		; pattern delay?
			bne.s	aon_gdc_nopatdelay
			tst.b	aon_patdelaycnt+1(a6)	; delaying ?
			bpl.s	aon_gdc_nopatdelay
			move.b	d1,aon_patdelaycnt+1(a6) ; start delay!
			bra.b	aon_gdc_nomoreFX
aon_gdc_nopatdelay
			cmp	#$0e60,d0		; pattern loop?
			bne.s	aon_gdc_noloopreset
			cmp.b	#$f0,aon_loopcnt(a6)	; loop over flag set ?
			beq.s	aon_gdc_noloopreset
			tst.b	d1			; no loop?
			beq.s	aon_gdc_noloopreset

			tst.b	aon_loopcnt(a6)
			bne.s	aon_gdc_dothatloopin
			move.b	d1,aon_loopcnt(a6)	; write counter
aon_gdc_dothatloopin	subq.b	#1,aon_loopcnt(a6)	; continue looping!
			bne.s	aon_gdc_notjustlooped
			move.b	#$f0,aon_loopcnt(a6)	; loop over flag
aon_gdc_notjustlooped	move.b	#-1,aon_loopflag(a6)
aon_gdc_noloopreset

aon_gdc_nomoreFX
			moveq	#0,d0
			moveq	#0,d1
			moveq	#0,d5			; flag for useoldinstr
			move.b	1(a0),d1		; Get Instrnr.
			and.b	#%00111111,d1		; skip unused bits
			subq.b	#1,d1
			bpl.s	aon_gdc_notoldinstr	; -1-> old instr
			tst.l	aon_instrptr(a4)	; get last instrptr
			beq.w	aon_gdc_nonewnote	; no instrument ?!!
							; then exit
			move.l	aon_instrptr(a4),a2	; last instrptr
			move.b	(a0),d2
			and.b	#63,d2			; no note?
			beq.w	aon_gdc_nonewinstr	; then pause !
			moveq	#1,d5			; flag for useoldinstr
			cmp.b	#3,aon_fxcom(a4)
			beq.w	aon_gdc_nonewinstr
			cmp.b	#5,aon_fxcom(a4)
			beq.w	aon_gdc_nonewinstr
			cmp.b	#27,aon_fxcom(a4)
			beq.w	aon_gdc_nonewinstr
			cmp.b	#28,aon_fxcom(a4)
			beq.w	aon_gdc_nonewinstr
			bra.b	aon_gdc_useoldinstr
aon_gdc_notoldinstr	move.b	(a0),d2
			and.b	#63,d2			; no note?
			bne.s	aon_gdc_notchangerepeat	; then only set repeat

			add.b	d1,d1
			add.b	d1,d1
			lea	aon_instrstarts(a6),a2
			move.l	(a2,d1),a2

			tst.b	instr_control(a2)
			bne.w	aon_gdc_resetvolume.etc		;aon_gdc_notsameinstr


			cmp.l	aon_instrptr(a4),a2
			beq.w	aon_gdc_resetvolume.etc
			move.l	a2,aon_instrptr(a4)	; save in channeldata
			move.b	#01,aon_chflag(a4)	; 01=NEW REPEATWAVE
			bra.w	aon_startrepeat
aon_gdc_notchangerepeat
			clr.l	aon_oldsampoff(a4)

			add.b	d1,d1
			add.b	d1,d1
			lea	aon_instrstarts(a6),a2
			move.l	(a2,d1),a2

			cmp.l	aon_instrptr(a4),a2
			bne.s	aon_gdc_notsameinstr
			cmp.b	#3,aon_fxcom(a4)
			beq.w	aon_gdc_resetvolume.etc
			cmp.b	#5,aon_fxcom(a4)
			beq.w	aon_gdc_resetvolume.etc
			cmp.b	#27,aon_fxcom(a4)
			beq.w	aon_gdc_resetvolume.etc
			cmp.b	#28,aon_fxcom(a4)
			beq.w	aon_gdc_resetvolume.etc
aon_gdc_notsameinstr
			move.l	a2,aon_instrptr(a4)	; save in channeldata
aon_gdc_useoldinstr

			clr.b	aon_vibCONT(a4)
			bsr.w	aon_initADSR

			tst.b	instr_control(a2)	; Synthmode on??
			beq.w	aon_startsample
************* HIER NACH INSTRUMENTEN-TYPEN UNTERSCHEIDEN!!!!!!!!!!!!!********
************* HIER NACH INSTRUMENTEN-TYPEN UNTERSCHEIDEN!!!!!!!!!!!!!********
************* HIER NACH INSTRUMENTEN-TYPEN UNTERSCHEIDEN!!!!!!!!!!!!!********

; ---- INIT SYNTHETIC INSTRUMENT ---------------	16-juli-1994
aon_gdc_initsynth

			move.b	#1,aon_chMODE(a4)

			move	aon_fxcom(a4),d0
			move.b	d0,d1
			and.b	#$f0,d0

			cmp	#$0e90,d0		; retrig note?
			bne.s	.noretrigging
			and.b	#$0f,d1
			move.b	d1,aon_stepfxcnt(a4)
.noretrigging

			lea	aon_wavestarts(a6),a3

			move.b	(a0),d2			; Alter Fehler: Bei
			and.b	#63,d2			; Wechsel des Instr.
			beq.w	aon_gdc_resetvolume.etc	; wurde perslide re-
			clr	aon_perslide(a4)	; settet!

			moveq	#0,d3
			cmp.b	#17,aon_fxcom(a4)	; 'h'  synthcontrol?!
			bne.b	.noth
			move.b	aon_fxdat(a4),d3
.noth
			btst	#4,d3
			bne.w	.initvib

			cmp	#$0ed0,d0		; delay note?
			bne.s	.notdelaynote
			and.b	#$0f,d1
			move.b	d1,aon_stepfxcnt(a4)
			bra.b	.startrepeat
.notdelaynote		move.b	#3,aon_chflag(a4)	; 3=New WAVE
.startrepeat

			moveq	#0,d0
			move.b	instr_waveform(a2),d0	; Nr. of waveform
			move.b	d0,aon_actwavenr(a4)
			add	d0,d0
			add	d0,d0			; *4 (longword!)
			move.l	(a3,d0.l),d1		; Get address..
; d1=Address of actual waveform
			cmp.l	aon_waveform(a4),d1
			bne.b	.notsamewaveU
			clr.b	aon_chflag(a4)

			tst.b	aon_synthWAVECONT(a4)	; Wave
			bne.w	.initVIB		; NICHT resetten!!

.notsamewaveU		move.l	d1,aon_waveform(a4)

.checkoffset
			moveq	#0,d0
			move.b	synth8_partwaveDMALen(a2),d0

			cmp.b	#9,aon_fxcom(a4)
			bne.b	.notoffset
			moveq	#0,d2
			move.b	aon_fxdat(a4),d2
			mulu	d0,d2
			add.l	d1,d2
			move.l	d2,d1
;aon_synthwaveactptr(a4)
			tst.b	aon_synthWAVESTOP(a4)
			beq.b	.notoffset
			move.l	d1,aon_synthwaveactptr(a4)
			move.l	d1,aon_repeatstrt(a4)
			bra.b	.initVIB
.notoffset
			tst.b	aon_synthWAVESTOP(a4)
			bne.b	.initVIB

			move.l	d1,aon_synthwaveactptr(a4)


			move	aon_wavelen(a4),aon_oldwavelen(a4)

			move	d0,aon_wavelen(a4)
			move	d0,aon_replen(a4)

			add	d0,d0
			move.l	d0,aon_synthWAVEaddbytes(a4)

			moveq	#0,d2
			move.b	synth8_WAVErep(a2),d2
			mulu	d0,d2
			add.l	d1,d2
			move.l	d2,aon_repeatstrt(a4)

			moveq	#0,d2
			move.b	synth8_WAVElen(a2),d2
			mulu	d0,d2
			add.l	d1,d2
			move.l	d2,aon_synthWAVEendptr(a4)

			moveq	#0,d2
			move.b	synth8_WAVErep(a2),d2
			mulu	d0,d2
			add.l	d1,d2
			move.l	d2,aon_synthWAVErepptr(a4)

			moveq	#0,d2
			move.b	synth8_WAVEreplen(a2),d2
			add.b	synth8_WAVErep(a2),d2
			mulu	d0,d2
			add.l	d1,d2
			move.l	d2,aon_synthWAVErependptr(a4)

			move.b	synth8_WAVEspd(a2),aon_synthWAVEcnt(a4)
			move.b	synth8_WAVEspd(a2),aon_synthWAVEspd(a4)
			move.b	synth8_WAVErepctrl(a2),aon_synthWAVERepctrl(a4)


; Vibrato initalisieren
.initvib
;			btst	#0,d3			; Restart
;			beq.b	.vibke			; Volume
;			clr.b	aon_synthENV(a4)	; Envelope ?!?
;.vibke
			clr.b	aon_vibON(a4)
			cmp.b	#3,synth8_vibwave(a2)	; 'Off' ?!
			beq.b	.vibOFF

			moveq	#0,d1
			move.b	synth8_vibdelay(a2),d1
			move	d1,aon_vibratotrigdelay(a4)
			moveq	#0,d1
			move.b	synth8_vibpara(a2),d1
			bne.b	.vib
			move	#-2,aon_vibratotrigdelay(a4)
			bra.b	.novib
.vib			move.l	a2,-(sp)
			bsr.w	aon_dofx_vibratoPARAM	; set parameters
			move.l	(sp)+,a2
			move.b	synth8_vibwave(a2),d0
			ror.b	#3,d0
			and.b	#%10011111,aon_vibratoampl(a4)
			or.b	d0,aon_vibratoampl(a4)
			move.b	#1,aon_vibCONT(a4)
			
.novib
			bra.w	aon_gdc_resetvolume.etc
.vibOFF			move.b	#"!",aon_vibon(a4)
			bra.w	aon_gdc_resetvolume.etc

; --------------------- INIT SAMPLE8BIT INSTRUMENT ----------------------
aon_startsample

			move.b	#"!",aon_vibON(a4)
			clr.b	aon_chMODE(a4)
			move	aon_fxcom(a4),d0
			move.b	d0,d1
			and.b	#$f0,d0

			cmp	#$0ed0,d0		; delay note?
			bne.s	aon_gdc_notdelaynote
			and.b	#$0f,d1
			move.b	d1,aon_stepfxcnt(a4)
			bra.b	aon_startrepeat
aon_gdc_notdelaynote
			cmp	#$0e90,d0		; retrig note?
			bne.s	aon_gdc_noretrigging
			and.b	#$0f,d1
			move.b	d1,aon_stepfxcnt(a4)
aon_gdc_noretrigging
			move.b	#03,aon_chflag(a4)	; 03=New SAMPLEWAVE
aon_startrepeat		lea	aon_wavestarts(a6),a3

;			cmp.b	#$3,aon_fxcom(a4)
;			beq.w	.resetper
;		cmp.b	#$5,aon_fxcom(a4)
;		bne.b	.noresetper
;.resetper
			move.b	(a0),d2			; Alter Fehler: Bei
			and.b	#63,d2			; Wechsel des Instr.
			beq.b	.noresetper		; wurde perslide re-
			clr	aon_perslide(a4)	; settet!
.noresetper			

			moveq	#0,d0
			move.b	instr_waveform(a2),d0	; Nr. of waveform
			move.b	d0,aon_actwavenr(a4)
			add	d0,d0
			add	d0,d0			; *4 (longword!)
			move.l	(a3,d0.l),d1		; Get address..
; d1=Address of actual waveform

			move.l	sample8_dmalen(a2),d4
			move	aon_wavelen(a4),aon_oldwavelen(a4)
			move	d4,aon_wavelen(a4)

			tst.l	sample8_dmareplen(a2)	; Is there any repeat?!
			bne.b	sample8_TheresARepeat
			move.l	a2,-(sp)
			lea	aon_leer(pc),a2
			move.l	a2,aon_repeatstrt(a4)
			move.l	(sp)+,a2
			move	#1,aon_replen(a4)
			bra.b	sample8_theresNoRepeat
sample8_theresARepeat

			move.l	sample8_dmarepoffset(a2),d2

		tst.b	aon_oversize(a6)
		bne.b	sample8_notzerorep
		tst.l	d2
		bne.b	sample8_NotzeroRep	; sonst sind keine
						; samples >128k mglich
		move.l	d1,aon_repeatstrt(a4)	;!!!!!!!!!!!!!!!!
		move	sample8_dmareplen+2(a2),aon_replen(a4)
		bra.b	sample8_zeroRep
sample8_NotzeroRep
			move.l	d2,d3		; save repeatstart in WORDS
			add.l	d2,d2
			add.l	d1,d2
			move.l	d2,aon_repeatstrt(a4)
			moveq	#0,d2
			move	sample8_dmareplen+2(a2),d2	; get repeatlen
			move	d2,aon_replen(a4)	; replen in WORDS

		tst.b	aon_oversize(a6)
		bne.b	sample8_zerorep
		add	d3,d2		; replen+repstart=wavelen
		move	d2,aon_wavelen(a4)

sample8_zeroRep
sample8_theresNorepeat
			move.l	sample8_dmaoffset(a2),d2
			add.l	d2,d2			; get bytesize!

			move.l	aon_oldsampoff(a4),d4
			lsr.l	#1,d4
			sub	d4,aon_wavelen(a4)	; offset from last com

			cmp.b	#9,aon_fxcom(a4)	; effect 'SAMPOFF'
			bne.s	aon_gdc_nonewsampoff	; no ??

			moveq	#0,d3
			move.b	aon_fxdat(a4),d3	; get offset
			lsl	#8,d3			; ->*256

			move.l	d3,d4
			lsr.l	#1,d4
			sub	d4,aon_wavelen(a4)
			bpl.s	aon_gdc_usesampoff
			move.l	aon_repeatstrt(a4),aon_waveform(a4)
			move	aon_replen(a4),aon_wavelen(a4)
			bra.b	aon_gdc_offendofsample
aon_gdc_usesampoff	add.l	d3,aon_oldsampoff(a4)
aon_gdc_nonewsampoff	
			add.l	d1,d2			; Realstart of wave
			add.l	aon_oldsampoff(a4),d2	; add offset
			move.l	d2,aon_waveform(a4)
aon_gdc_offendofsample
aon_gdc_resetvolume.etc

			tst.b	d5
			bne.s	aon_gdc_nonewinstr
			move.b	instr_volume(a2),aon_volume(a4)
; -----------------------------------

aon_gdc_nonewinstr

			moveq	#0,d0
			move.b	(a0),d0			; Get note
			and.b	#%00111111,d0
			bne.s	aon_gdc_notefound	; 0=Pause

			move.b	aon_lastnote(a4),d0	; Use last note!
			beq.w	aon_gdc_nonewnote
			cmp	#60,d0
			bgt.w	aon_gdc_nonewnote	; >B-3? -->pause!!!
			bra.b	aon_gdc_getarpeggio	; no instr retrig!!

aon_gdc_notefound	
			clr.b	aon_slideflag(a4)
			move.b	d0,aon_lastnote(a4)
			cmp	#60,d0
			bgt.w	aon_gdc_nonewnote	; >B-3? -->pause!!!

aon_gdc_getarpeggio
			move.l	aon_arpdata(a6),a3
			moveq	#0,d2
			moveq	#0,d3
			move.b	2(a0),d2
			move.b	1(a0),d3
			and.b	#%11000000,d2		; upper
			and.b	#%11000000,d3		; and lower 2 bits
			rol.b	#6,d2			; of arp.nr to use
			rol.b	#4,d3
			or.b	d2,d3			; *4 (4bytes/arp)

			lea	(a3,d3.l),a3		; get pointer on arpdat

			moveq	#0,d2
			move.b	instr_finetune(a2),d2	; get da finetune!!
			add	d2,d2
			move	(a5,d2.l),d2		; *120 (pertabsize)

			subq.b	#1,d0			; skip 'pause' mark
			add	d0,d0
			add	d0,d2			; offset in pertab

			cmp.b	#27,aon_fxcom(a4)
			beq.b	aon_arpslide
			cmp.b	#28,aon_fxcom(a4)
			beq.b	aon_arpslide
			cmp.b	#5,aon_fxcom(a4)
			beq.b	aon_arpslide
			cmp.b	#3,aon_fxcom(a4)
			bne.b	aon_notarpslide
aon_arpslide		move.b	(a0),d0
			and.b	#$3f,d0
			beq.b	aon_notarpslide
			move.b	#1,aon_slideflag(a4)
			lea	aon_periods(pc),a1
			move	(a1,d2.l),d1

			move	aon_period(a4),d0
			add	aon_perslide(a4),d0
			sub	d1,d0			; -actual periode=diff.
			move	d0,aon_perslide(a4)

;;;;;bra	aon_notarpslide

AON_notarpslide
			lea	aon_arpeggiotab(a4),a1
			cmp	#-1,2(a1)		; arpeggio im letzten
			bne.b	aon_NoArpReset		; step aktiv ?!
			clr	aon_arpeggiooff(a4)
			clr.b	aon_arpeggiocnt(a4)
aon_noarpreset
			tst.b	aon_fxcom(a4)
			bne.b	aon_gdc_noproarp
			tst.b	aon_fxdat(a4)
			beq.s	aon_gdc_noproarp
; Protracker-Arpeggio (fxcom=0) auslesen
			moveq	#0,d0
			moveq	#0,d1
			move.b	aon_fxdat(a4),d0
			move.b	d0,d1
			and.b	#$f0,d0
			and.b	#$0f,d1
			lsr.b	#4,d0
			add	d0,d0
			add	d1,d1
			move	d2,(a1)+
			add	d2,d0
			add	d2,d1
			move	d0,(a1)+
			move	d1,(a1)+
			bra.b	aon_gdc_arpend
aon_gdc_noproarp
; Professional arpeggio
			moveq	#0,d0
			moveq	#0,d1
			move.b	(a3)+,d0	; 1.nibble=anzahl arpeggios
			move.b	d0,d1
			lsr.b	#4,d0
			beq.b	aon_gdc_emptyarp	; arp_entry leer?!?!
			and.b	#$f,d1
			add	d1,d1
			add	d2,d1
			move	d1,(a1)+
			subq.b	#1,d0
			beq.b	aon_gdc_arpend
AON_GDC_writearps	moveq	#0,d1
			moveq	#0,d3
			move.b	(a3)+,d1	; 2 nibbles holen
			move.b	d1,d3
			lsr.b	#4,d1
			and.b	#$f,d3
			add	d1,d1
			add	d3,d3
			add	d2,d1
			move	d1,(a1)+
			subq.b	#1,d0
			beq.b	aon_gdc_arpend
			add	d2,d3
			move	d3,(a1)+
			subq.b	#1,d0
			bne.b	aon_gdc_writearps
aon_gdc_arpend		move	#-1,(a1)
aon_gdc_nonewnote	rts
aon_gdc_emptyarp
			clr	aon_arpeggiooff(a4)
			move.b	aon_arpeggiospd(a4),aon_arpeggiocnt(a4)
			subq.b	#1,aon_arpeggiocnt(a4)
			move	d2,(a1)+
			bra.b	aon_gdc_arpend
;========================================================================
; Vol-Envelope initalisieren
;
; Start		0-255
; Add 0-255 bis	255
; Sub 0-255 bis
; End		0-255

;
; a2=Instrumentdata
; a4=Channeldata
aon_initADSR:		
			cmp.b	#17,aon_fxcom(a4)
			bne.b	.notH
			move.b	aon_fxdat(a4),d3
			btst	#0,d3
			bne.b	.exit
.notH
			move.b	instr_Astart(a2),aon_synthVOL(a4)
			move.b	instr_Aadd(a2),d0
			beq.b	.noADSR
			move.b	d0,aon_synthADD(a4)
			move.b	instr_Asub(a2),aon_synthSUB(a4)
			move.b	instr_Aend(a2),aon_synthEND(a4)

			move.b	#1,aon_synthENV(a4)	; Envelope ADD
.exit			rts

.noADSR			move.b	#127,aon_synthVOL(a4)
			clr.b	aon_synthENV(a4)	; Envelope OFF
			rts

;========================================================================
; dont change a1!!!!!!1
; a4=chptr
AON_DOSYNTH
			clr.b	aon_vibDONE(a4)
			tst.b	aon_chflag(a4)
			bne.w	.exit
			tst.b	aon_chMODE(a4)		; isssees n sample?!
			beq.w	.exitSMPL
			tst.l	aon_waveform(a4)	; keine wellenform !?!
			beq.w	.exit

			tst.b	aon_synthwaveSTOP(a4)
			bne.w	.nonewwave


			addq.b	#1,aon_synthWAVEcnt(a4)
			move.b	aon_synthWAVEspd(a4),d0
			cmp.b	aon_synthWAVEcnt(a4),d0	; framecnt
			bgt.w	.nonewWAVE
			clr.b	aon_synthWAVEcnt(a4)
			move.l	aon_synthWAVEaddbytes(a4),d0
			add.l	d0,aon_synthWAVEactptr(a4)

			tst.l	d0	; partwave wandert nach links?!?!
			bpl.b	.rightloop
			move.l	aon_synthWAVErepptr(a4),d0	; links clippen
			cmp.l	aon_synthWAVEactptr(a4),d0
			ble.b	.notwaveend
			bra.b	.jumprepeat
.rightloop
			move.l	aon_synthWAVEendptr(a4),d0	;rechts clippen
			cmp.l	aon_synthWAVEactptr(a4),d0
			bgt.b	.notwaveend
.jumprepeat		tst.b	aon_synthWAVERepctrl(a4)
			beq.b	.normalrep
			cmp.b	#1,aon_synthWAVERepctrl(a4)
			beq.b	.backrep

.pingpong
		move.l	aon_synthWAVErependptr(a4),aon_synthWAVEendptr(a4)
			move.l	aon_synthwaveaddbytes(a4),d0
			sub.l	d0,aon_synthWAVEactptr(a4)
			neg.l	d0
			move.l	d0,aon_synthwaveaddbytes(a4)
			bra.b	.notwaveend

.normalrep		move.l	aon_synthWAVErepptr(a4),aon_synthWAVEactptr(a4)
		move.l	aon_synthWAVErependptr(a4),aon_synthWAVEendptr(a4)
			bra.b	.notwaveend
.backrep	move.l	aon_synthwaveRependptr(a4),aon_synthwaveActptr(a4)
			move.l	aon_synthwaveaddbytes(a4),d0
			bmi.b	.alreadyNeg
			neg.l	d0
			tst.b	aon_synthWAVESTOP(a4)
			bne.b	.notwaveend
.alreadyNeg		add.l	d0,aon_synthWAVEactptr(a4)
			move.l	d0,aon_synthwaveaddbytes(a4)
.notwaveend
			move.b	#1,aon_chflag(a4)	; new repoff

;		cmp.b	#9,aon_fxcom(a4)
;		beq.b	.setit
.setit			move.l	aon_synthWAVEactptr(a4),aon_repeatstrt(a4)
.nonewWAVE


.exitSMPL
; DO Envelope

			tst.b	aon_synthENV(a4)
			beq.b	.dovib
			moveq	#0,d0
			move.b	aon_synthVOL(a4),d0
			cmp.b	#1,aon_synthENV(a4)
			bne.b	.decay
			add.b	aon_synthADD(a4),d0
			bpl.b	.newVOL
			moveq	#127,d0
			move.b	#2,aon_synthENV(A4)
			bra.b	.newVOL
.decay			sub.b	aon_synthSUB(a4),d0
			cmp.b	aon_synthEND(a4),d0
			bgt.b	.newVOL
			move.b	aon_synthEND(a4),d0
			clr.b	aon_synthENV(a4)
.newVOL			move.b	d0,aon_synthVOL(a4)


; Vibrato
.dovib
			cmp.b	#"!",aon_vibON(a4)
			beq.b	.vibok
			cmp	#-1,aon_vibratoTRIGdelay(a4)
			bne.b	.delayvib
			move.b	#1,aon_vibON(a4)
			bra.b	.vibok
.delayvib		subq	#1,aon_vibratoTRIGdelay(a4)
.vibok

.exit
			cmp.b	#1,aon_vibON(a4)
			bne.b	.VIBoff
			bra.w	aon_dofx_viboldampl
.VIBoff			rts
;========================================================================
; a4=channelptr
; don't use a1
AON_DOFX
			tst.b	aon_vibCONT(a4)
			bne.b	.dauervibrato
			move.b	#"!",aon_vibON(a4)
.dauervibrato

			addq.b	#1,aon_arpeggiocnt(a4)
			move.b	aon_arpeggiospd(a4),d0	; time for arpeggio
			cmp.b	aon_arpeggiocnt(a4),d0	; tone-change ?!
			bgt.s	aon_dofx_nonewarpval

			clr.b	aon_arpeggiocnt(a4)	; clear counter

aon_dofx_newarpval	move	aon_arpeggiooff(a4),d1	; offset in tab
			lea	aon_arpeggiotab(a4),a3
			moveq	#0,d7
			move	(a3,d1),d7		; get act. note
			bpl.s	aon_dofx_notarpend
			clr	aon_arpeggiooff(a4)
			bra.b	aon_dofx_newarpval
aon_dofx_notarpend
			lea	aon_periods(pc),a3
			move	(a3,d7.l),d0		; get periode
			move	d0,aon_period(a4)	; store in chdata
			addq.b	#2,aon_arpeggiooff+1(a4) ; next value
			and.b	#$0f,aon_arpeggiooff+1(a4)
aon_dofx_nonewarpval

			lea	aon_doSYNTH(pc),a2
			move.l	a2,-(sp)
;bsr	aon_dosynth

			moveq	#0,d0
			moveq	#0,d1
			move.b	aon_fxdat(a4),d1

			move.b	aon_fxcom(a4),d0
			beq.w	aon_dofx_end

			tst.b	aon_framecnt(a6)
			beq.b	aon_dofx_atonce

			cmp.b	#1,d0
			beq.w	aon_dofx_portamentoup
			cmp.b	#$2,d0
			beq.w	aon_dofx_portamentodown
			cmp.b	#$3,d0
			beq.w	aon_dofx_toneslide
			cmp.b	#$4,d0
			beq.w	aon_dofx_vibrato
			cmp.b	#$5,d0
			beq.w	aon_dofx_glissvolumeslide
			cmp.b	#$6,d0
			beq.w	aon_dofx_vibvolumeslide
			cmp.b	#$a,d0
			beq.w	aon_dofx_volumeslide
aon_dofx_atonce
			cmp.b	#$b,d0
			beq.w	aon_dofx_breakto
			cmp.b	#$c,d0
			beq.w	aon_dofx_setvolume
			cmp.b	#$d,d0
			beq.w	aon_dofx_breakpat
			cmp.b	#$e,d0
			beq.w	aon_dofx_ecommands
			cmp.b	#$f,d0
			beq.w	aon_dofx_setspd
			cmp.b	#16,d0		'g'
			beq.w	aon_dofx_setvoldel
			cmp.b	#18,d0		'i'
			beq.w	aon_dofx_setwaveadsrspd
			cmp.b	#19,d0		'j'
			beq.w	aon_dofx_setarpspd
			cmp.b	#20,d0		'k'
			beq.w	aon_dofx_vibsetvolume
			cmp.b	#21,d0		'l'
			beq.w	aon_dofx_portvolslideUP
			cmp.b	#22,d0		'm'
			beq.w	aon_dofx_portvolslideDOWN
			cmp.b	#23,d0		'n'
			beq.w	aon_dofx_togglenoiseavoid
			cmp.b	#24,d0		'o'
			beq.w	aon_dofx_toggleoversize
			cmp.b	#25,d0		'p'
			beq.w	aon_dofx_fineVOLslidevib
			cmp.b	#26,d0		'q'
			beq.w	aon_dofx_synthdrums
			cmp.b	#27,d0		'r'
			beq.w	aon_dofx_setvolumePort
			cmp.b	#28,d0		's'
			beq.w	aon_dofx_finevolslidePort
			cmp.b	#29,d0		't'
			beq.w	aon_dofx_settrackvol
			cmp.b	#30,d0		'u'
			beq.w	aon_dofx_setwavecont
			cmp.b	#33,d0		'x'
			beq.w	aon_dofx_externalevent
aon_dofx_end		rts
; --------------------------------------------------------------------
; $1
aon_dofx_portamentoup
			sub	d1,aon_perslide(a4)
			rts
; --------------------------------------------------------------------
; $2
aon_dofx_portamentodown
			add	d1,aon_perslide(a4)
			rts
; --------------------------------------------------------------------
; $3
aon_dofx_toneslide	tst.b	d1
			beq.b	aon_dofx_toneslideNOW
			move.b	d1,aon_glissspd(a4)
aon_dofx_toneslideNOW
			tst.b	aon_slideflag(a4)
			beq.b	.exit
			move.b	aon_glissspd(a4),d1
			tst	aon_perslide(a4)
			beq.b	aon_dofx_end
			bpl.b	.sub
			add	d1,aon_perslide(a4)
			bmi.b	aon_dofx_end
			clr	aon_perslide(a4)
			rts
.sub			sub	d1,aon_perslide(a4)
			bpl.b	aon_dofx_end
			clr	aon_perslide(a4)
.exit			rts
; --------------------------------------------------------------------
; $4
aon_dofx_vibrato
			move.b	#1,aon_vibON(a4)
aon_dofx_vibratoPARAM
			tst.b	d1
			beq.b	.goon		; Vibrato-Parameter
			move.b	d1,d2		; setzen!!
			and.b	#$f0,d1
			lsr.b	#4,d1
			beq.b	.oldspd
			move.b	d1,aon_vibratospd(a4)
.oldspd			and.b	#$0f,d2
			beq.s	.goon
			and.b	#$f0,aon_vibratoampl(a4)
			or.b	d2,aon_vibratoampl(a4)
.goon			rts

; Einsprung um Vibrato-Effekt zu erzeugen
aon_dofx_viboldampl	
			tst.b	aon_vibdone(a4)	; Nur 1 Vibrato zur Zeit
			bne.b	aon_dofx_vibnotend
			move.b	#1,aon_vibdone(a4)

			moveq	#0,d2
			move.b	aon_vibratoampl(a4),d2
			and.b	#%01100000,d2
			beq.s	aon_dofx_vibSINE
			cmp.b	#32,d2
			beq.s	aon_dofx_vibRAMPDOWN
			lea	aon_vibrato_square(pc),a2
			bra.b	aon_dofx_vibSQUARE
aon_dofx_vibRAMPDOWN	lea	aon_vibrato_rampdown(pc),a2
			bra.b	aon_dofx_vibsquare
aon_dofx_vibSINE	lea	aon_vibrato_sine(pc),a2
aon_dofx_vibSQUARE
			move.b	aon_vibratopos(a4),d2
			moveq	#0,d0

			move.b	(a2,d2),d2		; vibrato-value
			move.b	aon_vibratoampl(a4),d0
			and.b	#$f,d0
			mulu	d0,d2			; *vibrato amplitude
			lsr	#7,d2

			move	aon_period(a4),d0	; period (smaller)

			btst	#7,aon_vibratoampl(a4)	; negativ ?
			beq.s	aon_dofx_vibpositiv
			sub	d2,d0
			bra.b	aon_dofx_vibnegativ
aon_dofx_vibpositiv
			add	d2,d0
aon_dofx_vibnegativ
			move	d0,aon_period(a4)

			move.b	aon_vibratospd(a4),d0
			add.b	d0,aon_vibratopos(a4)
			btst	#5,aon_vibratopos(a4)
			beq.s	aon_dofx_vibnotend
			and.b	#$1f,aon_vibratopos(a4)
			bchg	#7,aon_vibratoampl(a4)	; toggle pos/neg
aon_dofx_vibnotend	rts
; --------------------------------------------------------------------
; $5
aon_dofx_glissvolumeslide
			move	d1,-(sp)
			moveq	#0,d1
			bsr.w	aon_dofx_toneslideNOW
			move	(sp)+,d1
			bra.b	aon_dofx_volumeslide
; --------------------------------------------------------------------
; $6
aon_dofx_vibvolumeslide	move	d1,-(sp)
			bsr.w	aon_dofx_viboldampl
			move	(sp)+,d1
			bra.w	aon_dofx_volumeslide
; --------------------------------------------------------------------
; $A
aon_dofx_volumeslide	move.b	d1,d2
			and.b	#$0f,d1
			and.b	#$f0,d2
			lsr.b	#4,d2
			tst.b	d2	; Protracker-Kompatibilitt:
			bne.s	aon_dofx_vsok1	; Wenn volume slide up <>0
			; dann volume slide down nicht beachten!!
			sub.b	d1,aon_volume(a4)
			bpl.s	aon_dofx_vsok1
			clr.b	aon_volume(a4)
aon_dofx_vsok1		add.b	d2,aon_volume(a4)
			cmp.b	#64,aon_volume(a4)
			bls.s	aon_dofx_vsOK2
			move.b	#64,aon_volume(a4)
aon_dofx_vsok2		rts
; --------------------------------------------------------------------
; $B
aon_dofx_breakto
			subq.b	#1,d1
			move.b	d1,aon_pos(a6)
			move	#$ff00,aon_patcnt(a6)
			rts
; --------------------------------------------------------------------
; $C
aon_dofx_setvolume	move.b	d1,aon_volume(a4)
			rts
; --------------------------------------------------------------------
; $D
aon_dofx_breakpat
			move.b	d1,d0		; e.g	$32 -> #32
			and.b	#$0f,d1
			and.b	#$f0,d0
			lsr.b	#1,d0		; -> $30->$18=#24
			move.b	d0,d2
			lsr.b	#3,d2		; -> $18/8->$03
			add.b	d2,d0		; #24+3
			add.b	d2,d0		; #27+3 (=#30)
			add.b	d1,d0		; +2!
			add.b	d0,d0		; =#32
			add.b	d0,d0		; ->*4
			or	#$ff00,d0	; add breakflag
			move	d0,aon_patcnt(a6)
			rts
; --------------------------------------------------------------------
; $F
aon_dofx_setspd
			tst.b	d1
			beq.b	aon_dofx_replayend

			cmp.b	#32,d1
			bhi.b	.settempo2
			move.b	d1,aon_speed(a6)
.quit			rts

.settempo2		cmp.b	#200,d1
			bhi.b	.quit
			move.l	#aon_timerval,d0
			divu	d1,d0

			move.b	d1,aon_tempo(a6)
aon_dofx_settempo		
			bsr.w	aon_setSpeed
aon_dofx_vbireplay
			rts
aon_dofx_replayend	clr.b	aon_speed(a6)
			bsr.w	AON_Songend
aon_resettimer		move.b	#125,aon_tempo(a6)

			move.l	#aon_timerval,d0
			divu	#125,d0
			bsr.w	aon_setSpeed
			rts
; --------------------------------------------------------------------
; | E1- FineSlide Up                  E1x : value			   |
; | E2- FineSlide Down                E2x : value			   |
; | E3- Glissando Control             E3x : 0-off, 1-on (use with tonep.)  |
; | E4- Set Vibrato Waveform          E4x : 0-sine, 1-ramp down, 2-square  |
; | E5- Set Loop                      E5x : set loop point		   |
; | E6- Jump to Loop                  E6x : jump to loop, play x times	   |
; | E7- Set Tremolo Waveform          E7x : 0-sine, 1-ramp down. 2-square  |
; | E8- NOT USED							   |
; | E9- Retrig Note                   E9x : retrig from note + x vblanks   |
; | EA- Fine VolumeSlide Up           EAx : add x to volume		   |
; | EB- Fine VolumeSlide Down         EBx : subtract x from volume	   |
; | EC- NoteCut                       ECx : cut from note + x vblanks	   |
; | ED- NoteDelay                     EDx : delay note x vblanks	   |
; | EE- PatternDelay                  EEx : delay pattern x notes	   |
; | EF- Invert Loop                   EFx : speed			   |
; $Ex
aon_dofx_ECOMMANDS	move.b	d1,d0
			and.b	#$0f,d1
			and.b	#$f0,d0
			beq.s	aon_dofx_setfilter
			cmp.b	#$10,d0
			beq.s	aon_dofx_fineportamentoup
			cmp.b	#$20,d0
			beq.s	aon_dofx_fineportamentodn
			cmp.b	#$40,d0
			beq.s	aon_dofx_setvibratowave
			cmp.b	#$50,d0
			beq.b	aon_dofx_setlooppoint
			cmp.b	#$60,d0
			beq.b	aon_dofx_jump2loop
			cmp.b	#$90,d0
			beq.b	aon_dofx_retrignote
			cmp.b	#$a0,d0
			beq.w	aon_dofx_finevolup
			cmp.b	#$b0,d0
			beq.w	aon_dofx_finevoldn
			cmp.b	#$c0,d0
			beq.w	aon_dofx_notecut
			cmp.b	#$d0,d0
			beq.b	aon_dofx_retrignote
			rts
; --------------------------------------------------------------------
; $E0
aon_dofx_setfilter	tst.b	d1
			beq.s	aon_dofx_filteron
			bset	#1,$bfe001

			rts
aon_dofx_filteron	bclr	#1,$bfe001

			rts
; --------------------------------------------------------------------
; $E1
aon_dofx_fineportamentoup
			tst.b	aon_framecnt(a6)
			bne.s	aon_dofx_tool8
			sub	d1,aon_perslide(a4)
aon_dofx_tool8		rts
; --------------------------------------------------------------------
; $E2
aon_dofx_fineportamentodn
			tst.b	aon_framecnt(a6)
			bne.s	aon_dofx_tool82
			add	d1,aon_perslide(a4)
aon_dofx_tool82		rts
; --------------------------------------------------------------------
; $E4
aon_dofx_setvibratowave
			and.b	#3,d1
			ror.b	#3,d1
			and.b	#%10011111,aon_vibratoampl(a4)
			or.b	d1,aon_vibratoampl(a4)
			rts
; --------------------------------------------------------------------
; $E5
aon_dofx_setlooppoint
			move.b	aon_patcnt+1(a6),d0
			subq.b	#4,d0
			cmp.b	aon_looppoint(a6),d0
			beq.s	aon_dofx_justloopin
			move.b	d0,aon_looppoint(a6)
			clr.b	aon_loopcnt(a6)
aon_dofx_justloopin	rts
; --------------------------------------------------------------------
; $E6
aon_dofx_jump2loop
			tst.b	d1
			beq.s	aon_dofx_setlooppoint
			rts
; --------------------------------------------------------------------
; $E9
aon_dofx_retrignote	tst.b	aon_stepfxcnt(a4)
			bne.s	aon_dofx_noretrig
			move.b	#3,aon_chflag(a4)
			move.b	#$ef,aon_fxcom(a4)
			rts
aon_dofx_noretrig	subq.b	#1,aon_stepfxcnt(a4)
			rts
; --------------------------------------------------------------------
; $EA
aon_dofx_finevolup
			tst.b	aon_framecnt(a6)
			bne.s	aon_dofx_volresisup
			add.b	d1,aon_volume(a4)
			cmp.b	#64,aon_volume(a4)
			ble.s	aon_dofx_volresisup
			move.b	#64,aon_volume(a4)
aon_dofx_volresisup	rts
; --------------------------------------------------------------------
; $EB
aon_dofx_finevoldn	tst.b	aon_framecnt(a6)
			bne.s	aon_dofx_volresisdn
			sub.b	d1,aon_volume(a4)
			bpl.s	aon_dofx_volresisdn
			clr.b	aon_volume(a4)
aon_dofx_volresisdn	rts
; --------------------------------------------------------------------
; $EC
aon_dofx_notecut	tst.b	aon_stepfxcnt(a4)
			bne.s	.nonotecut
			clr.b	aon_volume(a4)
			rts
.nonotecut		subq.b	#1,aon_stepfxcnt(a4)
			rts
; --------------------------------------------------------------------
; 'g'
aon_dofx_setvoldel
			tst.b	aon_stepfxcnt(a4)
			bne.b	.novolset
			and.b	#$f0,d1
			lsr.b	#4,d1
			add.b	d1,d1
			add.b	d1,d1
			addq.b	#4,d1
			move.b	d1,aon_volume(a4)
			rts
.novolset		subq.b	#1,aon_stepfxcnt(a4)
			rts
; --------------------------------------------------------------------
; 'i'
aon_dofx_setwaveadsrspd
			move.b	d1,d2
			and.b	#$f0,d1
			lsr.b	#4,d1
			move.b	d1,aon_synthWAVEspd(a4)
			rts
; --------------------------------------------------------------------
; 'j'
aon_dofx_setarpspd	and.b	#$f,d1
			beq.b	.not
			move.b	d1,aon_arpeggiospd(a4)
.not			rts
; --------------------------------------------------------------------
; 'k'
aon_dofx_vibsetvolume	move	d1,-(sp)
			bsr.w	aon_dofx_viboldampl
			move	(sp)+,d1
			bra.w	aon_dofx_setvolume
; --------------------------------------------------------------------
; 'l'
aon_dofx_portvolslideUP
			lea	aon_nibbletab(pc),a0
			move	d1,d2
			lsr.b	#4,d1
			and.b	#$f,d2
			move.b	(a0,d1),d1
			bpl.b	.up1
			neg.b	d1
			bsr.b	aon_dofx_finevolDN
			bra.b	.down1
.up1			bsr.w	aon_dofx_finevolUP
.down1
			tst.b	aon_framecnt(a6)
			beq.b	.out
			moveq	#0,d1
			move.b	d2,d1
			bsr.w	aon_dofx_portamentoup

.out			rts

aoN_nibbletab		dc.b	0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1
; --------------------------------------------------------------------
; 'm'
aon_dofx_portvolslideDOWN
			lea	aon_nibbletab(pc),a0
			move	d1,d2
			lsr.b	#4,d1
			and.b	#$f,d2
			move.b	(a0,d1),d1
			bpl.b	.up1
			neg.b	d1
			bsr.w	aon_dofx_finevolDN
			bra.b	.down1
.up1			bsr.w	aon_dofx_finevolUP
.down1
			tst.b	aon_framecnt(a6)
			beq.b	.out
			moveq	#0,d1
			move.b	d2,d1
			bsr.w	aon_dofx_portamentoDOWN

.out			rts
; --------------------------------------------------------------------
; 'n'
aon_dofx_togglenoiseavoid
			move.b	d1,aon_noiseavoid(a6)
			rts
; --------------------------------------------------------------------
; 'o'
aon_dofx_toggleoversize
			move.b	d1,aon_oversize(a6)
			rts
; --------------------------------------------------------------------
; 'p'
aon_dofx_fineVOLslidevib
			move	d1,-(sp)
			bsr.w	aon_dofx_viboldampl
			move	(sp)+,d1
aon_dofx_fineVOlUpDown	moveq	#0,d2
			move.b	d1,d2
			lsr.b	#4,d2
			beq.b	.no
			move	d2,d1
			bra.w	aon_dofx_finevolup
.no			and.b	#$f,d1
			bra.w	aon_dofx_finevoldn
; --------------------------------------------------------------------
; 'q'
aon_dofx_synthdrums
			move	d1,d2
			lsr	#4,d1
			lsl	#3,d1
			bsr.w	aon_dofx_portamentodown
			move	d2,d1
			and	#$f,d1
			bra.w	aon_dofx_volumeslide
; --------------------------------------------------------------------
; 'r'
aon_dofx_setvolumePort
			move	d1,-(sp)
			bsr.w	aon_dofx_toneslideNOW
			move	(sp)+,d1
			bra.w	aon_dofx_setvolume
; --------------------------------------------------------------------
; 's'
aon_dofx_finevolslidePort
			move	d1,-(sp)
			bsr.w	aon_dofx_toneslideNOW
			move	(sP)+,d1
			bra.b	aon_dofx_fineVOlUpDown
; --------------------------------------------------------------------
; 't'
aon_dofx_settrackvol
			move	d1,aon_trackvol(a4)
			rts
; --------------------------------------------------------------------
; 'u'
;
aon_dofx_setwavecont	move.b	d1,d2
			and.b	#$f,d1
			move.b	d1,aon_synthWAVECONT(a4)
			lsr.b	#4,d2
			move.b	d2,aon_synthWAVESTOP(a4)
			rts
; --------------------------------------------------------------------
; 'v'
; --------------------------------------------------------------------
; 'w'
; --------------------------------------------------------------------
; 'x'
aon_dofx_externalevent
			tst.b	aon_framecnt(a6)	; nur 1* aufrufen!!!
			beq.b	.yo
			rts
.yo			lea	aon_event(pc),a0	; pc-relativ bleiben
			move.b	d1,(a0)
			rts
; --------------------------------------------------------------------
; 'y'
aon_dofx_externalevent2
			tst.b	aon_framecnt(a6)	; nur 1* aufrufen!!!
			beq.b	.yo
			rts
.yo			lea	aon_event+1(pc),a0	; pc-relativ bleiben
			move.b	d1,(a0)
			rts
; --------------------------------------------------------------------
; 'z'
aon_dofx_externalevent3
			tst.b	aon_framecnt(a6)	; nur 1* aufrufen!!!
			beq.b	.yo
			rts
.yo			lea	aon_event+2(pc),a0	; pc-relativ bleiben
			move.b	d1,(a0)
			rts
; --------------------------------------------------------------------

;========================================================================
AON_STARTINSTR.1
			move	aon_fxcom(a4),d0
			and	#$0ff0,d0
			cmp	#$0ed0,d0
			beq.b	aon_strtinsonlyrep.1

			btst	#1,aon_chflag(a4)	; bit1= aonflag=2 or 3
			beq.b	aon_strtins.notset1

		tst.b	aon_noiseavoid(a6)
		beq.b	.letsknack
		cmp	#255,aon_oldwavelen(a4)
		bhi.b	.letsknack
		tst	aon_oldwavelen(a4)
		beq.b	.letsknack
		cmp	#255,aon_wavelen(a4)
		ble.b	aon_strtins.notset1
.letsknack		bset	d7,d1
aon_strtins.notset1

			move	aon_period(a4),d0	; baseper+arpeggio
			add	aon_perslide(a4),d0	; portamento value
.checkhiper
			cmp	#103,d0
			bhs.b	.noperalert
			moveq	#103,d0
.noperalert		move	d0,$6(a5)

			moveq	#0,d0
			move.b	aon_volume(a4),d0
			moveq	#0,d2
			move.b	aon_synthVOL(a4),d2
			lsr.b	#1,d2
			mulu	d2,d0
			lsr	#6,d0
			mulu	aon_trackvol(a4),d0
			lsr	#6,d0
			move.b	d0,$9(a5)

			btst	#1,aon_chflag(a4)
			beq.s	aon_strtinsonlyrep.1
			move.l	aon_waveform(a4),$0(a5)

			move	aon_wavelen(a4),$4(a5)

aon_strtinsonlyrep.1
			addq.b	#1,d7
aon_strtinsonlyrep.2	lea	aon_chdatasize(a4),a4
			lea	$10(a5),a5
			rts
AON_STARTINSTR.2
			move	aon_fxcom(a4),d0
			and	#$0ff0,d0
			cmp	#$0ed0,d0
			beq.s	aon_strtinsonlyrep.1


			move.l	aon_repeatstrt(a4),(a5)
			move	aon_replen(a4),$4(a5)
			clr.b	aon_chflag(a4)
			bra.b	aon_strtinsonlyrep.1
;========================================================================
;aon_dmawait		dc.b	40,0				; rastlines

aon_event		dc.b	0,0,0	; z.b fr demo-synchronisation
			even


AON_leer		ds.b	mix_buflen
AON_hi			dc.b	64,64
AON_multab120	dc	120*0,120*1,120*2,120*3,120*4,120*5,120*6,120*7
		dc	120*8,120*9,120*10,120*11,120*12,120*13,120*14,120*15
AON_PERIODS
	DC.B	$0D,$60,$0C,$A0,$0B,$E8,$0B,$40		16 finetunes,5 octaves
	DC.B	$0A,$98,$0A,$00,$09,$70,$08,$E8
	DC.B	$08,$68,$07,$F0,$07,$80,$07,$14
	DC.B	$06,$B0,$06,$50,$05,$F4,$05,$A0
	DC.B	$05,$4C,$05,$00,$04,$B8,$04,$74
	DC.B	$04,$34,$03,$F8,$03,$C0,$03,$8A
	DC.B	$03,$58,$03,$28,$02,$FA,$02,$D0
	DC.B	$02,$A6,$02,$80,$02,$5C,$02,$3A
	DC.B	$02,$1A,$01,$FC,$01,$E0,$01,$C5
	DC.B	$01,$AC,$01,$94,$01,$7D,$01,$68
	DC.B	$01,$53,$01,$40,$01,$2E,$01,$1D
	DC.B	$01,$0D,$00,$FE,$00,$F0,$00,$E2
	DC.B	$00,$D6,$00,$CA,$00,$BE,$00,$B4
	DC.B	$00,$AA,$00,$A0,$00,$97,$00,$8F
	DC.B	$00,$87,$00,$7F,$00,$78,$00,$71
	DC.B	$0D,$48,$0C,$88,$0B,$D4,$0B,$2C
	DC.B	$0A,$88,$09,$F4,$09,$64,$08,$DC
	DC.B	$08,$5C,$07,$E4,$07,$74,$07,$08
	DC.B	$06,$A4,$06,$44,$05,$EA,$05,$96
	DC.B	$05,$44,$04,$FA,$04,$B2,$04,$6E
	DC.B	$04,$2E,$03,$F2,$03,$BA,$03,$84
	DC.B	$03,$52,$03,$22,$02,$F5,$02,$CB
	DC.B	$02,$A2,$02,$7D,$02,$59,$02,$37
	DC.B	$02,$17,$01,$F9,$01,$DD,$01,$C2
	DC.B	$01,$A9,$01,$91,$01,$7B,$01,$65
	DC.B	$01,$51,$01,$3E,$01,$2C,$01,$1C
	DC.B	$01,$0C,$00,$FD,$00,$EF,$00,$E1
	DC.B	$00,$D5,$00,$C9,$00,$BD,$00,$B3
	DC.B	$00,$A9,$00,$9F,$00,$96,$00,$8E
	DC.B	$00,$86,$00,$7E,$00,$77,$00,$71
	DC.B	$0D,$30,$0C,$70,$0B,$C0,$0B,$14
	DC.B	$0A,$78,$09,$E0,$09,$54,$08,$CC
	DC.B	$08,$50,$07,$D8,$07,$68,$06,$FC
	DC.B	$06,$98,$06,$38,$05,$E0,$05,$8A
	DC.B	$05,$3C,$04,$F0,$04,$AA,$04,$66
	DC.B	$04,$28,$03,$EC,$03,$B4,$03,$7E
	DC.B	$03,$4C,$03,$1C,$02,$F0,$02,$C5
	DC.B	$02,$9E,$02,$78,$02,$55,$02,$33
	DC.B	$02,$14,$01,$F6,$01,$DA,$01,$BF
	DC.B	$01,$A6,$01,$8E,$01,$78,$01,$63
	DC.B	$01,$4F,$01,$3C,$01,$2A,$01,$1A
	DC.B	$01,$0A,$00,$FB,$00,$ED,$00,$E0
	DC.B	$00,$D3,$00,$C7,$00,$BC,$00,$B1
	DC.B	$00,$A7,$00,$9E,$00,$95,$00,$8D
	DC.B	$00,$85,$00,$7D,$00,$76,$00,$70
	DC.B	$0D,$18,$0C,$5C,$0B,$A8,$0B,$00
	DC.B	$0A,$64,$09,$D0,$09,$40,$08,$BC
	DC.B	$08,$40,$07,$C8,$07,$58,$06,$F0
	DC.B	$06,$8C,$06,$2E,$05,$D4,$05,$80
	DC.B	$05,$32,$04,$E8,$04,$A0,$04,$5E
	DC.B	$04,$20,$03,$E4,$03,$AC,$03,$78
	DC.B	$03,$46,$03,$17,$02,$EA,$02,$C0
	DC.B	$02,$99,$02,$74,$02,$50,$02,$2F
	DC.B	$02,$10,$01,$F2,$01,$D6,$01,$BC
	DC.B	$01,$A3,$01,$8B,$01,$75,$01,$60
	DC.B	$01,$4C,$01,$3A,$01,$28,$01,$18
	DC.B	$01,$08,$00,$F9,$00,$EB,$00,$DE
	DC.B	$00,$D1,$00,$C6,$00,$BB,$00,$B0
	DC.B	$00,$A6,$00,$9D,$00,$94,$00,$8C
	DC.B	$00,$84,$00,$7D,$00,$76,$00,$6F
	DC.B	$0D,$00,$0C,$44,$0B,$94,$0A,$EC
	DC.B	$0A,$50,$09,$BC,$09,$30,$08,$AC
	DC.B	$08,$30,$07,$BC,$07,$4C,$06,$E4
	DC.B	$06,$80,$06,$22,$05,$CA,$05,$76
	DC.B	$05,$28,$04,$DE,$04,$98,$04,$56
	DC.B	$04,$18,$03,$DE,$03,$A6,$03,$72
	DC.B	$03,$40,$03,$11,$02,$E5,$02,$BB
	DC.B	$02,$94,$02,$6F,$02,$4C,$02,$2B
	DC.B	$02,$0C,$01,$EF,$01,$D3,$01,$B9
	DC.B	$01,$A0,$01,$88,$01,$72,$01,$5E
	DC.B	$01,$4A,$01,$38,$01,$26,$01,$16
	DC.B	$01,$06,$00,$F7,$00,$E9,$00,$DC
	DC.B	$00,$D0,$00,$C4,$00,$B9,$00,$AF
	DC.B	$00,$A5,$00,$9C,$00,$93,$00,$8B
	DC.B	$00,$83,$00,$7C,$00,$75,$00,$6E
	DC.B	$0C,$E8,$0C,$2C,$0B,$80,$0A,$D8
	DC.B	$0A,$3C,$09,$AC,$09,$20,$08,$9C
	DC.B	$08,$20,$07,$AC,$07,$3C,$06,$D4
	DC.B	$06,$74,$06,$16,$05,$C0,$05,$6C
	DC.B	$05,$1E,$04,$D6,$04,$90,$04,$4E
	DC.B	$04,$10,$03,$D6,$03,$9E,$03,$6A
	DC.B	$03,$3A,$03,$0B,$02,$E0,$02,$B6
	DC.B	$02,$8F,$02,$6B,$02,$48,$02,$27
	DC.B	$02,$08,$01,$EB,$01,$CF,$01,$B5
	DC.B	$01,$9D,$01,$86,$01,$70,$01,$5B
	DC.B	$01,$48,$01,$35,$01,$24,$01,$14
	DC.B	$01,$04,$00,$F5,$00,$E8,$00,$DB
	DC.B	$00,$CE,$00,$C3,$00,$B8,$00,$AE
	DC.B	$00,$A4,$00,$9B,$00,$92,$00,$8A
	DC.B	$00,$82,$00,$7B,$00,$74,$00,$6D
	DC.B	$0C,$D0,$0C,$18,$0B,$68,$0A,$C4
	DC.B	$0A,$2C,$09,$98,$09,$10,$08,$8C
	DC.B	$08,$10,$07,$9C,$07,$30,$06,$C8
	DC.B	$06,$68,$06,$0C,$05,$B4,$05,$62
	DC.B	$05,$16,$04,$CC,$04,$88,$04,$46
	DC.B	$04,$08,$03,$CE,$03,$98,$03,$64
	DC.B	$03,$34,$03,$06,$02,$DA,$02,$B1
	DC.B	$02,$8B,$02,$66,$02,$44,$02,$23
	DC.B	$02,$04,$01,$E7,$01,$CC,$01,$B2
	DC.B	$01,$9A,$01,$83,$01,$6D,$01,$59
	DC.B	$01,$45,$01,$33,$01,$22,$01,$12
	DC.B	$01,$02,$00,$F4,$00,$E6,$00,$D9
	DC.B	$00,$CD,$00,$C1,$00,$B7,$00,$AC
	DC.B	$00,$A3,$00,$9A,$00,$91,$00,$89
	DC.B	$00,$81,$00,$7A,$00,$73,$00,$6D
	DC.B	$0C,$B8,$0C,$00,$0B,$54,$0A,$B0
	DC.B	$0A,$18,$09,$88,$08,$FC,$08,$7C
	DC.B	$08,$04,$07,$90,$07,$24,$06,$BC
	DC.B	$06,$5C,$06,$00,$05,$AA,$05,$58
	DC.B	$05,$0C,$04,$C4,$04,$7E,$04,$3E
	DC.B	$04,$02,$03,$C8,$03,$92,$03,$5E
	DC.B	$03,$2E,$03,$00,$02,$D5,$02,$AC
	DC.B	$02,$86,$02,$62,$02,$3F,$02,$1F
	DC.B	$02,$01,$01,$E4,$01,$C9,$01,$AF
	DC.B	$01,$97,$01,$80,$01,$6B,$01,$56
	DC.B	$01,$43,$01,$31,$01,$20,$01,$10
	DC.B	$01,$00,$00,$F2,$00,$E4,$00,$D8
	DC.B	$00,$CC,$00,$C0,$00,$B5,$00,$AB
	DC.B	$00,$A1,$00,$98,$00,$90,$00,$88
	DC.B	$00,$80,$00,$79,$00,$72,$00,$6C
	DC.B	$0E,$2C,$0D,$60,$0C,$A0,$0B,$E8
	DC.B	$0B,$40,$0A,$98,$0A,$00,$09,$70
	DC.B	$08,$E8,$08,$68,$07,$F0,$07,$80
	DC.B	$07,$16,$06,$B0,$06,$50,$05,$F4
	DC.B	$05,$A0,$05,$4C,$05,$00,$04,$B8
	DC.B	$04,$74,$04,$34,$03,$F8,$03,$C0
	DC.B	$03,$8B,$03,$58,$03,$28,$02,$FA
	DC.B	$02,$D0,$02,$A6,$02,$80,$02,$5C
	DC.B	$02,$3A,$02,$1A,$01,$FC,$01,$E0
	DC.B	$01,$C5,$01,$AC,$01,$94,$01,$7D
	DC.B	$01,$68,$01,$53,$01,$40,$01,$2E
	DC.B	$01,$1D,$01,$0D,$00,$FE,$00,$F0
	DC.B	$00,$E2,$00,$D6,$00,$CA,$00,$BE
	DC.B	$00,$B4,$00,$AA,$00,$A0,$00,$97
	DC.B	$00,$8F,$00,$87,$00,$7F,$00,$78
	DC.B	$0E,$10,$0D,$48,$0C,$88,$0B,$D4
	DC.B	$0B,$2C,$0A,$8C,$09,$F0,$09,$64
	DC.B	$08,$DC,$08,$5C,$07,$E4,$07,$74
	DC.B	$07,$08,$06,$A4,$06,$44,$05,$EA
	DC.B	$05,$96,$05,$46,$04,$F8,$04,$B2
	DC.B	$04,$6E,$04,$2E,$03,$F2,$03,$BA
	DC.B	$03,$84,$03,$52,$03,$22,$02,$F5
	DC.B	$02,$CB,$02,$A3,$02,$7C,$02,$59
	DC.B	$02,$37,$02,$17,$01,$F9,$01,$DD
	DC.B	$01,$C2,$01,$A9,$01,$91,$01,$7B
	DC.B	$01,$65,$01,$51,$01,$3E,$01,$2C
	DC.B	$01,$1C,$01,$0C,$00,$FD,$00,$EE
	DC.B	$00,$E1,$00,$D4,$00,$C8,$00,$BD
	DC.B	$00,$B3,$00,$A9,$00,$9F,$00,$96
	DC.B	$00,$8E,$00,$86,$00,$7E,$00,$77
	DC.B	$0D,$F8,$0D,$30,$0C,$70,$0B,$C0
	DC.B	$0B,$14,$0A,$78,$09,$E0,$09,$54
	DC.B	$08,$CC,$08,$50,$07,$D8,$07,$68
	DC.B	$06,$FC,$06,$98,$06,$38,$05,$E0
	DC.B	$05,$8A,$05,$3C,$04,$F0,$04,$AA
	DC.B	$04,$66,$04,$28,$03,$EC,$03,$B4
	DC.B	$03,$7E,$03,$4C,$03,$1C,$02,$F0
	DC.B	$02,$C5,$02,$9E,$02,$78,$02,$55
	DC.B	$02,$33,$02,$14,$01,$F6,$01,$DA
	DC.B	$01,$BF,$01,$A6,$01,$8E,$01,$78
	DC.B	$01,$63,$01,$4F,$01,$3C,$01,$2A
	DC.B	$01,$1A,$01,$0A,$00,$FB,$00,$ED
	DC.B	$00,$DF,$00,$D3,$00,$C7,$00,$BC
	DC.B	$00,$B1,$00,$A7,$00,$9E,$00,$95
	DC.B	$00,$8D,$00,$85,$00,$7D,$00,$76
	DC.B	$0D,$DC,$0D,$18,$0C,$5C,$0B,$A8
	DC.B	$0B,$00,$0A,$64,$09,$D0,$09,$40
	DC.B	$08,$BC,$08,$40,$07,$C8,$07,$58
	DC.B	$06,$EE,$06,$8C,$06,$2E,$05,$D4
	DC.B	$05,$80,$05,$32,$04,$E8,$04,$A0
	DC.B	$04,$5E,$04,$20,$03,$E4,$03,$AC
	DC.B	$03,$77,$03,$46,$03,$17,$02,$EA
	DC.B	$02,$C0,$02,$99,$02,$74,$02,$50
	DC.B	$02,$2F,$02,$10,$01,$F2,$01,$D6
	DC.B	$01,$BC,$01,$A3,$01,$8B,$01,$75
	DC.B	$01,$60,$01,$4C,$01,$3A,$01,$28
	DC.B	$01,$18,$01,$08,$00,$F9,$00,$EB
	DC.B	$00,$DE,$00,$D1,$00,$C6,$00,$BB
	DC.B	$00,$B0,$00,$A6,$00,$9D,$00,$94
	DC.B	$00,$8C,$00,$84,$00,$7D,$00,$76
	DC.B	$0D,$C4,$0D,$00,$0C,$44,$0B,$94
	DC.B	$0A,$EC,$0A,$50,$09,$BC,$09,$30
	DC.B	$08,$AC,$08,$30,$07,$B8,$07,$4C
	DC.B	$06,$E2,$06,$80,$06,$22,$05,$CA
	DC.B	$05,$76,$05,$28,$04,$DE,$04,$98
	DC.B	$04,$56,$04,$18,$03,$DC,$03,$A6
	DC.B	$03,$71,$03,$40,$03,$11,$02,$E5
	DC.B	$02,$BB,$02,$94,$02,$6F,$02,$4C
	DC.B	$02,$2B,$02,$0C,$01,$EE,$01,$D3
	DC.B	$01,$B9,$01,$A0,$01,$88,$01,$72
	DC.B	$01,$5E,$01,$4A,$01,$38,$01,$26
	DC.B	$01,$16,$01,$06,$00,$F7,$00,$E9
	DC.B	$00,$DC,$00,$D0,$00,$C4,$00,$B9
	DC.B	$00,$AF,$00,$A5,$00,$9C,$00,$93
	DC.B	$00,$8B,$00,$83,$00,$7B,$00,$75
	DC.B	$0D,$AC,$0C,$E8,$0C,$2C,$0B,$80
	DC.B	$0A,$D8,$0A,$3C,$09,$AC,$09,$20
	DC.B	$08,$9C,$08,$20,$07,$AC,$07,$3C
	DC.B	$06,$D6,$06,$74,$06,$16,$05,$C0
	DC.B	$05,$6C,$05,$1E,$04,$D6,$04,$90
	DC.B	$04,$4E,$04,$10,$03,$D6,$03,$9E
	DC.B	$03,$6B,$03,$3A,$03,$0B,$02,$E0
	DC.B	$02,$B6,$02,$8F,$02,$6B,$02,$48
	DC.B	$02,$27,$02,$08,$01,$EB,$01,$CF
	DC.B	$01,$B5,$01,$9D,$01,$86,$01,$70
	DC.B	$01,$5B,$01,$48,$01,$35,$01,$24
	DC.B	$01,$14,$01,$04,$00,$F5,$00,$E8
	DC.B	$00,$DB,$00,$CE,$00,$C3,$00,$B8
	DC.B	$00,$AE,$00,$A4,$00,$9B,$00,$92
	DC.B	$00,$8A,$00,$82,$00,$7B,$00,$74
	DC.B	$0D,$90,$0C,$D0,$0C,$18,$0B,$68
	DC.B	$0A,$C4,$0A,$2C,$09,$98,$09,$10
	DC.B	$08,$8C,$08,$10,$07,$9C,$07,$30
	DC.B	$06,$C8,$06,$68,$06,$0C,$05,$B4
	DC.B	$05,$62,$05,$16,$04,$CC,$04,$88
	DC.B	$04,$46,$04,$08,$03,$CE,$03,$98
	DC.B	$03,$64,$03,$34,$03,$06,$02,$DA
	DC.B	$02,$B1,$02,$8B,$02,$66,$02,$44
	DC.B	$02,$23,$02,$04,$01,$E7,$01,$CC
	DC.B	$01,$B2,$01,$9A,$01,$83,$01,$6D
	DC.B	$01,$59,$01,$45,$01,$33,$01,$22
	DC.B	$01,$12,$01,$02,$00,$F4,$00,$E6
	DC.B	$00,$D9,$00,$CD,$00,$C1,$00,$B7
	DC.B	$00,$AC,$00,$A3,$00,$9A,$00,$91
	DC.B	$00,$89,$00,$81,$00,$7A,$00,$73
	DC.B	$0D,$78,$0C,$B8,$0C,$00,$0B,$54
	DC.B	$0A,$B0,$0A,$18,$09,$88,$08,$FC
	DC.B	$08,$7C,$08,$04,$07,$90,$07,$24
	DC.B	$06,$BC,$06,$5C,$06,$00,$05,$AA
	DC.B	$05,$58,$05,$0C,$04,$C4,$04,$7E
	DC.B	$04,$3E,$04,$02,$03,$C8,$03,$92
	DC.B	$03,$5E,$03,$2E,$03,$00,$02,$D5
	DC.B	$02,$AC,$02,$86,$02,$62,$02,$3F
	DC.B	$02,$1F,$02,$01,$01,$E4,$01,$C9
	DC.B	$01,$AF,$01,$97,$01,$80,$01,$6B
	DC.B	$01,$56,$01,$43,$01,$31,$01,$20
	DC.B	$01,$10,$01,$00,$00,$F2,$00,$E4
	DC.B	$00,$D8,$00,$CB,$00,$C0,$00,$B5
	DC.B	$00,$AB,$00,$A1,$00,$98,$00,$90
	DC.B	$00,$88,$00,$80,$00,$79,$00,$72


;========================================================================
AON_vibrato_sine
; ripped from ptreplay2.3
	dc.b	0,24,49,74,97,120,141,161
	dc.b	180,197,212,224,235,244,250,253
	dc.b	255,253,250,244,235,224,212,197
	dc.b	180,161,141,120,97,74,49,24	; ->32 bytes
AON_vibrato_rampdown
	dc.b	255,248,240,232,224,216,208,200,192,184,176,168,160,152,144
	dc.b	136,128,120,112,104,96,88,80,72,64,56,48,40,32,24,16,8
AON_vibrato_square
	dcb.b	32,255

;========================================================================
;========================================================================
AON_DATA
;
aon_speed		rs.b	1	0=off , 1-255
aon_framecnt		rs.b	1	0-aon_speed
aon_patcnt		rs	1	-1= break pat
aon_looppoint		rs.b	1
aon_loopcnt		rs.b	1
aon_loopflag		rs.b	1
aon_pos			rs.b	1	actual pos while replaying 
aon_statdata		rs.l	1	address of static data in module
aon_arpdata		rs.l	1	Pointer on arpeggio lists
aon_posdata		rs.l	1	address of position tab
aon_pattdata		rs.l	1	Pointer on patterns	(1st)
aon_patdelaycnt		rs	1
aon_wavestarts		rs.b	256	adrs of waveforms (0-63)
aon_instrstarts		rs.b	256	adrs of instruments (1-61)
aon_modulestart		rs.l	1	Start of module
aon_replayMode		rs.b	1	0=VBI,1=CIA A&B
aon_tempo		rs.b	1	tempo 32-255 (bei cia-use speed=6)
aon_noiseavoid		rs.b	1
aon_oversize		rs.b	1
aon_dmaflag		rs.b	1+1
aon_dmacon		rs	1
oldaudio		rs.l	1
aon_datasize		rs	1
			dcb.b	aon_datasize

AON_CHANNELS
;
			rsreset
aon_chflag		rs.b	1	<>0 = new wave! (1=sample,2=synth)
aon_lastnote		rs.b	1	well,the last note I guess ?!!!!
aon_waveform		rs.l	1	wavestart
aon_wavelen		rs	1	wavelen/2 (dma!)
aon_oldwavelen		rs	1	to avoid noise when using rep <512bytes
aon_repeatstrt		rs.l	1	repeatwavestart
aon_replen		rs	1	repeat-lenght/2 (dma!)
aon_instrptr		rs.l	1	POINTER oN ACT. INSTRDATA
aon_volume		rs.b	1	Act.Volume (written into register)

aon_stepfxcnt		rs.b	1	notecut/delay/retrig

aon_chMODE		rs.b	1	0=sample8,1=synth8
aon_vibratospd		rs.b	1
aon_vibratoampl		rs.b	1
aon_vibratopos		rs.b	1
aon_vibratotrigdelay	rs	1	-1=already triggered

aon_period		rs	1	Act.periode (written into register)
				;	(including slide up/down etc..)
aon_perslide		rs	1	Added to periode (e.g. 4 portamento)

aon_arpeggiooff		rs	1
aon_arpeggiotab		rs.b	16	7 ffsets (+ endmark) in per.tab
aon_arpeggiospd		rs.b	1	Frame-Change-Speed
aon_arpeggiocnt		rs.b	1	Countdown

aon_synthWAVEactPTR	rs.l	1	actptr	(absolute waveform-adressen!!)
aon_synthWAVEendPTR	rs.l	1	endwaveptr
aon_synthWAVErepPTR	rs.l	1	anfang des repeat-teils
aon_synthWAVErependPTR	rs.l	1	ende des repeat teils
aon_synthWAVEaddbytes	rs.l	1	addiere/subtrahiere xxxx bytes
aon_synthWAVEcnt	rs.b	1	framecnt
aon_synthWAVEspd	rs.b	1	wechsel der waveform jeden n-ten frame
aon_synthWAVErepctrl	rs.b	1	0=normal,1=back,2=pingpong
aon_synthWAVECONT	rs.b	1	0=normal,1=wave durchlaufen lassen
aon_synthADD		rs.b	1
aon_synthSUB		rs.b	1
aon_synthEND		rs.b	1
aon_synthENV		rs.b	1	0=NO AR envelope
aon_synthVOL		rs.b	1	akt. adsr byte (*volume/64=abs vol!!)
aon_vibON		rs.b	1	1=Do Vibrato!
aon_synthwaveSTOP	rs.b	1	1=dont continue wave until U10
aon_vibDONE		rs.b	1	1=Vibrato done
aon_vibCONT		rs.b	1+1	1=Dauervibrato(wavetable),0=Only '4'etc


aon_fxCOM		rs.b	1	Effect-Command
aon_fxDAT		rs.b	1	Effect-Parameter

aon_oldsampoff		rs.l	1	used for '9' effect
aon_glissspd		rs	1	speed for '3' effect

aon_slideflag		rs.b	1	<>0=Sliding active
aon_actwavenr		rs.b	1

aon_trackvol		rs	1	64=max,0=track mute

aon_chdatasize		rs	1

			ds.b	aon_chdatasize*8


;========================================================================







;; program	:	8-Channelmix-Test (7bit)
;; author	:	Bastian Spiegel (twice of lego)
;; date		:	- 23.Jan.1995
;; equ		:	68020+ is recommended!

	rem
-mixrate 1-64khz
-7-Bit Sampleauflsung
-Freie Lautstrkeeinstellung fr JEDEN Kanal
-Repeat fr jeden Kanal
	erem


loop			=1	; if loop is on,the routine needs about 4
				; rastlines more for every channel


mix_INIT2
			MOVEM.L	D0-A6,-(SP)
			LEA	$DFF000,A5
			BRA.B	mix_INIT22

mix_init

			movem.l	d0-a6,-(sp)

			lea	$dff000,a5

			lea	mix_multab64(pc),a0
			moveq	#0,d6	; 0-$40
			moveq	#0,d7	; 0-255
mix_in_mtab		moveq	#0,d1
			move.b	d7,d1
			ext	d1
			muls	d6,d1
			asr	#6+1,d1	; /2 teilen!!!!!
			move.b	d1,(a0)+
			addq.b	#1,d7
			bne.s	mix_in_mtab
			addq.b	#1,d6
			cmp.b	#$41,d6
			bne.s	mix_in_mtab

mix_INIT22
			move	#$f,$96(a5)
*			moveq	#10-1,d7
*			move.b	#254,d0
*.rastwait1		cmp.b	$dff006,d0
*			bne.b	.rastwait1
*			subq.b	#1,d0
*			dbf	d7,.rastwait1

			movem.l	d0-d7/a0-a6,-(a7)
			move.l	delibase,a5
			move.l	dtg_WaitAudioDMA(a5),a0
			jsr	(a0)
			movem.l	(a7)+,d0-d7/a0-a6

			move.l	mix_buff1(pc),$a0(a5)
			move.l	mix_buff2(pc),$b0(a5)
			move.l	mix_buff3(pc),$c0(a5)
			move.l	mix_buff3(pc),$d0(a5)
			move	#mix_buflen/2,d0
			move	d0,$a4(a5)
			move	d0,$b4(a5)
			move	d0,$c4(a5)
			move	d0,$d4(a5)
			move	mix_mixrate(pc),d0
			move	d0,$a6(a5)
			move	d0,$b6(a5)
			move	d0,$c6(a5)
			move	d0,$d6(a5)
			moveq	#64,d0
			move	d0,$a8(a5)
			move	d0,$b8(a5)
			move	d0,$c8(a5)
			move	d0,$d8(a5)

			move	#$ff,$dff09e	; no modulation
			move	#$800f,$96(a5)

			movem.l	(sp)+,d0-a6
			rts
;--------------------------------------------------------------------
; IN:	a0=bypass-ch
;	d7=anzahl kanle (bis zu 8 !)
mix_startsamples
			moveq	#0,d6
.loop
			moveq	#0,d4
			move	6(a0),d4	; period
			moveq	#0,d5
			move.b	9(a0),d5	; volume
			cmp	#$40,d5
			ble.b	.volok
			moveq	#$40,d5
.volok			move.l	(a0),d0		; samplestart
			moveq	#0,d1
			move	4(a0),d1	; sampledmalen
			add.l	d1,d1		; *2 fr bytes
			move.l	10(a0),d2	; repeatstart
			moveq	#0,d3
			move	14(a0),d3	; repeatdmalen
			add.l	d3,d3		; *2 fr bytes
			bsr.b	mix_startsample
.nonewsample		lea	$10(a0),a0
			addq	#1,d6
			dbf	d7,.loop
			rts
;--------------------------------------------------------------------
; IN:	d0=wavestart
;	d1=wavelen
;	d2=repoff
;	d3=replen
;	d4=period
;	d5=volume
;	d6=channel (0-7)
mix_startsample
			movem.l	d0-a6,-(sp)
			lea	mix_data,a1
			mulu	#mix_datasize,d6
			lea	(a1,d6),a1

			btst	#1,8(a0)
			beq.b	.repeat

			clr	mix_lastfloat(a1)
			move.b	#1,mix_status(a1)
			move.l	d0,mix_wavestart(a1)
			clr.l	mix_waveoff(a1)
			move.l	d1,mix_wavelen(a1)
.repeat			btst	#0,8(a0)
			beq.b	.norepeat

			move.l	d2,mix_repstrt(a1)
			move.l	d3,mix_replen(a1)

.norepeat		lsl.l	#8,d5
			add.l	#mix_multab64,d5
			move.l	d5,mix_volumeptr(a1)

			tst	d4
			beq.b	.noper
			move	d4,mix_period(a1)
			moveq	#0,d0
			move	mix_mixrate(pc),d0
			swap	d0
			divu.l	d4,d0
			tst	d0
			bne.b	.ok
			move	#$ffff,mix_period.float(a1)
			swap	d0
			tst	d0
			beq.b	.set
			subq	#1,d0
			bra.b	.set
.ok			move	d0,mix_period.float(a1)
			swap	d0
.set			move	d0,mix_norm.add(a1)
.noper			clr.b	8(a0)
			movem.l	(sp)+,d0-a6
			rts
;--------------------------------------------------------------------
; durch audioirqs aufrufen
mix_play
			move	#$f00,$dff180

			btst	#7,$dff01f
			bne.b	mix_play0
			btst	#0,$dff01e
			bne.b	mix_play1
			btst	#1,$dff01e
			bne.w	mix_play2
			btst	#2,$dff01e
			bne.w	mix_play3
			nop
			nop
			nop
			rte
mix_play0		movem.l	d0-a6,-(sp)
			move	#$4000,$dff09a
			lea	mix_buff1(pc),a0
			move.l	(a0),d0
			move.l	16(a0),(a0)	
			move.l	d0,16(a0)	
			move.l	d0,$dff0a0
			lea	mix_data+mix_datasize*0,a5
			lea	mix_data+mix_datasize*1,a6
			move.l	16(a0),a4
			bsr.w	mix_channels
			move	#$c000,$dff09a
			movem.l	(sp)+,d0-a6
			move	#$80,$dff09c
			move	#$aab,$dff180
			nop
			nop
			nop
			rte
mix_play1		movem.l	d0-a6,-(sp)
			move	#$4000,$dff09a
			lea	mix_buff2(pc),a0
			move.l	(a0),d0
			move.l	16(a0),(a0)	
			move.l	d0,16(a0)	
			move.l	d0,$dff0b0
			lea	mix_data+mix_datasize*2,a5
			lea	mix_data+mix_datasize*3,a6
			move.l	16(a0),a4
			bsr.w	mix_channels
			move	#$c000,$dff09a
			movem.l	(sp)+,d0-a6
			move	#$100,$dff09c
			move	#$aab,$dff180
			nop
			nop
			nop
			rte
mix_play2		movem.l	d0-a6,-(sp)
			move	#$4000,$dff09a
			lea	mix_buff3(pc),a0
			move.l	(a0),d0
			move.l	16(a0),(a0)	
			move.l	d0,16(a0)	
			move.l	d0,$dff0c0
			lea	mix_data+mix_datasize*4,a5
			lea	mix_data+mix_datasize*5,a6
			move.l	16(a0),a4
			bsr.b	mix_channels
			move	#$c000,$dff09a
			movem.l	(sp)+,d0-a6
			move	#$200,$dff09c
			move	#$aab,$dff180
			nop
			nop
			nop
			rte
mix_play3		movem.l	d0-a6,-(sp)
			move	#$4000,$dff09a
			lea	mix_buff4(pc),a0
			move.l	(a0),d0
			move.l	16(a0),(a0)	
			move.l	d0,16(a0)	
			move.l	d0,$dff0d0
			lea	mix_data+mix_datasize*6,a5
			lea	mix_data+mix_datasize*7,a6
			move.l	16(a0),a4
			bsr.b	mix_channels
			move	#$c000,$dff09a
			movem.l	(sp)+,d0-a6
			move	#$400,$dff09c
			move	#$aab,$dff180
			nop
			nop
			nop
			rte
;--------------------------------------------------------------------
; a5=ptr on chdata1
; a6=ptr on chdata2
; a4=ptr on destbuffer (chipmem!)
mix_channels:
;			bsr	mix_mix_mix
;
;			rts
;
;			move.l	a4,a3
;			moveq	#128/4-1,d7
;.interpol		rept	4
;			move.b	(a4),d1
;			move.b	1(a4),d2	; interpol-dreck
;			sub.b	d1,d2
;			asr.b	#2,d2
;			add.b	d2,d1
;			move.b	d1,(a4)+
;			endr
;			dbf	d7,.interpol
;			rts
;
;			rept	3
;			move.b	(a4),d1
;			move.b	1(a4),d2
;			sub.b	d1,d2
;			asr.b	#1,d2
;			add.b	d2,d1
;			move.b	d1,(a4)+
;			endr
;			move.b	(a4),d1
;			move.b	(a3),d2
;			sub.b	d1,d2
;			asr.b	#1,d2
;			add.b	d2,d1
;			move.b	d1,(a4)
;			rts


mix_mix_mix:		movem.l	a4-a6,-(sp)

			move.l	mix_wavestart(a5),a0	; wave1 startadr
			move.l	mix_wavestart(a6),a1	; wave2 startadr
			move.l	mix_waveoff(a5),d0	; wave1 mixoff
			move.l	mix_waveoff(a6),d1	; wave2 mixoff
			move.l	mix_volumeptr(a5),a2	; wave1 volumeptr
			move.l	mix_volumeptr(a6),a3	; wave2 volumeptr
			moveq	#0,d2
			move	mix_period.float(a5),d2
			swap	d2			; wave1 addx-add
			moveq	#0,d3			; wave1 addx-cnt
			move	mix_lastfloat(a5),d3
			swap	d3
			moveq	#0,d4
			move	mix_norm.add(a5),d4	; wave1 integer-add
			moveq	#0,d5
			move	mix_period.float(a6),d5	; wave2 addx-add
			moveq	#0,d6			; wave2 addx-cnt
			move	mix_lastfloat(a6),d6
			moveq	#0,d7
			move	mix_norm.add(a6),d7	; wave2 integer-add
			
			move	#mix_buflen/2,mix_cnt(a5)

			tst.b	mix_status(a5)
			beq.w	mix_RIGHT
			tst.b	mix_status(a6)
			beq.w	mix_LEFT

mix_BOTH

.loop


			rept	2

 move.b	(a0,d0.l),d2	; Ein Byte aus Wave 1 holen		14

 add	d5,d6		; Add float WAVE2			4

 move.b	(a1,d1.l),d3	; Ein Byte aus Wave 2 holen		14

 addx.l	d7,d1		; Floating-Point WAVE2			8

 move.b	(a2,d2),d2	; *Volume & div 2			14

 add.b	(a3,d3),d2	; *Volume & div 2			14

 swap	d2		; HI-Word holen				4
 swap	d3		; HI-Word holen				4
 add	d2,d3		; addx-trick				4
 swap	d2		; LO-Word holen				4
 swap	d3		; LO-Word holen				4

 move.b	d2,(a4)+	; Write to buffer			8

 addx.l	d4,d0		; Floating-Point WAVE1			8

			endr

			cmp.l	mix_wavelen(a5),d0
			bge.b	.resetwave1
.set1
			cmp.l	mix_wavelen(a6),d1
			bge.b	.resetwave2
.set2
			sub	#1,mix_cnt(a5)
			cmp	#0,mix_cnt(a5)
			bne.b	.loop

			swap	d3
			move	d3,mix_lastfloat(a5)
			move	d6,mix_lastfloat(a6)

			move.l	d0,mix_waveoff(a5)
			move.l	d1,mix_waveoff(a6)
			movem.l	(sp)+,a4-a6
			rts
.resetwave1		move.l	mix_repstrt(a5),a0
			move.l	a0,mix_wavestart(a5)
			moveq	#0,d0
			move.l	mix_replen(a5),mix_wavelen(a5)
			cmp.l	#2,mix_wavelen(a5)
			ble.w	mix_RIGHT.leftOFF
			bra.b	.set1
.resetwave2		move.l	mix_repstrt(a6),a1
			move.l	a1,mix_wavestart(a6)
			moveq	#0,d1
			move.l	mix_replen(a6),mix_wavelen(a6)
			cmp.l	#2,mix_wavelen(a6)
			ble.b	mix_LEFT.rightOFF
			bra.b	.set2
.d4			dc.l	0
.d7			dc.l	0
;----------------------------------------
mix_NOTHING.leftoff	clr.b	mix_status(a5)
			bra.b	mix_nothing
mix_NOTHING.rightoff	clr.b	mix_status(a6)
mix_NOTHING

.loop			clr	(a4)+
			sub	#1,mix_cnt(a5)
			cmp	#0,mix_cnt(a5)
			bne.b	.loop
			

			movem.l	(sp)+,a4-a6
			rts
;----------------------------------------
mix_LEFT.rightoff	clr.b	mix_status(a6)
mix_LEFT
			cmp.l	#2,mix_wavelen(a5)
			ble.b	mix_NOTHING

			swap	d2
			swap	d3
			moveq	#0,d5

.loop

			rept	2
 move.b	(a0,d0.l),d5	; Ein Byte aus Wave 1 holen		14
 add	d2,d3		; Mix-Bytes & Add float WAVE1		6
 move.b	(a2,d5),(a4)+	; *Volume & div 2			14
 addx.l	d4,d0		; Floating-Point WAVE1			8
			endr

			cmp.l	mix_wavelen(a5),d0
			bge.b	.resetwave1
.set1
			sub	#1,mix_cnt(a5)
			cmp	#0,mix_cnt(a5)
			bne.b	.loop

			swap	d3
			move	d3,mix_lastfloat(a5)

			move.l	d0,mix_waveoff(a5)
			movem.l	(sp)+,a4-a6
			rts
.resetwave1
			move.l	mix_repstrt(a5),a0
			move.l	a0,mix_wavestart(a5)
			moveq	#0,d0
			move.l	mix_replen(a5),mix_wavelen(a5)
			cmp.l	#2,mix_wavelen(a5)
			ble.w	mix_NOTHING.leftoff
			bra.b	.set1
;----------------------------------------
mix_RIGHT.leftoff	clr.b	mix_status(a5)
mix_RIGHT
			tst.b	mix_status(a6)
			beq.w	mix_NOTHING

			cmp.l	#0,a1
			beq.w	mix_NOTHING
			cmp.l	#2,mix_wavelen(a6)
			ble.w	mix_NOTHING

			moveq	#0,d3
.loop
			rept	2
 move.b	(a1,d1.l),d3	; Ein Byte aus Wave 2 holen		14
 add	d5,d6		; Add float WAVE2			4
 move.b	(a3,d3),(a4)+	; *Volume & div 2			14
 addx.l	d7,d1		; Floating-Point WAVE2			8
			endr

			cmp.l	mix_wavelen(a6),d1
			bge.b	.resetwave2
.set2
			sub	#1,mix_cnt(a5)
			cmp	#0,mix_cnt(a5)
			bne.b	.loop

			move	d6,mix_lastfloat(a6)
			move.l	d1,mix_waveoff(a6)
			movem.l	(sp)+,a4-a6
			rts
.resetwave2		move.l	mix_repstrt(a6),a1
			move.l	a1,mix_wavestart(a6)
			moveq	#0,d1
			move.l	mix_replen(a6),mix_wavelen(a6)
			cmp.l	#2,mix_wavelen(a6)
			ble.w	mix_NOTHING.rightoff
			bra.b	.set2
;--------------------------------------------------------------------
;--------------------------------------------------------------------
;--------------------------------------------------------------------
mix_buff1		dc.l	0	; diese Buffer werden gerade berechnet
mix_buff2		dc.l	0
mix_buff3		dc.l	0
mix_buff4		dc.l	0
mix_buff1hear		dc.l	0	; diese Buffer werden gerade angehrt
mix_buff2hear		dc.l	0
mix_buff3hear		dc.l	0
mix_buff4hear		dc.l	0

mix_multab64		ds.b	256*65
mix_mixrate		ds	1	; Period

mix_DATA
			rsreset
mix_wavestart		rs.l	1
mix_waveoff		rs.l	1
mix_wavelen		rs.l	1
mix_repstrt		rs.l	1
mix_replen		rs.l	1
mix_period		rs	1
mix_period.float	rs	1	umgerechnet auf mixrate/addx trick-add
;					float-cnt
;					$ffff= period  125
;					$8000= ...     250
;					$4000= ...     500
;					$2000= ...    1000
mix_norm.add		rs	1
mix_cnt			rs	1
mix_lastfloat		rs	1
mix_status		rs.b	1+1	0=Ch off , 1=Ch plays
mix_volumeptr		rs.l	1
mix_datasize		rs	1
			ds.b	mix_datasize*8


mix_bypass		ds.b	$10*8
;--------------------------------------------------------------------


;--------------------------------------------------------------------


;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################
;########################################################################

****************************************************************************
; ________________________________________________________________________
; 									
;                      -<>-O art.of.noise.replay v1.6 O-<>-		
; 			   coded by twice/lego! '93/4		
; ________________________________________________________________________

;========================================================================
AON8_PLAY		movem.l	d0-d7/a0-a6,-(sp)
			lea	aon_data,a6

			addq.b	#1,aon_framecnt(a6)
			move.b	aon_speed(a6),d0
			beq.b	aon8_playcurrent_nonewpos2
			cmp.b	aon_framecnt(a6),d0
			bhi.b	aon8_playcurrent_nonewpos2
			clr.b	aon_framecnt(a6)

			bsr.w	aon8_playnewstep
aon8_playcurrent_nonewpos2
			bsr.b	aon8_playfx

			movem.l	(sp)+,d0-d7/a0-a6
			rts

;---------------------- Effekte & Samplestarts ----------------------
AON8_PLAYFX		
			moveq	#0,d7
			move.b	aon_pos(a6),d7
			move.l	aon_posdata(a6),a1	; get start of posdat
			moveq	#0,d0
			move.b	(a1,d7),d0		; d7=act. pos + choff

;	CMP.B	#REPLAYST_ALL,REPLAYSTATUS+MAIN_DATA
;	BNE.S	.DONTSETPATNR
			MOVE.B	D0,ACTEDITPATTERN
;.DONTSETPATNR

			lea	aon_dofx,a1
			lea	aon_channels,a4	; do effect command
			jsr	(a1)
			lea	aon_chdatasize(a4),a4
			jsr	(a1)
			lea	aon_chdatasize(a4),a4
			jsr	(a1)
			lea	aon_chdatasize(a4),a4
			jsr	(a1)
			lea	aon_chdatasize(a4),a4
			jsr	(a1)
			lea	aon_chdatasize(a4),a4
			jsr	(a1)
			lea	aon_chdatasize(a4),a4
			jsr	(a1)
			lea	aon_chdatasize(a4),a4
			jsr	(a1)

			moveq	#0,d1			; Make channel-mask
			moveq	#0,d7
			lea	aon8_startinstr.1(pc),a1


			lea	aon_channels,a4	; do effect command
			lea	mix_bypass,a5
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)

			lea	-8*$10(a5),a5

			lea	-(8*aon_chdatasize)(a4),a4

			moveq	#0,d7

			lea	aon8_startinstr.2(pc),a1
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)
			jsr	(a1)

			rts

;========================================================================
;---------------------- Neuen Step auslesen -------------------------
aon8_playnewstep

;	TST.B	REPLAYSTATUS+MAIN_DATA
;	BEQ	AON8_PLAYCURRENT_NONEWPOSX

			cmp.b	#$ff,aon_patcnt(a6)
			beq.w	aon8_breakpat

; read new step
aon8_getstep
			tst.b	aon_patdelaycnt+1(a6)
			bmi.s	aon8_nopatdelay
			beq.s	aon8_nopatdelay
			subq.b	#1,aon_patdelaycnt+1(a6)
			bra.w	aon8_playcurrent_nonewposX
aon8_nopatdelay		move.b	#-1,aon_patdelaycnt+1(a6)
	
			lea	aon_channels,a4
			lea	aon_multab120,a5	; needed for periodtab

			moveq	#0,d0
			MOVE.b	ACTEDITPATTERN,D0

;move.b	aon_actpat(a6),d0
			move.l	aon_pattdata(a6),a0	; get start of patdat

			moveq	#11,d1
			lsl.l	d1,d0			; patnr*1024=patoff
			lea	(a0,d0.l),a0		; add to start of data
			move	aon_patcnt(a6),d1

;	MOVE.B	D1,DISPPATCNT+MAIN_DATA

			lsl	#3,d1			; *8
			lea	(a0,d1.l),a0		; add pattcounter

; a0=pointer on actual step
			jsr	aon_getdachannel	; get first channel
			lea	aon_chdatasize(a4),a4
			addq.l	#4,a0
			jsr	aon_getdachannel	; get second channel
			lea	aon_chdatasize(a4),a4
			addq.l	#4,a0
			jsr	aon_getdachannel	; get third channel
			lea	aon_chdatasize(a4),a4
			addq.l	#4,a0
			jsr	aon_getdachannel	; get fourth channel
			lea	aon_chdatasize(a4),a4
			addq.l	#4,a0
			jsr	aon_getdachannel	; get fifth channel
			lea	aon_chdatasize(a4),a4
			addq.l	#4,a0
			jsr	aon_getdachannel	; get sixth channel
			lea	aon_chdatasize(a4),a4
			addq.l	#4,a0
			jsr	aon_getdachannel	; get seventh channel
			lea	aon_chdatasize(a4),a4
			addq.l	#4,a0
			jsr	aon_getdachannel	; get eighth channel

			tst.b	aon_loopflag(a6)
			beq.s	aon8_nolooping
			clr.b	aon_loopflag(a6)
			move.b	aon_looppoint(a6),aon_patcnt+1(a6)
			bra.b	aon8_playcurrent_nonewposX
aon8_nolooping		addq.b	#4,aon_patcnt+1(a6)
			bne.b	aon8_playcurrent_nonewposX  ; End of pattern??
aon8_breakpat		

;	MOVE.B	#%1111,PATTDSPREQ+MAIN_DATA

			clr.b	aon_patdelaycnt+1(a6)
			clr	aon_looppoint(a6)

;	CMP.B	#REPLAYST_PAT,REPLAYSTATUS+MAIN_DATA
;	BEQ.B	AON8_PLAYCURRENT2

			addq.b	#1,aon_pos(a6)	; pos=pos+1
			move.l	aon_statdata(a6),a3
			move.b	aon.songinfo_maxpos(a3),d0	; get maxpos
			cmp.b	aon_pos(a6),d0	; End of song ??
			bhi.b	aon8_playcurrent2
			move.b	aon.songinfo_respos(a3),aon_pos(a6) ; Get restart pos!
			bsr.w	AON_SongEnd
aon8_playcurrent2	tst.b	aon_patcnt(a6)
			beq.b	aon8_playcurrent_nonewposX
			clr.b	aon_patcnt(a6)

			moveq	#0,d7
			move.b	aon_pos(a6),d7
			move.l	aon_posdata(a6),a1	; get start of posdat
			moveq	#0,d0
			move.b	(a1,d7),d0		; d7=act. pos + choff

;	CMP.B	#REPLAYST_ALL,REPLAYSTATUS+MAIN_DATA
;	BNE.S	AON8_DONTSETPATNR2
			MOVE.B	D0,ACTEDITPATTERN

AON8_DONTSETPATNR2
			bra.w	aon8_getstep
aon8_playcurrent_nonewposX
			rts
;========================================================================
AON8_STARTINSTR.1
			move	aon_fxcom(a4),d0
			and	#$0ff0,d0
			cmp	#$0ed0,d0
			beq.b	aon8_strtinsonlyrep.1

			move	aon_period(a4),d0	; baseper+arpeggio
			add	aon_perslide(a4),d0	; portamento value
.checkhiper
			cmp	#103,d0
			bhs.b	.noperalert
			moveq	#103,d0
.noperalert		move	d0,$6(a5)


			move.b	aon_chflag(a4),$8(a5)


			moveq	#0,d0
			move.b	aon_volume(a4),d0
			moveq	#0,d2
			move.b	aon_synthVOL(a4),d2
			mulu	d2,d0
			lsr	#6,d0
			mulu	aon_trackvol(a4),d0
			lsr	#6,d0
			move.b	d0,$9(a5)

			move.l	aon_waveform(a4),$0(a5)

			move	aon_wavelen(a4),$4(a5)

aon8_strtinsonlyrep.1
			addq.b	#1,d7
aon8_strtinsonlyrep.2	lea	aon_chdatasize(a4),a4
			lea	$10(a5),a5
			rts
AON8_STARTINSTR.2
			move	aon_fxcom(a4),d0
			and	#$0ff0,d0
			cmp	#$0ed0,d0
			beq.b	aon8_strtinsonlyrep.1

.sample2
			move.l	aon_repeatstrt(a4),10(a5)
			move	aon_replen(a4),14(a5)
			clr.b	aon_chflag(a4)
			bra.b	aon8_strtinsonlyrep.1
;--------------------------------------------------------------------
acteditpattern		ds.b	2


;====================================================================
			section	sdfsdf,data
mod:	dc.l	0

;	incbin	"dh1:sfx/mods/own.modules/1995/aon8.silence of the rain"
;	incbin	"dh1:sfx/mods/artofnoise/tommy/aon8.fm-demosong"
;	incbin	"dh1:sfx/mods/artofnoise/aon8.ethnomagic (NHP)"
;	incbin	"dh1:sfx/mods/artofnoise/aon8.scrambled mind"
;	incbin	"dh1:sfx/mods/artofnoise/tommy/aon8.trancemission2"
;	incbin	"dh1:sfx/mods/artofnoise/aon8.disk-maskin"


			section	buffer,bss_C
buffers			ds.b	512+mix_buflen*4*2	; DOUBLE BUFFERING

