#include <exec/exec.h>
#include <dos/dos.h>
#include <devices/ahi.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <clib/alib_protos.h>
#include "defines.h"

#ifndef IOERR_SUCCESS
#define IOERR_SUCCESS 0
#endif

int BUF_SIZE=882*2;
struct MsgPort *ahi_mp;
struct AHIRequest *ahi_io1, *ahi_io2, *join;
int ahi_open=0;
word *ahi_buf1, *ahi_buf2;
word soundbuffer1[882*16];
word soundbuffer2[882*16];
struct Task *parent_thread;
struct Task *soundcard_thread;
int play_active=0;
word play_addr;
byte play_speed;

extern int cpuJSR(word npc, byte na);
extern void synth_render (word *buffer, dword len);

void soundcard_init(void);
void start_playing(word nplay_addr, byte nplay_speed);
void stop_playing(void);
static void play_thread_func(void);

void soundcard_init(void)
{
	// If playing thread is active kill it
	stop_playing();
	
	ahi_mp = CreateMsgPort();
	ahi_io1 = (struct AHIRequest *)CreateIORequest(ahi_mp, sizeof(struct AHIRequest));
	ahi_io2 = (struct AHIRequest *)CreateIORequest(ahi_mp, sizeof(struct AHIRequest));
	join = NULL;
	if (!ahi_io1 || !ahi_io2) {
		PrintFault(ERROR_NO_FREE_STORE, NULL);
		return;
	}
	if (OpenDevice((STRPTR)"ahi.device", 0, (struct IORequest *)ahi_io1, 0)
		!= IOERR_SUCCESS)
	{
		Printf((STRPTR)"Failed to open ahi.device\n");
		return;
	}
	CopyMem(ahi_io1, ahi_io2, sizeof(struct AHIRequest));
	ahi_open = -1;
	ahi_buf1 = soundbuffer1;
	ahi_buf2 = soundbuffer2;
}

void start_playing(word nplay_addr, byte nplay_speed)
{
	if (!ahi_open) return;
	play_addr = nplay_addr;
	play_speed= nplay_speed;
	play_active = -1;
	parent_thread = FindTask(NULL);
	soundcard_thread = CreateTask((STRPTR)"TinySID soundcard thread",
		5, (APTR)play_thread_func, 8192);
}

void stop_playing(void)
{
	if (play_active) {
		play_active = 0;
		Wait(SIGF_CHILD);
		DeleteTask(soundcard_thread);
		soundcard_thread = NULL;
	}
	if (ahi_open) {
		CloseDevice((struct IORequest *)ahi_io1);
		ahi_open = 0;
	}
	DeleteIORequest((struct IORequest *)ahi_io1); ahi_io1 = NULL;
	DeleteIORequest((struct IORequest *)ahi_io2); ahi_io2 = NULL;
	DeleteMsgPort(ahi_mp); ahi_mp = NULL;
}

static void play_thread_func(void)
{
	UBYTE flags = ahi_mp->mp_Flags;
	UBYTE sigbit = ahi_mp->mp_SigBit;
	struct Task *sigtask = ahi_mp->mp_SigTask;
	int j;
	struct AHIRequest *io;
	word *buf;

	ahi_mp->mp_Flags = PA_IGNORE;
	ahi_mp->mp_SigBit = AllocSignal(-1);
	ahi_mp->mp_SigTask = FindTask(NULL);
	ahi_mp->mp_Flags = PA_SIGNAL;

	while (play_active) {
		io = ahi_io1;
		buf = ahi_buf1;
		if (play_speed == 0)
			for (j = 0; j < 8; j++) {
				cpuJSR(play_addr, 0);
				synth_render(&buf[882*j], 882);
			}
		else if (play_speed == 1)
			for (j = 0; j < 8; j++) {
				cpuJSR(play_addr, 0);
				synth_render(&buf[441*j], 441);
			}
		io->ahir_Std.io_Command = CMD_WRITE;
		io->ahir_Std.io_Offset = 0;
		io->ahir_Std.io_Data = buf;
		io->ahir_Std.io_Length = BUF_SIZE*8;
		io->ahir_Frequency = 44100;
		io->ahir_Type = AHIST_M16S;
		io->ahir_Volume = 0x10000;
		io->ahir_Position = 0x8000;
		io->ahir_Link = join;
		SendIO((struct IORequest *)io);
		if (join) {
			WaitIO((struct IORequest *)join);
		}
		join = io; ahi_io1 = ahi_io2; ahi_io2 = io;
		ahi_buf1 = ahi_buf2; ahi_buf2 = buf;
	}
	
	ahi_mp->mp_Flags = PA_IGNORE;
	ahi_mp->mp_SigBit = sigbit;
	ahi_mp->mp_SigTask = sigtask;
	ahi_mp->mp_Flags = flags;
		
	Signal(parent_thread, SIGF_CHILD);
	Wait(0);
}
