/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package symreader;
import javax.swing.DefaultListModel;
import java.io.File;
import java.io.FileInputStream;

/**
 *
 * @author Patrick Meng 2008
 */

interface SymphonieSequence { 
    int SEQUENCE_STARTPOS	=	0;
    int SEQUENCE_LENGTH		=	2;
    int SEQUENCE_LOOP		=	4;	//;1 = 1xLOOPEN
    int SEQUENCE_INFO		=	6;	//;0=PLAY 1=SKIP -1=LAST OF SONG
    int SEQUENCE_TUNE		=	8;	//;SEQ TRANSPOSE HALBTONES

    int SEQUENCE_SIZEOF		=	16;

    int SEQINFO_PLAY		=	0;
    int SEQINFO_SKIP		=	1;
    int SEQINFO_ENDSONG		=	-1;
}

interface SymphoniePosition {
    int POSITION_LOOPNUMB       =	4;
    int POSITION_LOOPCOUNT      =	6;
    int POSITION_PATNUM         =	8;
    int POSITION_STARTPOINT     =       10;
    int POSITION_LEN		=	12;
    int POSITION_SPEED		=	14;
    int POSITION_TUNE		=	16;
    int POSITION_EVENTSPERLINE	=	18;	//;WORD: 0=1 Event per Line
    int POSITION_SIZEOF		=	32;    
}

interface SymphonieNote { // Offsets to Event
        int NOTE_FX = 0;
        int NOTE_PITCH = 1;
        int NOTE_VOLUME = 2;
        int NOTE_INSTR = 3;
}

interface SymphonieEventType { // Event Types as in SymphonieNote.NOTE_FX
    int FX_KEYON=0;
    int FX_VOLUMESLIDEUP=1;
    int FX_VOLUMESLIDEDOWN=2;
    int FX_PITCHSLIDEUP=3;
    int FX_PITCHSLIDEDOWN=4;
    int FX_REPLAYFROM=5;
    int FX_FROMANDPITCH=6;
    int FX_SETFROMADD=7;
    int FX_FROMADD=8;
    int FX_SETSPEED=9;
    int FX_ADDPITCH=10;
    int FX_ADDVOLUME=11;
    int FX_VIBRATO=12;
    int FX_TREMOLO=13;
    int FX_SAMPLEVIB=14;
    int FX_PSLIDETO=15;
    int FX_RETRIG=16;
    int FX_EMPHASIS=17;
    int FX_ADDHALVTONE=18;
    int FX_CV=19;
    int FX_CVADD=20;
    int FX_FILTER=23;  
    int FX_DSPECHO=24; // Echo is defined as repeating delays
    int FX_DSPDELAY=25; // Delay
    int FX_DSPCHOR=26; // Chorus Experimental
}

interface SymphonieVolume { 
    int VOLUME_STOPSAMPLE	=	254;
    int VOLUME_CONTSAMPLE	=	253;
    int VOLUME_STARTSAMPLE	=	252;
    int VOLUME_KEYOFF		=	251;
    int VOLUME_SPEEDDOWN	=	250;
    int VOLUME_SPEEDUP		=	249;
    int VOLUME_SETPITCH		=	248;
    int VOLUME_PITCHUP		=	247;
    int VOLUME_PITCHDOWN	=	246;
    int VOLUME_PITCHUP2		=	245;
    int VOLUME_PITCHDOWN2	=	244;
    int VOLUME_PITCHUP3		=	243;
    int VOLUME_PITCHDOWN3	=	242;
    int VOLUME_NONE		=	0;
    int VOLUME_MIN		=	1;
    int VOLUME_MAX		=	100;
    int VOLUME_COMMAND		=	200;
}

interface SymphonieNotePitch { 
    int NOTEPITCH_NONOTE	=	-1;
    int NOTEPITCH_MIN		=	0;
    int NOTEPITCH_OCTAVE	=	12;
    int NOTEPITCH_MAX		=	(NOTEPITCH_OCTAVE*7);
}


// Patterneditor Handling
class SymphSongEvent {
    int Type;
    int ParaA;
    int ParaB;
    int ParaC;
    String AsString = "";
    String ShortString = "";
    SymphSongEvent(){
        Type = 0;
        ParaA = 0;
        ParaB = 0;
        ParaC = 0;
    };
};

public class ImportSongSymphonie {
    private DefaultListModel DebugListModel;
    private DefaultListModel InstrumentNamesModel;
    private DefaultListModel PositionsListModel;
    private Song mySong;
    private byte[] TempPatternData;
    private int[] ConvertInstNrIndex = new int[256];
    
    // Temp Vars for file reading
    private int ActualSampleIndex = 0;
    
    // Temp Vars, often used
    private SymphSongEvent tempEvent = new SymphSongEvent();
    
    public void initImport(DefaultListModel ListModel,
            DefaultListModel InstrList,
            DefaultListModel myPositionsListModel,
            Song SymSong) {
        DebugListModel = ListModel;
        InstrumentNamesModel = InstrList;
        PositionsListModel = myPositionsListModel;
        mySong = SymSong;
    }
    
    // Info Displaying
    private void addInstrumentList(String s) {
        InstrumentNamesModel.addElement(s);   
    }
    
    private void addPositionList(String s) {
        PositionsListModel.addElement(s);   
    }

    // Info Displaying
    private void PrintInfo(String s) {
        DebugListModel.addElement(s);   
    }
    
    private void PrintToInfoWindow (String s){
        PrintInfo(s);
    }

    private void PrintToInfoWindow (String s, int i){
        s = s + i;
        PrintToInfoWindow(s);
    }

    private void PrintToInfoWindow (String s, int i, String s2){
        s = s + i + " " + s2;
        PrintToInfoWindow(s);
    }
    
    private void PrintByteBlockAsString(byte[] SrcByteBlock, int Len) {
        String s="";
        char c;
        int i=0;
        int counter = 0;
        boolean CR;
        for(i=0;i<Len;i++) {
            CR = false;

            c = (char) SrcByteBlock[i];
            if(SrcByteBlock[i] == 13) CR = true;
            if(SrcByteBlock[i] == 10) CR = true;
            if(SrcByteBlock[i] >31) s = s + c;
            counter++;
            if((counter > 256) || CR) {
                counter = 0;
                PrintToInfoWindow("        " + s);
                s = "";
            }
        }    
        PrintToInfoWindow(s);
    }
  
    // File and memory i/o
    private String ReadID(FileInputStream fi) {                                        
        String s="";
        int databyte = 0;
                try {               
                    databyte = fi.read();
                    s = s + (char) databyte;
                    databyte = fi.read();
                    s = s + (char) databyte;
                    databyte = fi.read();
                    s = s + (char) databyte;                    
                    databyte = fi.read();
                    s = s + (char) databyte;
                } catch (java.io.IOException e) {
                    PrintInfo("ReadID():Error while reading file.");
                }           
                return(s);
    }

        private long ReadLong(FileInputStream fi) {                                        
            int databyte = 0;
            int Value = 0;

            try {               
                databyte = fi.read();
                databyte = databyte & 0x000000ff;
                Value = databyte;
                databyte = fi.read();
                databyte = databyte & 0x000000ff;
                Value = (256*Value) + databyte;
                databyte = fi.read();
                databyte = databyte & 0x000000ff;
                Value = (256*Value) + databyte;  
                databyte = fi.read();
                databyte = databyte & 0x000000ff;
                Value = (256*Value) + databyte;
            } catch (java.io.IOException e) {
                PrintInfo("ReadLong():Error while reading file.");
            }           
            return(Value);
        }

        private int ReadInt(FileInputStream fi) {                                        
            int databyte = 0;
            int bigint = 0;
            try {               
                databyte = fi.read();
                databyte = fi.read();
                databyte = fi.read();
                databyte = fi.read();
                if(databyte<128){ 
                    bigint = (int) databyte;
                } else {
                    bigint = (int) databyte-256;
                }                      

            } catch (java.io.IOException e) {
                PrintInfo("ReadInt():Error while reading file.");
                bigint = 10000; // illegal Event Id 
            }           
            return(bigint);
        }    

    private int ReadMemoryByteToInt(byte[] SrcByteBlock, int Offset){
        int tempint;
        tempint = (int) SrcByteBlock[Offset];
        tempint = tempint & 0x000000ff;
        return(tempint);
    }
    
    private int ReadMemoryShortToInt(byte[] SrcByteBlock, int Offset){
        int a,b;
        a = (int) SrcByteBlock[Offset];
        a = a & 0x000000ff;
        b = (int) SrcByteBlock[Offset+1];
        b = b & 0x000000ff;
        return((a*256)+b);
    }

    private int ReadMemoryShortToSignedInt(byte[] SrcByteBlock, int Offset){
        int a,b;
        a = (int) SrcByteBlock[Offset];
        a = a & 0x000000ff;
        b = (int) SrcByteBlock[Offset+1];
        b = b & 0x000000ff;
        a = (a*256)+b;
        if(a>=(128*256)) 
            a = -((256*256)-a);
        return(a);
    }    
    
    private long ReadMemoryLong(byte[] SrcByteBlock, int Offset){
        long templong2 = 0;
        long templong = 0;
        byte tempbyte = 0;

        tempbyte = SrcByteBlock[Offset];
        Offset++;
        templong2 = tempbyte;
        templong2 = templong2 & 0x000000ff;
        templong *= 256;
        templong = templong | templong2;
        tempbyte = SrcByteBlock[Offset];
        Offset++;
        templong2 = tempbyte;
        templong2 = templong2 & 0x000000ff;
        templong *= 256;
        templong = templong | templong2;
        tempbyte = SrcByteBlock[Offset];
        Offset++;
        templong2 = tempbyte;
        templong2 = templong2 & 0x000000ff;
        templong *= 256;
        templong = templong | templong2;
        tempbyte = SrcByteBlock[Offset];
        Offset++;
        templong2 = tempbyte;
        templong2 = templong2 & 0x000000ff;
        templong *= 256;
        templong = templong | templong2;
        return(templong);
    }
     
    private String ConvertByteBlockToString(byte[] SrcByteBlock, int Len){
        String s="";
        char c;
        int i=0;
        int counter = 0;
        for(i=0;i<Len;i++) {
            c = (char) SrcByteBlock[i];
            s = s + c;
            counter++;
            if(counter > 40) {
                counter = 0;
                c = '\r';
                s = s + c;
            }
        }
        return(s);
    }

    private int ConvertByteToInt(byte tempbyte){
        int newint;
        newint = tempbyte;
        if(newint < 0) {
            newint = 256+newint;
        }
        return(newint);
    }

    private void LoadPattern(byte[] Src, int Len) {
        int SrcEventLen = 4;
        int PatternSize = mySong.getNumbOfRows() * 
                mySong.getNumbOfVoices() * SrcEventLen;
        int NewNumbOfPatterns = Len / PatternSize;
        
        PrintToInfoWindow("Loading Pattern. Total Length:", Len);
        if(Len >0) {
            if(NewNumbOfPatterns > 0) mySong.setNumbOfPatterns(NewNumbOfPatterns); 
            ImportSymphoniePatterns(Src, Len);
            PrintToInfoWindow("Pattern Import Done.");
        }
    }   
    
    void BuildSongEvent(byte[] Src, int PatternIndex, int VoiceIndex, int LineNr, SongEvent se ) {
        int w = mySong.getNumbOfVoices();
        int h = mySong.getNumbOfRows();
        int SrcEventLen = 4;
        int PatternSize = w*h*SrcEventLen;       
        int BasePtr = (PatternSize * PatternIndex) +
                (LineNr * w * SrcEventLen) +
                (VoiceIndex * SrcEventLen);
        ConvertEvent(se, Src[BasePtr + SymphonieNote.NOTE_FX], 
                Src[BasePtr + SymphonieNote.NOTE_INSTR], 
                Src[BasePtr + SymphonieNote.NOTE_PITCH], 
                Src[BasePtr + SymphonieNote.NOTE_VOLUME]);
    }
    
    
    void ConvertInstrNr(SongEvent se) {
        int temp = (int) se.A;
        se.A = ConvertInstNrIndex[temp];
    }
    
    void ConvertEvent(SongEvent se, int FXType, int ParaA, int ParaB, int ParaC) {
        int tempPitch;
        FXType = FXType & 0x000000ff;
        ParaA = ParaA & 0x000000ff;
        ParaB = ParaB & 0x000000ff;
        ParaC = ParaC & 0x000000ff;
        se.SongFXType = SongEventType.FX_NONE;
        if((FXType==0) && 
            (ParaB==255) &&
            (ParaA == 0) &&
            (ParaC== 0) ) {
            se.SongFXType = SongEventType.FX_NONE;
            se.A = 0;
            se.B = 0;
            se.C = 0;
        } else {
            se.A = ParaA;
            se.B = ParaB;
            se.C = ParaC;
        switch(FXType){
            case(SymphonieEventType.FX_KEYON): {
                if(ParaC > SymphonieVolume.VOLUME_COMMAND) {
                    switch(ParaC) {
                        case SymphonieVolume.VOLUME_KEYOFF:
                            se.SongFXType = SongEventType.FX_KEYOFF;break;
                        case SymphonieVolume.VOLUME_STARTSAMPLE:
                            se.SongFXType = SongEventType.FX_STARTSAMPLE;break;
                        case SymphonieVolume.VOLUME_CONTSAMPLE:
                            se.SongFXType = SongEventType.FX_CONTSAMPLE;break;
                        case SymphonieVolume.VOLUME_STOPSAMPLE:
                            se.SongFXType = SongEventType.FX_STOPSAMPLE;break;
                        case SymphonieVolume.VOLUME_SPEEDDOWN:
                            se.SongFXType = SongEventType.FX_SPEEDDOWN;break;
                        case SymphonieVolume.VOLUME_SPEEDUP:
                            se.SongFXType = SongEventType.FX_SPEEDUP;break;
                        case SymphonieVolume.VOLUME_PITCHDOWN:
                            se.SongFXType = SongEventType.FX_PITCHDOWN;break;
                        case SymphonieVolume.VOLUME_PITCHDOWN2:
                            se.SongFXType = SongEventType.FX_PITCHDOWN2;break;
                        case SymphonieVolume.VOLUME_PITCHDOWN3:
                            se.SongFXType = SongEventType.FX_PITCHDOWN3;break;
                        case SymphonieVolume.VOLUME_PITCHUP:
                            se.SongFXType = SongEventType.FX_PITCHUP;break;
                        case SymphonieVolume.VOLUME_PITCHUP2:
                            se.SongFXType = SongEventType.FX_PITCHUP2;break;
                        case SymphonieVolume.VOLUME_PITCHUP3:
                            se.SongFXType = SongEventType.FX_PITCHUP3;break;
                        case SymphonieVolume.VOLUME_SETPITCH:
                            se.SongFXType = SongEventType.FX_SETPITCH;ConvertInstrNr(se);break;
                        } // end case volume special fx
                    } else {
                        // is Keyon
                        if(se.B==255) {
                            se.SongFXType = SongEventType.FX_SETVOLUME;
                        } else {
                            se.SongFXType = SongEventType.FX_KEYON;
                            ConvertInstrNr(se);
                        }
                    }
                } //end of Keyon case
                break;

            // Volume FX
            case(SymphonieEventType.FX_ADDVOLUME):
                se.SongFXType = SongEventType.FX_ADDVOLUME;break;
            case(SymphonieEventType.FX_CV):
                se.SongFXType = SongEventType.FX_CV;break;
            case(SymphonieEventType.FX_CVADD):
                se.SongFXType = SongEventType.FX_CVADD;break;
            case(SymphonieEventType.FX_VIBRATO):
                se.SongFXType = SongEventType.FX_VIBRATO;break;
            case(SymphonieEventType.FX_VOLUMESLIDEDOWN):
                se.SongFXType = SongEventType.FX_VOLUMESLIDEDOWN;break;
            case(SymphonieEventType.FX_VOLUMESLIDEUP):
                se.SongFXType = SongEventType.FX_VOLUMESLIDEUP;break;

                // Pitch FX
            case(SymphonieEventType.FX_ADDPITCH):
                se.SongFXType = SongEventType.FX_ADDPITCH;break;
            case(SymphonieEventType.FX_ADDHALVTONE):
                se.SongFXType = SongEventType.FX_ADDHALVTONE;break;
            case(SymphonieEventType.FX_PITCHSLIDEDOWN):
                se.SongFXType = SongEventType.FX_PITCHSLIDEDOWN;break;
            case(SymphonieEventType.FX_PITCHSLIDEUP):
                se.SongFXType = SongEventType.FX_PITCHSLIDEUP;break;
            case(SymphonieEventType.FX_PSLIDETO):
                se.SongFXType = SongEventType.FX_PSLIDETO;break;
            case(SymphonieEventType.FX_TREMOLO):
                se.SongFXType = SongEventType.FX_TREMOLO;break;

            // DSP Fx
            case(SymphonieEventType.FX_DSPCHOR):
                se.SongFXType = SongEventType.FX_DSPCHOR;break;
            case(SymphonieEventType.FX_DSPDELAY):
                se.SongFXType = SongEventType.FX_DSPDELAY;break;
            case(SymphonieEventType.FX_DSPECHO):
                se.SongFXType = SongEventType.FX_DSPECHO;break;
            // Other FX
            case(SymphonieEventType.FX_EMPHASIS):
                se.SongFXType = SongEventType.FX_EMPHASIS;break;
            case(SymphonieEventType.FX_FILTER):
                se.SongFXType = SongEventType.FX_CHANNELFILTER;break;
            case(SymphonieEventType.FX_SETSPEED):
                se.SongFXType = SongEventType.FX_SETSPEED;break;

                // Sample Pointer FX
            case(SymphonieEventType.FX_FROMADD):
                se.SongFXType = SongEventType.FX_FROMADD;break;
            case(SymphonieEventType.FX_FROMANDPITCH):
                se.SongFXType = SongEventType.FX_FROMANDPITCH;ConvertInstrNr(se);break;
           case(SymphonieEventType.FX_REPLAYFROM):
                se.SongFXType = SongEventType.FX_REPLAYFROM;break;
            case(SymphonieEventType.FX_RETRIG):
                se.SongFXType = SongEventType.FX_RETRIG;break;
            case(SymphonieEventType.FX_SAMPLEVIB):
                se.SongFXType = SongEventType.FX_SAMPLEVIB;break;
            case(SymphonieEventType.FX_SETFROMADD):
                se.SongFXType = SongEventType.FX_SETFROMADD;break;
            }
        }       
        se.UpdateEventClass();
    }
    
    void ImportSymphoniePatterns(byte[] Src, int Len) {
        SongEvent se = new SongEvent();
        SongPattern myPat;
        for(int PatternIndex=0;PatternIndex<mySong.getNumbOfPatterns();PatternIndex++) {
            myPat = mySong.getPattern(PatternIndex);
            myPat.init(mySong.getNumbOfVoices());
            for(int VoiceIndex=0;VoiceIndex<mySong.getNumbOfVoices();VoiceIndex++) {
                for(int LineNr=0;LineNr<mySong.getNumbOfRows();LineNr++) {
                    float TimePosition = (float) LineNr;
                    BuildSongEvent(Src, PatternIndex, VoiceIndex, LineNr, se );
                    myPat.addSongEvent(VoiceIndex, TimePosition, se);
                }
            }
        }
    }
     
     // Hunk Handling
    private String GetElementName(int ElementId) {
        String s ="Unknown Element ID";
        switch(ElementId) {
            case -1: s = "Number of Audiochannels";break;
            case -2: s = "Tracklength";break;
            case -3: s = "Total Patternlength in Events";break;
            case -4: s = "Number of Instruments";break;
            case -5: s = "Length of one Songevent in bytes";break;
            case -6: s = "System BPM";break;
            case -7: s = "Is a pure Song without Samples included (Flag)";break;
            case -10: s = "Songdata";break; // Positions ?
            case -11: s = "Sample (Binary)";break;
            case -12: s="";break; //s = "Emptysample (no data following)";break;
            case -13: s = "Notedata (Songevents)";break;
            case -14: s = "Samplenames (Instrumentdefinitions)";break;
            case -15: s = "Sequence";break;
            case -16: s = "Infotext";break;
            case -17: s = "Sample (Binary Deltapacked)";break;
            case -18: s = "Sample (Binary Deltapacked as 16 Bit)";break;
            case -19: s = "Infotype";break;
            case -20: s = "Infoobject (Binary)";break;
            case -21: s = "Infostring";break;
            case 10: s = "NG Sampleboost activated (Global Samplevolume)";break;
            case 11: s = "Stereo Enhancer, Pitchdiff";break;
            case 12: s = "Stereo Enhancer, Samplediff";break;
        }
        return(s);
    }   

    private boolean isElementWithSingleParameter(int ElementId) {
        boolean b = false;
        if((ElementId <= -1) && (ElementId >= -7)) {
            b = true;
        }
        if((ElementId <= 12) && (ElementId >= 10)) {
            b = true;
        }
        return(b);
    }

    // Instrument loading
    private void MoveNextNonVirtualSample(){
        boolean done = false;
        do{    
            ActualSampleIndex++;
            if(ActualSampleIndex >= mySong.getNumbOfInstruments()) {
                done = true;
            } else {
                SymphonieInstrument si =  mySong.getInstrumentExisting(ActualSampleIndex);
                if (si != null) {
                    if(si.MultiChannel < 2) done = true;
                }
            }
        } while(done == false);
    }
    
    private void LoadInstrumentNamesBlock(byte[] SrcByteBlock, long Len) {
        int NumbOfInstruments;
        int i,j;
        String s;
        char c;
        int SrcOffset = 0;
        int ActualInstrNr = 0;

        NumbOfInstruments = ( int )Len / 256;
        for(i=0; i<NumbOfInstruments; i++ ) {
            s = "";
            c = (char) SrcByteBlock[SrcOffset];
            j = 0;

            while(c != 0) {
                s = s.concat(String.valueOf(c));
                j++;
                c = (char) SrcByteBlock[SrcOffset+j];
                if(j>127) c = 0;
            }

            if( s.equals("ViRT")) {
                s = "* Virtual Instrument *";
                addInstrumentList(s);
                LoadInstrumentDefBlock(SrcByteBlock, i, SrcOffset, ActualInstrNr, s, true);
                ActualInstrNr ++;
            } else {
                if( !s.isEmpty()) {
                    addInstrumentList(s);
                    LoadInstrumentDefBlock(SrcByteBlock, i, SrcOffset, ActualInstrNr, s, false);
                    ActualInstrNr ++;
                }
            }
            SrcOffset += 256;
        }
    }
    
    private void LoadInstrumentDefBlock(byte[] SrcByteBlock, int OrigInstrNr, 
            int SrcOffset, int InstrNr, String s, boolean isVirtual) {
        SymphonieInstrument si;
        
        si = mySong.getInstrument(InstrNr);
        si.Name = s;
        si.VirtualSample = isVirtual;
        si.OrigInstrumentNr = OrigInstrNr;
        ConvertInstNrIndex[OrigInstrNr] = InstrNr;
        si.Type = ConvertByteToInt(SrcByteBlock[SrcOffset+128]);// 0=Normal, 4 = Looped
/*        
SAMPLENAME_INSTRTYPE	EQU	128	;0=No Instr         
INSTRTYPE_SILENT	EQU	-8
INSTRTYPE_KILL	EQU	-4
INSTRTYPE_NONE	EQU	0
INSTRTYPE_LOOP	EQU	4
INSTRTYPE_SUST	EQU	8 
*/        
        si.MultiChannel = ConvertByteToInt(SrcByteBlock[SrcOffset+132]); //0=MONO
        //MULTISAMPLE_MONO	EQU	0
        //MULTISAMPLE_STEREOL	EQU	1
        //MULTISAMPLE_STEREOR	EQU	2
        //MULTISAMPLE_LINESRC	EQU	3    

                // Volume
        si.Volume = ConvertByteToInt(SrcByteBlock[SrcOffset+134]);
        if(si.Volume == 0) si.Volume = 100; // default to 100%
        if(si.Volume > 100) si.Volume = 100; // toimplement

        // Tune
        si.Tune = SrcByteBlock[SrcOffset+139];  
        if(SrcByteBlock[SrcOffset+143] != 0) { // SAMPLENAME_DOWNSAMPLE	EQU	143	;0=NONE
            // Correct Pitch because of Downsampling
            if(SrcByteBlock[SrcOffset+143] == 1) si.Tune -= 12; 
            if(SrcByteBlock[SrcOffset+143] == 2) si.Tune -= 24; 
            if(SrcByteBlock[SrcOffset+143] == 3) si.Tune -= 36; 
            if(SrcByteBlock[SrcOffset+143] == 4) si.Tune -= 48; 
        }
        
        si.FineTune = SrcByteBlock[SrcOffset+138];

        // Looping
        si.LoopStart = ConvertByteToInt(SrcByteBlock[SrcOffset+129]) * 256 * 256; // 100% * 256 * 256
        si.Looplen = ConvertByteToInt(SrcByteBlock[SrcOffset+130]) * 256 * 256;
        si.setNumbOfLoops(ConvertByteToInt(SrcByteBlock[SrcOffset+131]) );
        si.NewLoopSystem = (si.LineSampleFlags & 16) != 0;
        if(si.NewLoopSystem == true) {
            si.LoopStart = (si.LoopStart ) 
                    + (ConvertByteToInt(SrcByteBlock[SrcOffset+150])  * 256)
                    + ConvertByteToInt(SrcByteBlock[SrcOffset+151])  ;
            si.Looplen = (si.Looplen ) +
                    + (ConvertByteToInt(SrcByteBlock[SrcOffset+152])  * 256)
                    + ConvertByteToInt(SrcByteBlock[SrcOffset+153])  ;
        }
        if(si.Type==0) {
            si.deactivateLoop();
        }
        if(si.Type==4) {
            si.setHasLoop(true);
        }
 
        // Playflags
        si.PlayFlag = ConvertByteToInt(SrcByteBlock[SrcOffset+142]) & 0xff;
        si.AllowPosDetune = (si.PlayFlag & 1) == 0;
        si.NoDsp = (si.PlayFlag & 2) != 0;
        si.PlaySynced = (si.PlayFlag & 4) != 0;
        //SAMPLENAME_PLAYFLAG	EQU	142	;0=NRM
        //SPLAYFLAG_DODETUNE	EQU	0	;BIT 0 SET:DO POS TUNE OFFSET
        //SPLAYFLAG_NODSP		EQU	1	;BIT 1 SET:DRY ROOM
        //SPLAYFLAG_SUPERFAST	EQU	2	;BIT 2 SET:SYNC PLAY (MONO-> 2xMONO, STEREO->SYNCED)
        // SAMPLENAME_PLAYFLAG

        // Linesample Flags
        si.LineSampleFlags = ConvertByteToInt(SrcByteBlock[SrcOffset+140]) & 0xff;
        si.PlayReverse = (si.LineSampleFlags & 1) != 0;
        si.AsQueue = (si.LineSampleFlags & 2) != 0;
        si.MirrorX = (si.LineSampleFlags & 4) != 0;
        if( (si.LineSampleFlags & 8) != 0) {
            si.SampleResolution = 16;
        } else {
            si.SampleResolution = 8;
        }
        si.NewLoopSystem = (si.LineSampleFlags & 16) != 0;
        //si.NoDsp = (si.LineSampleFlags & 32) != 0;

        si.isInUse = true;
        
        
        
    }
    
    // Sample Impport
    // Attach Sampledata to Instrument
    private void LoadInstrumentSample(byte[] src, long len) {
        int i;
        i = ActualSampleIndex;
        BuildInstrumentSamples(mySong.getInstrument(i), src, (int) len);
        mySong.getInstrument(i).SampleDataLoaded = true;
    }
    
    private void BuildInstrumentSamples(SymphonieInstrument si, byte[] src, int len) {
        si.ImportSample.Analyse(src, len);
        si.sp = si.ImportSample.SamplePools[0];
        si.sp.initLoopDateSymphonieFormat(si.hasLoop(), si.LoopStart, si.Looplen, si.getNumbOfLoops());
        if(si.MultiChannel==1) {
            if(si.ImportSample.getNumbOfChannels() ==2 ) {
                SymphonieInstrument siRight = mySong.getInstrument(ActualSampleIndex+1);
                siRight.sp = si.ImportSample.SamplePools[1];
                siRight.sp.initLoopDateSymphonieFormat(si.hasLoop(), si.LoopStart, si.Looplen, si.getNumbOfLoops());
                siRight.SampleDataLoaded = true;
                siRight.isInUse = true;
                siRight.MultiChannel = 2;
                siRight.Name = si.Name + " R";
                si.Name = si.Name + " L";
            } else {
                // error Stereo Sample not correctly recognized
            }
        }
    }
    
    private void DecodeSampleDeltapacked(byte[] Src, int Len ) {
        int i;
        int Index;
        long ActByte;
        long AddByte;
        byte tempByte;

        Index = 0;
        ActByte = (long) Src[Index];
        ActByte = ActByte & 0x000000ff;
        for(i=1;i<Len;i++) {
            AddByte = (long) Src[Index+1];
            ActByte += AddByte;
            ActByte = ActByte & 0x000000ff;

            if(ActByte>255) ActByte -=256;

            tempByte = (byte) ActByte;
            Src[Index+1] = tempByte;
            Index++;
        } 
        i = 1;
    }

    private void DecodeSampleDeltapacked(byte[] Src, int Len, int StartOffset ) {
        int i;
        int Index;
        long ActByte;
        long AddByte;
        byte tempByte;

        Index = StartOffset;
        ActByte = (long) Src[Index];
        ActByte = ActByte & 0x000000ff;
        for(i=1;i<Len;i++) {
            AddByte = (long) Src[Index+1];
            ActByte += AddByte;
            ActByte = ActByte & 0x000000ff;

            if(ActByte>255) ActByte -=256;

            tempByte = (byte) ActByte;
            Src[Index+1] = tempByte;
            Index++;
        } 
        i = 1;
    }

    private void DecodeSampleDeltapacked16(byte[] Src, int Len ) {
        int i,j;
        int TempSrcOffset = 0;
        int SrcOffsetMSB = 0;   // Vorderen 8 Bit
        int SrcOffsetLSB = 0;   // Hinteren 8 Bit
        int DestIndex = 0;
        int NumbOfBlocks;
        int BlockSize  = 4096;
        byte[] DestTempBlock = new byte[BlockSize];

        if(Len>BlockSize) { 
            NumbOfBlocks = Len / (BlockSize );
            SrcOffsetMSB = (BlockSize/2);
            SrcOffsetLSB = 0;

            for(j=0;j<(NumbOfBlocks);j++) {        
                DestIndex = 0;
                TempSrcOffset = SrcOffsetLSB;
                DecodeSampleDeltapacked(Src, BlockSize, SrcOffsetLSB);

                // Reshuffle Bytes
                for(i=0;i<(BlockSize/2);i++) {
                    byte tempbyte;
                    tempbyte = Src[SrcOffsetMSB++];
                    DestTempBlock[DestIndex++] = tempbyte ;
                    DestTempBlock[DestIndex++] = Src[SrcOffsetLSB++];
                } 
                DestIndex = 0;
                // Copyback
                for(i=0;i<(BlockSize);i++) {
                    Src[TempSrcOffset++] = DestTempBlock[DestIndex++];
                }
                SrcOffsetMSB = TempSrcOffset + (BlockSize/2);
                SrcOffsetLSB = TempSrcOffset;
            }
        }
    }    
    
    
    /* 
     * RLE packed data stream unpacker
     */
    private boolean CheckIsRLEPacked(byte[] SrcByteBlock, byte[] DestByteBlock, long Len){
        boolean isRLEPacked = true;
        // Look for "PACK" following a -1 as doublebyte
        if (SrcByteBlock[0] != 80) isRLEPacked = false;
        if (SrcByteBlock[1] != 65) isRLEPacked = false;
        if (SrcByteBlock[2] != 67) isRLEPacked = false;
        if (SrcByteBlock[3] != 75) isRLEPacked = false;
        if (SrcByteBlock[4] != -1) isRLEPacked = false;
        if (SrcByteBlock[5] != -1) isRLEPacked = false;
        if (Len <= 16) isRLEPacked = false;
        return(isRLEPacked);
    }    
     
    private void DecodeByteBlockRLE(byte[] SrcByteBlock, byte[] DestByteBlock, long Len, int DataBlockID ) {
        long UnpackedLen;
        boolean done = false;
        byte packtype;
        int blocklen;
        int SrcOffset=0, DestOffset = 0;
        int i;
        
        //boolean decodedToDest = false;

        UnpackedLen = Len;
        if( CheckIsRLEPacked(SrcByteBlock, DestByteBlock, Len) == true ) {
            UnpackedLen = ReadMemoryLong(SrcByteBlock, 6 );
            if(UnpackedLen != 0) {
                DestByteBlock = new byte[(int) UnpackedLen];
                SrcOffset = 10;
                //decodedToDest = true;
                while( !done ) {
                    packtype = SrcByteBlock[SrcOffset];
                    SrcOffset ++;
                    switch(packtype) {
                        case 0:  // 1:1 copy of upto 255 bytes
                            blocklen = ConvertByteToInt(SrcByteBlock[SrcOffset]);
                            SrcOffset++;
                            for(i=0;i<blocklen;i++) {
                                DestByteBlock[DestOffset] = SrcByteBlock[SrcOffset];
                                DestOffset++; SrcOffset++;
                            }
                            break;

                        case 3:  // up to 255 bytes 0 bytes (zero bytes)
                            blocklen = ConvertByteToInt(SrcByteBlock[SrcOffset]);
                            SrcOffset++;
                            for(i=0;i<blocklen;i++) {
                                DestByteBlock[DestOffset] = 0;
                                DestOffset++;
                            }
                            break;

                        case 2:  // two identical long s to unpack
                            DestByteBlock[DestOffset] = SrcByteBlock[SrcOffset];
                            DestByteBlock[DestOffset+1] = SrcByteBlock[SrcOffset+1];
                            DestByteBlock[DestOffset+2] = SrcByteBlock[SrcOffset+2];
                            DestByteBlock[DestOffset+3] = SrcByteBlock[SrcOffset+3];
                            DestOffset += 4;    
                            DestByteBlock[DestOffset] = SrcByteBlock[SrcOffset];
                            DestByteBlock[DestOffset+1] = SrcByteBlock[SrcOffset+1];
                            DestByteBlock[DestOffset+2] = SrcByteBlock[SrcOffset+2];
                            DestByteBlock[DestOffset+3] = SrcByteBlock[SrcOffset+3];
                            DestOffset += 4;
                            SrcOffset += 4;
                            break;

                        case 1:  // 1:1 copy of upto 255 long s
                            blocklen = ConvertByteToInt(SrcByteBlock[SrcOffset]);
                            SrcOffset++;
                            for(i=0;i<blocklen;i++) {
                                DestByteBlock[DestOffset] = SrcByteBlock[SrcOffset];
                                DestByteBlock[DestOffset+1] = SrcByteBlock[SrcOffset+1];
                                DestByteBlock[DestOffset+2] = SrcByteBlock[SrcOffset+2];
                                DestByteBlock[DestOffset+3] = SrcByteBlock[SrcOffset+3];
                                DestOffset+=4; 
                            }
                            SrcOffset += 4;
                            break;                        

                        case -1:
                            done = true;
                            break;

                    }

                    // end of block
                    if(SrcOffset>=Len) {
                        done = true;
                    }

                    // check for illegal packing type
                    if(packtype>3) {
                        done = true;
                    }

                    // check for illegal packing type
                    if(packtype<-1) {
                        done = true;

                    }
                }

                // Copy Back to Source Block
                SrcByteBlock = new byte[(int) UnpackedLen];
                for(i=0;i<UnpackedLen;i++) {
                    SrcByteBlock[i] = DestByteBlock[i];
                }
                PrintToInfoWindow("      RLE packed.  Unpacked Blocksize in Byte:", (int) UnpackedLen);
            }
        }
        LoadDataBlock(SrcByteBlock, UnpackedLen, DataBlockID);
    }
 
    void CopyByteBlock(byte[] src, byte[] dest, int len) {
        for(int i=0;i<len;i++) {dest[i] = src[i];}
    }
    void CopyByteBlock(byte[] src, byte[] dest, long len) {
        for(int i=0;i<(int) len;i++) {dest[i] = src[i];}
    }
    
    private void LoadDataBlock(byte[] SrcByteBlock, long Len, int DataBlockID ) {
    if(Len > 0) {
        switch(DataBlockID) {
            case -14:
                assert(mySong.getNumbOfInstruments()!=0);
                mySong.allocNumbInstruments(mySong.getNumbOfInstruments());
                LoadInstrumentNamesBlock(SrcByteBlock, Len);
                break;
            case -11:
                LoadInstrumentSample(SrcByteBlock, Len);
                MoveNextNonVirtualSample();
                break;
            case -13:
                TempPatternData = new byte[(int) Len];
                CopyByteBlock(SrcByteBlock, TempPatternData, (int) Len);
                break;
            case -17: // Deltapacked 8 Bit
                DecodeSampleDeltapacked(SrcByteBlock, (int) Len);
                LoadInstrumentSample(SrcByteBlock, Len);
                //mySong.getInstrument(ActualSampleIndex).SampleSourceType = 1;
                MoveNextNonVirtualSample();
                break;
            case -18: // Deltapacked 16 Bit
                DecodeSampleDeltapacked16(SrcByteBlock, (int) Len);
                LoadInstrumentSample(SrcByteBlock, Len);
                //mySong.getInstrument(ActualSampleIndex).SampleSourceType = 2;
                MoveNextNonVirtualSample();
                break;
            case -15: // Sequence
                ImportSongSeq(SrcByteBlock, (int) Len);
                break;        
            case -10: // Songdata
                ImportSongPositions(SrcByteBlock, (int) Len);
                break;
            }
    }
}

    void ImportSongSeq(byte[] src, long Len) {
        int of;
        int NumbOfElements = ((int) Len / SymphonieSequence.SEQUENCE_SIZEOF);
        mySong.allocResources();
        mySong.allocNumbOfSequences(NumbOfElements);
        if((Len>0) && (src!=null) && (NumbOfElements>0)) {
            if(NumbOfElements>mySong.getNumbOfSequences()) NumbOfElements = mySong.getNumbOfSequences();
            for(int i=0;i<NumbOfElements;i++) {
                of = SymphonieSequence.SEQUENCE_SIZEOF * i;
                Sequence Seq = mySong.getSequence(i);
                Seq.StartPosition = ReadMemoryShortToInt(src, of+SymphonieSequence.SEQUENCE_STARTPOS);
                Seq.EndPosition = ReadMemoryShortToInt(src, of+SymphonieSequence.SEQUENCE_LENGTH);
                Seq.EndPosition = Seq.EndPosition - Seq.StartPosition;
                Seq.Action = ReadMemoryShortToInt(src, of+SymphonieSequence.SEQUENCE_INFO);
                Seq.Tune = ReadMemoryShortToSignedInt(src, of+SymphonieSequence.SEQUENCE_TUNE);
                Seq.NumbOfLoops = ReadMemoryShortToInt(src, of+SymphonieSequence.SEQUENCE_LOOP);
            }
        } else {
            PrintInfo("Error:Importing Sequence.");
        } 
            
    }
    
    void ImportSongPositions(byte[] src, long Len) {
        int of;
        int NumbOfElements = ((int) Len / SymphoniePosition.POSITION_SIZEOF);
        mySong.allocNumbOfPositions(NumbOfElements);
        if((Len>0) && (src!=null) && (NumbOfElements>0)) {
            PrintInfo("Number of Positions:" + NumbOfElements);

            if(NumbOfElements>mySong.getNumbOfPositions()) NumbOfElements = mySong.getNumbOfPositions();
            for(int i=0;i<NumbOfElements;i++) {
                of = SymphoniePosition.POSITION_SIZEOF * i;
                Position Pos = mySong.getPosition(i);
                Pos.setNumbOfLayers(1);
                Pos.PatternNumbers[0] = ReadMemoryShortToInt(src, of+SymphoniePosition.POSITION_PATNUM);
                Pos.Tune = ReadMemoryShortToSignedInt(src, of+SymphoniePosition.POSITION_TUNE);
                Pos.StartRow = ReadMemoryShortToInt(src, of+SymphoniePosition.POSITION_STARTPOINT);
                Pos.RowLength = ReadMemoryShortToInt(src, of+SymphoniePosition.POSITION_LEN);
                Pos.NumbOfLoops = ReadMemoryShortToInt(src, of+SymphoniePosition.POSITION_LOOPNUMB);
                Pos.Speed_Cycl = ReadMemoryShortToInt(src, of+SymphoniePosition.POSITION_SPEED);
                addPositionList("" + i + ". Pat:" + Pos.PatternNumbers[0]
                        + " Spd:" + Pos.Speed_Cycl
                        + " Loops:" + Pos.NumbOfLoops
                        + " LineNr:" + Pos.StartRow
                        + " Len:" + Pos.RowLength
                        + " Tune:" + Pos.Tune
                );
            }
        } else {
            PrintInfo("Error:Importing Positions.");
        }         
    }
    
    private void LoadDataValue(int DataBlockID, int Value ) {
        switch(DataBlockID) {
            case -2:    mySong.setNumbOfRows(Value); // Trachklength
                break;
            case -1:    mySong.setNumbOfVoices(Value); // Number of Channels
                break;
            case -6:    mySong.setBPM((float) Value); // BMP
                break;
        }
    }

    public void runImport(File f) {                                        
        String s="";
        
        FileInputStream fi;
        long l = 0;
        int DataBlockID = 0;
        boolean done = false;
        long MaxElements = 1000;
        long ElementCounter =0;
        long FileLength = 0;
        long ReadLength = 0;
        String sDataBlockID;
        byte[] SrcByteBlock; // = new byte[1024];
        byte[] DestByteBlock = new byte[0];
        
        ActualSampleIndex = 0;
        PrintInfo("Loading SymMod...");
        PrintInfo(f.getPath());
        try {
            fi = new FileInputStream(f);
            s = ReadID(fi);
            PrintInfo(s);
            if(s.equals("SymM") ){
                PrintInfo(">> Symphonie Modul Header ID detected.");                
            } else {
                done = true;
                PrintInfo(">> Aborted. No Symphonie Modul Header detected.");
                if(s.equals("XPKF") ){
                    PrintInfo(">> Possibly XPK packed File. Unpack this file and try again.");
                }
            }
            
            l = ReadLong(fi);
            PrintToInfoWindow(">> Format Version:", (int) l); // should always be 1
            
            FileLength = f.length();
            PrintToInfoWindow(">> Filelength in Byte:", (int) FileLength);
            
            ReadLength +=8;
            
            while(!done) {
                // Abort if no too many Elements -> no symphonie Module
                ElementCounter ++;
                if(ElementCounter >=MaxElements){
                    done = true;
                    PrintInfo(">> Aborted Reading: Possibly no Symphonie Module Format.");                
                }
                
                // Read Element ID
                DataBlockID = ReadInt(fi);
                ReadLength +=4;
                sDataBlockID = GetElementName(DataBlockID);
                if(sDataBlockID!="") PrintToInfoWindow(">> Element ID:", (int) DataBlockID, sDataBlockID);
                
                // if id is not -12, it is a element with data following
                if(DataBlockID != -12) {
                    if( isElementWithSingleParameter(DataBlockID) ) {
                        l = ReadLong(fi);
                        
                        if((DataBlockID==-4) || (DataBlockID==-5)) {
                            l = l & 0x0000ffff;
                        }
                        LoadDataValue(DataBlockID, (int) l);
                        
                        PrintToInfoWindow("Size:" + l);// ?
                        ReadLength +=4;
                        
                    } else {
                        l = ReadLong(fi);
                        ReadLength +=4;
                        PrintToInfoWindow("      Binary Datalength in Byte:", (int) l);
                        try {
                           int numberread;
                           SrcByteBlock = new byte[(int) l]; 
                           numberread = fi.read(SrcByteBlock,0,(int) l);
                           DecodeByteBlockRLE(SrcByteBlock, DestByteBlock, l, DataBlockID);
                           
                           if(DataBlockID==-16) {
                               PrintByteBlockAsString(SrcByteBlock, (int) l); 
                           }
                           ReadLength +=l;
                        } catch (java.io.IOException e) {
                            PrintInfo("ERROR:While reading datablock.");
        
                        }
                        //done = true;
                    }
                } else {
                    //SymphManager.ActualSampleIndex++;
                }
            
                
                
                if(ReadLength >=(FileLength)) {
                    done = true;
                    PrintInfo(">> Finished. End of File reached.");                
                }            
            }
            
        
        } catch (java.io.FileNotFoundException e) {
            PrintInfo("Error:File not Found.");
        
        }
        if(TempPatternData != null) LoadPattern(TempPatternData, TempPatternData.length);
    }
    
}
