/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import symreader.Song;
import symreader.SymphonieDSP;
import symreader.SymphonieInstrument;
import symreader.Voice;

public class VoiceExpander {
    boolean isReady = false;
    boolean InitError = false;
    String ErrorString = "";
    float MixFrequency = 44100.0f;
    float BPM = 120.0f;
    float NewBPM = 120.0f;
    private int BPMTune = 100;
    float MasterVolume = 100.0f;
    float MasterTune = 0.0f;
    int NumbOfVoices = 64;
    int MinPitch = 0;
    int MaxPitch = 257;
    private int BasePitchOffset = 24;
    private float FreqTableFactor = 0.095f;
    int MixChannels = 2;
    int MixBufferLenSamples = 1024 * this.MixChannels;
    boolean Declicking = true;
    int InterpolationType = 1;
    int Dithering = 0;
    int DSPFxIndex = 0;
    byte[] MixBuffer = new byte[this.MixBufferLenSamples * 2];
    Voice[] Voices;
    float[] FreqBase = new float[]{1.0f, 1.0595f, 1.1225f, 1.1892f, 1.2599f, 1.3348f, 1.4142f, 1.4983f, 1.5874f, 1.6818f, 1.7818f, 1.8878f};
    float[] FreqTable;
    SymphonieDSP DSP = new SymphonieDSP(16);
    private Song LinkedSong = null;
    private int InitSamplesTillSongEvent = 5000;
    private int SamplesTillSongEvent = 0;
    boolean LogEvents = true;
    int EventCounter = 0;
    SourceDataLine line;
    AudioFormat format;
    DataLine.Info info;
    Random r = new Random();

    int getInitSamplesTillSongEvent() {
        return this.InitSamplesTillSongEvent * 100 / this.BPMTune;
    }

    VoiceExpander() {
        this.Voices = new Voice[this.NumbOfVoices];
        this.FreqTable = new float[this.MaxPitch + 1];
        this.InitFreqTable();
    }

    void setDeclicking(boolean b) {
        this.Declicking = b;
    }

    void setDSPFxIndex(int myDSP) {
        this.DSPFxIndex = myDSP;
        this.DSP.setBeatLength(this.getInitSamplesTillSongEvent());
        if (this.DSPFxIndex == 0) {
            this.DSP.stop();
        } else {
            this.DSP.stop();
            this.DSP.SetFxClass(this.DSPFxIndex);
            this.DSP.start();
        }
    }

    void setWetMixVolume(float DSPVolume) {
        this.DSP.WetMixVolume = DSPVolume / 100.0f;
    }

    void setDSPPreDelay(int len) {
        this.DSP.setDelay(len);
    }

    void setDSPLength(int len) {
        this.DSP.setNewLength(len);
    }

    void setDSPFeedback(float DSPVolume) {
        this.DSP.DSPIntensity = DSPVolume / 100.0f;
    }

    void setBPMTune(int myBPM) {
        this.BPMTune = myBPM;
    }

    void setSong(Song s) {
        this.LinkedSong = s;
        this.SamplesTillSongEvent = this.getInitSamplesTillSongEvent();
    }

    void setSongSpeed(float BPM, int Cycle) {
        float NewSpeed = (float)(178900 * Cycle) / BPM;
        this.InitSamplesTillSongEvent = (int)NewSpeed;
        this.DSP.setBeatLength(this.getInitSamplesTillSongEvent());
    }

    void checkSongEvent() {
        if (this.LinkedSong != null && this.LinkedSong.SongPlaying && this.SamplesTillSongEvent > 0) {
            --this.SamplesTillSongEvent;
            if (this.SamplesTillSongEvent <= 0) {
                int tempSamplesTillSongEvent = this.LinkedSong.PlaySongEvent(this);
                if (tempSamplesTillSongEvent != 0) {
                    this.InitSamplesTillSongEvent = tempSamplesTillSongEvent;
                }
                this.SamplesTillSongEvent = this.getInitSamplesTillSongEvent();
            }
        }
    }

    int getNumbOfPitches() {
        return this.MaxPitch - this.MinPitch;
    }

    void InitFreqTable() {
        int counter = 0;
        float factor = this.FreqTableFactor;
        for (int i = 0; i < this.getNumbOfPitches(); ++i) {
            this.FreqTable[i] = this.FreqBase[counter] * factor;
            if (++counter <= this.FreqBase.length - 1) continue;
            factor *= 2.0f;
            counter = 0;
        }
    }

    float getPitchToFreq(int Pitch, int Finetune) {
        float f1;
        if ((Pitch += this.BasePitchOffset) < this.MinPitch) {
            Pitch = this.MinPitch;
        }
        if (Pitch > this.MaxPitch - 1) {
            Pitch = this.MaxPitch - 1;
        }
        float f = this.FreqTable[Pitch] * 110.0f;
        if (Finetune > 0) {
            f1 = this.FreqTable[Pitch + 1] * 110.0f;
            f += (f1 - f) * (float)(Finetune / 127);
        }
        if (Finetune < 0) {
            f1 = this.FreqTable[Pitch - 1] * 110.0f;
            f += (f - f1) * (float)(Finetune / 128);
        }
        return f;
    }

    Voice getFreeVoice() {
        for (int i = 0; i < this.NumbOfVoices; ++i) {
            if (this.Voices[i] == null) {
                this.Voices[i] = new Voice();
                return this.Voices[i];
            }
            if (this.Voices[i].inUse) continue;
            return this.Voices[i];
        }
        return null;
    }

    Voice getVoiceNr(int i) {
        if (this.Voices[i] == null) {
            this.Voices[i] = new Voice();
            return this.Voices[i];
        }
        return this.Voices[i];
    }

    boolean PlayInstrument(SymphonieInstrument si, float freq, float vol) {
        Voice v = this.getFreeVoice();
        if (v != null && si != null) {
            v.si = si;
            if (v.si.sp != null && v.si.sp.getNumbOfSamples() > 1) {
                v.SampleEndPtr = v.si.sp.getNumbOfSamples() - 1;
                v.ChannelVolume = vol;
                v.PlayFrequency = freq;
                v.SourceFrequency = v.si.ImportSample.SampledFrequency;
                v.inUse = true;
                v.SamplePtr = 0.0f;
                v.Smoother.activateFadeIn();
                assert (v.SourceFrequency == 0.0f);
                return true;
            }
        }
        return false;
    }

    void SongEventVSlide(int VoiceNr, float VolChangeSpeed) {
        this.SetVoiceVSlide(VoiceNr, VolChangeSpeed);
    }

    void SongEventSetVolume(int VoiceNr, float vol) {
        float oldvol = this.GetVoiceVolume(VoiceNr);
        this.stopVolumeLFO(VoiceNr);
        if (Math.abs(vol - oldvol) > 40.0f) {
            Voice v = this.getVoiceNr(VoiceNr);
            v.Smoother.activateSampleSmoothing();
        }
        this.SetVoiceVolume(VoiceNr, vol);
    }

    void SongEventAddVolume(int VoiceNr, float vol) {
        this.stopVolumeLFO(VoiceNr);
        this.SetVoiceVolume(VoiceNr, this.GetVoiceVolume(VoiceNr) + vol);
    }

    void SongEventKeyOn(SymphonieInstrument si, int VoiceNr, int NoteIndex, float vol) {
        this.stopVolumeLFO(VoiceNr);
        int PosTuneOffset = 0;
        if (si.AllowPosDetune) {
            PosTuneOffset = this.LinkedSong.PosTuneOffset;
        }
        this.SongEventKeyOnFreq(si, VoiceNr, this.getPitchToFreq(NoteIndex + si.Tune + PosTuneOffset, si.FineTune), vol);
    }

    void SongEventSetPitch(SymphonieInstrument si, int VoiceNr, int NoteIndex) {
        int PosTuneOffset = 0;
        if (si.AllowPosDetune) {
            PosTuneOffset = this.LinkedSong.PosTuneOffset;
        }
        this.SetVoiceFreq(si, VoiceNr, this.getPitchToFreq(NoteIndex + si.Tune + PosTuneOffset, si.FineTune));
    }

    void SongEventKeyOnSamplePos(SymphonieInstrument si, int VoiceNr, int NoteIndex, float SamplePos) {
        int PosTuneOffset = 0;
        this.SongEventContinue(VoiceNr, false);
        if (si.AllowPosDetune) {
            PosTuneOffset = this.LinkedSong.PosTuneOffset;
        }
        this.SetVoiceSamplePos(si, VoiceNr, this.getPitchToFreq(NoteIndex + si.Tune + PosTuneOffset, si.FineTune), SamplePos);
    }

    void SongEventPausePlaying(int VoiceNr) {
        Voice v = this.getVoiceNr(VoiceNr);
        if (v != null) {
            v.pausePlaying();
            v.Smoother.activateFadeOut();
        }
    }

    void SongEventContinue(int VoiceNr, boolean ActivateFadeIn) {
        Voice v = this.getVoiceNr(VoiceNr);
        if (v != null) {
            if (ActivateFadeIn) {
                v.Smoother.activateFadeIn();
            }
            v.continuePlaying();
        }
    }

    void SongEventKeyOnFreq(SymphonieInstrument si, int VoiceNr, float Freq, float vol) {
        this.PlayInstrument(si, VoiceNr, Freq, vol);
    }

    float GetVoiceVolume(int VoiceNr) {
        Voice v = this.getVoiceNr(VoiceNr);
        if (v != null) {
            return v.ChannelVolume;
        }
        return 0.0f;
    }

    void SetVoiceVolume(int VoiceNr, float Vol) {
        Voice v = this.getVoiceNr(VoiceNr);
        if (v != null && Vol >= 0.0f && Vol <= 100.0f) {
            v.ChannelVolume = Vol;
        }
    }

    void SetVoiceVSlide(int VoiceNr, float VolChangeSpeed) {
        Voice v = this.getVoiceNr(VoiceNr);
        if (v != null) {
            v.LFOChannelVol.initSlide(VolChangeSpeed / 6500.0f);
        }
    }

    void stopVolumeLFO(int VoiceNr) {
        Voice v = this.getVoiceNr(VoiceNr);
        if (v != null) {
            v.LFOChannelVol.stop();
        }
    }

    void SetVoiceFreq(SymphonieInstrument si, int VoiceNr, float freq) {
        Voice v = this.getVoiceNr(VoiceNr);
        if (v != null && si.checkReady()) {
            v.si = si;
            v.PlayFrequency = freq;
            assert (v.SourceFrequency == 0.0f);
        }
    }

    void SetVoiceSamplePos(SymphonieInstrument si, int VoiceNr, float freq, float SamplePos) {
        Voice v = this.getVoiceNr(VoiceNr);
        if (v != null && si.checkReady()) {
            v.si = si;
            if (v.inUse) {
                v.Smoother.activateSampleSmoothing();
            } else {
                v.Smoother.activateFadeIn();
            }
            v.SampleEndPtr = v.si.sp.getNumbOfSamples() - 1;
            v.ChannelVolume = 100.0f;
            v.PlayFrequency = freq;
            v.SourceFrequency = v.si.ImportSample.SampledFrequency;
            v.inUse = true;
            v.SamplePtr = SamplePos >= 0.0f && SamplePos <= 255.0f ? SamplePos / 255.0f * (v.SampleEndPtr - 1.0f) : 0.0f;
            assert (v.SourceFrequency == 0.0f);
        }
    }

    void PlayInstrument(SymphonieInstrument si, int VoiceNr, float freq, float vol) {
        Voice v = this.getVoiceNr(VoiceNr);
        if (v != null && si.checkReady()) {
            if (v.inUse) {
                v.Smoother.activateSampleSmoothing();
            } else {
                v.Smoother.activateFadeIn();
            }
            v.continuePlaying();
            v.si = si;
            v.SampleEndPtr = v.si.sp.getNumbOfSamples() - 1;
            v.setNumbOfLoopsRemaining(v.si.sp.getNumbOfLoops());
            v.ChannelVolume = vol;
            v.PlayFrequency = freq;
            v.SourceFrequency = v.si.ImportSample.SampledFrequency;
            v.SamplePtr = 0.0f;
            v.isPausing = false;
            v.inUse = true;
            assert (v.SourceFrequency == 0.0f);
        }
    }

    void PlayInstrumentNote(SymphonieInstrument si, int NoteIndex, float vol) {
        float f = this.getPitchToFreq(NoteIndex + si.Tune, si.FineTune);
        this.PlayInstrument(si, f, vol);
    }

    void stopVoice(int index) {
        Voice v = this.Voices[index];
        v.LFOChannelVol.stop();
        v.LFOPitch.stop();
        v.LFOSample.stop();
        v.inUse = false;
        v.Smoother.stop();
        v.isPausing = false;
        v.LastSample = 0.0f;
    }

    void stopAll() {
        for (int i = 0; i < this.NumbOfVoices; ++i) {
            if (!this.isVoicePlaying(i)) continue;
            this.stopVoice(i);
        }
    }

    void setVoiceSmoothingLen(int len) {
        for (int i = 0; i < this.NumbOfVoices; ++i) {
            this.Voices[i].Smoother.setSmoothingLen(len);
        }
    }

    void endVoice(Voice v, float LastSamplePlayed) {
        v.inUse = false;
        if (LastSamplePlayed != 0.0f) {
            v.LastSample = LastSamplePlayed;
            v.Smoother.activateFadeOut();
        }
    }

    boolean isVoicePlaying(int i) {
        return this.Voices[i] != null && this.Voices[i].si != null && (this.Voices[i].inUse || this.Voices[i].Smoother.isFadeingOut());
    }

    boolean isVoicePausing(int i) {
        if (this.Declicking) {
            return this.Voices[i] != null && this.Voices[i].isPausing && !this.Voices[i].Smoother.isFadeingOut();
        }
        return this.Voices[i] != null && this.Voices[i].isPausing;
    }

    int getNumbOfVoicesPlaying() {
        int counter = 0;
        for (int i = 0; i < this.NumbOfVoices; ++i) {
            if (!this.isVoicePlaying(i)) continue;
            ++counter;
        }
        return counter;
    }

    float getNextMixSample(int ChannelNr) {
        float SampleMix = 0.0f;
        int ChannelStep = this.MixChannels;
        for (int i = 0; i < this.NumbOfVoices; i += ChannelStep) {
            if (!this.isVoicePlaying(i + ChannelNr) || this.isVoicePausing(i + ChannelNr)) continue;
            SampleMix += this.getNextVoiceSample(i + ChannelNr);
        }
        this.checkSongEvent();
        return SampleMix;
    }

    float getNextVoiceSample(int i) {
        float Sample = 0.0f;
        Voice v = this.Voices[i];
        v.processAllLFOs();
        float vol = v.ChannelVolume;
        if (v.inUse) {
            switch (this.InterpolationType) {
                case 0: {
                    Sample = v.si.sp.Samples[(int)v.SamplePtr];
                    break;
                }
                case 1: {
                    int ptr = (int)v.SamplePtr;
                    if ((float)(ptr + 1) <= v.SampleEndPtr) {
                        float fract = v.SamplePtr - (float)ptr;
                        Sample = v.si.sp.Samples[ptr + 1] * fract;
                        Sample += v.si.sp.Samples[ptr] * (1.0f - fract);
                        break;
                    }
                    Sample = v.si.sp.Samples[ptr];
                }
            }
            Sample = Sample * vol / 100.0f;
            Sample = Sample * (float)v.si.Volume / 100.0f;
            if (this.Declicking) {
                Sample = v.Smoother.getSmoothedSample(Sample);
            }
            float dSample = (1.1f + this.MasterTune / 50.0f) * v.PlayFrequency / 440.0f;
            v.SamplePtr += dSample;
            if (v.si.sp.hasLoop()) {
                this.ProcessLoopSystem(v);
            }
            if (v.SamplePtr > v.SampleEndPtr) {
                this.endVoice(v, Sample);
            }
            if (v.SamplePtr < 0.0f) {
                this.endVoice(v, Sample);
            }
        }
        if (!v.si.NoDsp) {
            this.DSP.addVoiceSampleIntoDSP(Sample);
        }
        return Sample;
    }

    void ProcessLoopSystem(Voice v) {
        if ((v.getNumbOfLoopsRemaining() > 0 || v.si.sp.getEndlessLoop()) && v.SamplePtr > (float)v.si.sp.getLoopEndSampleIndex()) {
            v.SamplePtr = v.si.sp.getLoopStart();
            v.Smoother.activateSampleSmoothing();
            if (!v.si.sp.getEndlessLoop()) {
                v.decNumbOfLoopsRemaining();
            }
        }
    }

    void SampleToBuffer(float fSample, byte[] Dest, int i) {
        if (fSample > 32767.0f) {
            fSample = 32767.0f;
        }
        if (fSample < -32767.0f) {
            fSample = -32767.0f;
        }
        short Sample = (short)fSample;
        Dest[i + 1] = (byte)Sample;
        Dest[i] = (byte)Short.reverseBytes(Sample);
    }

    void OpenMixSystem() {
        float Freq = 44100.0f;
        int Frames = 2;
        int NumbOfBits = 16;
        this.format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, Freq, NumbOfBits, this.MixChannels, Frames * this.MixChannels, Freq, true);
        this.info = new DataLine.Info(SourceDataLine.class, this.format);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(this.info);
            try {
                this.line.open(this.format);
                this.line.start();
                this.isReady = true;
                this.InitError = false;
                this.ErrorString = "Fast Mode (realtime performance)";
            }
            catch (Exception ex) {
                this.ErrorString = ex.getMessage();
                this.isReady = false;
                this.InitError = true;
            }
        }
        catch (Exception ex) {
            this.ErrorString = ex.getMessage();
            this.isReady = false;
            this.InitError = true;
        }
        if (this.InitError) {
            this.OpenMixSystemSafe();
        }
    }

    private void OpenMixSystemSafe() {
        this.format = new AudioFormat(44100.0f, 16, 1, true, true);
        this.info = new DataLine.Info(SourceDataLine.class, this.format);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(this.info);
            try {
                this.line.open(this.format);
                this.line.start();
                this.isReady = true;
                this.InitError = false;
                this.ErrorString = "Safe Mode (slow)";
            }
            catch (Exception ex) {
                this.ErrorString = ex.getMessage();
                this.isReady = false;
                this.InitError = true;
            }
        }
        catch (Exception ex) {
            this.ErrorString = ex.getMessage();
            this.isReady = false;
            this.InitError = true;
        }
    }

    float ProcessDithering(float Sample) {
        float e = this.r.nextFloat();
        return Sample + e * 23.0f;
    }

    void PlayActualMixThread() {
        while (true) {
            float DSPSample = 0.0f;
            for (int i = 0; i < this.MixBufferLenSamples; i += this.MixChannels) {
                for (int ChannelNr = 0; ChannelNr < this.MixChannels; ++ChannelNr) {
                    float Sample = this.getNextMixSample(ChannelNr);
                    this.DSP.advanceWritePtr();
                    DSPSample = this.DSP.getWetMixSample();
                    this.DSP.advanceReadPtr();
                    Sample = (Sample + DSPSample) * (this.MasterVolume / 100.0f) * 10000.0f;
                    if (this.Dithering == 1) {
                        Sample = this.ProcessDithering(Sample);
                    }
                    this.SampleToBuffer(Sample, this.MixBuffer, (i + ChannelNr) * 2);
                }
            }
            this.line.write(this.MixBuffer, 0, this.MixBufferLenSamples * 2);
            Thread.yield();
        }
    }
}

