*****************************************************************************
**                                                                         **
** Engine: Time                                                            **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


;**********************************************************************
;**               Eagleplayer Time V1.2                              **
;**               1993 Henryk "BUGGS" Richter                       **
;**              geschrieben auf ASM-ONE V1.02                       **
;** Beispielprogramm,fr solche,die zu bld sind,sich endlich 2.0 zu-**
;** zulegen,zeigt aber auch,wie man 1.3-kompatibel bleibt,trotzdem   **
;** die 2.0-Funktionen nutzt                                         **
;**********************************************************************
	;
	;Crash nach 3 Minuten, wenn Fehler im EP (EPG_wordreserved7)
	;
	incdir	include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/Eagleplayerengine.i
	include	dos/dos_lib.i
	include	exec/interrupts.i
	include	misc/Buggsmacros.i

ver		macro
		dc.b	"1.02"
		endm
StructVer	macro
		dc.w	1,02
		endm
date		macro
		dc.b	"05-Apr-97"
		endm
StructDate	macro
		dc.b	05,04
		dc.w	1997
		endm


Test = 0	;auf 0 lassen zur Nutzung mit dem Eagleplayer !!!!!
		;(zu Testzwecken meldet sich sonst der Analyzer selbst ab !)
debug = 0
;===========================================================================
	section	0,code
;===========================================================================
an_num = 12			;Anzahl der Balken (bloss nicht ndern)
an_zeilen = 13			;Keine nderung zulssig,siehe oben,siehe auch
				;GURU-LISTE
win_breite = 128
;===========================================================================
BEGIN
	bra.w	fangan
	EUSN_Identifier
	dc.l	0		;eus_next
	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
myepbase
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	0		;eus_tickflags
	dc.l	USMB_Zipwin!USMB_ChangeConfig	;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	MyBuggsname	;eus_Cname
	dc.l	myinfo
	dc.w	37		;eus_Kickstart
	dc.l	EAGLEVERSION	;eus_EPVersion
	structver		;eus_version,revision
	dc.l	0 *MyUsername	;eus_username
	dc.w	520		;eus_winx
	dc.w	72		;eus_winy
	dc.w	EUSB_openwin	;EUS_Flags, Window offen
	dc.l	0		;EUS_Special
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	structdate		;EUS_Creatordate
	dc.b	-5		;EUS_Priority
	dc.b	0
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	`$VER: Eagleplayer Time V`
		ver
		dc.b	` (`
		date
		dc.b	`)`,0
		even


Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Time
		dc.l	0


fangan
	move.l	4.w,a6			;Execbase laden

	lea	datas,a5		;allumfassendes Basisregister
	move.l	a5,a0
	move.w	#dataslen-1,d0		;BSS-Sektion vollstndig lschen
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	move.l	#-1,mytime(A5)

	moveq	#-1,d0			;irgendein Signal
	jsr	_LVOallocsignal(a6)	;allokieren
	tst.l	d0
	blt	NoSignal
	move.l	d0,mysignal(a5)		;merken

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)	;Task finden
	move.l	d0,mytask(a5)

					;Message Port initialisieren
	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;MSG Signal zuweisen lassen
	tst.l	d0
	blt	nosignal2		;Fehler

	lea	MsgPort(a5),a4		;MSG Port Struktur initialisieren

	move.b	#nt_msgport,ln_type(a4)
	move.b	#0,ln_pri(a4)
	move.b	#pa_signal,mp_flags(a4)
	move.b	d0,mp_sigbit(a4)

	move.l	mytask(a5),mp_sigtask(a4);mp_SigTask

	lea	mp_msglist(a4),a1
	Newlist	a1			;macro in Lists.i

	lea	int(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)	;INTUITION V1.2
	tst.l	d0
	beq	NOINT
	move.l	d0,intsave(a5)

	lea	graf(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)	;GRAPHICS V1.2
	tst.l	d0
	beq	NOGRAF
	move.l	d0,grafsave(a5)

	moveq	#0,d7			;Rckgabewert

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse usw. haben mchte
	blt	endme	;Fehler aufgetreten (Register D7 < 0),Programm beenden

	bsr	setint
	bsr	HandleActions		;Auf Usereingaben und Eagleplayer-
					;signale reagieren (Hauptprogramm
	bsr	remint
;========= Programmende =====================================================
endme
	move.l	d7,-(sp)
	bsr	closewin	;Fenster zu !
	move.l	(sp)+,d7		;Error oder Exit-Message vom Player ?

	blt.s	Ende	;kein Fehler,sondern Aufruf zum frhlichen ENDE
			;vom Eagleplayer erhalten

	bsr	Sendlastmessage	;einige letzte Worte,falls eigenmchtige Ver-
				;abschiedung (darf aber nicht auftreten
Ende
	move.l	mypubscreen(a5),d0	;Public Screen loslassen,falls nicht
	beq.s	.ok			;schon getan
	move.l	d0,a1
	suba.l	a0,a0
	move.l	intsave(A5),a6
	jsr	_LVOunlockpubscreen(a6)
.ok
	move.l	grafsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4.w,a6			;eigenen Port wieder entfernen

	lea	msgport(a5),a2
	move.b	mp_sigbit(a2),d0
	ext.w	d0
	ext.l	d0
	jsr	_LVOfreesignal(a6)
NoSignal2
	move.l	mysignal(a5),d0
	move.l	4.w,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0			;Returncode
	rts
*************************************************************
*       Setzt Interrupt fr Scroller (VBlank)               *
*************************************************************
Setint	
	tst.w	intset(a5)	;Interrupt schon gesetzt ?
	bne.s	.no	;ja->raus

	move.l	4.w,a6
	lea	inter(a5),a1
	lea	INT_Prog(pc),a0
	move.l	a0,IS_code(a1)
	move.b	#nt_interrupt,ln_type(a1)
	move.b	#0,ln_pri(a1)
	moveq	#5,d0
	jsr	_LVOaddintserver(a6)

	move.w	#1,intset(a5)
.no
	rts
*************************************************************
*         entfernt Scroller-Interrupt                       *
*************************************************************
Remint
	tst.w	intset(a5)
	beq.s	.no

	move.l	4.w,a6
	moveq	#5,d0
	clr.w	intset(a5)
	lea	inter(a5),a1
	jsr	_LVOremintserver(a6)
.no	rts
*************************************************************
*                  VBLANK Interrupt                         *
*************************************************************
INT_Prog
	movem.l	d0-a6,-(sp)
	lea	datas,a5

;	addq.w	#1,counter2(a5)
;	cmp.w	#50*60*3,counter2(a5)
;	bne.s	.wei
;	lea	begin(pc),a0
;	move.l	eus_epbase(a0),a0
;	move.b	epg_wordreserved7+1(a0),d0
;	beq.s	.wei
;	moveq	#2,d0
;	add.w	d0,d0
;	move.l	d0,a0
;	clr.l	(A0)			;wech mit echsech
;.wei

	move.b	counter(A5),d0
	addq.b	#1,d0
	and.b	#15,d0
	move.b	d0,counter(A5)
	bne.s	.ret

	move.l	4.w,a6
	move.l	mytask(A5),a1
	move.l	mysignal(A5),d1
	moveq	#0,d0
	bset	d1,d0
	jsr	_LVOsignal(a6)

.ret
	movem.l	(sp)+,d0-a6
	moveq	#0,d0
	rts
************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin
	tst.l	winhandle(a5)	;haben wir denn schon ein Fensterle ??
	bne.w	.Error

	move.l	intsave(a5),a6
	cmp.w	#37,lib_version(A6)
	bhs.s	.openwindow20
					;Fenster unter 1.3
	lea	mywindow(pc),a0

	moveq	#11,d1			;Font = 8 Pixel  +  3 Pixel Rand
	move.w	d1,myhoehe1(a5)

	move.w	#3,offx(A5)

	add.w	#AN_zeilen+18,d1	;6 Y-Stufen des Analyzers + Rand

	lea	begin(pc),a1
	move.w	eus_winx(a1),nw_leftedge(a0)
	move.w	eus_winy(a1),nw_topedge(a0)
	jsr	_LVOopenwindow(a6)
	move.l	d0,winhandle(a5)
	tst.l	d0
	bne.w	.winopened

	lea	mywindow(pc),a0
	clr.w	nw_topedge(A0)
	clr.w	nw_leftedge(A0)

	jsr	_LVOopenwindow(a6)
	move.l	d0,winhandle(a5)
	tst.l	d0
	bne.w	.winopened
	bra	.error
.openwindow20		;Fenster unter 2.0 ffnen
			;Routine blieb implementiert,da unter 2.0 einige
			;neue Funktionen (Zipwindow) existieren und zudem ein
			;eigener Font gesetzt werden kann. Wenn dieser eine
			;andere Hhe hat,kann`s Probleme geben,deshalb die
			;2.0 kompatible Routine
	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep
	move.l	d0,a0
	move.l	EPG_Pubscreen(A0),d0
.noep
	move.l	d0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	bne.s	.pubs1

	suba.l	a0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	beq	.Error			;sollte nicht auftreten (warum auch ?)
.pubs1
	move.l	d0,mypubscreen(a5)	;fr UnLockpubscreen() merken
	move.l	d0,a1
	move.b	SC_Wborleft(a1),d0
	ext.w	d0
	move.w	d0,offx(A5)

	move.l	sc_font(a1),a0
	move.l	a0,fontatt(a5)		;fr Fonthhenberechnung sichern

	bsr	getwinheight		;in D1 Windowhhe abholen 
					;(welch Service)

					;WINDOW INIT
	lea	mytags(a5),a1		;Zeiger auf Tagliste
	lea	begin(pc),a0		;Zeiger auf Struktur am Programmanfang

	move.l	#WA_Pubscreen,(a1)+
	move.l	mypubscreen(A5),(a1)+

	move.l	#WA_Pubscreenfallback,(a1)+
	move.l	#1,(a1)+

	moveq	#0,d0
	move.l	#wa_top,(a1)+		;Y-Position des Fensters

	move.w	eus_winy(a0),d0		;holen und eintragen
	move.l	d0,(a1)+

	move.l	#wa_left,(a1)+		;X-Position
	move.w	eus_winx(a0),d0
	move.l	d0,(a1)+

	move.l	#wa_innerwidth,(a1)+		;Breite
	move.l	#win_breite-6,(a1)+
	move.l	#wa_innerheight,(a1)+	;Hhe
	move.l	#32+12,(a1)+

	move.l	#wa_flags,(a1)+
	move.l	#Windowdrag!Windowdepth!Windowclose,(a1)+ ;das soll er knnen

	move.l	#WA_TITLE,(a1)+		;Windowname
	lea	mywinname(pc),a0
	move.l	a0,(a1)+
	move.l	#wa_zoom,(a1)+
	lea	myzoom(a5),a0
	move.w	#0,(a0)		;X-Position im ZIP-Mode
	move.w	#101,2(a0)	;Y-Position im ZIP-Mode
	move.w	#168,4(a0)		;Breite des Zip-Windows im SMALL-MODE
	move.w	myhoehe1(a5),myhoehe2(a5)
	move.l	a0,(a1)+
	move.l	#wa_idcmp,(a1)+
	move.l	#closewindow!menupick!refreshwindow,(a1)+ ;das wolln wir wissen
	move.l	#wa_autoadjust,(a1)+	;Gre notfalls einschrnken
	move.l	#1,(a1)+

	move.l	#WA_ScreenTitle,(a1)+
	move.l	#Project0STitle,(a1)+

	move.l	#TAG_DONE,(a1)+		;das war alles

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;alloah Window !
	move.l	d0,Winhandle(a5)
	tst.l	d0
	bne.s	.winopened

	lea	mytags(a5),a1		;Fehler,nochmal auf Position 0/0
	move.l	#wa_top,(a1)+		;zu ffnen versuchen
	move.l	#0,(a1)+
	move.l	#wa_left,(a1)+
	move.l	#0,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;wirst DU wohl aufgehen !
	move.l	d0,Winhandle(a5)
	tst.l	d0
	beq	.Error
.winopened
	move.l	d0,a0
	move.l	wd_userport(a0),a0	;User Port holen
	move.l	a0,port(a5)		;und sichern

	lea	my_bitmap(a5),a3
	bsr	makebitmap		;EXTRA Bitmap erzeugen
	bge.s	.gotit		;ist erzeugt

	move.l	intsave(a5),a6		;wenn nicht mal die paar Bytes fr
	move.l	winhandle(a5),a0	;unsere 2.Bitmap da sind,Fenster wieder
	clr.l	Winhandle(a5)		;schlieen
	clr.l	port(a5)
	jsr	_LVOclosewindow(a6)

	bra.s	.Error			;Fehler
.gotit
	bsr	addmenus		;Men darstellen
	bsr	refresh			;Rahmen zeichnen
.error
	move.l	intsave(a5),a6
	suba.l	a0,a0
	move.l	mypubscreen(a5),d0
	beq.s	.nopub
	move.l	d0,a1
	move.l	#0,mypubscreen(a5)
	jmp	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.nopub	rts
*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin
	tst.l	winhandle(a5)	;Window gar nicht auf ?
	beq.s	.nowin	;nein,raus

	bsr	freebitmap	;Extra Bitmap freigeben
	bsr	freemenus	;Mens freigeben
	
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.nosetxy		;ja; X,Y-Position nicht merken
	lea	begin(pc),a1
	move.w	wd_topedge(a0),eus_winy(a1)
	move.w	wd_leftedge(a0),eus_winx(a1)
.nosetxy
	clr.l	Winhandle(a5)
	clr.l	port(a5)
	jsr	_LVOclosewindow(a6) ;Window schlieen
.nowin	rts
********************************************************************
*    Init Message Struktur,Willkommensnachricht an Eagleplayer     *
********************************************************************
Sendfirstmessage
	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)	;Eagleplayers Port finden
	tst.l	d0
	bne.s	.ok
					;Wenn dieser nicht gefunden werden
					;konnte,
	bsr	 openwin		;Fenster ffnen

					;und Requester erstellen,der mitteilt,
					;da kein Eagleplayer weit und breit
					;zu finden ist

	move.l	winhandle(a5),d0	;*Window
	beq.w	.error		;kann mein Window nicht ffnen,gleich rausgehen
	move.l	d0,a0

	lea	Noportitext(pc),a1	;*Bodytext (Itext-Struktur
	lea	retryitext(pc),a2	;*Positive Text
	lea	cancelitext(pc),a3	;*Negative Text
	moveq	#0,d0			;Idcmp True
	moveq	#0,d1			;Idcmp False
	move.w	#260,d2			;Breite
	move.w	#46,d3			;Hhe

	move.l	Intsave(a5),a6
	jsr	_LVOautorequest(a6)	;Requester unter 1.3
	tst.l	d0
	beq.s	.error			;Cancel->Ende des Programms

	bra	SendFirstmessage	;nochmal versuchen
.ok
	move.l	d0,a0			;Portadresse

	
	lea.l	msgport(a5),a1
	move.l	a1,d3			;Msgportadresse
	move.l	mytask(a5),d4		;Taskadresse
	moveq	#-1,d5
;	move.l	mysignal(a5),d5		;Signalnummer
	move.w	#USclass_Newuserprg,d6	;Meldung,da ein neues Userprogramm an-
					;kommt

	ifne	debug
	lea	mymessage(a5),a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(a1)
	move.w	#-2,UM_UserNr(a1)
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	moveq	#0,d7			;alles klar
	rts				;Rcksprung
.error
	moveq	#-1,d7			;Fatal Error
	rts				;Ende

******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
;NUR ZU TESTZWECKEN,KEIN USERPROGRAMM SOLLTE SICH EIGENMCHTIG VERABSCHIEDEN,
;DA DER PLAYER SONST VERGEBLICH AUF DAS RCKSENDEN DER NACHRICHTEN WARTET
Sendlastmessage:
	move.l	4.w,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	lea.l	msgport(a5),a1
	move.l	a1,d3			;Messageport

	lea	Mymessage(a5),a1		;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)	;Lnge
	clr.l	ln_succ(A1)
	clr.l	ln_pred(A1)
	move.b	#nt_message,ln_type(a1) 	;Typ: Message

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)	;Typ der Message

	move.l	d3,mn_replyport(a1)		;Portadresse,an die
						;zurckgesendet wird
	clr.l	UM_Userport(a1)		;Portadresse fr EaglePlayer
	clr.l	UM_TaskAdr(a1)		;Taskadresse
	clr.l	UM_Signal(a1)		;Signalnummer
	move.w	#Usclass_exit,UM_class(a1)	;Messageinhalt
				;z.B. USClass_Closewin,USclass_Newuserprg

	move.b	#1,messagesent(a5)		;merken,da Nachricht gesendet

	move.l	4.w,a6
	jsr	_LVOputmsg(a6)		;Nachricht losschicken
.wait					;auf Rckmeldung warten
	lea.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	lea.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*******************************************************************************
sendmess:
	lea	Mymessage(a5),a1		;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)	;Lnge
	move.b	#nt_message,ln_type(a1) 	;Typ: Message
	clr.l	ln_succ(A1)
	clr.l	ln_pred(A1)
	lea	begin(pc),a2			;Zeiger auf Struktur am Anfang

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)	;Typ der Message

	move.l	d3,mn_replyport(a1)		;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)		;Portadresse fr EaglePlayer
	move.l	d4,UM_TaskAdr(a1)		;Taskadresse
	move.l	d5,UM_Signal(a1)		;Signalnummer
	move.w	d6,UM_class(a1)			;Messageinhalt
				;z.B. USClass_Closewin,USclass_Newuserprg

	move.b	#1,messagesent(a5)		;merken,da Nachricht gesendet

	move.l	4.w,a6
	jmp	_LVOputmsg(a6)		;Nachricht losschicken
*********************** Men wechschmeisen ************************************
Freemenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),d0
	beq.s	.end
	move.l	d0,a0
	jsr	_LVOclearmenustrip(A6)	;Mens vom Window lsen
.end
	rts
*****************************************************************************
* Hhe des Hauptfensters berechnen unter Anpassung an den eingestellten Font*
*****************************************************************************
getwinheight:
	move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
	move.w	d0,d1
	move.w	d0,fonth(a5)

	move.b	sc_wbortop(a1),d0
	ext.w	d0
	add.w	d0,d1			;Berechnen der Gre fr ZIPwindow()
	move.w	d1,myhoehe1(a5)		;und eintragen
	
	add.w	#32+15,d1		;6 Y-Stufen des Analyzers + Rand
	rts
********************* Men anhngen *************************
Addmenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	lea	projmenu(pc),a1
	jmp	_LVOsetmenustrip(a6)
*************************************************************
*     2. Bitmap erzeugen fr direkten Zugriff auf Bild      *
*       (per Blitter wird kopiert,Tiefe = 2)                *
* Adresse auf leere Struktur in A3 bergeben                *
*************************************************************
makebitmap
	move.l	grafsave(a5),a6

	move.w	#an_num,(a3)		;bm_BytesPerRow
	move.w	#an_zeilen,bm_rows(a3)	;13 Zeilen

	move.b	#1,bm_depth(a3)		;2 Bitplanes

	move.w	#an_num*8,d0		;Breite in Pixeln
	move.w	#an_zeilen*8,d1		;Hhe in Zeilen
	jsr	_LVOallocraster(a6)	;896 Bytes Chipmem von der Graphics
	tst.l	d0			;Library anfordern
	beq.s	.norast
	move.l	d0,bm_planes(a3)	;Adresse sichern

	moveq	#0,d7			;alles klar
	rts
.norast
	moveq	#-1,d7			;fatal Error
	rts
**************************************************************
*                   Bitplane(s) freigeben                    *
**************************************************************
freebitmap
	move.l	grafsave(a5),a6		;Graphics Library
	lea	my_bitmap(a5),a1
	move.l	bm_planes(a1),d0	;Planeptr[1]
	beq.s	.no1
	clr.l	bm_planes(a1)

	move.l	d0,a0
	move.w	#an_num*8,d0		;Breite
	move.w	#an_zeilen*8,d1		;Hhe
	jsr	_LVOfreeraster(a6)
.no1
RET	rts
*************************************************************
*                   Fenster "refreshen"                     *
*************************************************************
Refresh
	move.l	winhandle(a5),d0
	beq.s	Ret
	move.l	d0,a0

	move.w	myhoehe1(a5),d1		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1
	beq.s	RET			;ja,kein Refresh

	move.l	grafsave(a5),a6
	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0
	jsr	_LVOsetapen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.l	winhandle(A5),a1
	move.b	wd_borderright(a1),d2
	ext.w	d2
	neg.w	d2
	add.w	wd_width(a1),d2

	move.b	wd_borderbottom(a1),d3
	ext.w	d3
	neg.w	d3
	add.w	wd_height(a1),d3

	move.b	wd_bordertop(a1),d1
	ext.w	d1

	move.l	wd_rport(a1),a1

	move.b	#1,rp_areaptsz(a1)
	lea	patt1(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	offx(A5),d0		;x1

	subq.w	#1,d2
	subq.w	#1,d3
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	lea	patt2(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	offx(A5),d0
	add.w	#17,d0			;Left
	move.w	myhoehe1(a5),d1		;Top
	add.w	#3,d1
	move.w	#85,d2
	move.w	#an_zeilen+3,d3
	add.w	d0,d2
	add.w	d1,d3
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	move.w	offx(A5),d0
	add.w	#17-8,d0		;Left
	move.w	myhoehe1(a5),d1		;Top
	add.w	#3+20,d1
	move.w	#101,d2
	move.w	#an_zeilen+3,d3
	add.w	d0,d2
	add.w	d1,d3
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	move.w	#3+8,d0
	move.w	myhoehe1(A5),d1		;y1
	addq.w	#4,d1
	jsr	_LVOmove(A6)

	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshwindowframe(A6)

;	bra.s	time2win
;	nop
;	rts
***************************************************************
* Kopiert aktuelle Zeitwerte ins Fenster                      *
***************************************************************
Time2win
;========================================================================
	move.l	myepbase(pc),a0		;Eagleplayer Basisadresse
	move.l	EPG_CurrentTime(a0),d6
	cmp.l	mytime(a5),d6
	beq.w	.nowrite
	move.l	d6,mytime(A5)

	moveq	#0,d0			;Sekunden einer
	moveq	#0,d1			;Sekunden zehner
	moveq	#0,d2			;Minuten einer
	moveq	#0,d3			;Minuten zehner
	move.l	#$ffff,d7

	divu	#60,d6			;durch Minuten
	move.l	d6,d5
	swap	d5			;Sekunden.w
	and.l	d7,d6		;ausmaskieren (Rest=Sekunden lschen)
	bge.s	.noset0
	moveq	#0,d6			;irgendwas lief schief,Minuten 0 setzen
.noset0
	cmp.w	#60,d6			;schon mehr als 60 Minuten um ?
	blo.s	.nohours
	divu	#60,d6			;durch Stunden
	swap	d6			;brigbleibende Minuten
.nohours
	and.l	d7,d6		;d6.w Minuten
	and.l	d7,d5		;d5.w Sekunden

					;Dezimalumwandlung
	divu	#10,d6
	move.w	d6,d3			;Minuten zehner
	swap	d6
	move.w	d6,d2			;Minuten einer

	divu	#10,d5
	move.w	d5,d1			;Sekunden zehner
	swap	d5
	move.w	d5,d0			;Sekunden einer

.timezero
	moveq	#26,d4		;Lnge einer Ziffer (13Zeilen*1Wort=26Bytes)

	mulu	d4,d0		;Offsets fr die einzelnen Ziffern berechnen
	mulu	d4,d1
	mulu	d4,d2
	mulu	d4,d3

	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),a0

	lea	ziffern(pc),a1	;Ziffernbasisadresse
	add.l	a1,d0		;+Offset
	add.l	a1,d1
	add.l	a1,d2
	add.l	a1,d3

	move.l	d0,a1		;in Register sichern
	move.l	d1,a2
	move.l	d2,a3
	move.l	d3,a4
	lea	Doppelpunkt(pc),a6

	moveq	#12,d0		;13 Zeilen
.copy
	move.w	(a4)+,(a0)+	;Minuten Zehner
	move.w	(a3)+,(a0)+	;Minuten einer
	move.w	(a6)+,(a0)+	;Doppelpunkt
	move.w	(a2)+,(a0)+	;Sekunden zehner
	move.w	(a1)+,(a0)+	;Sekunden einer
	addq.l	#2,a0
	dbf	d0,.copy
; ========= In das Window (dessen Rastport) kopieren =====================
.nopeek
	move.l	grafsave(a5),a6		;Graphics Library
	move.l	winhandle(a5),a1	;Fensteradresse

	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	offx(A5),d2
	add.w	#21,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	addq.w	#5,d3			;ein kleines Stck tiefer

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	#10*8,d4		;Breite
	move.w	#an_zeilen,d5		;Hhe
		
	move.b	#$c0,d6		;Miniterm = nur kopieren , keine Verknpfung

	jsr	_LVObltbitmaprastport(a6)
.nowrite
	rts
*************************************************************************
*************************** Uhrenfunktion *******************************
*************************************************************************
Clock
	movem.l	d0-a6,-(sp)
	bsr	Time2win		;counter !
	movem.l	(sp)+,d0-a6

	move.l	#$ffff,d7
	move.l	intsave(a5),a6		;neue Zeit holen
	lea	U_seconds(a5),a0
	lea	U_micros(a5),a1
	jsr	_LVOcurrenttime(a6)

	move.l	U_seconds(a5),d6	;gesamte neue Zeit
	cmp.l	merk_seconds(a5),d6	;schon 1 Sekunde um ?
	beq	.nowrite		;nein,weiterwarten

	move.l	d6,merk_seconds(a5)

				;Zeit durch Sekunden pro Tag dividieren, der
				;Rest ergibt dann die Sekunden des akt. Tages
	move.b	d6,d0

	lsr.l	#1,d6		;durch Sekunden
	divu	#60*60*24/2,d6	;pro Tag dividieren
	swap	d6
	and.l	d7,d6

	lsl.l	#1,d6

	and.b	#1,d0
	or.b	d0,d6

	divu	#60,d6			;durch Minuten
	move.l	d6,d4
	swap	d4			;Sekunden.w
	and.l	d7,d6			;ausmaskieren (Rest=Sekunden lschen)

	divu	#60,d6			;durch Stunden
	move.l	d6,d5
	swap	d5			;Minuten.w

	and.l	d7,d6		;d6.w Stunden
	and.l	d7,d5		;d5.w Minuten
	and.l	d7,d4		;d4.w Sekunden
					;Dezimalumwandlung
	divu	#10,d6
	move.w	d6,d0			;Stunden zehner
	swap	d6
	move.w	d6,d1			;Stunden einer

	divu	#10,d5
	move.w	d5,d2			;Minuten zehner
	swap	d5
	move.w	d5,d3			;Minuten einer

	divu	#10,d4
	move.w	d4,d5			;Sekunden zehner
	swap	d4
	move.w	d4,d6			;Sekunden einer

	moveq	#26,d4		;Lnge einer Ziffer (13Zeilen*1Wort=26Bytes)
				;Offsets fr die einzelnen Ziffern berechnen
	mulu	d4,d0		;Stunden zehner
	mulu	d4,d1		;Stunden einer
	mulu	d4,d2		;Minuten zehner
	mulu	d4,d3		;Minuten einer

	mulu	#13,d5		;Sekunden zehner
	mulu	#13,d6		;Sekunden einer

	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),a0

	move.l	a5,-(sp)

	lea	ziffern(pc),a1	;Ziffernbasisadresse
	add.l	a1,d0		;+Offset
	add.l	a1,d1
	add.l	a1,d2
	add.l	a1,d3

	lea	kleineziffern(pc),a5	;Ziffernbasisadresse

	move.l	d0,a1		;in Register sichern
	move.l	d1,a2
	move.l	d2,a3
	move.l	d3,a4

	lea	Doppelpunkt(pc),a6

	moveq	#12,d0		;13 Zeilen
.copy
	move.w	(a1)+,(a0)+	;Stunden zehner
	move.w	(a2)+,(a0)+	;Stunden einer
	move.w	(a6)+,(a0)+	;Doppelpunkt
	move.w	(a3)+,(a0)+	;Minuten zehner
	move.w	(a4)+,(a0)+	;Minuten einer
	move.b	(a5,d5.w),(a0)+	;Sekunden zehner
	move.b	(a5,d6.w),(a0)+	;Sekunden einer
	addq.w	#1,d5
	addq.w	#1,d6
	dbf	d0,.copy

	move.l	(sp)+,a5
; ========= In das Window (dessen Rastport) kopieren =====================
	move.l	grafsave(a5),a6		;Graphics Library
	move.l	winhandle(a5),a1	;Fensteradresse

	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	offx(A5),d2
	add.w	#13,d2			;X2
	move.w	myhoehe1(a5),d3		;Y2
	add.w	#5+20,d3		;ein kleines Stck tiefer

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	#an_num*8,d4		;Breite
	move.w	#an_zeilen,d5		;Hhe
		
	move.b	#$c0,d6		;Miniterm = nur kopieren , keine Verknpfung

	jsr	_LVObltbitmaprastport(a6)
.nowrite
	rts
*******************************************************************
*    berprfen,ob Analyzerstruktur schon bergeben wurde und     *
* und ob der aktuelle Player Lautstrke und Sampleperiod bergibt *
*******************************************************************
AN_test

;========== Window offen mit voller Gre ? =======================
	move.l	winhandle(a5),d0	;Window berhaupt offen ?
	beq	.noanalyze		;nein,raus
	move.l	d0,a0

	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.Noanalyze		;nein,raus

;============ Strukturadresse bekannt ? ===========================
	bsr	clock
.noanalyze
	rts
***************************************************************************
*           Nachrichtenbearbeitung ,Hauptprogramm                         *
***************************************************************************
HandleActions
	bra.s	.ma

.ma2

	btst	d3,d0		;Signal: Analyzer ???
	beq.s	.ma		;nein
	bsr.s	An_test		;Analyzer nimmt Arbeit auf !

.ma

	move.l	4.w,a6
	move.l	port(a5),d0	;Fenster offen ?
	beq.s	.nowinport	;nein 
	move.l	d0,a0
	jsr	_LVOgetmsg(a6)	;Fenstermeldung abholen
	tst.l	d0		;Meldung bekommen ?
	bne	.msg		;ja,auswerten
.nowinport
	lea.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)	;Message vom Eagleplayer bekommen (oder eigene
	tst.l	d0		;abgeschickte zurck ?)
	bne	.AN_msg		;ja,auswerten
	
;--------- Signalmaske erstellen ,auf die gewartet wird ---------------

	moveq	#0,d0
	move.l	4.w,a6
	move.l	port(a5),d1	;Windowport
	beq.s	.no		;kein Fenster offen
	move.l	d1,a0
	move.b	mp_sigbit(a0),d1;Signalbit aus Messageport holen
	bset	d1,d0		;in Maske einfgen
.no
	lea.l	msgport(a5),a0	;2.Messageport
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
	move.l	mysignal(a5),d3	;Signal fr Analyzer
	bset	d3,d0		;Signalbit fr Abarbeitung des Analyzers selbst
				;(Auswertungsroutine namens "ANALYZE1")
	jsr	_LVOwait(a6)	;auf Signale warten
	bra	.ma2
;================ Message an Analyzerport bekommen ===========================
.AN_msg

	move.l	d0,a1
				;persnliche Daten bekanntgeben
				;(ja,ja der Datenschutz...)

	move.l	a5,UM_Userport(a1)		;Trick:erst Basisadresse
						;sichern,dann Offset addieren
	add.l	#msgport,UM_UserPort(a1)	;wohin soll der Eagleplayer
						;senden ?-> an unseren MSGPORT!

	lea	begin(pc),a2			;Usernummer,nicht ndern,wird
	move.w	UM_class(a1),d3		<-	;Kommando

	ifne	debug
	move.w	um_usernr(a1),saveusernr(A5)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	mytask(a5),UM_TaskAdr(a1)	;unsere Taskadresse

	move.l	mysignal(a5),d1			;Signal,auf das wir sehnschtig
	move.l	d1,UM_Signal(a1)		;warten

	cmp.w	#USclass_exit,d3	;Meldung,das Programm zu beenden
	bne.s	.noclrtask		;alles dicht machen und verschwinden

	clr.l	um_taskadr(A1)
	clr.l	um_Signal(A1)
	clr.l	um_Userport(A1)

.noclrtask

	move.l	UM_Type(a1),d7			;Wem gehrt die Message ?
	move.l	UM_structadr(a1),d6 	<-	;Strukturadresse

	cmp.w	#USclass_getconfig,d3		;wenn dieses Kommando,sofort
						;auswerten,bevor die Message
						;zurckgesendet wird
	bne	.noprev
	moveq	#0,d0
	move.l	winhandle(A5),d1		;Fenster
	beq.s	.prnowin			;kein Fenster,keine nderung
						;der Voreinstellungen
	or.w	#eusb_openwin,d0		;Flag: Fenster offen

	move.l	d1,a0				;Fenster
	move.w	myhoehe1(a5),d1			;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1		;Reale Hhe mit brechneter fr
						;ZIP-Modus vergleichen
	bne.s	.getxy				;kein ZIP-Mode
	or.w	#eusb_zipwin,d0			;FLAG: ZIP-Modus
	bra.s	.prnowin			;Windowposition nicht auswerten
.getxy
	move.w	wd_leftedge(a0),eus_winx(a2)	;Fensterposition merken
	move.w	wd_topedge(a0),eus_winy(a2)
.prnowin
	move.w	d0,eus_flags(a2)		;Flags bergeben
.noprev

	cmp.w	#USclass_Show,d3	;Fenster ffnen
	beq.s	.win

	cmp.w	#USclass_Activate,d3	;Fenster ffnen
	bne.w	.nowin
.win

	move.l	Begin+EUS_EPBase(pc),a0
	move.l	EPG_SomePrefs(a0),d0
	btst	#EGPRF_Iconify,d0
	bne.w	.nowin

	push	all
	bsr	Openwin			;Hallo da bin ich !
	pop	all
	
.nowin
	cmp.w	#USclass_Hide,d3	;Fenster schlieen
	beq.s	.closewin
	cmp.w	#USclass_DeActivate,d3	;Fenster schlieen
	bne.s	.noclosewin
.closewin
	push	all
	bsr	Closewin		;Window zu machen
	pop	all
.noclosewin

	lea	msgport(a5),a0
	move.l	mn_replyport(a1),d0
	cmp.l	a0,d0		;eine von uns abgeschickte Message ?
	beq.s	.noreply	;ja,keinesfalls nochmal auf den Weg schicken
	jsr	_LVOreplymsg(a6)
.noreply
	cmp.l	#USM_Userprg,d7	;Message zurckbekommen ?
	bne.s	.nomy
	move.b	#0,messagesent(a5)	;merken,da Message-Struktur frei
	bra	.mess			;eventl. Message vom Esagle auswerten
.nomy
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	bne	.noeagle		;n
.mess
	move.l	d6,an_structadr(a5)	;Analyzerstrukturadresse merken

	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq.w	.ma			;adresse bekommen
.skip
	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,d4

	move.l	intsave(a5),a6
	cmp.w	#37,lib_version(a6)
	blt	.ma
	jsr	_LVOzipwindow(a6)

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#1,d1

	lea	begin(pc),a6
	move.l	eus_epbase(a6),a6
	move.l	dtg_dosbase(A6),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip

.clearzip
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip

	cmp.w	#USclass_exit,d3	;Meldung,das Programm zu beenden
	beq	.exit			;alles dicht machen und verschwinden

	cmp.w	#USclass_NewConfig,d3	;Neu angekommene Config setzen ?
	bne.w	.nonewcon		;n

	lea	begin(pc),a0		;Anfang des Programms (EUS_-Struktur)
	move.w	eus_flags(a0),d0	;Flags holen
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;ffnen
	bra.s	.weio
.nowino
	bsr	closewin		;schlieen
.weio
	lea	begin(pc),a0		;Anfang des Programms (EUS_-Struktur)
	move.l	winhandle(a5),d0	;Fensteradresse
	beq.s	.nothingtomove		;kein Window , keine Windowbewegung

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;neue X-Position
	move.w	d0,d1			;sichern
	blt.s	.oldx			;kleiner 0 -> sofort aufhren

	add.w	wd_width(a1),d1		;neue Position + Windowbreite
	cmp.w	sc_width(a2),d1		;grer als Screenbreite ?
	bhi.s	.oldx			;dann alte X-Position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;neue - alte X-Position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;neue Y-Position
	move.w	d1,d2			;sichern
	blt.s	.oldy		;kleiner 0 -> sofort aufhren

	add.w	wd_height(a1),d2	;neue Position + Windowhhe
	cmp.w	sc_height(a2),d2	;grer als Screenhhe ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;neue - alte Y-Position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1
.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_zipwin,d0		;Zipwindow ?
	bne	.setzip			;yes
	bra	.clearzip		;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma
;======================== Meldung an IDCMP-Port ==========================
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<-
	move.l	im_Iaddress(a1),d6 	<-
	jsr	_LVOreplymsg(a6)

	cmp.l	#refreshwindow,d7	;Fensterinhalt neu aufbauen ?
	bne.s	.testgads
	bsr	refresh			;Rahmen neu !
	bra	.ma
.testgads
	cmp.l	#menupick,d7		;Men aufgerufen ??
	bne.s	.nomenu
	move.w	d5,d0
	cmp.w	#menunull,d0		;kein Menpunkt ??
	beq	.ma

	and.w	#$7e0,d0
	cmp.w	#32,d0		;2. Item ? (Hide)
	beq	.closewinny	;Window schlieen und dies an Eagleplayer
				;signalisieren

	cmp.w	#64,d0		;3. Item ? (Quit)
	beq	.endme

	bsr	Merror			;Infotext ausgeben (Requester)
	bra	.ma
.nomenu
	cmp.l	#CloseWindow,d7		;Fenster schlieen ?
	bne	.ma
.closewinny
	if	Test=0

	tst.b	messagesent(a5)		;Message zurck ?? (normalerweise ja)
	bne	.ma			;nein,weiter warten,bis Message zurck
					;ist und wieder genutzt werden kann

	bsr	closewin		;Fenster schlieen
	move.l	4.w,a6			;an Eagleplayer signalisieren
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)	;Eagleplayer finden
	tst.l	d0
	beq.s	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse

	lea.l	msgport(a5),a1
	move.l	a1,d3			;Messageport
	move.l	mytask(a5),d4		;Task
	move.l	mysignal(a5),d5		;Signal
	move.w	#USclass_DeActivate,d6	;Kommando
	bsr	sendmess		;senden
	bra	.ma

	else

	bra.w	.endme		;nur fr Testvarianten

	endc
.endme
	moveq	#0,d7		;Ende des Hauptprogrammes,darf nicht aufgerufen
	RTS			;werden
.exit	moveq	#-1,d7		;Exit-Message vom Eagleplayer erhalten,alles
	rts			;dichtmachen
	
;=== Ganze Bitmap lschen,hier ganz einfach: das Gadget liegt genau in dem ===
;=== Bereich,wo hineinkopiert wird,also Gadget refreshen->alles sauber     ===
.Clearpic
	clr.l	U_seconds(a5)
	clr.l	M_seconds(a5)

	tst.l	winhandle(a5)		;Fenster offen ?
	beq.s	.rts

	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.rts

	movem.l	d0-a6,-(sp)
	bsr	refresh
	movem.l	(sp)+,d0-a6			;lschen
.rts
	rts
;===========================================================================
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0-a6,-(sp)

	move.l	winhandle(a5),d0	;*Window
	beq.s	.noabout	;kein Window->raus,sollte aber nicht vorkommen,
				;da diese Funktion eh nur ber Men erreichbar
				;ist
	move.l	d0,a0

	lea	aboutitext(pc),a1	;*Bodytext (Itext-Struktur)
	suba.l	a2,a2			;*Positive Text (keiner)
	lea	okitext(pc),a3		;*Negative Text (ok)
	moveq	#0,d0			;Idcmp True
	moveq	#0,d1			;Idcmp False
	move.w	#360,d2			;Breite
	move.w	#62,d3			;Hhe

	move.l	Intsave(a5),a6
	jsr	_LVOautorequest(a6)	;Requester unter 1.3
.noabout
	movem.l	(sp)+,d0-a6	
	rts
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************

int:	dc.b	`intuition.library`,0
graf:	dc.b	`graphics.library`,0

portname:	dc.b	`EAGLEPLAYERPORT`,0
MyWinName:	dc.b	`Time`,0
MyAnalyzername:	dc.b	`ETime.1`,0
*MyUsername:	dc.b	`*    Time    *`,0
my_easylabel2:	dc.b	`Cancel`,0
my_easylabel3:	dc.b	`OK`,0
my_easylabel1:	dc.b	`Retry`,0

Project0STitle: dc.b	'Time (Eagleplayer),  DEFECT Softworks',0

Aboutmessage:
	dc.b	`          EaglePlayer Time`
	ver
	dc.b	$0
Aboutmessage.2:
	dc.b	` 1993 Henryk "BUGGS" Richter, Shareware`,0
Aboutmessage.3
myinfo
	dc.b	`Timecounter / Clock for the Eagleplayer`,0
NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0
	even
MyBuggsname	dc.b	`Buggs of DEFECT`,0,1

	even
Aboutitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	11
	dc.w	3
	dc.l	myfontatt
	dc.l	Aboutmessage
	dc.l	.about2
.about2
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	11
	dc.w	11
	dc.l	myfontatt
	dc.l	Aboutmessage.2
	dc.l	.about3
.about3
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	11
	dc.w	19
	dc.l	myfontatt
	dc.l	Aboutmessage.3
	dc.l	0
MyWindow:
	dc.w	0
	dc.w	0
	dc.w	win_breite
	dc.w	11+32+15-1
	dc.b	0
	dc.b	1
	dc.l	closewindow!menupick!refreshwindow
	dc.l	Windowdrag!Windowdepth!Windowclose
	dc.l	0
	dc.l	0
	dc.l	MYwinname
	dc.l	0
	dc.l	0
	dc.w	0,0
	dc.w	0,0
	dc.w	1
Noportitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	6
	dc.w	3
	dc.l	myfontatt
	dc.l	Noportmessage
	dc.l	0
Retryitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	6
	dc.w	3
	dc.l	myfontatt
	dc.l	my_easylabel1
	dc.l	0
Cancelitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	6
	dc.w	3
	dc.l	myfontatt
	dc.l	my_easylabel2
	dc.l	0
OKitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	6
	dc.w	3
	dc.l	myfontatt
	dc.l	my_easylabel3
	dc.l	0
myfontatt:
	dc.l	myfontname
	dc.w	8
	dc.w	0
myfontname:	dc.b	`topaz.font`,0
	even
projmenu:
	dc.l	0
	dc.w	0,0,60,0
	dc.w	menuenabled
	dc.l	projname
	dc.l	aboutitem
	dc.w	0,0,0,0
projname:
	dc.b	`Project`,0
	even
aboutitem:
	dc.l	hideitem
	dc.w	0,0,80,10
	dc.w	highitem!highcomp!itemenabled!itemtext!commseq
	dc.l	0
	dc.l	abouttextstr
	dc.l	0
	dc.b	`A`
	dc.b	0
	dc.l	0
	dc.l	Menunull
abouttextstr:
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	1
	dc.w	1
	dc.l	Myfontatt
	dc.l	aboutname
	dc.l	0
aboutname:
	dc.b	`About`,0
Hideitem:
	dc.l	QuitItem
	dc.w	0,10,80,10
	dc.w	highitem!highcomp!itemenabled!itemtext!commseq
	dc.l	0
	dc.l	Hidetext
	dc.l	0
	dc.b	`H`
	dc.b	0
	dc.l	0
	dc.l	Menunull
quititem:
	dc.l	0
	dc.w	0,20,80,10
	dc.w	highitem!highcomp!itemenabled!itemtext!commseq
	dc.l	0
	dc.l	quittext
	dc.l	0
	dc.b	`Q`
	dc.b	0
	dc.l	0
	dc.l	Menunull
Quittext:
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	1
	dc.w	1
	dc.l	Myfontatt
	dc.l	quitname
	dc.l	0
quitname:
	dc.b	`Quit`,0
	even
Hidetext:
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	1
	dc.w	1
	dc.l	Myfontatt
	dc.l	Hidename
	dc.l	0
Hidename:
	dc.b	`Hide`,0
	even
patt1	dc.w	%1010101010101010
	dc.w	%0101010101010101
patt2	dc.w	0,0

Ziffern
 DC.W $9FC8,$CF98,$E038,$E038,$E038,$C018,$0000,$C018,$E038,$E038,$E038,$CF98,$9FC8
 dc.w $0008,$0018,$0038,$0038,$0038,$0018,$0000,$0018,$0038,$0038,$0038,$0018,$0008
 dc.w $1FC8,$0F98,$0038,$0038,$0038,$0F98,$1FC0,$CF80,$E000,$E000,$E000,$CF80,$9FC0
 dc.w $1FC8,$0F98,$0038,$0038,$0038,$0F98,$1FC0,$0F98,$0038,$0038,$0038,$0F98,$1FC8
 dc.w $8008,$C018,$E038,$E038,$E038,$CF98,$1FC0,$0F98,$0038,$0038,$0038,$0018,$0008
 dc.w $9FC0,$CF80,$E000,$E000,$E000,$CF80,$1FC0,$0F98,$0038,$0038,$0038,$0F98,$1FC8
 dc.w $9FC0,$CF80,$E000,$E000,$E000,$CF80,$1FC0,$CF98,$E038,$E038,$E038,$CF98,$9FC8
 dc.w $1FC8,$0F98,$0038,$0038,$0038,$0018,$0000,$0018,$0038,$0038,$0038,$0018,$0008
 DC.W $9FC8,$CF98,$E038,$E038,$E038,$CF98,$1FC0,$CF98,$E038,$E038,$E038,$CF98,$9FC8
 dc.w $9FC8,$CF98,$E038,$E038,$E038,$CF98,$1FC0,$0F98,$0038,$0038,$0038,$0F98,$1FC8
Doppelpunkt
	dc.w	%0000000000000000
	dc.w	%0000000000000000
	dc.w	%0000001100000000
	dc.w	%0000011110000000
	dc.w	%0000001100000000
	dc.w	%0000000000000000
	dc.w	%0000000000000000
	dc.w	%0000000000000000
	dc.w	%0000001100000000
	dc.w	%0000011110000000
	dc.w	%0000001100000000
	dc.w	%0000000000000000
	dc.w	%0000000000000000
KleineZiffern
	dc.b	0,0,0,0,0,0,$7c,$82,$82,0,$82,$82,$7c	;0
	dc.b	0,0,0,0,0,0,0,2,2,0,2,2,0		;1
	dc.b	0,0,0,0,0,0,$7c,2,2,$7c,$80,$80,$7c	;2
	dc.b	0,0,0,0,0,0,$7c,2,2,$7c,2,2,$7c		;3
	dc.b	0,0,0,0,0,0,0,$82,$82,$7c,2,2,0		;4
	dc.b	0,0,0,0,0,0,$7c,$80,$80,$7c,2,2,$7c	;5
	dc.b	0,0,0,0,0,0,$7c,$80,$80,$7c,$82,$82,$7c	;6
	dc.b	0,0,0,0,0,0,$7c,2,2,0,2,2,0		;7
	dc.b	0,0,0,0,0,0,$7c,$82,$82,$7c,$82,$82,$7c	;8
	dc.b	0,0,0,0,0,0,$7c,$82,$82,$7c,2,2,$7c	;9
;*** Leertabellen (spter im BSS-Hunk) ,Diskettenplatzsparend untergebracht***
		section	1,BSS
datas:
intsave:	rs.l	1	;Intuition
grafsave:	rs.l	1	;Graphics
WinHandle:	rs.l	1	;Fenster
Port:		rs.l	1	;Fenster IDCMP-Port
MsgPort:	rs.b	mp_size	;extra Messageport
Mysignal	rs.l	1	;Signalnummer
Mytask		rs.l	1	;Taskadresse
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
fontatt:	rs.l	1	;Fontattr Strukturadresse

mytags:		rs.l	20*2
myzoom:		rs.w	3	;left,top,width,height
myhoehe2:	rs.w	1
myhoehe1:	rs.w	1
winwidth:	rs.w	1	;Breite des Fensters

M_Seconds	rs.l	1	;Sekundenzhler,auf den sich das ganze bezieht
U_Seconds	rs.l	1	;neuer Wert
Merk_seconds	rs.l	1
U_Micros	rs.l	1	;nur der Vollstndigkeit halber

MY_Bitmap:	rs.b	8	;Bitmap Struktur
		rs.l	1
		rs.l	1
		rs.l	6

Intset	rs.w	1
inter:	rs.l	2
	rs.b	1	;2
	rs.b	1	;127
	rs.l	3

offx		rs.w	1
Mymessage:	rs.b	UM_sizeof	;Intuimessagestruktur
AN_Structadr:	rs.l	1		;vom Eagleplayer erhaltene Struktur
counter2	rs.w	1

mytime		rs.l	1

Messagesent:	rs.b	1		;Flag,ob Message losgeschickt
counter		rs.b	1		;Frei
	ifne	debug
saveusernr	rs.w	1
	endc
DatasLen:	rs.w	0		;Lnge des BSS-Blocks

		ds.b	DatasLen
	end
